/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.api.spell;

public enum SpellResult {
    STOP(true, false, false, false, true),
    PENDING(true, false, false, false, true),
    CAST(true, false, false),
    CAST_SELF(true, false, false),
    CAST_TARGET(true, false, false),
    ALTERNATE(true, false, false, true),
    ALTERNATE_UP(true, false, false, true),
    ALTERNATE_DOWN(true, false, false, true),
    ALTERNATE_SNEAK(true, false, false, true),
    ALTERNATE_JUMPING(true, false, false, true),
    FIZZLE(false, true, false),
    BACKFIRE(false, true, false),
    BLOCKED(false, true, false),
    DEACTIVATE(false, false, true),
    TARGET_SELECTED(false, false, true),
    CURSED(false, true, true),
    COOLDOWN(false, true, true),
    NO_TARGET(false, false, false),
    FAIL(false, true, true),
    CANCELLED(true, false, true, false, true),
    INSUFFICIENT_RESOURCES(false, true, true),
    INSUFFICIENT_PERMISSION(false, true, true),
    ENTITY_REQUIRED(false, true, true),
    LIVING_ENTITY_REQUIRED(false, true, true),
    PLAYER_REQUIRED(false, true, true),
    LOCATION_REQUIRED(false, true, true),
    WORLD_REQUIRED(false, true, true),
    INVALID_WORLD(false, true, true),
    NO_ACTION(false, false, false);

    private final boolean success;
    private final boolean failure;
    private final boolean free;
    private final boolean alternate;
    private final boolean stop;

    private SpellResult(boolean success, boolean failure, boolean free, boolean alternate, boolean stop) {
        this.success = success;
        this.failure = failure;
        this.free = free;
        this.alternate = alternate;
        this.stop = stop;
    }

    private SpellResult(boolean success, boolean failure, boolean free) {
        this.success = success;
        this.failure = failure;
        this.free = free;
        this.alternate = false;
        this.stop = false;
    }

    private SpellResult(boolean success, boolean failure, boolean free, boolean alternate) {
        this.success = success;
        this.failure = failure;
        this.free = free;
        this.alternate = alternate;
        this.stop = false;
    }

    public boolean isFailure() {
        return this.failure;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isFree() {
        return this.free;
    }

    public boolean isFree(boolean castOnNoTarget) {
        if (this == NO_TARGET || this == NO_ACTION) {
            return !castOnNoTarget;
        }
        return this.isFree();
    }

    public boolean isStop() {
        return this.stop;
    }

    public boolean shouldRefundCooldown(boolean castOnNoTarget) {
        return !castOnNoTarget && (this == NO_TARGET || this == NO_ACTION);
    }

    public boolean isAlternate() {
        return this.alternate;
    }

    public SpellResult min(SpellResult other) {
        return this.ordinal() < other.ordinal() ? this : other;
    }

    public SpellResult max(SpellResult other) {
        return this.ordinal() > other.ordinal() ? this : other;
    }
}

