/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.api.event;

import com.elmakers.mine.bukkit.api.attributes.AttributeProvider;
import com.elmakers.mine.bukkit.api.entity.TeamProvider;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.requirements.RequirementsProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class LoadEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private MageController controller;
    private List<AttributeProvider> attributeProviders = new ArrayList<AttributeProvider>();
    private List<TeamProvider> teamProviders = new ArrayList<TeamProvider>();
    private Map<String, RequirementsProcessor> requirementProcessors = new HashMap<String, RequirementsProcessor>();

    public LoadEvent(MageController controller) {
        this.controller = controller;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public MageController getController() {
        return this.controller;
    }

    public void registerAttributeProvider(AttributeProvider provider) {
        this.attributeProviders.add(provider);
    }

    public void registerTeamProvider(TeamProvider provider) {
        this.teamProviders.add(provider);
    }

    public void registerRequirementsProcessor(String requirementType, RequirementsProcessor processor) {
        if (this.requirementProcessors.containsKey(requirementType)) {
            this.controller.getLogger().warning("Tried to register RequiremensProcessor twice for same type: " + requirementType);
        }
        this.requirementProcessors.put(requirementType, processor);
    }

    public Map<String, RequirementsProcessor> getRequirementProcessors() {
        return this.requirementProcessors;
    }

    public Collection<AttributeProvider> getAttributeProviders() {
        return this.attributeProviders;
    }

    public Collection<TeamProvider> getTeamProviders() {
        return this.teamProviders;
    }
}

