/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.action.GUIAction;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageClass;
import com.elmakers.mine.bukkit.api.magic.MageClassTemplate;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.requirements.Requirement;
import com.elmakers.mine.bukkit.api.spell.CostReducer;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.integration.VaultController;
import com.elmakers.mine.bukkit.item.Cost;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationStore;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationTransform;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SelectorAction
extends BaseSpellAction
implements GUIAction,
CostReducer {
    protected double costScale = 1.0;
    protected boolean autoClose = true;
    protected SelectorConfiguration defaultConfiguration;
    protected MaterialAndData confirmFillMaterial;
    protected CastContext context;
    private Map<Integer, SelectorOption> showingItems;
    private int numSlots;
    private int has = 0;
    private String title;
    private String confirmTitle;
    private String confirmUnlockTitle;
    private boolean isActive = false;
    private SpellResult finalResult = null;

    @Override
    public void deactivated() {
        if (this.context != null) {
            this.context.getMage().removeItemsWithTag("slot");
        }
        this.isActive = false;
    }

    @Override
    public void dragged(InventoryDragEvent event) {
        event.setCancelled(true);
    }

    protected String getMessage(String key) {
        return this.context.getMessage(key, this.getDefaultMessage(this.context, key));
    }

    protected String getDefaultMessage(CastContext context, String key) {
        return context.getController().getMessages().get("shops." + key);
    }

    @Override
    public void clicked(InventoryClickEvent event) {
        event.setCancelled(true);
        ItemStack item = event.getCurrentItem();
        Mage mage = this.context.getMage();
        if (item == null || !InventoryUtils.hasMeta(item, "slot")) {
            if (!this.autoClose) {
                mage.deactivateGUI();
            }
            return;
        }
        int slotIndex = Integer.parseInt(InventoryUtils.getMetaString(item, "slot"));
        MageController controller = this.context.getController();
        SelectorOption option = this.showingItems.get(slotIndex);
        if (option == null || option.isPlaceholder()) {
            return;
        }
        String unpurchasableMessage = InventoryUtils.getMetaString(item, "unpurchasable");
        if (unpurchasableMessage != null && !unpurchasableMessage.isEmpty()) {
            this.context.showMessage(unpurchasableMessage);
            mage.deactivateGUI();
            return;
        }
        Cost required = option.getRequiredCost(this, this.context);
        if (required != null) {
            String baseMessage = this.getMessage("insufficient");
            String costDescription = required.getFullDescription(controller.getMessages(), this);
            costDescription = baseMessage.replace("$cost", costDescription);
            this.context.showMessage(costDescription);
        } else {
            String itemName = option.getName();
            if (InventoryUtils.hasMeta(item, "confirm")) {
                String inventoryTitle = this.getConfirmTitle(option).replace("$item", itemName);
                Inventory confirmInventory = CompatibilityUtils.createInventory(null, 9, inventoryTitle);
                InventoryUtils.removeMeta(item, "confirm");
                for (int i = 0; i < 9; ++i) {
                    if (i != 4) {
                        ItemStack filler = this.confirmFillMaterial.getItemStack(1);
                        ItemMeta meta = filler.getItemMeta();
                        if (meta != null) {
                            meta.setDisplayName(ChatColor.DARK_GRAY + (i < 4 ? "-->" : "<--"));
                            filler.setItemMeta(meta);
                        }
                        confirmInventory.setItem(i, filler);
                        continue;
                    }
                    confirmInventory.setItem(i, item);
                }
                mage.deactivateGUI();
                this.isActive = true;
                mage.activateGUI(this, confirmInventory);
                return;
            }
            this.finalResult = option.give(this, this.context);
            if (this.finalResult.isSuccess() && this.finalResult != SpellResult.NO_TARGET) {
                this.context.showMessage(option.getSelectedMessage(this));
            }
        }
        if (this.autoClose || this.finalResult != SpellResult.CAST) {
            if (this.isActive) {
                mage.deactivateGUI();
            }
        } else {
            mage.continueGUI(this, this.getInventory(this.context));
        }
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.context = context;
        this.defaultConfiguration = new SelectorConfiguration(parameters);
        this.confirmFillMaterial = ConfigurationUtils.getMaterialAndData(parameters, "confirm_filler", new MaterialAndData(Material.AIR));
        this.autoClose = parameters.getBoolean("auto_close", true);
        this.costScale = parameters.getDouble("scale", 1.0);
        this.title = parameters.getString("title");
        this.confirmTitle = parameters.getString("confirm_title");
        this.confirmUnlockTitle = parameters.getString("unlock_confirm_title");
        this.finalResult = null;
        this.isActive = false;
        this.numSlots = 0;
        this.showingItems = new HashMap<Integer, SelectorOption>();
        this.has = 0;
        Collection<ConfigurationSection> optionConfigs = ConfigurationUtils.getNodeList(parameters, "options");
        if (optionConfigs != null) {
            ArrayList<SelectorOption> options = new ArrayList<SelectorOption>();
            for (ConfigurationSection configurationSection : optionConfigs) {
                SelectorOption newOption = new SelectorOption(this.defaultConfiguration, configurationSection, context, this);
                if (newOption.hasLimit() && newOption.has(context)) {
                    ++this.has;
                }
                options.add(newOption);
            }
            for (SelectorOption selectorOption : options) {
                if (selectorOption.isUnavailable() && !selectorOption.showIfUnavailable()) continue;
                Integer targetSlot = selectorOption.getSlot();
                int slot = targetSlot == null ? this.numSlots : targetSlot;
                this.showingItems.put(slot, selectorOption);
                this.numSlots = Math.max(slot + 1, this.numSlots);
            }
        }
    }

    public SpellResult showItems(CastContext context) {
        Mage mage = context.getMage();
        Player player = mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        this.isActive = true;
        this.finalResult = SpellResult.NO_ACTION;
        Inventory displayInventory = this.getInventory(context);
        mage.activateGUI(this, displayInventory);
        return SpellResult.PENDING;
    }

    protected String getInventoryTitle() {
        if (this.title != null && !this.title.isEmpty()) {
            return this.title;
        }
        return this.getMessage("title");
    }

    protected String getConfirmTitle(SelectorOption option) {
        if (option.isUnlock()) {
            if (this.confirmUnlockTitle != null && !this.confirmUnlockTitle.isEmpty()) {
                return this.confirmUnlockTitle;
            }
            return this.getMessage("unlock_confirm_title");
        }
        if (this.confirmTitle != null && !this.confirmTitle.isEmpty()) {
            return this.confirmTitle;
        }
        return this.getMessage("confirm_title");
    }

    protected String getBalanceDescription(CastContext context) {
        Mage mage = context.getMage();
        Player player = mage.getPlayer();
        Messages messages = context.getController().getMessages();
        String description = "";
        switch (this.defaultConfiguration.getCostType()) {
            case "xp": {
                String xpAmount = Integer.toString(mage.getExperience());
                description = messages.get("costs.xp_amount").replace("$amount", xpAmount);
                break;
            }
            case "sp": {
                String spAmount = Integer.toString(mage.getSkillPoints());
                description = messages.get("costs.sp_amount").replace("$amount", spAmount);
                break;
            }
            case "levels": {
                int levels = player == null ? 0 : player.getLevel();
                String levelAmount = Integer.toString(levels);
                description = messages.get("costs.levels_amount").replace("$amount", levelAmount);
                break;
            }
            default: {
                if (!VaultController.hasEconomy()) break;
                double balance = VaultController.getInstance().getBalance(player);
                description = VaultController.getInstance().format(balance);
            }
        }
        return description;
    }

    protected Inventory getInventory(CastContext context) {
        String inventoryTitle = this.getInventoryTitle();
        String balanceDescription = this.getBalanceDescription(context);
        inventoryTitle = inventoryTitle.replace("$balance", balanceDescription);
        int invSize = (int)Math.ceil((float)this.numSlots / 9.0f) * 9;
        Inventory displayInventory = CompatibilityUtils.createInventory(null, invSize, inventoryTitle);
        for (Map.Entry<Integer, SelectorOption> entry : this.showingItems.entrySet()) {
            ItemStack icon = entry.getValue().getIcon();
            InventoryUtils.setMeta(icon, "slot", Integer.toString(entry.getKey()));
            displayInventory.setItem(entry.getKey().intValue(), icon);
        }
        return displayInventory;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("confirm");
        parameters.add("path");
        parameters.add("path_end");
        parameters.add("path_exact");
        parameters.add("auto_upgrade");
        parameters.add("require_wand");
        parameters.add("permission");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        MageController controller = spell.getController();
        if (parameterKey.equals("path") || parameterKey.equals("path_exact") || parameterKey.equals("path_end")) {
            examples.addAll(controller.getWandPathKeys());
        } else if (parameterKey.equals("require_wand") || parameterKey.equals("confirm") || parameterKey.equals("auto_upgrade")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public void finish(CastContext context) {
        this.isActive = false;
        this.finalResult = null;
    }

    public RequirementsResult checkDefaultRequirements(CastContext context) {
        return this.defaultConfiguration.checkRequirements(context);
    }

    @Override
    public SpellResult perform(CastContext context) {
        if (this.isActive) {
            return SpellResult.PENDING;
        }
        if (this.finalResult != null) {
            return this.finalResult;
        }
        RequirementsResult check = this.checkDefaultRequirements(context);
        if (!check.result.isSuccess()) {
            context.sendMessage(check.message);
            return check.result;
        }
        if (this.showingItems.isEmpty()) {
            context.showMessage("no_items", this.getDefaultMessage(context, "no_items"));
            return SpellResult.NO_ACTION;
        }
        return this.showItems(context);
    }

    @Nullable
    protected ItemStack parseItem(String itemKey) {
        if (itemKey == null || itemKey.isEmpty() || itemKey.equalsIgnoreCase("none")) {
            return null;
        }
        ItemStack item = this.context.getController().createItem(itemKey);
        if (item == null) {
            this.context.getLogger().warning("Failed to create item in selector: " + itemKey);
        }
        return item;
    }

    @Override
    public float getCostReduction() {
        return 0.0f;
    }

    @Override
    public float getConsumeReduction() {
        return 0.0f;
    }

    @Override
    public float getCostScale() {
        return (float)this.costScale;
    }

    protected class SelectorOption
    extends SelectorConfiguration {
        protected Integer slot;
        protected String name;
        protected List<String> lore;
        protected String unavailableMessage;
        protected boolean placeholder;
        protected boolean unavailable;

        public SelectorOption(SelectorConfiguration defaults, ConfigurationSection configuration, CastContext context, CostReducer reducer) {
            ItemMeta meta;
            SpellTemplate spellTemplate;
            Mage mage;
            ConfigurationSection unlocks;
            String description;
            this.slot = null;
            this.name = null;
            this.lore = null;
            this.selectedMessage = defaults.selectedMessage;
            this.items = defaults.items;
            this.costs = defaults.costs;
            this.castSpell = defaults.castSpell;
            this.applyToWand = defaults.applyToWand;
            this.unlockClass = defaults.unlockClass;
            this.currency = defaults.currency;
            this.sp = defaults.sp;
            this.experience = defaults.experience;
            this.limit = defaults.limit;
            this.unlockKey = defaults.unlockKey;
            this.unlockSection = defaults.unlockSection;
            this.showConfirmation = defaults.showConfirmation;
            this.costType = defaults.costType;
            this.showUnavailable = defaults.showUnavailable;
            this.commands = defaults.commands;
            this.lore = configuration.contains("lore") ? configuration.getStringList("lore") : new ArrayList();
            boolean bl = this.placeholder = configuration.getBoolean("placeholder") || configuration.getString("item", "").equals("none");
            if (this.placeholder) {
                this.icon = new ItemStack(Material.AIR);
                return;
            }
            this.parse(configuration);
            if (defaults.requirements != null) {
                if (this.requirements == null) {
                    this.requirements = defaults.requirements;
                } else {
                    this.requirements.addAll(defaults.requirements);
                }
            }
            if (configuration.contains("slot")) {
                this.slot = configuration.getInt("slot");
            }
            MageController controller = context.getController();
            this.name = configuration.getString("name", "");
            if (this.name.isEmpty() && this.unlockClass != null && !this.unlockClass.isEmpty()) {
                MageClassTemplate mageClass = controller.getMageClassTemplate(this.unlockClass);
                this.name = SelectorAction.this.getMessage("unlock_class");
                if (mageClass != null) {
                    this.name = this.name.replace("$class", mageClass.getName());
                } else {
                    controller.getLogger().warning("Unknown class in selector config: " + this.unlockClass);
                }
            }
            if (this.name.isEmpty() && this.items != null) {
                this.name = controller.describeItem((ItemStack)this.items.get(0));
            }
            if (this.name.isEmpty() && this.castSpell != null && !this.castSpell.isEmpty()) {
                SpellTemplate spell = controller.getSpellTemplate(this.castSpell);
                this.name = SelectorAction.this.getMessage("cast_spell");
                if (spell != null) {
                    this.name = this.name.replace("$spell", spell.getName());
                } else {
                    controller.getLogger().warning("Unknown spell in selector config: " + this.castSpell);
                }
            }
            if ((description = configuration.getString("description")) == null) {
                if (this.unlockClass != null && !this.unlockClass.isEmpty()) {
                    MageClassTemplate mageClass = controller.getMageClassTemplate(this.unlockClass);
                    description = mageClass.getDescription();
                } else if (this.castSpell != null && !this.castSpell.isEmpty()) {
                    SpellTemplate spell = controller.getSpellTemplate(this.castSpell);
                    if (spell == null) {
                        controller.getLogger().warning("Unknown spell in selector config: " + this.castSpell);
                    } else {
                        description = spell.getDescription();
                    }
                }
            }
            if (description != null && !description.isEmpty()) {
                InventoryUtils.wrapText(description, this.lore);
            }
            boolean unlocked = false;
            if (this.unlockKey != null && !this.unlockKey.isEmpty() && (unlocks = (mage = context.getMage()).getData().getConfigurationSection(this.unlockSection)) != null && unlocks.getBoolean(this.unlockKey, false)) {
                unlocked = true;
                this.costs = null;
                this.showConfirmation = false;
                String unlockedMessage = SelectorAction.this.getMessage("unlocked_lore");
                InventoryUtils.wrapText(unlockedMessage, this.lore);
            }
            if (!unlocked) {
                RequirementsResult check = this.checkRequirements(context);
                if (!check.result.isSuccess()) {
                    this.unavailable = true;
                    this.unavailableMessage = check.message;
                    if (this.unavailableMessage != null && !this.unavailableMessage.isEmpty()) {
                        InventoryUtils.wrapText(check.message, this.lore);
                    }
                }
            }
            if (this.costs != null && !this.unavailable) {
                String costHeading = SelectorAction.this.getMessage("cost_heading");
                if (!costHeading.isEmpty()) {
                    InventoryUtils.wrapText(costHeading, this.lore);
                }
                String costKey = this.unlockKey != null && !this.unlockKey.isEmpty() ? "unlock_cost_lore" : "cost_lore";
                String requiredKey = this.unlockKey != null && !this.unlockKey.isEmpty() ? "required_unlock_cost_lore" : "required_cost_lore";
                String costString = SelectorAction.this.getMessage(costKey);
                String requiredCostString = SelectorAction.this.getMessage(requiredKey);
                for (Cost cost : this.costs) {
                    if (this.costModifiers != null) {
                        for (CostModifier modifier : this.costModifiers) {
                            modifier.modify(cost);
                        }
                    }
                    String costDescription = cost.has(context.getMage(), context.getWand(), reducer) ? costString : requiredCostString;
                    costDescription = costDescription.replace("$cost", cost.getFullDescription(context.getController().getMessages(), reducer));
                    InventoryUtils.wrapText(costDescription, this.lore);
                }
            }
            if (this.icon == null && this.items != null) {
                this.icon = InventoryUtils.getCopy((ItemStack)this.items.get(0));
            }
            if (this.icon == null && this.castSpell != null && !this.castSpell.isEmpty() && (spellTemplate = context.getController().getSpellTemplate(this.castSpell)) != null) {
                if (this.unavailable && spellTemplate.getDisabledIcon() != null) {
                    this.icon = spellTemplate.getDisabledIcon().getItemStack(1);
                }
                if (this.icon == null && spellTemplate.getIcon() != null) {
                    this.icon = spellTemplate.getIcon().getItemStack(1);
                }
            }
            if (this.icon == null && defaults.icon != null) {
                this.icon = InventoryUtils.getCopy(defaults.icon);
            }
            ItemMeta itemMeta = meta = this.icon == null ? null : this.icon.getItemMeta();
            if (this.icon == null || meta == null) {
                this.icon = InventoryUtils.getURLSkull("http://textures.minecraft.net/texture/1adaf6e6e387bc18567671bb82e948488bbacff97763ee5985442814989f5d");
                meta = this.icon.getItemMeta();
                if (meta == null) {
                    this.icon = new ItemStack(Wand.DefaultUpgradeMaterial);
                    meta = this.icon.getItemMeta();
                }
            }
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.name));
            if (!this.lore.isEmpty()) {
                ArrayList<String> itemLore = meta.getLore();
                if (itemLore == null) {
                    itemLore = new ArrayList<String>();
                }
                for (String line : this.lore) {
                    itemLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
                }
                meta.setLore(itemLore);
            }
            this.icon.setItemMeta(meta);
            this.icon = InventoryUtils.makeReal(this.icon);
            InventoryUtils.makeUnbreakable(this.icon);
            InventoryUtils.hideFlags(this.icon, (byte)63);
            if (this.unavailable) {
                if (this.unavailableMessage != null && !this.unavailableMessage.isEmpty()) {
                    InventoryUtils.setMeta(this.icon, "unpurchasable", this.unavailableMessage);
                } else {
                    this.showUnavailable = false;
                }
            }
            if (this.showConfirmation) {
                InventoryUtils.setMeta(this.icon, "confirm", "true");
            }
        }

        @Nullable
        protected Cost takeCosts(CostReducer reducer, CastContext context) {
            Cost required = this.getRequiredCost(reducer, context);
            if (required != null) {
                return required;
            }
            if (this.costs != null) {
                for (Cost cost : this.costs) {
                    cost.deduct(context.getMage(), context.getWand(), reducer);
                }
            }
            return null;
        }

        @Nullable
        public Cost getRequiredCost(CostReducer reducer, CastContext context) {
            if (this.costs != null) {
                for (Cost cost : this.costs) {
                    if (cost.has(context.getMage(), context.getWand(), reducer)) continue;
                    return cost;
                }
            }
            return null;
        }

        public SpellResult give(CostReducer reducer, CastContext context) {
            Cost required;
            Mage mage = context.getMage();
            com.elmakers.mine.bukkit.api.wand.Wand wand = context.getWand();
            if (this.placeholder) {
                return SpellResult.NO_ACTION;
            }
            if (this.unlockClass != null && !this.unlockClass.isEmpty()) {
                if (mage.hasClassUnlocked(this.unlockClass)) {
                    String hasClassMessage = SelectorAction.this.getMessage("has_class").replace("$class", this.name);
                    context.showMessage(hasClassMessage);
                    return SpellResult.NO_TARGET;
                }
                mage.unlockClass(this.unlockClass);
            }
            if (this.applyToWand && this.items != null) {
                if (wand == null) {
                    context.showMessage("no_wand", SelectorAction.this.getDefaultMessage(context, "no_wand"));
                    return SpellResult.NO_TARGET;
                }
                boolean anyApplied = false;
                for (ItemStack item : this.items) {
                    anyApplied = wand.addItem(item) || anyApplied;
                }
                if (!anyApplied) {
                    String inapplicable = SelectorAction.this.getMessage("not_applicable").replace("$item", this.name);
                    context.showMessage(inapplicable);
                    return SpellResult.NO_TARGET;
                }
            }
            MageController controller = context.getController();
            if (this.castSpell != null && !this.castSpell.isEmpty()) {
                MageSpell spell = null;
                spell = mage.getSpell(this.castSpell);
                if (SelectorAction.this.autoClose) {
                    mage.deactivateGUI();
                }
                if (spell == null || !spell.cast()) {
                    context.showMessage("cast_fail", SelectorAction.this.getDefaultMessage(context, "cast_fail"));
                    return SpellResult.NO_TARGET;
                }
            }
            if (this.unlockKey != null && !this.unlockKey.isEmpty()) {
                Object unlocks = mage.getData().getConfigurationSection(this.unlockSection);
                if (unlocks != null && !unlocks.getBoolean(this.unlockKey)) {
                    String unlockMessage = SelectorAction.this.getMessage("unlocked");
                    context.showMessage(this.getCostsMessage(reducer, unlockMessage));
                }
                if (unlocks == null) {
                    unlocks = mage.getData().createSection(this.unlockSection);
                }
                unlocks.set(this.unlockKey, (Object)true);
            }
            if (this.sp != 0) {
                if (mage.isAtMaxSkillPoints()) {
                    return SpellResult.NO_TARGET;
                }
                mage.addSkillPoints(this.sp);
            }
            if (this.items != null && !this.applyToWand) {
                for (ItemStack item : this.items) {
                    ItemStack copy = InventoryUtils.getCopy(item);
                    mage.giveItem(copy);
                }
            }
            if (this.commands != null && !this.commands.isEmpty()) {
                for (String command : this.commands) {
                    String execute = context.parameterize(command);
                    controller.getPlugin().getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), execute);
                }
            }
            if (this.experience != 0) {
                mage.giveExperience(this.experience);
            }
            if (this.currency != 0 && VaultController.hasEconomy()) {
                VaultController.getInstance().depositPlayer(mage.getPlayer(), this.currency);
            }
            if ((required = this.takeCosts(reducer, context)) != null) {
                String baseMessage = SelectorAction.this.getMessage("insufficient");
                String costDescription = required.getFullDescription(controller.getMessages(), reducer);
                costDescription = baseMessage.replace("$cost", costDescription);
                context.showMessage(costDescription);
                return SpellResult.INSUFFICIENT_RESOURCES;
            }
            return SpellResult.CAST;
        }

        public Integer getSlot() {
            return this.slot;
        }

        public boolean isPlaceholder() {
            return this.placeholder;
        }

        public boolean isUnavailable() {
            return this.unavailable;
        }

        @Nullable
        public ItemStack getIcon() {
            return this.icon;
        }

        public String getName() {
            return this.name;
        }

        public String getSelectedMessage(CostReducer reducer) {
            return this.getCostsMessage(reducer, this.selectedMessage);
        }

        public String getCostsMessage(CostReducer reducer, String baseMessage) {
            String costString = "";
            if (this.costs != null) {
                for (Cost cost : this.costs) {
                    if (!costString.isEmpty()) {
                        costString = costString + ", ";
                    }
                    costString = costString + cost.getFullDescription(SelectorAction.this.context.getController().getMessages(), reducer);
                }
            }
            if (costString.isEmpty()) {
                costString = SelectorAction.this.getMessage("nothing");
            }
            return baseMessage.replace("$item", this.name).replace("$name", this.name).replace("$cost", costString);
        }
    }

    protected class SelectorConfiguration {
        @Nullable
        protected ItemStack icon;
        @Nullable
        protected List<ItemStack> items;
        @Nullable
        protected List<Cost> costs = null;
        @Nonnull
        protected String costType = "currency";
        @Nullable
        protected String castSpell = null;
        @Nullable
        protected String unlockClass = null;
        @Nullable
        protected String selectedMessage = null;
        @Nullable
        protected String unlockKey = null;
        @Nonnull
        protected String unlockSection = "unlocked";
        @Nullable
        protected Collection<Requirement> requirements;
        @Nullable
        protected List<String> commands;
        @Nullable
        protected List<CostModifier> costModifiers;
        protected boolean applyToWand = false;
        protected boolean showConfirmation = false;
        protected boolean showUnavailable = false;
        protected int experience;
        protected int sp;
        protected int currency = 0;
        protected int limit = 0;

        public SelectorConfiguration(ConfigurationSection configuration) {
            this.parse(configuration);
        }

        protected SelectorConfiguration() {
        }

        protected void parse(ConfigurationSection configuration) {
            List itemList;
            Collection<ConfigurationSection> requirementConfigurations;
            this.applyToWand = configuration.getBoolean("apply_to_wand", this.applyToWand);
            this.castSpell = configuration.getString("cast_spell", this.castSpell);
            this.unlockClass = configuration.getString("unlock_class", this.unlockClass);
            this.currency = configuration.getInt("currency", this.currency);
            this.experience = configuration.getInt("experience", this.experience);
            this.sp = configuration.getInt("sp", this.sp);
            this.limit = configuration.getInt("limit", this.limit);
            this.unlockKey = configuration.getString("unlock", this.unlockKey);
            this.unlockSection = configuration.getString("unlock_section", this.unlockSection);
            this.showConfirmation = configuration.getBoolean("confirm", this.showConfirmation);
            this.costType = configuration.getString("cost_type", this.costType);
            this.showUnavailable = configuration.getBoolean("show_unavailable", this.showUnavailable);
            this.commands = ConfigurationUtils.getStringList(configuration, "commands");
            this.selectedMessage = configuration.getString("selected", this.selectedMessage);
            if (this.selectedMessage == null) {
                this.selectedMessage = SelectorAction.this.getMessage("selected");
            }
            if ((requirementConfigurations = ConfigurationUtils.getNodeList(configuration, "requirements")) != null) {
                this.requirements = new ArrayList<Requirement>();
                for (ConfigurationSection requirementConfiguration : requirementConfigurations) {
                    this.requirements.add(new Requirement(requirementConfiguration));
                }
            }
            if (configuration.contains("item")) {
                this.items = new ArrayList<ItemStack>();
                ItemStack item = SelectorAction.this.parseItem(configuration.getString("item"));
                if (item != null) {
                    this.items.add(item);
                }
            }
            if (configuration.contains("items") && (itemList = configuration.getStringList("items")).size() > 0) {
                this.items = new ArrayList<ItemStack>();
                for (String itemKey : itemList) {
                    this.items.add(SelectorAction.this.parseItem(itemKey));
                }
            }
            if (this.items != null && this.items.isEmpty()) {
                this.items = null;
            }
            this.icon = SelectorAction.this.parseItem(configuration.getString("icon"));
            this.costModifiers = this.parseCostModifiers(configuration, "cost_modifiers");
            this.costs = this.parseCosts(ConfigurationUtils.getConfigurationSection(configuration, "costs"));
            int cost = configuration.getInt("cost");
            if (cost > 0) {
                if (this.costs == null) {
                    this.costs = new ArrayList<Cost>();
                }
                this.costs.add(new Cost(SelectorAction.this.context.getController(), this.costType, cost));
            }
        }

        @Nullable
        protected List<Cost> parseCosts(ConfigurationSection node) {
            if (node == null) {
                return null;
            }
            ArrayList<Cost> costs = new ArrayList<Cost>();
            Set costKeys = node.getKeys(false);
            for (String key : costKeys) {
                costs.add(new Cost(SelectorAction.this.context.getController(), key, node.getInt(key, 1)));
            }
            return costs;
        }

        @Nullable
        protected List<CostModifier> parseCostModifiers(ConfigurationSection configuration, String section) {
            Collection<ConfigurationSection> modifierConfigs = ConfigurationUtils.getNodeList(configuration, section);
            if (modifierConfigs == null) {
                return null;
            }
            ArrayList<CostModifier> modifiers = new ArrayList<CostModifier>();
            for (ConfigurationSection modifierConfig : modifierConfigs) {
                modifiers.add(new CostModifier(modifierConfig));
            }
            return modifiers;
        }

        public boolean hasLimit() {
            return this.limit > 0;
        }

        public String getCostType() {
            return this.costType;
        }

        public boolean has(CastContext context) {
            Mage mage = context.getMage();
            return this.unlockClass != null && !this.unlockClass.isEmpty() && mage.hasClassUnlocked(this.unlockClass);
        }

        public RequirementsResult checkRequirements(CastContext context) {
            String message;
            MageController controller = context.getController();
            Mage mage = context.getMage();
            Player player = mage.getPlayer();
            if (player == null) {
                return new RequirementsResult(SpellResult.PLAYER_REQUIRED);
            }
            if (this.limit > 0 && SelectorAction.this.has >= this.limit) {
                return new RequirementsResult(SpellResult.NO_TARGET, SelectorAction.this.getMessage("at_limit").replace("$limit", Integer.toString(this.limit)));
            }
            if (this.unlockClass != null && !this.unlockClass.isEmpty() && mage.hasClassUnlocked(this.unlockClass)) {
                return new RequirementsResult(SpellResult.NO_TARGET, SelectorAction.this.getMessage("has_class").replace("$class", this.unlockClass));
            }
            if (this.requirements != null && (message = controller.checkRequirements(context, this.requirements)) != null) {
                return new RequirementsResult(SpellResult.NO_TARGET, message);
            }
            return new RequirementsResult(SpellResult.CAST);
        }

        public boolean isUnlock() {
            return this.unlockKey != null && !this.unlockKey.isEmpty();
        }

        public boolean showIfUnavailable() {
            return this.showUnavailable;
        }
    }

    protected class CostModifier {
        private ModifierType type;
        private String equation;
        private String property;
        private double defaultValue;

        public CostModifier(ConfigurationSection configuration) {
            String typeString = configuration.getString("type");
            try {
                this.type = ModifierType.valueOf(typeString.toUpperCase());
            }
            catch (Exception ex) {
                SelectorAction.this.context.getLogger().warning("Invalid modifier type in selector config: " + typeString);
                this.type = null;
                return;
            }
            this.defaultValue = configuration.getDouble("default");
            this.equation = configuration.getString("scale");
            this.property = this.type == ModifierType.ATTRIBUTE ? configuration.getString("attribute") : configuration.getString("property");
        }

        public void modify(Cost cost) {
            if (this.type == null) {
                return;
            }
            Mage mage = SelectorAction.this.context.getMage();
            double value = this.defaultValue;
            switch (this.type) {
                case MAGE: {
                    value = mage.getProperties().getProperty(this.property, value);
                    break;
                }
                case ATTRIBUTE: {
                    Double attribute = mage.getAttribute(this.property);
                    if (attribute == null) break;
                    value = attribute;
                    break;
                }
                case CLASS: {
                    MageClass activeClass = mage.getActiveClass();
                    if (activeClass == null) break;
                    value = activeClass.getProperty(this.property, value);
                    break;
                }
                case WAND: {
                    com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
                    if (wand == null) break;
                    value = wand.getProperty(this.property, value);
                }
            }
            EquationTransform transform = EquationStore.getInstance().getTransform(this.equation);
            transform.setVariable("x", value);
            double scale = transform.get();
            cost.scale(scale);
        }
    }

    protected static enum ModifierType {
        WAND,
        MAGE,
        CLASS,
        ATTRIBUTE;

    }

    protected class RequirementsResult {
        public final SpellResult result;
        public final String message;

        public RequirementsResult(SpellResult result, String message) {
            this.result = result;
            this.message = message;
        }

        public RequirementsResult(SpellResult result) {
            this(result, this$0.context.getMessage(result.name().toLowerCase()));
        }
    }
}

