/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.builtin.VolumeAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;

public class PlaneAction
extends VolumeAction {
    protected Axis axis;
    protected Axis brushAxis;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        this.axis = this.parseAxis(parameters.getString("axis"), Axis.Y);
        this.brushAxis = this.parseAxis(parameters.getString("brush_axis"), this.axis);
        super.prepare(context, parameters);
    }

    protected Axis parseAxis(String axisType, Axis defaultAxis) {
        if (axisType != null) {
            if (axisType.equalsIgnoreCase("x")) {
                return Axis.X;
            }
            if (axisType.equalsIgnoreCase("z")) {
                return Axis.Z;
            }
            return Axis.Y;
        }
        return defaultAxis;
    }

    @Override
    protected boolean calculateSize(CastContext context) {
        switch (this.axis) {
            case X: {
                this.xSize = 0.0;
                break;
            }
            case Z: {
                this.zSize = 0.0;
                break;
            }
            default: {
                this.ySize = 0.0;
            }
        }
        return super.calculateSize(context);
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        MaterialBrush brush = context.getBrush();
        Location targetLocation = context.getTargetLocation();
        Location orientLocation = targetLocation.clone();
        switch (this.brushAxis) {
            case X: {
                orientLocation.setY(orientLocation.getY() + 1.0);
                orientLocation.setZ(orientLocation.getZ() + 1.0);
                break;
            }
            case Z: {
                orientLocation.setX(orientLocation.getX() + 1.0);
                orientLocation.setY(orientLocation.getY() + 1.0);
                break;
            }
            default: {
                orientLocation.setX(orientLocation.getX() + 1.0);
                orientLocation.setZ(orientLocation.getZ() + 1.0);
            }
        }
        brush.setTarget(orientLocation, targetLocation);
    }

    @Override
    protected boolean containsPoint(int x, int y, int z) {
        return true;
    }

    protected static enum Axis {
        X,
        Y,
        Z;

    }
}

