/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.builtin.CustomProjectileAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.entity.EntityData;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.SafetyUtils;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Wolf;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;

public class EntityProjectileAction
extends CustomProjectileAction {
    private boolean noTarget = true;
    private boolean doTeleport = false;
    private boolean doVelocity = false;
    private boolean orient = false;
    private Vector velocityOffset;
    private Vector locationOffset;
    protected CreatureSpawnEvent.SpawnReason spawnReason = CreatureSpawnEvent.SpawnReason.CUSTOM;
    private Collection<PotionEffect> projectileEffects;
    private com.elmakers.mine.bukkit.api.entity.EntityData entityData;
    protected String variantName;
    protected Entity entity = null;
    protected Plugin plugin = null;

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        this.projectileEffects = ConfigurationUtils.getPotionEffects(parameters.getConfigurationSection("projectile_potion_effects"));
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        String mobType;
        super.prepare(context, parameters);
        this.plugin = context.getPlugin();
        this.doVelocity = parameters.getBoolean("apply_velocity", true);
        this.doTeleport = parameters.getBoolean("teleport", true);
        this.noTarget = parameters.getBoolean("no_target", true);
        this.orient = parameters.getBoolean("orient", false);
        this.velocityOffset = ConfigurationUtils.getVector(parameters, "velocity_offset");
        this.locationOffset = ConfigurationUtils.getVector(parameters, "location_offset");
        if (parameters.contains("spawn_reason")) {
            String reasonText = parameters.getString("spawn_reason").toUpperCase();
            try {
                this.spawnReason = CreatureSpawnEvent.SpawnReason.valueOf((String)reasonText);
            }
            catch (Exception ex) {
                context.getMage().sendMessage("Unknown spawn reason: " + reasonText);
            }
        }
        if ((mobType = parameters.getString("type")) == null || mobType.isEmpty()) {
            context.getLogger().warning("EntityProjectileAction missing type parameter");
        } else {
            this.entityData = context.getController().getMob(mobType);
            if (this.entityData == null) {
                this.entityData = new EntityData(context.getController(), parameters);
            }
        }
        this.variantName = parameters.getString("variant");
        if (this.variantName != null && this.variantName.isEmpty()) {
            this.variantName = null;
        }
    }

    protected Entity setEntity(MageController controller, @Nonnull Entity entity) {
        DyeColor color;
        this.entity = entity;
        if (this.noTarget) {
            entity.setMetadata("notarget", (MetadataValue)new FixedMetadataValue(controller.getPlugin(), (Object)true));
        }
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).setMaxHealth(1000.0);
            ((LivingEntity)entity).setHealth(1000.0);
        }
        if (entity instanceof Slime) {
            ((Slime)entity).setSize(1);
        }
        if (entity instanceof Ocelot) {
            Ocelot ocelot = (Ocelot)entity;
            Ocelot.Type variant = Ocelot.Type.WILD_OCELOT;
            if (this.variantName != null) {
                try {
                    variant = Ocelot.Type.valueOf((String)this.variantName.toUpperCase());
                }
                catch (Exception exception) {}
            } else {
                variant = Ocelot.Type.WILD_OCELOT;
            }
            ocelot.setCatType(variant);
        }
        if (entity instanceof Sheep) {
            Sheep sheep = (Sheep)entity;
            color = DyeColor.WHITE;
            if (this.variantName != null) {
                try {
                    color = DyeColor.valueOf((String)this.variantName.toUpperCase());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            sheep.setColor(color);
        }
        if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            if (this.variantName != null) {
                color = DyeColor.RED;
                try {
                    color = DyeColor.valueOf((String)this.variantName.toUpperCase());
                    wolf.setTamed(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                wolf.setCollarColor(color);
            }
        }
        if (this.projectileEffects != null && entity instanceof LivingEntity) {
            CompatibilityUtils.applyPotionEffects((LivingEntity)entity, this.projectileEffects);
        }
        this.targeting.ignoreEntity(entity);
        return entity;
    }

    @Override
    public SpellResult start(CastContext context) {
        if (this.entity == null) {
            Location location = this.adjustLocation(this.sourceLocation.getLocation(context));
            Entity spawned = this.entityData.spawn(context.getController(), location, this.spawnReason);
            if (spawned != null) {
                this.setEntity(context.getController(), spawned);
            }
        }
        if (this.entity == null) {
            return SpellResult.FAIL;
        }
        return super.start(context);
    }

    protected Location adjustLocation(Location target) {
        if (this.locationOffset != null) {
            target = target.clone().add(this.locationOffset);
        }
        return target;
    }

    @Override
    public SpellResult step(CastContext context) {
        SpellResult result = super.step(context);
        if (this.entity == null) {
            return SpellResult.CAST;
        }
        Location target = this.adjustLocation(this.actionContext.getTargetLocation());
        if (this.doVelocity) {
            Vector velocity = this.velocity.clone().multiply(this.distanceTravelledThisTick);
            if (this.velocityOffset != null) {
                velocity = velocity.add(this.velocityOffset);
            }
            SafetyUtils.setVelocity(this.entity, velocity);
        }
        if (this.doTeleport) {
            if (this.orient) {
                target.setDirection(this.velocity);
            }
            this.entity.teleport(target);
        }
        return result;
    }

    @Override
    public void finishEffects() {
        super.finishEffects();
        if (this.entity != null) {
            if (this.plugin != null) {
                this.entity.removeMetadata("notarget", this.plugin);
            }
            this.entity.remove();
            this.entity = null;
        }
    }
}

