/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public class CycleBlockAction
extends BaseSpellAction {
    private Map<MaterialAndData, MaterialAndData> materials = new HashMap<MaterialAndData, MaterialAndData>();

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        List allMaterials = parameters.getList("materials");
        this.materials.clear();
        if (allMaterials == null) {
            spell.getController().getLogger().warning("CycleBlock action missing materials list");
        } else {
            for (List list : allMaterials) {
                ArrayList<MaterialAndData> materialList = new ArrayList<MaterialAndData>();
                for (String material : list) {
                    MaterialAndData entry = new MaterialAndData(material);
                    if (!entry.isValid()) continue;
                    materialList.add(entry);
                }
                for (int i = 0; i < materialList.size(); ++i) {
                    this.materials.put((MaterialAndData)materialList.get(i), (MaterialAndData)materialList.get((i + 1) % materialList.size()));
                }
            }
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        Block block = context.getTargetBlock();
        if (!context.hasBuildPermission(block)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        MaterialAndData targetMaterial = new MaterialAndData(block);
        MaterialAndData newMaterial = this.materials.get(targetMaterial);
        if (newMaterial == null) {
            return SpellResult.NO_TARGET;
        }
        context.registerForUndo(block);
        newMaterial.modify(block);
        return SpellResult.CAST;
    }

    @Override
    public boolean requiresBuildPermission() {
        return true;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }
}

