/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public abstract class CompoundEntityAction
extends CompoundAction {
    private List<WeakReference<Entity>> entities = new ArrayList<WeakReference<Entity>>();
    private int currentEntity = 0;

    public abstract void addEntities(CastContext var1, List<WeakReference<Entity>> var2);

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.currentEntity = 0;
    }

    @Override
    public SpellResult start(CastContext context) {
        this.entities.clear();
        this.addEntities(context, this.entities);
        return SpellResult.NO_TARGET;
    }

    @Override
    public boolean next(CastContext context) {
        ++this.currentEntity;
        return this.currentEntity < this.entities.size();
    }

    @Override
    public SpellResult step(CastContext context) {
        while (this.currentEntity < this.entities.size()) {
            Entity entity = (Entity)this.entities.get(this.currentEntity).get();
            if (entity == null) {
                ++this.currentEntity;
                this.skippedActions(context);
                continue;
            }
            this.actionContext.setTargetEntity(entity);
            if (entity instanceof LivingEntity) {
                this.actionContext.setTargetLocation(((LivingEntity)entity).getEyeLocation());
            } else {
                this.actionContext.setTargetLocation(entity.getLocation());
            }
            return this.startActions();
        }
        return SpellResult.NO_ACTION;
    }

    @Override
    @Nullable
    public Object clone() {
        CompoundEntityAction action = (CompoundEntityAction)super.clone();
        if (action != null) {
            action.entities = new ArrayList<WeakReference<Entity>>(this.entities);
        }
        return action;
    }
}

