/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.action.GUIAction;
import com.elmakers.mine.bukkit.api.block.CurrencyItem;
import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.WandUpgradePath;
import com.elmakers.mine.bukkit.integration.VaultController;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class BaseShopAction
extends BaseSpellAction
implements GUIAction {
    protected boolean requireWand = false;
    private String permissionNode = null;
    private String requiredPath = null;
    private String requiredTemplate = null;
    private String requiresCompletedPath = null;
    private String exactPath = null;
    protected boolean filterBound = false;
    protected int upgradeLevels = 0;
    protected double costScale = 1.0;
    protected boolean autoClose = true;
    protected boolean autoUpgrade = false;
    protected boolean castsSpells = false;
    protected boolean applyToWand = false;
    protected boolean applyToCaster = false;
    protected boolean isXP = false;
    protected boolean isSkillPoints = false;
    protected boolean sell = false;
    protected boolean isItems = false;
    protected boolean showConfirmation = true;
    protected boolean showActiveIcons = false;
    protected boolean putInHand = true;
    protected ItemStack worthItem = null;
    protected com.elmakers.mine.bukkit.block.MaterialAndData confirmFillMaterial;
    protected CastContext context;
    private Map<Integer, ShopItem> showingItems;
    private List<ItemStack> itemStacks;
    private boolean isActive = false;
    private SpellResult finalResult = null;

    @Override
    public void deactivated() {
        if (this.context != null) {
            this.context.getMage().removeItemsWithTag("shop");
        }
        this.isActive = false;
    }

    @Override
    public void dragged(InventoryDragEvent event) {
        event.setCancelled(true);
    }

    protected String getDefaultMessage(CastContext context, String key) {
        return context.getController().getMessages().get("shops." + key);
    }

    public SpellResult checkContext(CastContext context) {
        String template;
        Mage mage = context.getMage();
        MageController controller = mage.getController();
        Player player = mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        if (this.permissionNode != null && !player.hasPermission(this.permissionNode)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (!this.requireWand) {
            return SpellResult.CAST;
        }
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        if (wand == null) {
            context.showMessage("no_wand", this.getDefaultMessage(context, "no_wand"));
            return SpellResult.FAIL;
        }
        WandUpgradePath path = wand.getPath();
        if (!(this.requiredTemplate == null || (template = wand.getTemplateKey()) != null && template.equals(this.requiredTemplate))) {
            context.showMessage(context.getMessage("no_template", this.getDefaultMessage(context, "no_template")).replace("$wand", wand.getName()));
            return SpellResult.FAIL;
        }
        if (this.requiredPath != null || this.exactPath != null) {
            WandUpgradePath requiresPath;
            if (path == null) {
                context.showMessage(context.getMessage("no_path", this.getDefaultMessage(context, "no_path")).replace("$wand", wand.getName()));
                return SpellResult.FAIL;
            }
            if (this.requiredPath != null && !path.hasPath(this.requiredPath)) {
                requiresPath = controller.getPath(this.requiredPath);
                if (requiresPath != null) {
                    context.showMessage(context.getMessage("no_required_path", this.getDefaultMessage(context, "no_required_path")).replace("$path", requiresPath.getName()));
                } else {
                    context.getLogger().warning("Invalid path specified in Shop action: " + this.requiredPath);
                }
                return SpellResult.FAIL;
            }
            if (this.exactPath != null && !this.exactPath.equals(path.getKey())) {
                requiresPath = controller.getPath(this.exactPath);
                if (requiresPath != null) {
                    context.showMessage(context.getMessage("no_path_exact", this.getDefaultMessage(context, "no_path_exact")).replace("$path", requiresPath.getName()));
                } else {
                    context.getLogger().warning("Invalid path specified in Shop action: " + this.exactPath);
                }
                return SpellResult.FAIL;
            }
            if (this.requiresCompletedPath != null && path.canEnchant(wand)) {
                context.showMessage(context.getMessage("no_path_end", this.getDefaultMessage(context, "no_path_end")).replace("$path", path.getName()));
                return SpellResult.FAIL;
            }
        }
        return SpellResult.CAST;
    }

    protected boolean hasItemCosts(CastContext context, ShopItem shopItem) {
        Mage mage = context.getMage();
        MageController controller = context.getController();
        double worth = shopItem.getWorth();
        boolean hasCosts = true;
        if (worth > 0.0) {
            if (this.isXP) {
                worth = Math.ceil(this.costScale * worth * controller.getWorthBase() / controller.getWorthXP());
                hasCosts = mage.getExperience() >= (int)worth;
            } else if (this.isItems) {
                worth = Math.ceil(this.costScale * worth * controller.getWorthBase() / controller.getWorthItemAmount());
                int hasAmount = this.getItemAmount(controller, mage);
                hasCosts = (double)hasAmount >= worth;
            } else if (this.isSkillPoints) {
                worth = Math.ceil(this.costScale * worth * controller.getWorthBase() / controller.getWorthSkillPoints());
                hasCosts = (double)mage.getSkillPoints() >= Math.ceil(worth);
            } else {
                worth = Math.ceil(this.costScale * worth * controller.getWorthBase());
                hasCosts = VaultController.getInstance().has(mage.getPlayer(), worth);
            }
        }
        return hasCosts;
    }

    protected String getItemCost(CastContext context, ShopItem shopItem) {
        String amountString = "?";
        MageController controller = context.getController();
        Messages messages = controller.getMessages();
        double worth = shopItem.getWorth();
        if (this.isXP) {
            worth = Math.ceil(this.costScale * worth * controller.getWorthBase() / controller.getWorthXP());
            amountString = Integer.toString((int)worth);
            amountString = messages.get("costs.xp_amount").replace("$amount", amountString);
        } else if (this.isItems) {
            worth = Math.ceil(this.costScale * worth * controller.getWorthBase() / controller.getWorthItemAmount());
            amountString = this.formatItemAmount(controller, worth);
        } else if (this.isSkillPoints) {
            worth = Math.ceil(this.costScale * worth * controller.getWorthBase() / controller.getWorthSkillPoints());
            amountString = Integer.toString((int)Math.ceil(worth));
            amountString = messages.get("costs.sp_amount").replace("$amount", amountString);
        } else {
            worth = Math.ceil(this.costScale * worth * controller.getWorthBase());
            amountString = VaultController.getInstance().format(worth);
        }
        return amountString;
    }

    protected void giveCosts(CastContext context, ShopItem shopItem) {
        Mage mage = context.getMage();
        MageController controller = context.getController();
        double worth = shopItem.getWorth();
        if (this.isXP) {
            worth = Math.ceil(this.costScale * worth * controller.getWorthBase() / controller.getWorthXP());
            mage.giveExperience((int)worth);
        } else if (this.isItems) {
            worth = Math.ceil(this.costScale * worth * controller.getWorthBase() / controller.getWorthItemAmount());
            ItemStack worthItem = this.getWorthItem(controller);
            for (int amount = (int)Math.ceil(worth); amount > 0; amount -= worthItem.getAmount()) {
                worthItem = InventoryUtils.getCopy(worthItem);
                worthItem.setAmount(Math.min(amount, 64));
                mage.giveItem(worthItem);
            }
        } else if (this.isSkillPoints) {
            worth = Math.ceil(this.costScale * worth * controller.getWorthBase() / controller.getWorthSkillPoints());
            int amount = (int)Math.ceil(worth);
            mage.addSkillPoints(amount);
        } else {
            worth = Math.ceil(this.costScale * worth * controller.getWorthBase());
            VaultController.getInstance().depositPlayer(mage.getPlayer(), worth);
        }
    }

    protected boolean takeCosts(CastContext context, ShopItem shopItem) {
        Mage mage = context.getMage();
        MageController controller = context.getController();
        double worth = shopItem.getWorth();
        if (this.isXP) {
            worth = Math.ceil(this.costScale * worth * controller.getWorthBase() / controller.getWorthXP());
            mage.removeExperience((int)worth);
        } else if (this.isItems) {
            worth = Math.ceil(this.costScale * worth * controller.getWorthBase() / controller.getWorthItemAmount());
            this.removeItems(controller, mage, (int)Math.ceil(worth));
        } else if (this.isSkillPoints) {
            worth = Math.ceil(this.costScale * worth * controller.getWorthBase() / controller.getWorthSkillPoints());
            mage.addSkillPoints(-((int)Math.ceil(worth)));
        } else {
            worth = Math.ceil(this.costScale * worth * controller.getWorthBase());
            VaultController.getInstance().withdrawPlayer(mage.getPlayer(), worth);
        }
        return true;
    }

    @Override
    public void clicked(InventoryClickEvent event) {
        boolean hasCosts;
        event.setCancelled(true);
        ItemStack item = event.getCurrentItem();
        Mage mage = this.context.getMage();
        if (item == null || !InventoryUtils.hasMeta(item, "shop")) {
            if (!this.autoClose) {
                mage.deactivateGUI();
            }
            return;
        }
        int slotIndex = Integer.parseInt(InventoryUtils.getMetaString(item, "shop"));
        MageController controller = this.context.getController();
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        ShopItem shopItem = this.showingItems.get(slotIndex);
        if (shopItem == null) {
            return;
        }
        String unpurchasableMessage = InventoryUtils.getMetaString(shopItem.getItem(), "unpurchasable");
        if (unpurchasableMessage != null && !unpurchasableMessage.isEmpty()) {
            this.context.showMessage(unpurchasableMessage);
            mage.deactivateGUI();
            return;
        }
        boolean bl = hasCosts = this.sell ? this.hasItem(controller, mage, shopItem.getItem()) : this.hasItemCosts(this.context, shopItem);
        if (!hasCosts) {
            String costString = this.context.getMessage("insufficient", this.getDefaultMessage(this.context, "insufficient"));
            costString = this.sell ? costString.replace("$cost", this.formatItemAmount(controller, item, shopItem.getItem().getAmount())) : costString.replace("$cost", this.getItemCost(this.context, shopItem));
            this.context.showMessage(costString);
        } else {
            String itemName = this.formatItemAmount(controller, item, item.getAmount());
            if (InventoryUtils.hasMeta(item, "confirm")) {
                String inventoryTitle = this.context.getMessage("confirm_title", this.getDefaultMessage(this.context, "confirm_title")).replace("$item", itemName);
                Inventory confirmInventory = CompatibilityUtils.createInventory(null, 9, inventoryTitle);
                InventoryUtils.removeMeta(item, "confirm");
                for (int i = 0; i < 9; ++i) {
                    if (i != 4) {
                        ItemStack filler = this.confirmFillMaterial.getItemStack(1);
                        ItemMeta meta = filler.getItemMeta();
                        if (meta != null) {
                            meta.setDisplayName(ChatColor.DARK_GRAY + (i < 4 ? "-->" : "<--"));
                            filler.setItemMeta(meta);
                        }
                        confirmInventory.setItem(i, filler);
                        continue;
                    }
                    confirmInventory.setItem(i, item);
                }
                mage.deactivateGUI();
                this.isActive = true;
                mage.activateGUI(this, confirmInventory);
                return;
            }
            String costString = this.context.getMessage("deducted", this.getDefaultMessage(this.context, "deducted"));
            if (this.sell) {
                costString = costString.replace("$cost", this.getItemCost(this.context, shopItem));
                this.removeItems(controller, mage, item, shopItem.getItem().getAmount());
                this.giveCosts(this.context, shopItem);
            } else {
                costString = costString.replace("$cost", this.getItemCost(this.context, shopItem));
                item = shopItem.getItem();
                if (this.requireWand) {
                    if (wand == null) {
                        this.context.showMessage("no_wand", this.getDefaultMessage(this.context, "no_wand"));
                        mage.deactivateGUI();
                        return;
                    }
                    if (this.applyToWand && !wand.addItem(item)) {
                        String inapplicable = this.context.getMessage("not_applicable", this.getDefaultMessage(this.context, "not_applicable")).replace("$item", itemName);
                        this.context.showMessage(inapplicable);
                        mage.deactivateGUI();
                        return;
                    }
                }
                CasterProperties caster = this.getCaster(this.context);
                if (this.applyToCaster && !caster.addItem(item)) {
                    String inapplicable = this.context.getMessage("not_applicable", this.getDefaultMessage(this.context, "not_applicable")).replace("$item", itemName);
                    this.context.showMessage(inapplicable);
                    mage.deactivateGUI();
                    return;
                }
                if (this.castsSpells) {
                    MageSpell spell = null;
                    String spellKey = controller.getSpell(item);
                    String spellArgs = controller.getSpellArgs(item);
                    spell = mage.getSpell(spellKey);
                    if (spell != null && (spellArgs != null ? !spell.cast(StringUtils.split((String)spellArgs, (char)' ')) : !spell.cast())) {
                        this.context.showMessage("cast_fail", this.getDefaultMessage(this.context, "cast_fail"));
                        mage.deactivateGUI();
                        return;
                    }
                }
                if (!this.takeCosts(this.context, shopItem)) {
                    costString = this.context.getMessage("insufficient", this.getDefaultMessage(this.context, "insufficient"));
                    costString = costString.replace("$cost", this.getItemCost(this.context, shopItem));
                    this.context.showMessage(costString);
                    return;
                }
                if (!(this.castsSpells || this.applyToWand || this.applyToCaster)) {
                    com.elmakers.mine.bukkit.api.wand.Wand newWand;
                    MaterialAndData inactiveIcon;
                    ItemStack copy = InventoryUtils.getCopy(item);
                    if (this.filterBound && Wand.isBound(copy)) {
                        com.elmakers.mine.bukkit.api.wand.Wand bindWand = controller.getWand(copy);
                        mage.tryToOwn(bindWand);
                    }
                    if (this.showActiveIcons && controller.getAPI().isWand(copy) && (inactiveIcon = (newWand = controller.getWand(copy)).getInactiveIcon()) != null) {
                        inactiveIcon.applyToItem(copy);
                    }
                    Player player = mage.getPlayer();
                    if (this.putInHand) {
                        this.context.getController().giveItemToPlayer(player, copy);
                    } else {
                        PlayerInventory inventory = player.getInventory();
                        ItemStack inHand = inventory.getItemInMainHand();
                        Integer freeSlot = null;
                        if (InventoryUtils.isEmpty(inHand)) {
                            for (int i = 0; i < inventory.getSize() && freeSlot == null; ++i) {
                                if (i == inventory.getHeldItemSlot() || !InventoryUtils.isEmpty(inventory.getItem(i))) continue;
                                freeSlot = i;
                            }
                        }
                        if (freeSlot == null) {
                            this.context.getController().giveItemToPlayer(player, copy);
                        } else {
                            inventory.setItem(freeSlot.intValue(), copy);
                        }
                    }
                }
            }
            costString = costString.replace("$item", itemName);
            this.context.showMessage(costString);
            if (!this.sell && wand != null && this.autoUpgrade) {
                if (this.upgradeLevels <= 0) {
                    WandUpgradePath nextPath;
                    WandUpgradePath path = wand.getPath();
                    WandUpgradePath wandUpgradePath = nextPath = path != null ? path.getUpgrade() : null;
                    if (nextPath != null && path.checkUpgradeRequirements(wand, null) && !path.canEnchant(wand)) {
                        path.upgrade(wand, mage);
                    }
                } else {
                    wand.enchant(this.upgradeLevels, mage, false);
                }
            }
            this.finalResult = SpellResult.CAST;
            this.onPurchase(this.context, item);
        }
        if (this.autoClose) {
            mage.deactivateGUI();
        } else {
            mage.continueGUI(this, this.getInventory(this.context));
        }
    }

    protected void onPurchase(CastContext context, ItemStack itemPurchased) {
    }

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        this.castsSpells = parameters.getBoolean("cast_spells", false);
        this.showActiveIcons = parameters.getBoolean("show_active_icons", false);
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.permissionNode = parameters.getString("permission", null);
        this.sell = parameters.getBoolean("sell", false);
        this.showConfirmation = parameters.getBoolean("confirm", true);
        this.confirmFillMaterial = ConfigurationUtils.getMaterialAndData(parameters, "confirm_filler", new com.elmakers.mine.bukkit.block.MaterialAndData(Material.AIR));
        this.requiredPath = parameters.getString("path", null);
        this.exactPath = parameters.getString("path_exact", null);
        this.requiresCompletedPath = parameters.getString("path_end", null);
        this.requiredTemplate = parameters.getString("require_template", null);
        this.autoUpgrade = parameters.getBoolean("auto_upgrade", false);
        this.upgradeLevels = parameters.getInt("upgrade_levels", 0);
        this.requireWand = parameters.getBoolean("require_wand", false);
        this.autoClose = parameters.getBoolean("auto_close", true);
        this.costScale = parameters.getDouble("scale", 1.0);
        this.filterBound = parameters.getBoolean("filter_bound", false);
        this.putInHand = parameters.getBoolean("put_in_hand", true);
        String worthItemKey = parameters.getString("worth_item", "");
        this.worthItem = !worthItemKey.isEmpty() ? context.getController().createItem(worthItemKey) : null;
        if (!this.autoClose) {
            this.showConfirmation = false;
        }
        if (this.requiresCompletedPath != null) {
            this.requiredPath = this.requiresCompletedPath;
            this.exactPath = this.requiresCompletedPath;
        }
        if (this.requiredPath != null || this.exactPath != null || this.requiredTemplate != null) {
            this.requireWand = true;
        }
        this.applyToCaster = parameters.getBoolean("apply_to_caster", false);
        this.applyToWand = parameters.getBoolean("apply_to_wand", this.requireWand && !this.applyToCaster);
        if (this.applyToWand) {
            this.applyToCaster = false;
            this.requireWand = true;
        }
        MageController controller = context.getController();
        this.isXP = parameters.getBoolean("use_xp", false);
        this.isItems = parameters.getBoolean("use_items", false) && this.getWorthItem(controller) != null;
        boolean bl = this.isSkillPoints = parameters.getBoolean("use_sp", false) && controller.isSPEnabled();
        if (!(this.isSkillPoints || this.isXP || this.isItems || VaultController.hasEconomy())) {
            if (this.getWorthItem(controller) != null) {
                this.isItems = true;
            } else {
                this.isSkillPoints = true;
            }
        }
        this.finalResult = null;
        this.isActive = false;
    }

    protected String getBalanceDescription(CastContext context) {
        Mage mage = context.getMage();
        MageController controller = context.getController();
        Messages messages = controller.getMessages();
        String description = "";
        if (this.isXP) {
            String xpAmount = Integer.toString(mage.getExperience());
            description = messages.get("costs.xp_amount").replace("$amount", xpAmount);
        } else if (this.isItems) {
            int itemAmount = this.getItemAmount(controller, mage);
            description = this.formatItemAmount(controller, itemAmount);
        } else if (this.isSkillPoints) {
            String spAmount = Integer.toString(mage.getSkillPoints());
            description = messages.get("costs.sp_amount").replace("$amount", spAmount);
        } else {
            double balance = VaultController.getInstance().getBalance(mage.getPlayer());
            description = VaultController.getInstance().format(balance);
        }
        return description;
    }

    public SpellResult showItems(CastContext context, List<ShopItem> items) {
        Mage mage = context.getMage();
        this.context = context;
        Player player = mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        this.showingItems = new HashMap<Integer, ShopItem>();
        this.itemStacks = new ArrayList<ItemStack>();
        String costString = context.getMessage("cost_lore", this.getDefaultMessage(context, "cost_lore"));
        String costHeading = context.getMessage("cost_heading", this.getDefaultMessage(context, "cost_heading"));
        for (ShopItem shopItem : items) {
            String costs;
            String permission;
            String template;
            int currentSlot = this.itemStacks.size();
            if (this.filterBound && shopItem != null && (template = Wand.getWandTemplate(shopItem.getItem())) != null && mage.getBoundWand(template) != null) {
                shopItem = null;
            }
            if (shopItem == null) {
                this.showingItems.put(currentSlot, null);
                this.itemStacks.add(new ItemStack(Material.AIR));
                continue;
            }
            ItemStack item = InventoryUtils.getCopy(shopItem.getItem());
            if (item == null || (permission = shopItem.getPermission()) != null && !permission.isEmpty() && !player.hasPermission(permission)) continue;
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                this.itemStacks.add(item);
                continue;
            }
            ArrayList<String> lore = meta.getLore();
            if (lore == null) {
                lore = new ArrayList<String>();
            }
            if (!costHeading.isEmpty()) {
                InventoryUtils.wrapText(costHeading, lore);
            }
            if (!(costs = costString.replace("$cost", this.getItemCost(context, shopItem))).isEmpty()) {
                lore.add(costs);
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
            item = InventoryUtils.makeReal(item);
            InventoryUtils.setMeta(item, "shop", Integer.toString(currentSlot));
            if (this.showConfirmation) {
                InventoryUtils.setMeta(item, "confirm", "true");
            }
            this.showingItems.put(currentSlot, shopItem);
            this.itemStacks.add(item);
        }
        if (this.itemStacks.size() == 0) {
            context.showMessage("no_items", this.getDefaultMessage(context, "no_items"));
            return SpellResult.FAIL;
        }
        this.isActive = true;
        this.finalResult = SpellResult.NO_ACTION;
        Inventory displayInventory = this.getInventory(context);
        mage.activateGUI(this, displayInventory);
        return SpellResult.PENDING;
    }

    protected String getInventoryTitle(CastContext context) {
        String pathName;
        com.elmakers.mine.bukkit.api.wand.Wand wand = context.getWand();
        WandUpgradePath path = wand == null ? null : wand.getPath();
        String string = pathName = path == null ? null : path.getName();
        if (pathName == null) {
            pathName = "";
        }
        String title = context.getMessage("title", this.getDefaultMessage(context, "title"));
        title = title.replace("$path", pathName);
        return title;
    }

    protected Inventory getInventory(CastContext context) {
        String inventoryTitle = this.getInventoryTitle(context);
        String balanceDescription = this.getBalanceDescription(context);
        inventoryTitle = inventoryTitle.replace("$balance", balanceDescription);
        int invSize = this.itemStacks == null ? 0 : this.itemStacks.size();
        invSize = (int)Math.ceil((float)invSize / 9.0f) * 9;
        Inventory displayInventory = CompatibilityUtils.createInventory(null, invSize, inventoryTitle);
        if (this.itemStacks != null) {
            int slot = 0;
            for (ItemStack item : this.itemStacks) {
                displayInventory.setItem(slot++, item);
            }
        }
        return displayInventory;
    }

    @Nullable
    protected ItemStack getWorthItem(MageController controller) {
        return this.worthItem == null ? controller.getWorthItem() : this.worthItem;
    }

    protected String formatItemAmount(MageController controller, double amount) {
        CurrencyItem currency = controller.getCurrency();
        if (this.worthItem == null && currency != null) {
            int evenAmount = (int)Math.ceil(amount);
            String currencyName = currency.getName();
            if (currencyName != null && !currencyName.isEmpty()) {
                if (evenAmount == 1) {
                    return Integer.toString(evenAmount) + " " + currencyName;
                }
                String pluralName = currency.getPluralName();
                if (pluralName == null || pluralName.isEmpty()) {
                    pluralName = currencyName;
                }
                return Integer.toString(evenAmount) + " " + pluralName;
            }
        }
        return this.formatItemAmount(controller, this.getWorthItem(controller), amount);
    }

    protected String formatItemAmount(MageController controller, ItemStack item, double amount) {
        String spellKey = controller.getSpell(item);
        if (spellKey != null) {
            SpellKey key = new SpellKey(spellKey);
            if (key.getLevel() > 1) {
                return controller.describeItem(item) + " " + controller.getMessages().get("spell.level_description").replace("$level", Integer.toString(key.getLevel()));
            }
            return controller.describeItem(item);
        }
        return Integer.toString((int)Math.ceil(amount)) + " " + controller.describeItem(item);
    }

    protected boolean hasItem(MageController controller, Mage mage, ItemStack item) {
        if (Wand.isSP(item)) {
            return mage.hasItem(item);
        }
        return this.getItemAmount(controller, item, mage) >= item.getAmount();
    }

    protected int getItemAmount(MageController controller, Mage mage) {
        return this.getItemAmount(controller, this.getWorthItem(controller), mage);
    }

    protected int getItemAmount(MageController controller, ItemStack worthItem, Mage mage) {
        if (Wand.isSP(worthItem)) {
            return mage.getSkillPoints();
        }
        int itemAmount = 0;
        ItemStack[] contents = mage.getInventory().getContents();
        for (int i = 0; i < contents.length; ++i) {
            if (contents[i] == null || !controller.itemsAreEqual(contents[i], worthItem)) continue;
            itemAmount += contents[i].getAmount();
        }
        return itemAmount;
    }

    protected void removeItems(MageController controller, Mage mage, int amount) {
        this.removeItems(controller, mage, this.getWorthItem(controller), amount);
    }

    protected void removeItems(MageController controller, Mage mage, ItemStack worthItem, int amount) {
        if (Wand.isSP(worthItem)) {
            mage.removeItem(worthItem);
            return;
        }
        int remainingAmount = amount;
        Inventory inventory = mage.getInventory();
        ItemStack[] contents = inventory.getContents();
        for (int i = 0; i < contents.length; ++i) {
            if (contents[i] != null && controller.itemsAreEqual(contents[i], worthItem)) {
                if (contents[i].getAmount() <= remainingAmount) {
                    remainingAmount -= contents[i].getAmount();
                    contents[i] = null;
                } else {
                    contents[i].setAmount(contents[i].getAmount() - remainingAmount);
                    remainingAmount = 0;
                }
            }
            if (remainingAmount <= 0) break;
        }
        inventory.setContents(contents);
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("confirm");
        parameters.add("path");
        parameters.add("path_end");
        parameters.add("path_exact");
        parameters.add("auto_upgrade");
        parameters.add("require_wand");
        parameters.add("permission");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        MageController controller = spell.getController();
        if (parameterKey.equals("path") || parameterKey.equals("path_exact") || parameterKey.equals("path_end")) {
            examples.addAll(controller.getWandPathKeys());
        } else if (parameterKey.equals("require_wand") || parameterKey.equals("confirm") || parameterKey.equals("auto_upgrade")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public void finish(CastContext context) {
        this.isActive = false;
        this.finalResult = null;
    }

    @Override
    public SpellResult perform(CastContext context) {
        if (this.isActive) {
            return SpellResult.PENDING;
        }
        if (this.finalResult != null) {
            return this.finalResult;
        }
        SpellResult contextResult = this.checkContext(context);
        if (!contextResult.isSuccess()) {
            return contextResult;
        }
        List<ShopItem> items = this.getItems(context);
        if (items == null) {
            return SpellResult.NO_ACTION;
        }
        return this.showItems(context, items);
    }

    @Nullable
    protected abstract List<ShopItem> getItems(CastContext var1);

    @Nonnull
    protected CasterProperties getCaster(CastContext context) {
        Mage mage = context.getMage();
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        CasterProperties caster = wand;
        if (caster == null) {
            caster = mage.getActiveClass();
        }
        if (caster == null) {
            caster = mage.getProperties();
        }
        return caster;
    }

    protected static class ShopItem
    implements Comparable<ShopItem> {
        @Nonnull
        private final ItemStack item;
        private final double worth;
        @Nullable
        private final String permission;
        @Nullable
        private final ConfigurationSection configuration;

        public ShopItem(ItemStack item, double worth) {
            this.item = (ItemStack)Preconditions.checkNotNull((Object)item);
            this.worth = worth;
            this.permission = null;
            this.configuration = null;
        }

        public ShopItem(MageController controller, ItemStack item, ConfigurationSection configuration) {
            double worth = configuration.getDouble("cost", -1.0);
            if (worth < 0.0) {
                Double defaultWorth = controller.getWorth(item);
                worth = defaultWorth == null ? 0.0 : defaultWorth;
            }
            this.item = (ItemStack)Preconditions.checkNotNull((Object)item);
            this.worth = worth;
            this.permission = configuration.getString("permission");
            this.configuration = configuration;
        }

        public ShopItem(MageController controller, ItemStack item, double worth) {
            if (worth < 0.0) {
                Double defaultWorth = controller.getWorth(item);
                worth = defaultWorth == null ? 0.0 : defaultWorth;
            }
            this.item = item;
            this.worth = worth;
            this.permission = null;
            this.configuration = null;
        }

        public double getWorth() {
            return this.worth;
        }

        public ItemStack getItem() {
            return this.item;
        }

        @Nullable
        public String getPermission() {
            return this.permission;
        }

        @Nullable
        public ConfigurationSection getConfiguration() {
            return this.configuration;
        }

        @Override
        public int compareTo(ShopItem o) {
            return (int)(this.worth - o.worth);
        }
    }
}

