/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.google.common.io.Files;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class MagicConfigCommandExecutor
extends MagicTabExecutor {
    public MagicConfigCommandExecutor(MagicAPI api) {
        super(api);
    }

    @Override
    public Collection<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        HashSet<String> options = new HashSet<String>();
        if (!sender.hasPermission("Magic.commands.mconfig")) {
            return options;
        }
        if (args.length == 1) {
            this.addIfPermissible(sender, options, "Magic.commands.mconfig.clean", "clean");
        }
        return options;
    }

    public boolean onCommand(CommandSender sender, Command command, String alias, String[] args) {
        if (!this.api.hasPermission(sender, "Magic.commands.mconfig")) {
            this.sendNoPermission(sender);
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("Usage: mconfig [clean]");
            return true;
        }
        String subCommand = args[0];
        if (!this.api.hasPermission(sender, "Magic.commands.mconfig." + subCommand)) {
            this.sendNoPermission(sender);
            return true;
        }
        if (subCommand.equals("clean")) {
            this.onMagicClean(sender, args.length > 1 ? args[1] : "");
        } else {
            sender.sendMessage("Usage: mconfig [clean]");
        }
        return true;
    }

    protected void onMagicClean(CommandSender sender, String configName) {
        ArrayList<String> configFiles = new ArrayList<String>();
        if (!configName.isEmpty()) {
            configFiles.add(configName);
        } else {
            configFiles.add("spells");
            configFiles.add("wands");
            configFiles.add("paths");
            configFiles.add("mobs");
            configFiles.add("items");
            configFiles.add("crafting");
            configFiles.add("materials");
            configFiles.add("messages");
        }
        File pluginFolder = this.api.getPlugin().getDataFolder();
        for (String configFileName : configFiles) {
            sender.sendMessage(ChatColor.AQUA + "Checking " + ChatColor.DARK_AQUA + configFileName);
            try {
                File defaultsFile = new File(pluginFolder, "defaults/" + configFileName + ".defaults.yml");
                File configFile = new File(pluginFolder, configFileName + ".yml");
                YamlConfiguration cleanConfig = new YamlConfiguration();
                YamlConfiguration currentConfig = new YamlConfiguration();
                currentConfig.load(configFile);
                YamlConfiguration defaultConfig = new YamlConfiguration();
                defaultConfig.load(defaultsFile);
                Set allKeys = currentConfig.getKeys(true);
                for (String key : allKeys) {
                    Object defaultValue = defaultConfig.get(key);
                    Object configValue = currentConfig.get(key);
                    if (configValue instanceof ConfigurationSection || !this.areDifferent(configValue, defaultValue)) continue;
                    cleanConfig.set(key, configValue);
                }
                int originalTopSize = currentConfig.getKeys(false).size();
                int cleanTopSize = cleanConfig.getKeys(false).size();
                int cleanSize = cleanConfig.getKeys(true).size();
                int removedCount = allKeys.size() - cleanSize;
                if (removedCount > 0) {
                    int removedTopCount = originalTopSize - cleanTopSize;
                    sender.sendMessage(ChatColor.LIGHT_PURPLE + "Removed " + ChatColor.GOLD + removedTopCount + ChatColor.LIGHT_PURPLE + " top-level sections and " + ChatColor.GOLD + removedCount + ChatColor.LIGHT_PURPLE + " total sections.");
                    File backupFile = new File(pluginFolder, configFileName + ".yml.bak");
                    if (backupFile.exists()) {
                        sender.sendMessage(ChatColor.YELLOW + "  Backup file exists, will not overwrite: " + backupFile.getName());
                    } else {
                        sender.sendMessage(ChatColor.DARK_PURPLE + "  Saved backup file to " + backupFile.getName() + ", delete this file if all looks good.");
                        Files.copy((File)configFile, (File)backupFile);
                    }
                    String[] lines = StringUtils.split((String)cleanConfig.saveToString(), (char)'\n');
                    PrintWriter out = new PrintWriter(configFile);
                    out.println("#");
                    out.println("# Default options have been removed from the file via /mconfig clean");
                    out.println("#");
                    for (String line : lines) {
                        if (!line.startsWith(" ")) {
                            out.println("");
                        }
                        out.println(line);
                    }
                    out.close();
                    continue;
                }
                sender.sendMessage(ChatColor.GOLD + "Looks clean to me!");
            }
            catch (Exception ex) {
                sender.sendMessage(ChatColor.RED + "An error occurred, please check logs!");
                ex.printStackTrace();
            }
        }
    }

    private boolean areDifferent(Object configValue, Object defaultValue) {
        if (defaultValue == null) {
            return true;
        }
        if (configValue instanceof ConfigurationSection || configValue instanceof Map) {
            if (!(defaultValue instanceof ConfigurationSection) && !(defaultValue instanceof Map)) {
                return true;
            }
            Map<String, Object> configMap = configValue instanceof ConfigurationSection ? NMSUtils.getMap((ConfigurationSection)configValue) : (Map<String, Object>)configValue;
            Map<String, Object> defaultMap = defaultValue instanceof ConfigurationSection ? NMSUtils.getMap((ConfigurationSection)defaultValue) : (Map<String, Object>)defaultValue;
            return !configMap.equals(defaultMap);
        }
        if (configValue instanceof List) {
            if (!(defaultValue instanceof List)) {
                return true;
            }
            List configList = (List)configValue;
            List defaultList = (List)defaultValue;
            if (configList.size() != defaultList.size()) {
                return true;
            }
            for (int i = 0; i < configList.size(); ++i) {
                if (!this.areDifferent(configList.get(i), defaultList.get(i))) continue;
                return true;
            }
            return false;
        }
        return !defaultValue.equals(configValue);
    }
}

