/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.magic.ProgressionPath;
import com.elmakers.mine.bukkit.magic.BaseMagicConfigurable;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MageClassTemplate;
import com.elmakers.mine.bukkit.magic.MageProperties;
import com.elmakers.mine.bukkit.magic.MagicPropertyType;
import com.elmakers.mine.bukkit.magic.TemplatedProperties;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class MageClass
extends TemplatedProperties
implements com.elmakers.mine.bukkit.api.magic.MageClass {
    protected final MageClassTemplate template;
    protected final MageProperties mageProperties;
    protected final Mage mage;
    private MageClass parent;

    public MageClass(@Nonnull Mage mage, @Nonnull MageClassTemplate template) {
        super(template.hasParent() ? MagicPropertyType.SUBCLASS : MagicPropertyType.CLASS, mage.getController());
        this.template = template;
        this.mageProperties = mage.getProperties();
        this.mage = mage;
    }

    @Override
    protected void migrateProperty(String key, MagicPropertyType propertyType) {
        super.migrateProperty(key, propertyType, this.template);
    }

    @Override
    public boolean hasProperty(String key) {
        BaseMagicConfigurable storage = this.getStorage(key);
        if (storage != null) {
            return storage.hasOwnProperty(key);
        }
        return this.hasOwnProperty(key) || this.template.hasProperty(key);
    }

    @Override
    public Object getProperty(String key) {
        Object value = null;
        BaseMagicConfigurable storage = this.getStorage(key);
        if (storage != null && storage != this) {
            value = storage.getProperty(key);
        }
        if (value == null) {
            value = super.getProperty(key);
        }
        if (value == null) {
            value = this.template.getProperty(key);
        }
        return value;
    }

    @Override
    public Object getInheritedProperty(String key) {
        Object value = super.getProperty(key);
        if (value == null) {
            value = this.template.getProperty(key);
        }
        if (value == null && this.parent != null) {
            value = this.parent.getInheritedProperty(key);
        }
        return value;
    }

    @Override
    @Nonnull
    public MageClassTemplate getTemplate() {
        return this.template;
    }

    @Nullable
    public MageClass getParent() {
        return this.parent;
    }

    public MageClass getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    public void setParent(@Nonnull MageClass parent) {
        this.parent = parent;
    }

    @Override
    public void describe(CommandSender sender, @Nullable Set<String> ignoreProperties) {
        super.describe(sender, ignoreProperties);
        Set hideKeys = this.getConfiguration().getKeys(false);
        if (ignoreProperties != null) {
            hideKeys.addAll(ignoreProperties);
        }
        this.template.describe(sender, hideKeys);
        hideKeys.addAll(this.template.getConfiguration().getKeys(false));
        MageClass parent = this.getParent();
        if (parent != null) {
            sender.sendMessage(ChatColor.AQUA + "Parent Class: " + ChatColor.GREEN + parent.getTemplate().getKey());
            parent.describe(sender, hideKeys);
        }
    }

    public ConfigurationSection getEffectiveConfiguration() {
        ConfigurationSection effectiveConfiguration = ConfigurationUtils.cloneConfiguration(this.getConfiguration());
        ConfigurationSection templateConfiguration = this.template.getConfiguration();
        ConfigurationUtils.overlayConfigurations(effectiveConfiguration, templateConfiguration);
        if (this.parent != null) {
            ConfigurationSection parentConfiguration = this.parent.getEffectiveConfiguration();
            ConfigurationUtils.overlayConfigurations(effectiveConfiguration, parentConfiguration);
        } else {
            ConfigurationSection mageConfiguration = this.mageProperties.getConfiguration();
            ConfigurationUtils.overlayConfigurations(effectiveConfiguration, mageConfiguration);
        }
        return effectiveConfiguration;
    }

    @Override
    protected BaseMagicConfigurable getStorage(MagicPropertyType propertyType) {
        switch (propertyType) {
            case SUBCLASS: {
                return this;
            }
            case CLASS: {
                return this.getRoot();
            }
            case MAGE: {
                return this.mageProperties;
            }
        }
        return null;
    }

    @Override
    public boolean tickMana() {
        if (!this.hasOwnMana() && this.parent != null) {
            return this.parent.tickMana();
        }
        return super.tickMana();
    }

    @Override
    public Mage getMage() {
        return this.mage;
    }

    @Override
    public boolean isPlayer() {
        return this.mageProperties.isPlayer();
    }

    @Override
    public Player getPlayer() {
        return this.mageProperties.getPlayer();
    }

    @Override
    public void loadProperties() {
        if (this.parent != null) {
            this.parent.loadProperties();
        }
        super.loadProperties();
        this.armorUpdated();
    }

    @Override
    public String getKey() {
        return this.template.getKey();
    }

    @Override
    public void armorUpdated() {
        if (this.hasOwnMana()) {
            this.updateMaxMana(this.mage);
        }
    }

    @Override
    public boolean updateMaxMana(Mage mage) {
        if (!this.hasOwnMana()) {
            boolean modified = false;
            if (this.parent != null) {
                modified = this.parent.updateMaxMana(mage);
                this.effectiveManaMax = this.parent.getEffectiveManaMax();
                this.effectiveManaRegeneration = this.parent.getEffectiveManaRegeneration();
            }
            return modified;
        }
        return super.updateMaxMana(mage);
    }

    @Override
    public void updated() {
        this.updateMaxMana(this.mage);
        Wand activeWand = this.mage.getActiveWand();
        if (activeWand != null) {
            activeWand.updated();
        }
    }

    @Override
    public ProgressionPath getPath() {
        String pathKey = this.getString("path");
        if (pathKey == null || pathKey.length() == 0) {
            pathKey = this.controller.getDefaultWandPath();
        }
        return this.controller.getPath(pathKey);
    }

    @Override
    public String getName() {
        return this.template.getName();
    }
}

