/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class CheckEntityAction
extends CompoundAction {
    private Set<EntityType> allowedTypes;
    private Set<EntityType> deniedTypes;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        EntityType entityType;
        List<String> keys;
        super.prepare(context, parameters);
        if (parameters.contains("allowed_entities")) {
            keys = ConfigurationUtils.getStringList(parameters, "allowed_entities");
            this.allowedTypes = new HashSet<EntityType>();
            for (String key : keys) {
                try {
                    entityType = EntityType.valueOf((String)key.toUpperCase());
                    this.allowedTypes.add(entityType);
                }
                catch (Exception ex) {
                    context.getLogger().warning("Invalid entity type in CheckEntity configuration: " + key);
                }
            }
        }
        if (parameters.contains("denied_entities")) {
            keys = ConfigurationUtils.getStringList(parameters, "denied_entities");
            this.deniedTypes = new HashSet<EntityType>();
            for (String key : keys) {
                try {
                    entityType = EntityType.valueOf((String)key.toUpperCase());
                    this.deniedTypes.add(entityType);
                }
                catch (Exception ex) {
                    context.getLogger().warning("Invalid entity type in CheckEntity configuration: " + key);
                }
            }
        }
    }

    protected boolean isAllowed(CastContext context) {
        Entity targetEntity = context.getTargetEntity();
        if (targetEntity == null) {
            return false;
        }
        if (this.allowedTypes != null && !this.allowedTypes.contains(targetEntity.getType())) {
            return false;
        }
        return this.deniedTypes == null || !this.deniedTypes.contains(targetEntity.getType());
    }

    @Override
    public SpellResult step(CastContext context) {
        boolean allowed = this.isAllowed(context);
        ActionHandler actions = this.getHandler("actions");
        if (actions == null || actions.size() == 0) {
            return allowed ? SpellResult.CAST : SpellResult.STOP;
        }
        if (!allowed) {
            return SpellResult.NO_TARGET;
        }
        return this.startActions();
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }
}

