/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.magic.MagicConfigurable;
import com.elmakers.mine.bukkit.magic.BaseMagicConfigurable;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import com.elmakers.mine.bukkit.math.EquationStore;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationTransform;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Player;

public abstract class MagicConfigurableExecutor
extends MagicTabExecutor {
    public MagicConfigurableExecutor(MagicAPI api) {
        super(api);
    }

    public boolean onConfigure(String command, MagicConfigurable target, CommandSender sender, Player player, String[] parameters, boolean safe) {
        if (parameters.length < 1 || safe && parameters.length < 2) {
            sender.sendMessage("Use: /" + command + " configure <property> [value]");
            sender.sendMessage("Properties: " + StringUtils.join((Collection)BaseMagicConfigurable.PROPERTY_KEYS, (String)", "));
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        String value = "";
        for (int i = 1; i < parameters.length; ++i) {
            if (i != 1) {
                value = value + " ";
            }
            value = value + parameters[i];
        }
        if (value.isEmpty()) {
            value = null;
        } else if (value.equals("\"\"")) {
            value = "";
        }
        boolean modified = false;
        if (value == null) {
            if (target.removeProperty(parameters[0])) {
                modified = true;
                mage.sendMessage(this.api.getMessages().get(command + ".removed_property").replace("$name", parameters[0]));
            } else {
                mage.sendMessage(this.api.getMessages().get(command + ".no_property").replace("$name", parameters[0]));
            }
        } else {
            double property;
            MemoryConfiguration node = new MemoryConfiguration();
            EquationTransform transform = EquationStore.getInstance().getTransform(value);
            double transformed = Double.NaN;
            if (transform.getException() == null && !Double.isNaN(property = target.getProperty(parameters[0], Double.NaN).doubleValue())) {
                transform.setVariable("x", property);
                transformed = transform.get();
            }
            if (!Double.isNaN(transformed)) {
                node.set(parameters[0], (Object)transformed);
            } else {
                node.set(parameters[0], (Object)value);
            }
            if (safe) {
                modified = target.upgrade((ConfigurationSection)node);
            } else {
                target.configure((ConfigurationSection)node);
                modified = true;
            }
            if (modified) {
                mage.sendMessage(this.api.getMessages().get(command + ".reconfigured"));
            } else {
                mage.sendMessage(this.api.getMessages().get(command + ".not_reconfigured"));
            }
        }
        mage.checkWand();
        if (sender != player) {
            if (modified) {
                sender.sendMessage(this.api.getMessages().getParameterized(command + ".player_reconfigured", "$name", player.getName()));
            } else {
                sender.sendMessage(this.api.getMessages().getParameterized(command + ".player_not_reconfigured", "$name", player.getName()));
            }
        }
        return true;
    }
}

