/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.item;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.CostReducer;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.integration.VaultController;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Cost
implements com.elmakers.mine.bukkit.api.item.Cost {
    protected ItemStack item;
    protected boolean itemWildcard;
    protected double amount;
    protected Type type;

    public Cost(MageController controller, String key, double cost) {
        this.amount = cost;
        if (key.toLowerCase().equals("xp")) {
            this.type = Type.XP;
        } else if (key.toLowerCase().equals("sp")) {
            this.type = Type.SP;
        } else if (key.toLowerCase().equals("mana")) {
            this.type = Type.MANA;
        } else if (key.toLowerCase().equals("currency")) {
            this.type = Type.CURRENCY;
        } else if (key.toLowerCase().equals("health")) {
            this.type = Type.HEALTH;
        } else if (key.toLowerCase().equals("hunger")) {
            this.type = Type.HUNGER;
        } else if (key.toLowerCase().equals("levels")) {
            this.type = Type.LEVELS;
        } else {
            if (key.endsWith(":*")) {
                key = key.substring(0, key.length() - 2);
                this.itemWildcard = true;
            } else {
                this.itemWildcard = false;
            }
            this.item = controller.createItem(key, true);
            if (this.item != null) {
                this.item.setAmount((int)Math.ceil(this.amount));
            }
            this.type = Type.ITEM;
        }
    }

    @Override
    public boolean isEmpty(CostReducer reducer) {
        switch (this.type) {
            case ITEM: {
                return this.item == null || this.getReducedCost(this.item.getAmount(), reducer) == 0.0;
            }
            case LEVELS: {
                return this.getLevels(reducer) == 0;
            }
            case XP: {
                return this.getXP(reducer) == 0;
            }
            case MANA: {
                return this.getMana(reducer) == 0;
            }
            case CURRENCY: {
                return this.getCurrency(reducer) == 0.0;
            }
            case SP: {
                return this.getSkillPoints(reducer) == 0;
            }
        }
        return this.getReducedCost(this.amount, reducer) == 0.0;
    }

    @Override
    public boolean has(Mage mage, Wand wand, CostReducer reducer) {
        Player player = mage.getPlayer();
        switch (this.type) {
            case ITEM: {
                return this.isConsumeFree(reducer) || mage.hasItem(this.getItemStack(reducer), this.itemWildcard);
            }
            case XP: {
                return mage.getExperience() >= this.getXP(reducer);
            }
            case LEVELS: {
                return player != null && player.getLevel() >= this.getLevels(reducer);
            }
            case MANA: {
                return wand == null ? mage.getMana() >= (float)this.getMana(reducer) : wand.getMana() >= (float)this.getMana(reducer);
            }
            case CURRENCY: {
                VaultController vault = VaultController.getInstance();
                return vault.has(mage.getPlayer(), this.getCurrency(reducer));
            }
            case SP: {
                return mage.getSkillPoints() >= this.getSkillPoints(reducer);
            }
            case HEALTH: {
                LivingEntity living = mage.getLivingEntity();
                return living != null && living.getHealth() >= this.getReducedCost(this.amount, reducer);
            }
            case HUNGER: {
                return player != null && (double)player.getFoodLevel() >= this.getReducedCost(this.amount, reducer);
            }
        }
        return false;
    }

    @Override
    public boolean has(Mage mage) {
        return this.has(mage, mage.getActiveWand(), null);
    }

    @Override
    public void deduct(Mage mage, Wand wand, CostReducer reducer) {
        Player player = mage.getPlayer();
        switch (this.type) {
            case ITEM: {
                if (this.isConsumeFree(reducer)) break;
                ItemStack itemStack = this.getItemStack(reducer);
                mage.removeItem(itemStack, this.itemWildcard);
                break;
            }
            case XP: {
                mage.removeExperience(this.getXP(reducer));
                break;
            }
            case LEVELS: {
                if (player == null) break;
                int newLevel = Math.max(0, player.getLevel() - this.getLevels(reducer));
                player.setLevel(newLevel);
                break;
            }
            case MANA: {
                if (wand != null) {
                    wand.removeMana(this.getMana(reducer));
                    break;
                }
                mage.removeMana(this.getMana(reducer));
                break;
            }
            case CURRENCY: {
                VaultController vault = VaultController.getInstance();
                vault.withdrawPlayer(mage.getPlayer(), this.getCurrency(reducer));
                break;
            }
            case SP: {
                mage.addSkillPoints(-this.getSkillPoints(reducer));
                break;
            }
            case HEALTH: {
                LivingEntity living = mage.getLivingEntity();
                if (living == null) break;
                living.setHealth(Math.max(0.0, living.getHealth() - this.getReducedCost(this.amount, reducer)));
                break;
            }
            case HUNGER: {
                if (player == null) break;
                player.setFoodLevel(Math.max(0, player.getFoodLevel() - this.getRoundedCost(this.amount, reducer)));
            }
        }
    }

    @Override
    public void deduct(Mage mage) {
        this.deduct(mage, mage.getActiveWand(), null);
    }

    protected int getRoundedCost(double cost, CostReducer reducer) {
        return (int)Math.ceil(this.getReducedCost(cost, reducer));
    }

    protected double getReducedCost(double cost, CostReducer reducer) {
        double reduction;
        double reducedAmount = cost;
        double d = reduction = reducer == null ? 0.0 : (double)reducer.getCostReduction();
        if (reduction >= 1.0) {
            return 0.0;
        }
        if (reduction > 0.0) {
            reducedAmount = (1.0 - reduction) * reducedAmount;
        }
        if (reducer != null) {
            reducedAmount *= (double)reducer.getCostScale();
        }
        return reducedAmount;
    }

    public int getAmount(CostReducer reducer) {
        return this.getRoundedCost(this.amount, reducer);
    }

    public boolean isConsumeFree(CostReducer reducer) {
        return reducer != null && reducer.getConsumeReduction() >= 1.0f;
    }

    @Override
    public String getDescription(Messages messages) {
        return this.getDescription(messages, null);
    }

    @Override
    public String getFullDescription(Messages messages) {
        return this.getFullDescription(messages, null);
    }

    @Override
    public String getDescription(Messages messages, CostReducer reducer) {
        if (this.amount == 0.0) {
            return "";
        }
        switch (this.type) {
            case ITEM: {
                if (this.item == null || !(reducer.getConsumeReduction() < 1.0f)) break;
                return messages.describeItem(this.item);
            }
            case XP: {
                return messages.get("costs.xp");
            }
            case LEVELS: {
                return messages.get("costs.levels");
            }
            case SP: {
                return messages.get("costs.sp");
            }
            case MANA: {
                return messages.get("costs.mana");
            }
            case HUNGER: {
                return messages.get("costs.hunger");
            }
            case HEALTH: {
                return messages.get("costs.health");
            }
            case CURRENCY: {
                return messages.getCurrencyPlural();
            }
        }
        return "";
    }

    @Override
    public String getFullDescription(Messages messages, CostReducer reducer) {
        if (this.getAmount(reducer) == 0) {
            return "";
        }
        switch (this.type) {
            case ITEM: {
                if (this.item == null || this.isConsumeFree(reducer)) break;
                return this.getAmount(reducer) + " " + messages.describeItem(this.item);
            }
            case XP: {
                return messages.get("costs.xp_amount").replace("$amount", Integer.valueOf(this.getXP(reducer)).toString());
            }
            case LEVELS: {
                return messages.get("costs.levels_amount").replace("$amount", Integer.valueOf(this.getLevels(reducer)).toString());
            }
            case SP: {
                return messages.get("costs.sp_amount").replace("$amount", Integer.toString(this.getSkillPoints(reducer)));
            }
            case MANA: {
                return messages.get("costs.mana_amount").replace("$amount", Integer.toString(this.getMana(reducer)));
            }
            case HEALTH: {
                return messages.get("costs.health_amount").replace("$amount", Integer.toString(this.getMana(reducer)));
            }
            case HUNGER: {
                return messages.get("costs.hunger_amount").replace("$amount", Integer.toString(this.getMana(reducer)));
            }
            case CURRENCY: {
                return messages.get("costs.currency_amount").replace("$amount", Integer.valueOf((int)Math.ceil(this.getCurrency(reducer))).toString());
            }
        }
        return "";
    }

    @Override
    public boolean isItem() {
        return this.type == Type.ITEM && this.item != null;
    }

    @Override
    public ItemStack getItemStack() {
        return CompatibilityUtils.getCopy(this.item);
    }

    protected ItemStack getItemStack(CostReducer reducer) {
        ItemStack item = this.getItemStack();
        if (item != null) {
            item.setAmount(this.getRoundedCost(item.getAmount(), reducer));
        }
        return item;
    }

    public int getXP(CostReducer reducer) {
        return this.type == Type.XP ? this.getRoundedCost(this.amount, reducer) : 0;
    }

    public int getLevels(CostReducer reducer) {
        return this.type == Type.LEVELS ? this.getRoundedCost(this.amount, reducer) : 0;
    }

    public int getSkillPoints(CostReducer reducer) {
        return this.type == Type.SP ? this.getRoundedCost(this.amount, reducer) : 0;
    }

    public double getCurrency(CostReducer reducer) {
        return this.type == Type.CURRENCY ? this.getReducedCost(this.amount, reducer) : 0.0;
    }

    public int getMana(CostReducer reducer) {
        return this.type == Type.MANA ? this.getRoundedCost(this.amount, reducer) : 0;
    }

    public void setAmount(double amount) {
        this.amount = amount;
        if (this.type == Type.ITEM && this.item != null) {
            this.item.setAmount((int)Math.max(1.0, Math.ceil(amount)));
        }
    }

    @Override
    public void scale(double scale) {
        this.setAmount(this.amount * scale);
    }

    protected static enum Type {
        ITEM,
        XP,
        SP,
        MANA,
        CURRENCY,
        HEALTH,
        HUNGER,
        LEVELS;

    }
}

