/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.BrushMode;
import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.event.AddSpellEvent;
import com.elmakers.mine.bukkit.api.event.SpellUpgradeEvent;
import com.elmakers.mine.bukkit.api.event.WandPreActivateEvent;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.CostReducer;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.WandAction;
import com.elmakers.mine.bukkit.effect.SoundEffect;
import com.elmakers.mine.bukkit.effect.builtin.EffectRing;
import com.elmakers.mine.bukkit.heroes.HeroesManager;
import com.elmakers.mine.bukkit.magic.BaseMagicConfigurable;
import com.elmakers.mine.bukkit.magic.BaseMagicProperties;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MageClass;
import com.elmakers.mine.bukkit.magic.MageClassTemplate;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.magic.MagicPropertyType;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import com.elmakers.mine.bukkit.utility.ColorHD;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.wand.LostWand;
import com.elmakers.mine.bukkit.wand.UnknownWandException;
import com.elmakers.mine.bukkit.wand.WandLevel;
import com.elmakers.mine.bukkit.wand.WandManaMode;
import com.elmakers.mine.bukkit.wand.WandMode;
import com.elmakers.mine.bukkit.wand.WandOrganizer;
import com.elmakers.mine.bukkit.wand.WandProperties;
import com.elmakers.mine.bukkit.wand.WandTemplate;
import com.elmakers.mine.bukkit.wand.WandUpgradePath;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class Wand
extends WandProperties
implements CostReducer,
com.elmakers.mine.bukkit.api.wand.Wand {
    public static final int OFFHAND_SLOT = 40;
    public static final int INVENTORY_SIZE = 27;
    public static final int PLAYER_INVENTORY_SIZE = 36;
    public static final int INVENTORY_ORGANIZE_BUFFER = 4;
    public static final int HOTBAR_SIZE = 9;
    public static final int HOTBAR_INVENTORY_SIZE = 8;
    public static final float DEFAULT_SPELL_COLOR_MIX_WEIGHT = 1.0E-4f;
    public static Vector DEFAULT_CAST_OFFSET = new Vector(0.0, 0.0, 0.5);
    public static String DEFAULT_WAND_TEMPLATE = "default";
    private static int WAND_VERSION = 5;
    private static final String[] EMPTY_PARAMETERS = new String[0];
    private static final Random random = new Random();
    @Nullable
    protected ItemStack item;
    @Nullable
    protected Mage mage;
    @Nullable
    protected CastContext effectsContext;
    private String id = "";
    private List<Inventory> hotbars;
    private List<Inventory> inventories;
    private Map<String, Integer> spellInventory = new HashMap<String, Integer>();
    private Set<String> spells = new LinkedHashSet<String>();
    private Map<String, Integer> spellLevels = new HashMap<String, Integer>();
    private Map<String, Integer> brushInventory = new HashMap<String, Integer>();
    private Set<String> brushes = new LinkedHashSet<String>();
    private String activeSpell = "";
    private String alternateSpell = "";
    private String alternateSpell2 = "";
    private String activeBrush = "";
    protected String wandName = "";
    protected String description = "";
    private String owner = "";
    private String ownerId = "";
    private String template = "";
    private String path = "";
    private String mageClassKey = null;
    private boolean superProtected = false;
    private boolean superPowered = false;
    private boolean glow = false;
    private boolean bound = false;
    private boolean indestructible = false;
    private boolean undroppable = false;
    private boolean keep = false;
    private boolean passive = false;
    private boolean autoOrganize = false;
    private boolean autoAlphabetize = false;
    private boolean autoFill = false;
    private boolean isUpgrade = false;
    private boolean randomizeOnActivate = true;
    private boolean rename = false;
    private boolean renameDescription = false;
    private boolean quickCast = false;
    private boolean quickCastDisabled = false;
    private boolean manualQuickCastDisabled = false;
    private boolean isInOffhand = false;
    private boolean hasId = false;
    private int inventoryRows = 1;
    private Vector castLocation;
    private WandAction leftClickAction = WandAction.NONE;
    private WandAction rightClickAction = WandAction.NONE;
    private WandAction dropAction = WandAction.NONE;
    private WandAction swapAction = WandAction.NONE;
    private com.elmakers.mine.bukkit.block.MaterialAndData icon = null;
    private com.elmakers.mine.bukkit.block.MaterialAndData upgradeIcon = null;
    private com.elmakers.mine.bukkit.block.MaterialAndData inactiveIcon = null;
    private int inactiveIconDelay = 0;
    private String upgradeTemplate = null;
    protected float consumeReduction = 0.0f;
    protected float cooldownReduction = 0.0f;
    protected Map<String, Double> protection;
    private float power = 0.0f;
    private float spMultiplier = 1.0f;
    private float blockFOV = 0.0f;
    private float blockChance = 0.0f;
    private float blockReflectChance = 0.0f;
    private int blockMageCooldown = 0;
    private int blockCooldown = 0;
    private int maxEnchantCount = 0;
    private int enchantCount = 0;
    private boolean hasInventory = false;
    private boolean locked = false;
    private boolean lockedAllowUpgrades = false;
    private boolean forceUpgrade = false;
    private boolean isHeroes = false;
    private int uses = 0;
    private boolean hasUses = false;
    private boolean isSingleUse = false;
    private boolean limitSpellsToPath = false;
    private float manaPerDamage = 0.0f;
    private ColorHD effectColor = null;
    private float effectColorSpellMixWeight = 1.0E-4f;
    private ParticleEffect effectParticle = null;
    private float effectParticleData = 0.0f;
    private int effectParticleCount = 0;
    private int effectParticleInterval = 0;
    private double effectParticleMinVelocity = 0.0;
    private double effectParticleRadius = 0.0;
    private double effectParticleOffset = 0.0;
    private boolean effectBubbles = false;
    private boolean activeEffectsOnly = false;
    private EffectRing effectPlayer = null;
    private int castInterval = 0;
    private double castMinVelocity = 0.0;
    private Vector castVelocityDirection = null;
    private String castSpell = null;
    private ConfigurationSection castParameters = null;
    private Map<PotionEffectType, Integer> potionEffects = new HashMap<PotionEffectType, Integer>();
    private SoundEffect effectSound = null;
    private int effectSoundInterval = 0;
    private int quietLevel = 0;
    private Map<String, String> castOverrides = null;
    private boolean hasSpellProgression = false;
    private long lastSoundEffect;
    private long lastParticleEffect;
    private long lastSpellCast;
    private WandMode mode = null;
    private WandMode brushMode = null;
    private int openInventoryPage = 0;
    private boolean inventoryIsOpen = false;
    private boolean inventoryWasOpen = false;
    private Inventory displayInventory = null;
    private int currentHotbar = 0;
    public static WandManaMode manaMode = WandManaMode.BAR;
    public static WandManaMode spMode = WandManaMode.NUMBER;
    public static boolean regenWhileInactive = true;
    public static Material DefaultUpgradeMaterial = Material.NETHER_STAR;
    public static Material DefaultWandMaterial = Material.BLAZE_ROD;
    public static Material EnchantableWandMaterial = null;
    public static boolean SpellGlow = false;
    public static boolean BrushGlow = false;
    public static boolean BrushItemGlow = true;
    public static boolean LiveHotbar = true;
    public static boolean LiveHotbarSkills = false;
    public static boolean LiveHotbarCooldown = true;
    public static boolean Unbreakable = false;
    public static boolean Undroppable = true;
    public static SoundEffect inventoryOpenSound = null;
    public static SoundEffect inventoryCloseSound = null;
    public static SoundEffect inventoryCycleSound = null;
    public static SoundEffect noActionSound = null;
    public static String WAND_KEY = "wand";
    public static String UPGRADE_KEY = "wand_upgrade";
    public static String WAND_SELF_DESTRUCT_KEY = null;
    public static byte HIDE_FLAGS = (byte)63;
    public static String brushSelectSpell = "";
    private Inventory storedInventory = null;
    private int heldSlot = 0;

    public Wand(MagicController controller) {
        super(controller);
        this.hotbars = new ArrayList<Inventory>();
        this.setHotbarCount(1);
        this.inventories = new ArrayList<Inventory>();
    }

    @Deprecated
    public Wand(MagicController controller, ItemStack itemStack) {
        this(controller);
        Preconditions.checkNotNull((Object)itemStack);
        if (itemStack.getType() == Material.AIR) {
            itemStack.setType(DefaultWandMaterial);
        }
        this.icon = new com.elmakers.mine.bukkit.block.MaterialAndData(itemStack);
        this.item = itemStack;
        boolean needsSave = false;
        boolean isWand = Wand.isWand(this.item);
        boolean isUpgradeItem = Wand.isUpgrade(this.item);
        if (isWand || isUpgradeItem) {
            int version;
            WandTemplate migrateTemplate;
            ConfigurationSection wandConfig = Wand.itemToConfig(this.item, (ConfigurationSection)new MemoryConfiguration());
            WandTemplate wandTemplate = controller.getWandTemplate(wandConfig.getString("template"));
            WandTemplate wandTemplate2 = migrateTemplate = wandTemplate == null ? null : wandTemplate.getMigrateTemplate();
            if (migrateTemplate != null) {
                wandConfig.set("template", (Object)migrateTemplate.getKey());
            }
            if ((version = wandConfig.getInt("version", 0)) < WAND_VERSION) {
                this.migrate(version, wandConfig);
                needsSave = true;
            }
            this.randomizeOnActivate = !wandConfig.contains("icon");
            this.load(wandConfig);
        } else {
            this.updateIcon();
        }
        this.loadProperties();
        if ((this.isUpgrade || isUpgradeItem) && isWand) {
            needsSave = true;
            InventoryUtils.removeMeta(this.item, WAND_KEY);
        }
        if (needsSave) {
            this.saveState();
        }
        this.updateName();
        this.updateLore();
    }

    public Wand(MagicController controller, ConfigurationSection config) {
        this(controller, DefaultWandMaterial, 0);
        this.load(config);
        this.loadProperties();
        this.updateName();
        this.updateLore();
        this.saveState();
    }

    protected Wand(MagicController controller, String templateName) throws UnknownWandException {
        this(controller);
        WandTemplate template;
        if (templateName == null || templateName.length() == 0) {
            templateName = DEFAULT_WAND_TEMPLATE;
        }
        int level = 0;
        if (templateName.contains("(")) {
            String levelString = templateName.substring(templateName.indexOf(40) + 1, templateName.length() - 1);
            try {
                level = Integer.parseInt(levelString);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex);
            }
            templateName = templateName.substring(0, templateName.indexOf(40));
        }
        if ((template = controller.getWandTemplate(templateName)) == null) {
            throw new UnknownWandException(templateName);
        }
        WandTemplate migrateTemplate = template.getMigrateTemplate();
        if (migrateTemplate != null) {
            template = migrateTemplate;
            templateName = migrateTemplate.getKey();
        }
        this.setTemplate(templateName);
        this.setProperty("version", WAND_VERSION);
        ConfigurationSection templateConfig = template.getConfiguration();
        if (templateConfig == null) {
            throw new UnknownWandException(templateName);
        }
        this.loadProperties();
        if (level > 0) {
            boolean wasLocked = this.locked;
            this.locked = false;
            this.randomize(level, false, null, true);
            this.locked = wasLocked;
        }
        if (!this.randomizeOnActivate) {
            this.randomize();
        }
        this.updateName();
        this.updateLore();
        this.saveState();
    }

    public Wand(MagicController controller, Material icon, short iconData) {
        this(controller, InventoryUtils.makeReal(new ItemStack(icon, 1, iconData)));
        this.saveState();
        this.updateName();
    }

    protected void migrate(int version, ConfigurationSection wandConfig) {
        Object spellInventoryRaw;
        ConfigurationSection templateConfig;
        if (version <= 1 && (templateConfig = this.controller.getWandTemplateConfiguration(wandConfig.getString("template"))) != null) {
            String randomizeIcon = templateConfig.getString("randomize_icon");
            String currentIcon = wandConfig.getString("icon");
            if (randomizeIcon != null && currentIcon != null && randomizeIcon.equals(currentIcon)) {
                wandConfig.set("icon", null);
            }
            wandConfig.set("randomize", null);
            Set keys = templateConfig.getKeys(false);
            for (String key : keys) {
                Object templateData = templateConfig.get(key);
                Object wandData = wandConfig.get(key);
                if (wandData == null) continue;
                String templateString = templateData.toString();
                String wandString = wandData.toString();
                if (templateData instanceof List) {
                    templateString = templateString.substring(1, templateString.length() - 1);
                    templateString = templateString.replace(", ", ",");
                    templateData = templateString;
                }
                if (wandString.equalsIgnoreCase(templateString)) {
                    wandConfig.set(key, null);
                    continue;
                }
                try {
                    double numericValue = Double.parseDouble(wandString);
                    double numericTemplate = Double.parseDouble(templateString);
                    if (numericValue == numericTemplate) {
                        wandConfig.set(key, null);
                        continue;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (!wandData.equals(templateData)) continue;
                wandConfig.set(key, null);
            }
        }
        if (version <= 3) {
            String templateIcon;
            templateConfig = this.controller.getWandTemplateConfiguration(wandConfig.getString("template"));
            String string = templateIcon = templateConfig == null ? null : templateConfig.getString("icon");
            if (templateIcon != null && templateIcon.equals(wandConfig.getString("icon", ""))) {
                wandConfig.set("icon", null);
            }
        }
        if (version <= 4 && (spellInventoryRaw = wandConfig.get("spell_inventory")) != null) {
            Map<String, Object> spellInventory = null;
            HashMap<String, Integer> newSpellInventory = new HashMap<String, Integer>();
            if (spellInventoryRaw instanceof Map) {
                spellInventory = (Map<String, Object>)spellInventoryRaw;
            } else if (spellInventoryRaw instanceof ConfigurationSection) {
                spellInventory = NMSUtils.getMap((ConfigurationSection)spellInventoryRaw);
            }
            if (spellInventory != null) {
                for (Map.Entry<String, Object> spellEntry : spellInventory.entrySet()) {
                    Object slot = spellEntry.getValue();
                    if (slot == null || !(slot instanceof Integer)) continue;
                    SpellKey spellKey = new SpellKey(spellEntry.getKey());
                    Object testSlot = spellInventory.get(spellKey.getBaseKey());
                    if (testSlot != null) {
                        slot = testSlot;
                    }
                    newSpellInventory.put(spellKey.getBaseKey(), (Integer)slot);
                }
                wandConfig.set("spell_inventory", newSpellInventory);
            }
        }
        wandConfig.set("version", (Object)WAND_VERSION);
    }

    @Override
    public void load(ConfigurationSection configuration) {
        if (configuration != null) {
            this.setTemplate(configuration.getString("template"));
        }
        super.load(configuration);
    }

    protected void setHotbarCount(int count) {
        this.hotbars.clear();
        while (this.hotbars.size() < count) {
            this.hotbars.add(CompatibilityUtils.createInventory(null, 8, "Wand"));
        }
        while (this.hotbars.size() > count) {
            this.hotbars.remove(0);
        }
    }

    @Override
    public void unenchant() {
        this.controller.cleanItem(this.item);
        this.clear();
    }

    public void setIcon(Material material, byte data) {
        this.setIcon(material == null ? null : new com.elmakers.mine.bukkit.block.MaterialAndData(material, data));
        this.updateIcon();
    }

    public void updateItemIcon() {
        this.setIcon(this.icon);
    }

    protected void updateIcon() {
        if (this.icon != null && this.icon.getMaterial() != null && this.icon.getMaterial() != Material.AIR) {
            WandTemplate template;
            String templateIcon;
            String iconKey = this.icon.getKey();
            if (iconKey != null && iconKey.isEmpty()) {
                iconKey = null;
            }
            String string = templateIcon = (template = this.getTemplate()) != null ? template.getProperty("icon", "") : null;
            if (templateIcon == null || !templateIcon.equals(iconKey)) {
                this.setProperty("icon", iconKey);
            }
        }
    }

    @Override
    public void setInactiveIcon(MaterialAndData materialData) {
        this.inactiveIcon = materialData == null ? null : (materialData instanceof com.elmakers.mine.bukkit.block.MaterialAndData ? (com.elmakers.mine.bukkit.block.MaterialAndData)materialData : new com.elmakers.mine.bukkit.block.MaterialAndData(materialData));
        String inactiveIconKey = null;
        if (this.inactiveIcon != null && this.inactiveIcon.getMaterial() != null && this.inactiveIcon.getMaterial() != Material.AIR && (inactiveIconKey = this.inactiveIcon.getKey()) != null && inactiveIconKey.isEmpty()) {
            inactiveIconKey = null;
        }
        this.setProperty("inactive_icon", inactiveIconKey);
        this.updateItemIcon();
    }

    @Override
    public void setIcon(MaterialAndData materialData) {
        if (materialData instanceof com.elmakers.mine.bukkit.block.MaterialAndData) {
            this.setIcon((com.elmakers.mine.bukkit.block.MaterialAndData)materialData);
        } else {
            this.setIcon(new com.elmakers.mine.bukkit.block.MaterialAndData(materialData));
        }
        this.updateIcon();
    }

    public void setIcon(com.elmakers.mine.bukkit.block.MaterialAndData materialData) {
        if (materialData == null || !materialData.isValid()) {
            return;
        }
        if (materialData.getMaterial() == Material.AIR || materialData.getMaterial() == null) {
            materialData.setMaterial(DefaultWandMaterial);
        }
        this.icon = materialData;
        if (this.item == null) {
            this.item = InventoryUtils.makeReal(this.icon.getItemStack(1));
        }
        Short durability = null;
        if (!this.indestructible && !this.isUpgrade && this.icon.getMaterial().getMaxDurability() > 0) {
            durability = this.item.getDurability();
        }
        try {
            if (this.inactiveIcon == null || this.mage != null && this.getMode() == WandMode.INVENTORY && this.isInventoryOpen()) {
                this.icon.applyToItem(this.item);
            } else {
                this.inactiveIcon.applyToItem(this.item);
            }
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.WARNING, "Unable to apply wand icon", ex);
            this.item.setType(DefaultWandMaterial);
        }
        if (durability != null) {
            this.item.setDurability(durability.shortValue());
        }
        if ((this.indestructible || Unbreakable || this.isUpgrade) && !manaMode.useDurability()) {
            CompatibilityUtils.makeUnbreakable(this.item);
        } else {
            CompatibilityUtils.removeUnbreakable(this.item);
        }
        CompatibilityUtils.hideFlags(this.item, HIDE_FLAGS);
    }

    @Override
    public void makeUpgrade() {
        if (!this.isUpgrade) {
            this.isUpgrade = true;
            String oldName = this.wandName;
            String newName = this.getMessage("upgrade_name");
            newName = newName.replace("$name", oldName);
            String newDescription = this.controller.getMessages().get("wand.upgrade_default_description");
            if (this.template != null && this.template.length() > 0) {
                newDescription = this.controller.getMessages().get("wands." + this.template + ".upgrade_description", this.description);
            }
            this.setIcon(DefaultUpgradeMaterial, (byte)0);
            this.setName(newName);
            this.setDescription(newDescription);
            InventoryUtils.removeMeta(this.item, WAND_KEY);
            this.saveState();
            this.updateName(true);
            this.updateLore();
        }
    }

    public void newId() {
        this.id = UUID.randomUUID().toString();
        this.setProperty("id", this.id);
    }

    public boolean checkId() {
        if (this.id == null || this.id.length() == 0) {
            this.newId();
            return true;
        }
        return false;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean isModifiable() {
        return !this.locked;
    }

    @Override
    public boolean isIndestructible() {
        return this.indestructible;
    }

    @Override
    public boolean isUndroppable() {
        return this.undroppable;
    }

    public boolean isUpgrade() {
        return this.isUpgrade;
    }

    @Override
    public boolean usesMana() {
        if (this.isCostFree()) {
            return false;
        }
        return this.getManaMax() > 0 || this.isHeroes && this.mage != null;
    }

    @Override
    public void removeMana(float amount) {
        HeroesManager heroes;
        if (this.isHeroes && this.mage != null && (heroes = this.controller.getHeroes()) != null) {
            heroes.removeMana(this.mage.getPlayer(), (int)Math.ceil(amount));
        }
        super.removeMana(amount);
        this.updateMana();
    }

    @Override
    public float getCooldownReduction() {
        return this.cooldownReduction;
    }

    @Override
    public float getConsumeReduction() {
        return this.consumeReduction;
    }

    @Override
    public float getCostScale() {
        return 1.0f;
    }

    public void setCooldownReduction(float reduction) {
        this.cooldownReduction = reduction;
        this.setProperty("cooldown_reduction", Float.valueOf(this.cooldownReduction));
    }

    @Override
    public boolean hasInventory() {
        return this.hasInventory;
    }

    @Override
    public float getPower() {
        return this.power;
    }

    @Override
    public boolean isSuperProtected() {
        return this.superProtected;
    }

    @Override
    public boolean isSuperPowered() {
        return this.superPowered;
    }

    @Override
    public boolean isConsumeFree() {
        return this.consumeReduction >= 1.0f;
    }

    @Override
    public boolean isCooldownFree() {
        return this.cooldownReduction > 1.0f;
    }

    public double getProtection(String protectionType) {
        Double amount = this.protection == null ? null : this.protection.get(protectionType);
        return amount == null ? 0.0 : amount;
    }

    @Override
    public String getName() {
        return this.wandName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOwner() {
        return this.owner == null ? "" : this.owner;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    @Override
    public long getWorth() {
        long worth = 0L;
        Collection spells = this.getSpells();
        for (String spellKey : spells) {
            SpellTemplate spell = this.controller.getSpellTemplate(spellKey);
            if (spell == null) continue;
            worth = (long)((double)worth + spell.getWorth());
        }
        return worth;
    }

    @Override
    public void setName(String name) {
        this.wandName = ChatColor.stripColor((String)name);
        this.setProperty("name", this.wandName);
        this.updateName();
    }

    public void setTemplate(String templateName) {
        this.template = templateName;
        WandTemplate wandTemplate = this.controller.getWandTemplate(templateName);
        if (wandTemplate instanceof BaseMagicProperties) {
            this.setWandTemplate(wandTemplate);
        }
        this.setProperty("template", this.template);
    }

    @Override
    public String getTemplateKey() {
        return this.template;
    }

    @Override
    public boolean hasTag(String tag) {
        WandTemplate template = this.getTemplate();
        return template != null && template.hasTag(tag);
    }

    @Override
    public WandUpgradePath getPath() {
        String pathKey = this.path;
        if (pathKey == null || pathKey.length() == 0) {
            pathKey = this.controller.getDefaultWandPath();
        }
        return WandUpgradePath.getPath(pathKey);
    }

    public boolean hasPath() {
        return this.path != null && this.path.length() > 0;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
        this.setProperty("description", description);
        this.updateLore();
    }

    public boolean tryToOwn(Player player) {
        if (this.ownerId == null || this.ownerId.length() == 0) {
            this.takeOwnership(player);
            return true;
        }
        return false;
    }

    public void takeOwnership(Player player) {
        Mage mage = this.mage;
        if (mage == null) {
            mage = this.controller.getMage(player);
        }
        if (mage != null && (this.ownerId == null || this.ownerId.length() == 0) && this.quietLevel < 2) {
            WandUpgradePath path;
            String controlKey;
            SpellTemplate spellTemplate;
            mage.sendMessage(this.getMessage("bound_instructions", "").replace("$wand", this.getName()));
            String spellKey = this.getActiveSpellKey();
            SpellTemplate spellTemplate2 = spellTemplate = spellKey != null && !spellKey.isEmpty() ? this.controller.getSpellTemplate(spellKey) : null;
            if (spellTemplate != null) {
                String message = this.getMessage("spell_instructions", "").replace("$wand", this.getName());
                mage.sendMessage(message.replace("$spell", spellTemplate.getName()));
            }
            if (this.spells.size() > 1 && (controlKey = this.getControlKey(WandAction.TOGGLE)) != null) {
                controlKey = this.controller.getMessages().get("controls." + controlKey);
                mage.sendMessage(this.getMessage("inventory_instructions", "").replace("$wand", this.getName()).replace("$toggle", controlKey));
            }
            if ((path = this.getPath()) != null) {
                String message = this.getMessage("enchant_instructions", "").replace("$wand", this.getName());
                mage.sendMessage(message);
            }
        }
        this.owner = ChatColor.stripColor((String)player.getDisplayName());
        this.ownerId = mage.getId();
        this.setProperty("owner", this.owner);
        this.setProperty("owner_id", this.ownerId);
        this.updateLore();
        this.saveState();
    }

    public String getControlKey(WandAction action) {
        String controlKey = null;
        if (this.rightClickAction == action) {
            controlKey = "right_click";
        } else if (this.dropAction == action) {
            controlKey = "drop";
        } else if (this.leftClickAction == action) {
            controlKey = "left_click";
        } else if (this.swapAction == action) {
            controlKey = "swap";
        }
        return controlKey;
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    @Override
    public MaterialAndData getIcon() {
        return this.icon;
    }

    @Override
    public MaterialAndData getInactiveIcon() {
        return this.inactiveIcon;
    }

    protected List<Inventory> getAllInventories() {
        int hotbarCount = this.getHotbarCount();
        ArrayList<Inventory> allInventories = new ArrayList<Inventory>(this.inventories.size() + hotbarCount);
        if (hotbarCount > 0) {
            allInventories.addAll(this.hotbars);
        }
        allInventories.addAll(this.inventories);
        return allInventories;
    }

    public Set<String> getSpells() {
        HashSet<String> spellSet = new HashSet<String>();
        for (String key : this.spells) {
            Integer level = this.spellLevels.get(key);
            if (level != null) {
                spellSet.add(new SpellKey(key, level).getKey());
                continue;
            }
            spellSet.add(key);
        }
        return spellSet;
    }

    public Set<String> getBrushes() {
        return this.brushes;
    }

    protected Integer parseSlot(String[] pieces) {
        Integer slot = null;
        if (pieces.length > 1) {
            try {
                slot = Integer.parseInt(pieces[1]);
            }
            catch (Exception ex) {
                slot = null;
            }
            if (slot != null && slot < 0) {
                slot = null;
            }
        }
        return slot;
    }

    public void addToInventory(ItemStack itemStack) {
        String brushKey;
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return;
        }
        if (this.getBrushMode() != WandMode.INVENTORY && Wand.isBrush(itemStack) && (!com.elmakers.mine.bukkit.block.MaterialBrush.isSpecialMaterialKey(brushKey = Wand.getBrush(itemStack)) || com.elmakers.mine.bukkit.block.MaterialBrush.isSchematic(brushKey))) {
            return;
        }
        List<Inventory> checkInventories = this.getAllInventories();
        boolean added = false;
        WandMode mode = this.getMode();
        int fullSlot = 0;
        for (Inventory inventory : checkInventories) {
            int inventorySize = inventory.getSize();
            Integer slot = null;
            int freeSpace = 0;
            for (int i = 0; i < inventorySize && freeSpace < 4; ++i) {
                ItemStack existing = inventory.getItem(i);
                if (!InventoryUtils.isEmpty(existing)) continue;
                if (slot == null) {
                    slot = i;
                }
                ++freeSpace;
            }
            if (slot != null && (freeSpace >= 4 || inventorySize == 8 || mode == WandMode.CHEST)) {
                added = true;
                inventory.setItem(slot.intValue(), itemStack);
                fullSlot += slot.intValue();
                break;
            }
            fullSlot += inventory.getSize();
        }
        if (!added) {
            fullSlot = this.getHotbarSize() + this.getInventorySize() * this.inventories.size();
            Inventory newInventory = CompatibilityUtils.createInventory(null, this.getInventorySize(), "Wand");
            newInventory.addItem(new ItemStack[]{itemStack});
            this.inventories.add(newInventory);
        }
        this.updateSlot(fullSlot, itemStack);
    }

    @Nonnull
    protected Inventory getInventoryByIndex(int inventoryIndex) {
        while (inventoryIndex >= this.inventories.size()) {
            this.inventories.add(CompatibilityUtils.createInventory(null, this.getInventorySize(), "Wand"));
        }
        return this.inventories.get(inventoryIndex);
    }

    protected int getHotbarSize() {
        if (this.getMode() != WandMode.INVENTORY) {
            return 0;
        }
        return this.hotbars.size() * 8;
    }

    @Nonnull
    protected Inventory getInventory(int slot) {
        int hotbarSize = this.getHotbarSize();
        if (slot < hotbarSize) {
            return this.hotbars.get(slot / 8);
        }
        int inventoryIndex = (slot - hotbarSize) / this.getInventorySize();
        return this.getInventoryByIndex(inventoryIndex);
    }

    protected int getInventorySlot(int slot) {
        int hotbarSize = this.getHotbarSize();
        if (slot < hotbarSize) {
            return slot % 8;
        }
        return (slot - hotbarSize) % this.getInventorySize();
    }

    protected void addToInventory(ItemStack itemStack, Integer slot) {
        if (slot == null) {
            this.addToInventory(itemStack);
            return;
        }
        Inventory inventory = this.getInventory(slot);
        slot = this.getInventorySlot(slot);
        ItemStack existing = inventory.getItem(slot.intValue());
        inventory.setItem(slot.intValue(), itemStack);
        if (existing != null && existing.getType() != Material.AIR) {
            this.addToInventory(existing);
        }
    }

    protected void buildInventory() {
        this.displayInventory = null;
        for (Inventory inventory : this.hotbars) {
            inventory.clear();
        }
        this.inventories.clear();
        ArrayList<ItemStack> unsorted = new ArrayList<ItemStack>();
        for (String key : this.spells) {
            int spellLevel;
            SpellKey spellKey = new SpellKey(key, spellLevel = this.getSpellLevel(key));
            SpellTemplate spell = this.controller.getSpellTemplate(spellKey.getKey());
            ItemStack itemStack = Wand.createSpellItem(spell, "", this.controller, this.getActiveMage(), this, false);
            if (itemStack == null) continue;
            Integer slot = this.spellInventory.get(spell.getSpellKey().getBaseKey());
            if (slot == null) {
                unsorted.add(itemStack);
                continue;
            }
            this.addToInventory(itemStack, slot);
        }
        WandMode wandMode = this.getBrushMode();
        for (String brushKey : this.brushes) {
            boolean addToInventory = wandMode == WandMode.INVENTORY || com.elmakers.mine.bukkit.block.MaterialBrush.isSpecialMaterialKey(brushKey) && !com.elmakers.mine.bukkit.block.MaterialBrush.isSchematic(brushKey);
            if (!addToInventory) continue;
            ItemStack itemStack = this.createBrushIcon(brushKey);
            if (itemStack == null) {
                this.controller.getPlugin().getLogger().warning("Unable to create brush icon for key " + brushKey);
                continue;
            }
            Integer slot = this.brushInventory.get(brushKey);
            if (this.activeBrush == null || this.activeBrush.length() == 0) {
                this.activeBrush = brushKey;
            }
            this.addToInventory(itemStack, slot);
        }
        for (ItemStack unsortedItem : unsorted) {
            this.addToInventory(unsortedItem);
        }
        this.updateHasInventory();
        if (this.openInventoryPage >= this.inventories.size() && this.openInventoryPage != 0 && this.hasInventory) {
            this.setOpenInventoryPage(0);
        }
    }

    protected void parseSpells(String spellString) {
        spellString = spellString.replaceAll("[\\]\\[]", "");
        String[] spellNames = StringUtils.split((String)spellString, (char)',');
        this.loadSpells(Arrays.asList(spellNames));
    }

    protected void clearSpells() {
        this.spellLevels.clear();
        this.spells.clear();
    }

    protected void loadSpells(Collection<String> spellKeys) {
        this.clearSpells();
        WandUpgradePath path = this.getPath();
        for (String spellName : spellKeys) {
            String[] pieces = StringUtils.split((String)spellName, (char)'@');
            Integer slot = this.parseSlot(pieces);
            String loadedKey = pieces[0].trim();
            SpellKey spellKey = new SpellKey(loadedKey);
            SpellTemplate spell = this.controller.getSpellTemplate(loadedKey);
            if (this.limitSpellsToPath && path != null && !path.containsSpell(spellKey.getBaseKey())) continue;
            while (spell == null && spellKey.getLevel() > 0) {
                spellKey = new SpellKey(spellKey.getBaseKey(), spellKey.getLevel() - 1);
                spell = this.controller.getSpellTemplate(spellKey.getKey());
            }
            if (spell == null) continue;
            spellKey = spell.getSpellKey();
            Integer currentLevel = this.spellLevels.get(spellKey.getBaseKey());
            if (currentLevel == null || currentLevel < spellKey.getLevel()) {
                this.setSpellLevel(spellKey.getBaseKey(), spellKey.getLevel());
                if (slot != null) {
                    this.spellInventory.put(spellKey.getBaseKey(), slot);
                }
                this.spells.add(spellKey.getBaseKey());
            }
            if (this.activeSpell != null && this.activeSpell.length() != 0) continue;
            this.activeSpell = spellKey.getBaseKey();
        }
    }

    protected void parseBrushes(String brushString) {
        brushString = brushString.replaceAll("[\\]\\[]", "");
        String[] brushNames = StringUtils.split((String)brushString, (char)',');
        this.loadBrushes(Arrays.asList(brushNames));
    }

    protected void clearBrushes() {
        this.brushes.clear();
    }

    protected void loadBrushes(Collection<String> brushKeys) {
        this.clearBrushes();
        for (String materialName : brushKeys) {
            String[] pieces = StringUtils.split((String)materialName, (char)'@');
            Integer slot = this.parseSlot(pieces);
            String materialKey = pieces[0].trim();
            if (slot != null) {
                this.brushInventory.put(materialKey, slot);
            }
            this.brushes.add(materialKey);
        }
    }

    protected void loadBrushInventory(Map<String, ? extends Object> inventory) {
        if (inventory == null) {
            return;
        }
        for (Map.Entry<String, ? extends Object> brushEntry : inventory.entrySet()) {
            Object slot = brushEntry.getValue();
            if (slot == null || !(slot instanceof Integer)) continue;
            this.brushInventory.put(brushEntry.getKey(), (Integer)slot);
        }
    }

    protected void loadSpellInventory(Map<String, ? extends Object> inventory) {
        if (inventory == null) {
            return;
        }
        for (Map.Entry<String, ? extends Object> spellEntry : inventory.entrySet()) {
            Object slot = spellEntry.getValue();
            if (slot == null || !(slot instanceof Integer)) continue;
            this.spellInventory.put(spellEntry.getKey(), (Integer)slot);
        }
    }

    protected void loadSpellLevels(Map<String, ? extends Object> levels) {
        if (levels == null) {
            return;
        }
        for (Map.Entry<String, ? extends Object> spellEntry : levels.entrySet()) {
            Object level = spellEntry.getValue();
            if (level == null || !(level instanceof Integer)) continue;
            this.setSpellLevel(spellEntry.getKey(), (Integer)level);
        }
    }

    protected ItemStack createSpellIcon(SpellTemplate spell) {
        return Wand.createSpellItem(spell, "", this.controller, this.getActiveMage(), this, false);
    }

    public static ItemStack createSpellItem(String spellKey, MagicController controller, Wand wand, boolean isItem) {
        String[] split = spellKey.split(" ", 2);
        return Wand.createSpellItem(controller.getSpellTemplate(split[0]), split.length > 1 ? split[1] : "", controller, wand == null ? null : wand.getActiveMage(), wand, isItem);
    }

    public static ItemStack createSpellItem(String spellKey, MagicController controller, com.elmakers.mine.bukkit.api.magic.Mage mage, Wand wand, boolean isItem) {
        String[] split = spellKey.split(" ", 2);
        return Wand.createSpellItem(controller.getSpellTemplate(split[0]), split.length > 1 ? split[1] : "", controller, mage, wand, isItem);
    }

    public static ItemStack createSpellItem(SpellTemplate spell, String args, MagicController controller, com.elmakers.mine.bukkit.api.magic.Mage mage, Wand wand, boolean isItem) {
        if (spell == null) {
            return null;
        }
        String iconURL = spell.getIconURL();
        ItemStack itemStack = null;
        if (iconURL != null && (controller.isUrlIconsEnabled() || spell.getIcon() == null || !spell.getIcon().isValid() || spell.getIcon().getMaterial() == Material.AIR)) {
            itemStack = InventoryUtils.getURLSkull(iconURL);
        }
        if (itemStack == null) {
            ItemStack originalItemStack = null;
            MaterialAndData icon = spell.getIcon();
            if (icon == null) {
                controller.getPlugin().getLogger().warning("Unable to create spell icon for " + spell.getName() + ", missing material");
                return null;
            }
            try {
                originalItemStack = new ItemStack(icon.getMaterial(), 1, icon.getData().shortValue());
                itemStack = InventoryUtils.makeReal(originalItemStack);
            }
            catch (Exception ex) {
                itemStack = null;
            }
            if (itemStack == null) {
                if (icon.getMaterial() != Material.AIR) {
                    String iconName = icon.getName();
                    controller.getPlugin().getLogger().warning("Unable to create spell icon for " + spell.getKey() + " with material " + iconName);
                }
                return originalItemStack;
            }
        }
        InventoryUtils.makeUnbreakable(itemStack);
        InventoryUtils.hideFlags(itemStack, (byte)63);
        Wand.updateSpellItem(controller.getMessages(), itemStack, spell, args, mage, wand, wand == null ? null : wand.activeBrush, isItem);
        if (wand != null && wand.getMode() == WandMode.SKILLS && !isItem) {
            Object spellNode;
            InventoryUtils.setMeta(itemStack, "skill", "true");
            String mageClassKey = wand.getMageClassKey();
            if (mageClassKey != null && (spellNode = InventoryUtils.getNode(itemStack, "spell")) != null) {
                InventoryUtils.setMeta(spellNode, "class", mageClassKey);
            }
            if (wand != null && !wand.quickCast && (spellNode = InventoryUtils.getNode(itemStack, "spell")) != null) {
                InventoryUtils.setMetaBoolean(spellNode, "quick_cast", false);
            }
        }
        return itemStack;
    }

    protected ItemStack createBrushIcon(String materialKey) {
        return Wand.createBrushItem(materialKey, this.controller, this, false);
    }

    public static ItemStack createBrushItem(String materialKey, MageController controller, Wand wand, boolean isItem) {
        com.elmakers.mine.bukkit.block.MaterialBrush brushData = com.elmakers.mine.bukkit.block.MaterialBrush.parseMaterialKey(materialKey);
        if (brushData == null) {
            return null;
        }
        ItemStack itemStack = brushData.getItem(controller, isItem);
        if (BrushGlow || isItem && BrushItemGlow) {
            CompatibilityUtils.addGlow(itemStack);
        }
        InventoryUtils.makeUnbreakable(itemStack);
        InventoryUtils.hideFlags(itemStack, (byte)63);
        Wand.updateBrushItem(controller.getMessages(), itemStack, brushData, wand);
        return itemStack;
    }

    protected boolean findItem() {
        Player player;
        if (this.mage != null && this.item != null && (player = this.mage.getPlayer()) != null) {
            ItemStack itemInHand = player.getInventory().getItemInMainHand();
            if (itemInHand != null && itemInHand != this.item && itemInHand.equals((Object)this.item)) {
                this.item = itemInHand;
                this.isInOffhand = false;
                return true;
            }
            itemInHand = player.getInventory().getItemInOffHand();
            if (itemInHand != null && itemInHand != this.item && itemInHand.equals((Object)this.item)) {
                this.item = itemInHand;
                this.isInOffhand = true;
                return true;
            }
            itemInHand = player.getInventory().getItem(this.heldSlot);
            if (itemInHand != null && itemInHand != this.item && itemInHand.equals((Object)this.item)) {
                this.item = itemInHand;
                this.isInOffhand = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public void saveState() {
        Object wandNode;
        if (this.findItem()) {
            this.updateItemIcon();
            this.updateName();
            this.updateLore();
        }
        if (this.item == null || this.item.getType() == Material.AIR) {
            return;
        }
        if (this.isUpgrade && Wand.isWand(this.item)) {
            InventoryUtils.removeMeta(this.item, WAND_KEY);
        }
        if ((wandNode = InventoryUtils.createNode(this.item, this.isUpgrade ? UPGRADE_KEY : WAND_KEY)) == null) {
            this.controller.getLogger().warning("Failed to save wand state for wand to : " + this.item);
        } else {
            InventoryUtils.saveTagsToNBT(this.getConfiguration(), wandNode);
        }
    }

    public static ConfigurationSection itemToConfig(ItemStack item, ConfigurationSection stateNode) {
        Object wandNode = InventoryUtils.getNode(item, WAND_KEY);
        if (wandNode == null && (wandNode = InventoryUtils.getNode(item, UPGRADE_KEY)) == null) {
            return null;
        }
        ConfigurationUtils.loadAllTagsFromNBT(stateNode, wandNode);
        return stateNode;
    }

    public static void configToItem(ConfigurationSection itemSection, ItemStack item) {
        ConfigurationSection stateNode = itemSection.getConfigurationSection("wand");
        Object wandNode = InventoryUtils.createNode(item, WAND_KEY);
        if (wandNode != null) {
            InventoryUtils.saveTagsToNBT(stateNode, wandNode);
        }
    }

    protected String getPotionEffectString() {
        return Wand.getPotionEffectString(this.potionEffects);
    }

    @Override
    public void save(ConfigurationSection node, boolean filtered) {
        ConfigurationUtils.addConfigurations(node, this.getConfiguration());
        if (filtered) {
            node.set("id", null);
            node.set("owner_id", null);
            node.set("owner", null);
            node.set("template", null);
            node.set("mana_timestamp", null);
            node.set("enchant_count", null);
        }
        if (this.isUpgrade) {
            node.set("upgrade", (Object)true);
        }
        if (this.template != null && !this.template.isEmpty()) {
            node.set("template", null);
            node.set("inherit", (Object)this.template);
        }
    }

    public void updateBrushes() {
        if (this.brushes.isEmpty()) {
            this.setProperty("brushes", null);
        } else {
            this.setProperty("brushes", new ArrayList<String>(this.brushes));
        }
    }

    public void updateSpells() {
        if (this.spells.isEmpty()) {
            this.setProperty("spells", null);
            this.setProperty("spells_levels", null);
        } else {
            this.setProperty("spells", new ArrayList<String>(this.spells));
            this.setProperty("spell_levels", new HashMap<String, Integer>(this.spellLevels));
        }
    }

    public void updateBrushInventory() {
        if (this.brushInventory.isEmpty()) {
            this.setProperty("brush_inventory", null);
        } else {
            this.setProperty("brush_inventory", new HashMap<String, Integer>(this.brushInventory));
        }
    }

    public void updateSpellInventory() {
        if (this.spellInventory.isEmpty()) {
            this.setProperty("spell_inventory", null);
        } else {
            this.setProperty("spell_inventory", new HashMap<String, Integer>(this.spellInventory));
        }
    }

    public void setEffectColor(String hexColor) {
        if (hexColor.contains(".")) {
            hexColor = hexColor.substring(0, hexColor.indexOf(46));
        }
        if (hexColor == null || hexColor.length() == 0 || hexColor.equals("none")) {
            this.effectColor = null;
            return;
        }
        this.effectColor = new ColorHD(hexColor);
        if (hexColor.equals("random")) {
            this.setProperty("effect_color", this.effectColor.toString());
        }
    }

    private void migrateProtection(String legacy, String migrateTo) {
        if (this.hasProperty(legacy)) {
            this.setProperty("protection." + migrateTo, this.getDouble(legacy));
            this.clearProperty(legacy);
        }
    }

    @Override
    public void loadProperties() {
        Object spellInventoryRaw;
        WandUpgradePath upgradePath;
        String iconKey;
        int page;
        int hotbar;
        int newCount;
        super.loadProperties();
        this.locked = this.getBoolean("locked", this.locked);
        this.lockedAllowUpgrades = this.getBoolean("locked_allow_upgrades", false);
        this.consumeReduction = (float)this.getDouble("consume_reduction");
        this.cooldownReduction = (float)this.getDouble("cooldown_reduction");
        this.power = (float)this.getDouble("power");
        ConfigurationSection protectionConfig = this.getConfigurationSection("protection");
        if (protectionConfig == null && this.hasProperty("protection")) {
            this.migrateProtection("protection", "overall");
            this.migrateProtection("protection_physical", "physical");
            this.migrateProtection("protection_projectiles", "projectile");
            this.migrateProtection("protection_falling", "fall");
            this.migrateProtection("protection_fire", "fire");
            this.migrateProtection("protection_explosions", "protection_explosion");
            protectionConfig = this.getConfigurationSection("protection");
        }
        if (protectionConfig != null) {
            this.protection = new HashMap<String, Double>();
            for (String protectionKey : protectionConfig.getKeys(false)) {
                this.protection.put(protectionKey, protectionConfig.getDouble(protectionKey));
            }
        }
        this.hasId = this.getBoolean("unique", false);
        this.blockChance = (float)this.getDouble("block_chance");
        this.blockReflectChance = (float)this.getDouble("block_reflect_chance");
        this.blockFOV = (float)this.getDouble("block_fov");
        this.blockMageCooldown = this.getInt("block_mage_cooldown");
        this.blockCooldown = this.getInt("block_cooldown");
        this.manaPerDamage = (float)this.getDouble("mana_per_damage");
        this.spMultiplier = (float)this.getDouble("sp_multiplier", 1.0);
        this.mageClassKey = this.getString("class");
        this.uses = this.getInt("uses");
        this.hasUses = this.uses > 0;
        float healthRegeneration = (float)this.getDouble("health_regeneration", 0.0);
        float hungerRegeneration = (float)this.getDouble("hunger_regeneration", 0.0);
        float speedIncrease = (float)this.getDouble("haste", 0.0);
        if (speedIncrease > 0.0f) {
            this.potionEffects.put(PotionEffectType.SPEED, 1);
        }
        if (healthRegeneration > 0.0f) {
            this.potionEffects.put(PotionEffectType.REGENERATION, 1);
        }
        if (hungerRegeneration > 0.0f) {
            this.potionEffects.put(PotionEffectType.SATURATION, 1);
        }
        if (!regenWhileInactive) {
            this.setProperty("mana_timestamp", System.currentTimeMillis());
        }
        if (this.hasProperty("effect_color")) {
            this.setEffectColor(this.getString("effect_color"));
        }
        this.id = this.getString("id");
        this.isUpgrade = this.getBoolean("upgrade");
        this.quietLevel = this.getInt("quiet");
        this.effectBubbles = this.getBoolean("effect_bubbles");
        this.keep = this.getBoolean("keep");
        this.passive = this.getBoolean("passive");
        this.indestructible = this.getBoolean("indestructible");
        this.superPowered = this.getBoolean("powered");
        this.superProtected = this.getBoolean("protected");
        this.glow = this.getBoolean("glow");
        this.undroppable = this.getBoolean("undroppable");
        this.isHeroes = this.getBoolean("heroes");
        this.bound = this.getBoolean("bound");
        this.forceUpgrade = this.getBoolean("force");
        this.autoOrganize = this.getBoolean("organize");
        this.autoAlphabetize = this.getBoolean("alphabetize");
        this.autoFill = this.getBoolean("fill");
        this.rename = this.getBoolean("rename");
        this.renameDescription = this.getBoolean("rename_description");
        this.enchantCount = this.getInt("enchant_count");
        this.maxEnchantCount = this.getInt("max_enchant_count");
        this.inventoryRows = this.getInt("inventory_rows", 5);
        if (this.inventoryRows <= 0) {
            this.inventoryRows = 1;
        }
        if (this.hasProperty("effect_particle")) {
            this.effectParticle = ConfigurationUtils.toParticleEffect(this.getString("effect_particle"));
            this.effectParticleData = 0.0f;
        } else {
            this.effectParticle = null;
        }
        this.effectSound = this.hasProperty("effect_sound") ? ConfigurationUtils.toSoundEffect(this.getString("effect_sound")) : null;
        this.activeEffectsOnly = this.getBoolean("active_effects");
        this.effectParticleData = (float)this.getDouble("effect_particle_data");
        this.effectParticleCount = this.getInt("effect_particle_count");
        this.effectParticleRadius = this.getDouble("effect_particle_radius");
        this.effectParticleOffset = this.getDouble("effect_particle_offset");
        this.effectParticleInterval = this.getInt("effect_particle_interval");
        this.effectParticleMinVelocity = this.getDouble("effect_particle_min_velocity");
        this.effectSoundInterval = this.getInt("effect_sound_interval");
        this.castLocation = this.getVector("cast_location");
        this.castInterval = this.getInt("cast_interval");
        this.castMinVelocity = this.getDouble("cast_min_velocity");
        this.castVelocityDirection = this.getVector("cast_velocity_direction");
        this.castSpell = this.getString("cast_spell");
        String castParameterString = this.getString("cast_parameters", null);
        if (castParameterString != null && !castParameterString.isEmpty()) {
            this.castParameters = new MemoryConfiguration();
            ConfigurationUtils.addParameters(StringUtils.split((String)castParameterString, (char)' '), this.castParameters);
        } else {
            this.castParameters = null;
        }
        WandMode newMode = Wand.parseWandMode(this.getString("mode"), this.controller.getDefaultWandMode());
        if (newMode != this.mode) {
            if (this.isInventoryOpen()) {
                this.closeInventory();
            }
            this.mode = newMode;
        }
        this.brushMode = Wand.parseWandMode(this.getString("brush_mode"), this.controller.getDefaultBrushMode());
        if (this.getBoolean("mode_drop", false)) {
            this.dropAction = WandAction.TOGGLE;
            this.swapAction = WandAction.CYCLE_HOTBAR;
            this.rightClickAction = WandAction.NONE;
            this.quickCast = true;
            this.quickCastDisabled = true;
            this.manualQuickCastDisabled = false;
        } else if (this.mode == WandMode.CAST) {
            this.leftClickAction = WandAction.CAST;
            this.rightClickAction = WandAction.CAST;
            this.swapAction = WandAction.NONE;
            this.dropAction = WandAction.NONE;
        } else if (this.mode == WandMode.CYCLE) {
            this.leftClickAction = WandAction.CAST;
            this.rightClickAction = WandAction.NONE;
            this.swapAction = WandAction.NONE;
            this.dropAction = WandAction.CYCLE;
        } else {
            this.leftClickAction = WandAction.NONE;
            this.rightClickAction = WandAction.NONE;
            this.dropAction = WandAction.NONE;
            this.swapAction = WandAction.NONE;
            this.quickCast = false;
            this.quickCastDisabled = false;
            this.manualQuickCastDisabled = false;
        }
        String quickCastType = this.getString("quick_cast", this.getString("mode_cast"));
        if (quickCastType != null) {
            if (quickCastType.equalsIgnoreCase("true")) {
                this.quickCast = true;
                this.quickCastDisabled = true;
                this.manualQuickCastDisabled = false;
            } else if (quickCastType.equalsIgnoreCase("manual")) {
                this.quickCast = false;
                this.quickCastDisabled = true;
                this.manualQuickCastDisabled = false;
            } else if (quickCastType.equalsIgnoreCase("disable")) {
                this.quickCast = false;
                this.quickCastDisabled = true;
                this.manualQuickCastDisabled = true;
            } else {
                this.quickCast = false;
                this.quickCastDisabled = false;
                this.manualQuickCastDisabled = false;
            }
        }
        this.leftClickAction = Wand.parseWandAction(this.getString("left_click"), this.leftClickAction);
        this.rightClickAction = Wand.parseWandAction(this.getString("right_click"), this.rightClickAction);
        this.dropAction = Wand.parseWandAction(this.getString("drop"), this.dropAction);
        this.swapAction = Wand.parseWandAction(this.getString("swap"), this.swapAction);
        this.owner = this.getString("owner");
        this.ownerId = this.getString("owner_id");
        this.template = this.getString("template");
        this.upgradeTemplate = this.getString("upgrade_template");
        this.path = this.getString("path");
        this.activeSpell = this.getString("active_spell");
        if (this.activeSpell != null && this.activeSpell.contains("|")) {
            SpellKey activeKey = new SpellKey(this.activeSpell);
            this.activeSpell = activeKey.getBaseKey();
            this.setProperty("active_spell", this.activeSpell);
        }
        this.alternateSpell = this.getString("alternate_spell");
        this.alternateSpell2 = this.getString("alternate_spell2");
        this.activeBrush = this.getString("active_brush", this.getString("active_material"));
        if (this.hasProperty("hotbar_count") && ((newCount = Math.max(1, this.getInt("hotbar_count"))) != this.hotbars.size() || newCount > this.hotbars.size())) {
            if (this.isInventoryOpen()) {
                this.closeInventory();
            }
            this.setHotbarCount(newCount);
        }
        if (this.hasProperty("hotbar") && (hotbar = this.getInt("hotbar")) != this.currentHotbar) {
            this.setCurrentHotbar(hotbar < 0 || hotbar >= this.hotbars.size() ? 0 : hotbar);
        }
        if (this.hasProperty("page") && (page = this.getInt("page")) != this.openInventoryPage) {
            this.openInventoryPage = page;
        }
        this.wandName = this.controller.getMessages().get("wand.default_name");
        this.description = "";
        ConfigurationSection templateConfig = null;
        if (this.template != null && !this.template.isEmpty()) {
            templateConfig = this.controller.getWandTemplateConfiguration(this.template);
            if (templateConfig != null) {
                this.wandName = templateConfig.getString("name", this.wandName);
                this.description = templateConfig.getString("description", this.description);
                int templateUses = templateConfig.getInt("uses");
                this.isSingleUse = templateUses == 1;
                this.hasUses = this.hasUses || templateUses > 0;
            }
            this.wandName = this.controller.getMessages().get("wands." + this.template + ".name", this.wandName);
            this.description = this.controller.getMessages().get("wands." + this.template + ".description", this.description);
        }
        this.wandName = this.getString("name", this.wandName);
        this.description = this.getString("description", this.description);
        WandTemplate wandTemplate = this.getTemplate();
        InventoryUtils.applyAttributes(this.item, this.getConfigurationSection("attributes"), this.getString("attribute_slot"));
        ConfigurationSection enchantments = this.getConfigurationSection("enchantments");
        InventoryUtils.applyEnchantments(this.item, enchantments);
        if (enchantments == null || enchantments.getKeys(false).isEmpty()) {
            if (this.glow) {
                CompatibilityUtils.addGlow(this.item);
            } else {
                CompatibilityUtils.removeGlow(this.item);
            }
        }
        if (this.hasProperty("icon_inactive")) {
            iconKey = this.getString("icon_inactive");
            if (wandTemplate != null) {
                iconKey = wandTemplate.migrateIcon(iconKey);
            }
            if (iconKey != null) {
                this.inactiveIcon = new com.elmakers.mine.bukkit.block.MaterialAndData(iconKey);
            }
        } else {
            this.inactiveIcon = null;
        }
        if (this.inactiveIcon != null && (this.inactiveIcon.getMaterial() == null || this.inactiveIcon.getMaterial() == Material.AIR)) {
            this.inactiveIcon = null;
        }
        this.inactiveIconDelay = this.getInt("icon_inactive_delay");
        boolean bl = this.randomizeOnActivate = this.randomizeOnActivate && this.hasProperty("randomize_icon");
        if (this.randomizeOnActivate) {
            String randomizeIcon = this.getString("randomize_icon");
            this.setIcon(new com.elmakers.mine.bukkit.block.MaterialAndData(randomizeIcon));
            if (this.item == null) {
                this.controller.getLogger().warning("Invalid randomize_icon in wand '" + this.template + "' config: " + randomizeIcon);
            }
        } else if (this.hasProperty("icon")) {
            iconKey = this.getString("icon");
            if (wandTemplate != null) {
                iconKey = wandTemplate.migrateIcon(iconKey);
            }
            if (iconKey.contains(",")) {
                Random r = new Random();
                String[] keys = StringUtils.split((String)iconKey, (char)',');
                iconKey = keys[r.nextInt(keys.length)];
            }
            if (templateConfig != null && iconKey.contains("i.imgur.com")) {
                iconKey = templateConfig.getString("icon");
            }
            this.setIcon(new com.elmakers.mine.bukkit.block.MaterialAndData(iconKey));
            if (this.item == null) {
                this.controller.getLogger().warning("Invalid icon in wand '" + this.template + "' config: " + iconKey);
            }
            this.updateIcon();
        } else if (this.isUpgrade) {
            this.setIcon(new com.elmakers.mine.bukkit.block.MaterialAndData(DefaultUpgradeMaterial));
        } else {
            this.setIcon(new com.elmakers.mine.bukkit.block.MaterialAndData(DefaultWandMaterial));
        }
        if (this.hasProperty("upgrade_icon")) {
            this.upgradeIcon = new com.elmakers.mine.bukkit.block.MaterialAndData(this.getString("upgrade_icon"));
        }
        if ((upgradePath = this.getPath()) != null) {
            this.hasSpellProgression = upgradePath.getSpells().size() > 0 || upgradePath.getExtraSpells().size() > 0 || upgradePath.getRequiredSpells().size() > 0;
            upgradePath.checkMigration(this);
        } else {
            this.hasSpellProgression = false;
        }
        if (this.isHeroes) {
            this.hasSpellProgression = true;
        }
        this.brushInventory.clear();
        this.spellInventory.clear();
        this.limitSpellsToPath = this.getBoolean("limit_spells_to_path");
        Object wandSpells = this.getObject("spells");
        if (wandSpells != null) {
            if (wandSpells instanceof String) {
                this.parseSpells((String)wandSpells);
            } else if (wandSpells instanceof Collection) {
                Collection spellList = (Collection)wandSpells;
                this.loadSpells(spellList);
            } else {
                this.clearSpells();
            }
        } else {
            this.clearSpells();
        }
        Object spellLevelsRaw = this.getObject("spell_levels");
        if (spellLevelsRaw != null) {
            if (spellLevelsRaw instanceof Map) {
                Map spellLevels = (Map)spellLevelsRaw;
                this.loadSpellLevels(spellLevels);
            } else if (spellLevelsRaw instanceof ConfigurationSection) {
                this.loadSpellLevels(NMSUtils.getMap((ConfigurationSection)spellLevelsRaw));
            }
        }
        this.checkActiveSpell();
        Object wandBrushes = this.getObject("brushes", this.getObject("materials"));
        if (wandBrushes != null) {
            if (wandBrushes instanceof String) {
                this.parseBrushes((String)wandBrushes);
            } else if (wandBrushes instanceof Collection) {
                Collection brushList = (Collection)wandBrushes;
                this.loadBrushes(brushList);
            } else {
                this.clearBrushes();
            }
        } else {
            this.clearBrushes();
        }
        Object brushInventoryRaw = this.getObject("brush_inventory");
        if (brushInventoryRaw != null) {
            if (brushInventoryRaw instanceof Map) {
                Map brushInventory = (Map)brushInventoryRaw;
                this.loadBrushInventory(brushInventory);
            } else if (brushInventoryRaw instanceof ConfigurationSection) {
                this.loadBrushInventory(NMSUtils.getMap((ConfigurationSection)brushInventoryRaw));
            }
        }
        if ((spellInventoryRaw = this.getObject("spell_inventory")) != null) {
            if (spellInventoryRaw instanceof Map) {
                Map spellInventory = (Map)spellInventoryRaw;
                this.loadSpellInventory(spellInventory);
            } else if (spellInventoryRaw instanceof ConfigurationSection) {
                this.loadSpellInventory(NMSUtils.getMap((ConfigurationSection)spellInventoryRaw));
            }
        } else {
            this.updateSpellInventory();
        }
        this.castOverrides = null;
        if (this.hasProperty("overrides")) {
            this.castOverrides = null;
            Object overridesGeneric = this.getObject("overrides");
            if (overridesGeneric != null) {
                this.castOverrides = new HashMap<String, String>();
                if (overridesGeneric instanceof String) {
                    String overrides = (String)overridesGeneric;
                    if (!overrides.isEmpty()) {
                        String[] pairs;
                        overrides = overrides.replaceAll("[\\]\\[]", "");
                        for (String override : pairs = StringUtils.split((String)overrides, (char)',')) {
                            this.parseOverride(override);
                        }
                    }
                } else if (overridesGeneric instanceof List) {
                    List overrideList = (List)overridesGeneric;
                    for (String override : overrideList) {
                        this.parseOverride(override);
                    }
                } else if (overridesGeneric instanceof ConfigurationSection) {
                    ConfigurationSection overridesSection = (ConfigurationSection)overridesGeneric;
                    Set keys = overridesSection.getKeys(true);
                    for (String key : keys) {
                        Object leaf = overridesSection.get(key);
                        if (leaf instanceof ConfigurationSection || leaf instanceof Map) continue;
                        this.castOverrides.put(key, leaf.toString());
                    }
                }
            }
        }
        this.potionEffects.clear();
        if (this.hasProperty("potion_effects")) {
            this.addPotionEffects(this.potionEffects, this.getString("potion_effects", null));
        }
        if (this.effectSound == null) {
            this.effectSoundInterval = 0;
        } else {
            int n = this.effectSoundInterval = this.effectSoundInterval == 0 ? 5 : this.effectSoundInterval;
        }
        if (this.effectParticle == null) {
            this.effectParticleInterval = 0;
        }
        this.checkActiveMaterial();
    }

    private void parseOverride(String override) {
        String[] keyValue = StringUtils.split((String)(override = override.replace("\\|", ",")), (char)' ');
        if (keyValue.length > 0) {
            String value = keyValue.length > 1 ? keyValue[1] : "";
            this.castOverrides.put(keyValue[0], value);
        }
    }

    @Override
    public void describe(CommandSender sender, @Nullable Set<String> ignoreProperties) {
        ChatColor wandColor = this.isModifiable() ? ChatColor.AQUA : ChatColor.RED;
        sender.sendMessage(wandColor + this.wandName);
        if (this.isUpgrade) {
            sender.sendMessage(ChatColor.YELLOW + "(Upgrade)");
        }
        if (this.description.length() > 0) {
            sender.sendMessage(ChatColor.ITALIC + "" + ChatColor.GREEN + this.description);
        } else {
            sender.sendMessage(ChatColor.ITALIC + "" + ChatColor.GREEN + "(No Description)");
        }
        if (this.owner != null && this.owner.length() > 0 && this.ownerId != null && this.ownerId.length() > 0) {
            sender.sendMessage(ChatColor.ITALIC + "" + ChatColor.WHITE + this.owner + " (" + ChatColor.GRAY + this.ownerId + ChatColor.WHITE + ")");
        } else {
            sender.sendMessage(ChatColor.ITALIC + "" + ChatColor.WHITE + "(No Owner)");
        }
        super.describe(sender, ignoreProperties);
        WandTemplate template = this.getTemplate();
        if (template != null) {
            sender.sendMessage("" + ChatColor.BOLD + ChatColor.GREEN + "Template Configuration:");
            ConfigurationSection itemConfig = this.getConfiguration();
            Set ownKeys = itemConfig.getKeys(false);
            template.describe(sender, ignoreProperties, ownKeys);
        }
    }

    private static String getBrushDisplayName(Messages messages, MaterialBrush brush) {
        String materialName;
        String string = materialName = brush == null ? null : brush.getName(messages);
        if (materialName == null) {
            materialName = "none";
        }
        return ChatColor.GRAY + materialName;
    }

    private static String getSpellDisplayName(Messages messages, SpellTemplate spell, MaterialBrush brush) {
        String name = "";
        if (spell != null) {
            name = brush != null && spell.usesBrush() ? ChatColor.GOLD + spell.getName() + " " + Wand.getBrushDisplayName(messages, brush) + ChatColor.WHITE : ChatColor.GOLD + spell.getName() + ChatColor.WHITE;
        }
        return name;
    }

    private String getActiveWandName(SpellTemplate spell, MaterialBrush brush) {
        int remaining = this.getRemainingUses();
        String wandColorPrefix = this.hasUses && remaining <= 1 ? "single_use_prefix" : (this.isModifiable() ? (this.bound ? "bound_prefix" : "unbound_prefix") : (this.path != null && this.path.length() > 0 ? "has_path_prefix" : "unmodifiable_prefix"));
        String name = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getMessage(wandColorPrefix)) + this.getDisplayName();
        if (this.randomizeOnActivate) {
            return name;
        }
        Collection spells = this.getSpells();
        Messages messages = this.controller.getMessages();
        boolean showSpell = this.isModifiable() && this.hasSpellProgression();
        boolean bl = showSpell = !this.quickCast && (spells.size() > 1 || showSpell) && this.getMode() != WandMode.SKILLS;
        if (spell != null && showSpell) {
            name = Wand.getSpellDisplayName(messages, spell, brush) + " (" + name + ChatColor.WHITE + ")";
        }
        if (remaining > 1) {
            String message = this.getMessage("uses_remaining_brief");
            name = name + ChatColor.DARK_RED + " (" + message.replace("$count", Integer.valueOf(remaining).toString()) + ChatColor.DARK_RED + ")";
        }
        return name;
    }

    private String getActiveWandName(SpellTemplate spell) {
        return this.getActiveWandName(spell, this.mage == null ? com.elmakers.mine.bukkit.block.MaterialBrush.parseMaterialKey(this.activeBrush) : this.mage.getBrush());
    }

    private String getActiveWandName(com.elmakers.mine.bukkit.block.MaterialBrush brush) {
        SpellTemplate spell = null;
        if (this.activeSpell != null && this.activeSpell.length() > 0) {
            spell = this.controller.getSpellTemplate(this.activeSpell);
        }
        return this.getActiveWandName(spell, brush);
    }

    private String getActiveWandName() {
        SpellTemplate spell = null;
        if (this.activeSpell != null && this.activeSpell.length() > 0) {
            spell = this.controller.getSpellTemplate(this.activeSpell);
        }
        return this.getActiveWandName(spell);
    }

    protected String getDisplayName() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)(this.randomizeOnActivate ? this.getMessage("randomized_name") : this.wandName));
    }

    public void updateName(boolean isActive) {
        if (isActive) {
            CompatibilityUtils.setDisplayName(this.item, !this.isUpgrade ? this.getActiveWandName() : ChatColor.translateAlternateColorCodes((char)'&', (String)this.getMessage("upgrade_prefix")) + this.getDisplayName());
        } else {
            CompatibilityUtils.setDisplayName(this.item, ChatColor.stripColor((String)this.getDisplayName()));
        }
    }

    private void updateName() {
        this.updateName(true);
    }

    protected static String convertToHTML(String line) {
        int tagCount = 1;
        line = "<span style=\"color:white\">" + line;
        for (ChatColor c : ChatColor.values()) {
            tagCount += StringUtils.countMatches((String)line, (String)c.toString());
            String replaceStyle = "";
            if (c == ChatColor.ITALIC) {
                replaceStyle = "font-style: italic";
            } else if (c == ChatColor.BOLD) {
                replaceStyle = "font-weight: bold";
            } else if (c == ChatColor.UNDERLINE) {
                replaceStyle = "text-decoration: underline";
            } else {
                String color = c.name().toLowerCase().replace("_", "");
                if (c == ChatColor.LIGHT_PURPLE) {
                    color = "mediumpurple";
                }
                replaceStyle = "color:" + color;
            }
            line = line.replace(c.toString(), "<span style=\"" + replaceStyle + "\">");
        }
        for (int i = 0; i < tagCount; ++i) {
            line = line + "</span>";
        }
        return line;
    }

    public String getHTMLDescription() {
        List<String> rawLore = this.getLore();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("<h2>" + Wand.convertToHTML(this.getActiveWandName()) + "</h2>");
        for (String line : rawLore) {
            lore.add(Wand.convertToHTML(line));
        }
        return "<div style=\"background-color: black; margin: 8px; padding: 8px\">" + StringUtils.join(lore, (String)"<br/>") + "</div>";
    }

    protected void addPropertyLore(List<String> lore, boolean isSingleSpell) {
        float costReduction;
        Object spell;
        float manaRegenerationBoost;
        if (this.usesMana() && this.effectiveManaMax > 0) {
            int manaMax = this.getManaMax();
            if (this.effectiveManaMax != manaMax) {
                String fullMessage = this.getLevelString("mana_amount_boosted", manaMax, this.controller.getMaxMana());
                ConfigurationUtils.addIfNotEmpty(fullMessage.replace("$mana", Integer.toString(this.effectiveManaMax)), lore);
            } else {
                ConfigurationUtils.addIfNotEmpty(this.getLevelString("mana_amount", manaMax, this.controller.getMaxMana()), lore);
            }
            int manaRegeneration = this.getManaRegeneration();
            if (manaRegeneration > 0 && this.effectiveManaRegeneration > 0) {
                if (this.effectiveManaRegeneration != manaRegeneration) {
                    String fullMessage = this.getLevelString("mana_regeneration_boosted", manaRegeneration, this.controller.getMaxManaRegeneration());
                    ConfigurationUtils.addIfNotEmpty(fullMessage.replace("$mana", Integer.toString(this.effectiveManaRegeneration)), lore);
                } else {
                    ConfigurationUtils.addIfNotEmpty(this.getLevelString("mana_regeneration", manaRegeneration, this.controller.getMaxManaRegeneration()), lore);
                }
            }
            if (this.manaPerDamage > 0.0f) {
                ConfigurationUtils.addIfNotEmpty(this.getLevelString("mana_per_damage", this.manaPerDamage, this.controller.getMaxManaRegeneration()), lore);
            }
        }
        if (this.superPowered) {
            ConfigurationUtils.addIfNotEmpty(this.getMessage("super_powered"), lore);
        }
        if (this.blockReflectChance > 0.0f) {
            ConfigurationUtils.addIfNotEmpty(this.getLevelString("reflect_chance", this.blockReflectChance), lore);
        } else if (this.blockChance != 0.0f) {
            ConfigurationUtils.addIfNotEmpty(this.getLevelString("block_chance", this.blockChance), lore);
        }
        float manaMaxBoost = this.getManaMaxBoost();
        if (manaMaxBoost != 0.0f) {
            ConfigurationUtils.addIfNotEmpty(this.getPercentageString("mana_boost", manaMaxBoost), lore);
        }
        if ((manaRegenerationBoost = this.getManaRegenerationBoost()) != 0.0f) {
            ConfigurationUtils.addIfNotEmpty(this.getPercentageString("mana_regeneration_boost", manaRegenerationBoost), lore);
        }
        if (this.castSpell != null && (spell = this.controller.getSpellTemplate(this.castSpell)) != null) {
            ConfigurationUtils.addIfNotEmpty(this.getMessage("spell_aura").replace("$spell", spell.getName()), lore);
        }
        for (Map.Entry entry : this.potionEffects.entrySet()) {
            ConfigurationUtils.addIfNotEmpty(this.describePotionEffect((PotionEffectType)entry.getKey(), (Integer)entry.getValue()), lore);
        }
        if (this.consumeReduction > 0.0f && !isSingleSpell) {
            ConfigurationUtils.addIfNotEmpty(this.getLevelString("consume_reduction", this.consumeReduction), lore);
        }
        if ((costReduction = this.getCostReduction()) > 0.0f && !isSingleSpell) {
            ConfigurationUtils.addIfNotEmpty(this.getLevelString("cost_reduction", costReduction), lore);
        }
        if (this.cooldownReduction > 0.0f && !isSingleSpell) {
            ConfigurationUtils.addIfNotEmpty(this.getLevelString("cooldown_reduction", this.cooldownReduction), lore);
        }
        if (this.power > 0.0f) {
            ConfigurationUtils.addIfNotEmpty(this.getLevelString("power", this.power), lore);
        }
        if (this.superProtected) {
            ConfigurationUtils.addIfNotEmpty(this.getMessage("super_protected"), lore);
        } else if (this.protection != null) {
            for (Map.Entry<String, Double> entry : this.protection.entrySet()) {
                String template;
                String protectionType = entry.getKey();
                double amount = entry.getValue();
                if (!(amount > 0.0)) continue;
                String templateKey = this.getMessageKey("protection." + protectionType);
                if (this.controller.getMessages().containsKey(templateKey)) {
                    template = this.controller.getMessages().get(templateKey);
                } else {
                    templateKey = this.getMessageKey("protection.unknown");
                    template = this.controller.getMessages().get(templateKey);
                    String pretty = protectionType.substring(0, 1).toUpperCase() + protectionType.substring(1);
                    template = template.replace("$type", pretty);
                }
                template = this.controller.getMessages().formatLevelString(template, (float)amount);
                ConfigurationUtils.addIfNotEmpty(template, lore);
            }
        }
        if (this.spMultiplier > 1.0f) {
            ConfigurationUtils.addIfNotEmpty(this.getPercentageString("sp_multiplier", this.spMultiplier - 1.0f), lore);
        }
    }

    public String getLevelString(String templateName, float amount) {
        return this.controller.getMessages().getLevelString(this.getMessageKey(templateName), amount);
    }

    public String getLevelString(String templateName, float amount, float max) {
        return this.controller.getMessages().getLevelString(this.getMessageKey(templateName), amount, max);
    }

    public String getPercentageString(String templateName, float amount) {
        return this.controller.getMessages().getPercentageString(this.getMessageKey(templateName), amount);
    }

    protected List<String> getCustomLore(Collection<String> loreTemplate) {
        ArrayList<String> lore = new ArrayList<String>();
        block20: for (String line : loreTemplate) {
            if (line.startsWith("$")) {
                switch (line) {
                    case "$description": {
                        this.addDescriptionLore(lore);
                        break;
                    }
                    case "$path": {
                        String pathTemplate = this.getMessage("path_lore", "");
                        String pathName = this.getPathName();
                        if (pathName == null || pathTemplate.isEmpty()) continue block20;
                        lore.add(pathTemplate.replace("$path", pathName));
                        break;
                    }
                    case "$owner": {
                        this.addOwnerDescription(lore);
                        break;
                    }
                    case "$spells": {
                        int spellCount = this.getSpells().size();
                        if (spellCount <= 0) continue block20;
                        ConfigurationUtils.addIfNotEmpty(this.getMessage("spell_count").replace("$count", Integer.valueOf(spellCount).toString()), lore);
                        break;
                    }
                    case "$brushes": {
                        int materialCount = this.getBrushes().size();
                        if (materialCount <= 0) continue block20;
                        ConfigurationUtils.addIfNotEmpty(this.getMessage("material_count").replace("$count", Integer.valueOf(materialCount).toString()), lore);
                        break;
                    }
                    case "$uses": {
                        int remaining = this.getRemainingUses();
                        if (this.isSingleUse || remaining <= 0) continue block20;
                        String message = remaining == 1 ? this.getMessage("uses_remaining_singular") : this.getMessage("uses_remaining_brief");
                        ConfigurationUtils.addIfNotEmpty(message.replace("$count", Integer.valueOf(remaining).toString()), lore);
                        break;
                    }
                    case "$mana_max": {
                        String fullMessage;
                        if (!this.usesMana()) continue block20;
                        int manaMax = this.getManaMax();
                        if (this.effectiveManaMax != manaMax) {
                            fullMessage = this.getLevelString("mana_amount_boosted", manaMax, this.controller.getMaxMana());
                            ConfigurationUtils.addIfNotEmpty(fullMessage.replace("$mana", Integer.toString(this.effectiveManaMax)), lore);
                            break;
                        }
                        ConfigurationUtils.addIfNotEmpty(this.getLevelString("mana_amount", manaMax, this.controller.getMaxMana()), lore);
                        break;
                    }
                    case "$mana_regeneration": {
                        int manaRegeneration;
                        String fullMessage;
                        if (!this.usesMana() || (manaRegeneration = this.getManaRegeneration()) <= 0) continue block20;
                        if (this.effectiveManaRegeneration != manaRegeneration) {
                            fullMessage = this.getLevelString("mana_regeneration_boosted", manaRegeneration, this.controller.getMaxManaRegeneration());
                            ConfigurationUtils.addIfNotEmpty(fullMessage.replace("$mana", Integer.toString(this.effectiveManaRegeneration)), lore);
                            break;
                        }
                        ConfigurationUtils.addIfNotEmpty(this.getLevelString("mana_regeneration", manaRegeneration, this.controller.getMaxManaRegeneration()), lore);
                        break;
                    }
                    default: {
                        lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
                    }
                }
                continue;
            }
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
        }
        return lore;
    }

    protected void addDescriptionLore(List<String> lore) {
        String descriptionTemplate = this.controller.getMessages().get(this.getMessageKey("description_lore"), "");
        if (!this.description.isEmpty() && !descriptionTemplate.isEmpty()) {
            if (this.description.contains("$path")) {
                String pathName = this.getPathName();
                String description = ChatColor.translateAlternateColorCodes((char)'&', (String)this.description);
                description = description.replace("$path", pathName == null ? "Unknown" : pathName);
                InventoryUtils.wrapText(descriptionTemplate.replace("$description", description), lore);
            } else {
                String description = ChatColor.translateAlternateColorCodes((char)'&', (String)this.description);
                InventoryUtils.wrapText(descriptionTemplate.replace("$description", description), lore);
            }
        }
    }

    protected String getPathName() {
        MageClassTemplate classTemplate;
        String pathName = null;
        com.elmakers.mine.bukkit.api.wand.WandUpgradePath path = this.getPath();
        if (path != null) {
            pathName = path.getName();
        } else if (this.mageClassKey != null && !this.mageClassKey.isEmpty() && (classTemplate = this.controller.getMageClassTemplate(this.mageClassKey)) != null) {
            String pathKey = classTemplate.getProperty("path", "");
            if (!pathKey.isEmpty()) {
                path = this.controller.getPath(pathKey);
            }
            pathName = path != null ? path.getName() : classTemplate.getName();
        }
        return pathName;
    }

    protected void addOwnerDescription(List<String> lore) {
        if (this.owner != null && this.owner.length() > 0) {
            if (this.bound) {
                String ownerDescription = this.getMessage("bound_description", "$name").replace("$name", this.owner);
                ConfigurationUtils.addIfNotEmpty(ownerDescription, lore);
            } else {
                String ownerDescription = this.getMessage("owner_description", "$name").replace("$name", this.owner);
                ConfigurationUtils.addIfNotEmpty(ownerDescription, lore);
            }
        }
    }

    protected List<String> getLore() {
        boolean isSingleSpell;
        Object customLore = this.getProperty("lore");
        if (customLore != null && customLore instanceof Collection) {
            return this.getCustomLore((Collection)customLore);
        }
        ArrayList<String> lore = new ArrayList<String>();
        int spellCount = this.getSpells().size();
        int materialCount = this.getBrushes().size();
        String pathName = this.getPathName();
        if (this.description.length() > 0) {
            String description;
            String newDescription;
            if (this.randomizeOnActivate) {
                String randomDescription = this.getMessage("randomized_lore");
                String randomTemplate = this.controller.getMessages().get(this.getMessageKey("randomized_description"), "");
                if (randomDescription.length() > 0 && !randomTemplate.isEmpty()) {
                    InventoryUtils.wrapText(randomTemplate.replace("$description", randomDescription), lore);
                    return lore;
                }
            }
            if (this.description.contains("$") && !this.description.contains("$path") && !(newDescription = this.controller.getMessages().escape(this.description)).equals(this.description)) {
                this.description = newDescription;
                this.setProperty("description", this.description);
            }
            String descriptionTemplate = this.controller.getMessages().get(this.getMessageKey("description_lore"), "");
            if (this.description.contains("$path") && !descriptionTemplate.isEmpty()) {
                description = ChatColor.translateAlternateColorCodes((char)'&', (String)this.description);
                description = description.replace("$path", pathName == null ? "Unknown" : pathName);
                InventoryUtils.wrapText(descriptionTemplate.replace("$description", description), lore);
            } else if (this.description.contains("$")) {
                String randomDescription = this.getMessage("randomized_lore");
                String randomTemplate = this.controller.getMessages().get(this.getMessageKey("randomized_description"), "");
                if (randomDescription.length() > 0 && !randomTemplate.isEmpty()) {
                    randomDescription = ChatColor.translateAlternateColorCodes((char)'&', (String)randomDescription);
                    InventoryUtils.wrapText(randomTemplate.replace("$description", randomDescription), lore);
                    return lore;
                }
            } else if (!descriptionTemplate.isEmpty()) {
                description = ChatColor.translateAlternateColorCodes((char)'&', (String)this.description);
                InventoryUtils.wrapText(descriptionTemplate.replace("$description", description), lore);
            }
        }
        String pathTemplate = this.getMessage("path_lore", "");
        if (pathName != null && !pathTemplate.isEmpty()) {
            lore.add(pathTemplate.replace("$path", pathName));
        }
        if (!this.isUpgrade) {
            this.addOwnerDescription(lore);
        }
        SpellTemplate spell = this.controller.getSpellTemplate(this.getActiveSpellKey());
        Messages messages = this.controller.getMessages();
        boolean bl = isSingleSpell = spell != null && spellCount == 1 && !this.hasInventory && !this.isUpgrade;
        if (isSingleSpell) {
            Wand.addSpellLore(messages, spell, lore, this.getActiveMage(), this);
        }
        if (materialCount == 1 && this.activeBrush != null && this.activeBrush.length() > 0) {
            lore.add(Wand.getBrushDisplayName(messages, com.elmakers.mine.bukkit.block.MaterialBrush.parseMaterialKey(this.activeBrush)));
        }
        if (spellCount > 0) {
            if (this.isUpgrade) {
                ConfigurationUtils.addIfNotEmpty(this.getMessage("upgrade_spell_count").replace("$count", Integer.valueOf(spellCount).toString()), lore);
            } else if (spellCount > 1) {
                ConfigurationUtils.addIfNotEmpty(this.getMessage("spell_count").replace("$count", Integer.valueOf(spellCount).toString()), lore);
            }
        }
        if (materialCount > 0) {
            if (this.isUpgrade) {
                ConfigurationUtils.addIfNotEmpty(this.getMessage("upgrade_material_count").replace("$count", Integer.valueOf(materialCount).toString()), lore);
            } else if (materialCount > 1) {
                ConfigurationUtils.addIfNotEmpty(this.getMessage("material_count").replace("$count", Integer.valueOf(materialCount).toString()), lore);
            }
        }
        int remaining = this.getRemainingUses();
        if (!this.isSingleUse && remaining > 0) {
            if (this.isUpgrade) {
                String message = remaining == 1 ? this.getMessage("upgrade_uses_singular") : this.getMessage("upgrade_uses");
                ConfigurationUtils.addIfNotEmpty(message.replace("$count", Integer.valueOf(remaining).toString()), lore);
            } else {
                String message = remaining == 1 ? this.getMessage("uses_remaining_singular") : this.getMessage("uses_remaining_brief");
                ConfigurationUtils.addIfNotEmpty(message.replace("$count", Integer.valueOf(remaining).toString()), lore);
            }
        }
        this.addPropertyLore(lore, isSingleSpell);
        if (this.isUpgrade) {
            ConfigurationUtils.addIfNotEmpty(this.getMessage("upgrade_item_description"), lore);
        }
        return lore;
    }

    protected void updateLore() {
        CompatibilityUtils.setLore(this.item, this.getLore());
    }

    public void save() {
        this.saveState();
        this.updateName();
        this.updateLore();
    }

    public int getRemainingUses() {
        return this.uses;
    }

    public void makeEnchantable(boolean enchantable) {
        if (EnchantableWandMaterial == null) {
            return;
        }
        if (!enchantable) {
            this.item.setType(this.icon.getMaterial());
            this.item.setDurability(this.icon.getData().shortValue());
        } else {
            Set<Material> enchantableMaterials = this.controller.getMaterialSet("enchantable");
            if (!enchantableMaterials.contains(this.item.getType())) {
                this.item.setType(EnchantableWandMaterial);
                this.item.setDurability((short)0);
            }
        }
        this.updateName();
    }

    public static boolean hasActiveWand(Player player) {
        if (player == null) {
            return false;
        }
        ItemStack activeItem = player.getInventory().getItemInMainHand();
        return Wand.isWand(activeItem);
    }

    public static Wand getActiveWand(MagicController controller, Player player) {
        ItemStack activeItem = player.getInventory().getItemInMainHand();
        if (Wand.isWand(activeItem)) {
            return controller.getWand(activeItem);
        }
        return null;
    }

    public static boolean isWand(ItemStack item) {
        return item != null && InventoryUtils.hasMeta(item, WAND_KEY);
    }

    public static boolean isWandOrUpgrade(ItemStack item) {
        return Wand.isWand(item) || Wand.isUpgrade(item);
    }

    public static boolean isSpecial(ItemStack item) {
        return Wand.isWand(item) || Wand.isUpgrade(item) || Wand.isSpell(item) || Wand.isBrush(item) || Wand.isSP(item);
    }

    public static boolean isBound(ItemStack item) {
        Object wandSection = InventoryUtils.getNode(item, WAND_KEY);
        if (wandSection == null) {
            return false;
        }
        String boundValue = InventoryUtils.getMetaString(wandSection, "bound");
        return boundValue != null && boundValue.equalsIgnoreCase("true");
    }

    public static boolean isSelfDestructWand(ItemStack item) {
        return item != null && WAND_SELF_DESTRUCT_KEY != null && InventoryUtils.hasMeta(item, WAND_SELF_DESTRUCT_KEY);
    }

    public static boolean isSP(ItemStack item) {
        return InventoryUtils.hasMeta(item, "sp");
    }

    public static Integer getSP(ItemStack item) {
        if (InventoryUtils.isEmpty(item)) {
            return null;
        }
        String spNode = InventoryUtils.getMetaString(item, "sp");
        if (spNode == null) {
            return null;
        }
        Integer sp = null;
        try {
            sp = Integer.parseInt(spNode);
        }
        catch (Exception ex) {
            sp = null;
        }
        return sp;
    }

    public static boolean isUpgrade(ItemStack item) {
        return item != null && InventoryUtils.hasMeta(item, UPGRADE_KEY);
    }

    public static boolean isSpell(ItemStack item) {
        return item != null && InventoryUtils.hasMeta(item, "spell");
    }

    public static boolean isSkill(ItemStack item) {
        return item != null && InventoryUtils.hasMeta(item, "skill");
    }

    public static boolean isBrush(ItemStack item) {
        return item != null && InventoryUtils.hasMeta(item, "brush");
    }

    protected static Object getWandOrUpgradeNode(ItemStack item) {
        if (InventoryUtils.isEmpty(item)) {
            return null;
        }
        Object wandNode = InventoryUtils.getNode(item, WAND_KEY);
        if (wandNode == null) {
            wandNode = InventoryUtils.getNode(item, UPGRADE_KEY);
        }
        return wandNode;
    }

    public static String getWandTemplate(ItemStack item) {
        Object wandNode = Wand.getWandOrUpgradeNode(item);
        if (wandNode == null) {
            return null;
        }
        return InventoryUtils.getMetaString(wandNode, "template");
    }

    public static String getWandId(ItemStack item) {
        if (InventoryUtils.isEmpty(item)) {
            return null;
        }
        Object wandNode = InventoryUtils.getNode(item, WAND_KEY);
        if (wandNode == null) {
            return null;
        }
        return InventoryUtils.getMetaString(wandNode, "id");
    }

    public static String getSpell(ItemStack item) {
        if (InventoryUtils.isEmpty(item)) {
            return null;
        }
        Object spellNode = InventoryUtils.getNode(item, "spell");
        if (spellNode == null) {
            return null;
        }
        return InventoryUtils.getMetaString(spellNode, "key");
    }

    public static String getSpellClass(ItemStack item) {
        if (InventoryUtils.isEmpty(item)) {
            return null;
        }
        Object spellNode = InventoryUtils.getNode(item, "spell");
        if (spellNode == null) {
            return null;
        }
        return InventoryUtils.getMetaString(spellNode, "class");
    }

    public static boolean isQuickCastSkill(ItemStack item) {
        if (InventoryUtils.isEmpty(item)) {
            return false;
        }
        Object spellNode = InventoryUtils.getNode(item, "spell");
        if (spellNode == null) {
            return false;
        }
        Boolean quickCast = InventoryUtils.containsNode(spellNode, "quick_cast") ? InventoryUtils.getMetaBoolean(spellNode, "quick_cast") : null;
        return quickCast == null ? true : quickCast;
    }

    public static String getSpellArgs(ItemStack item) {
        if (InventoryUtils.isEmpty(item)) {
            return null;
        }
        Object spellNode = InventoryUtils.getNode(item, "spell");
        if (spellNode == null) {
            return null;
        }
        return InventoryUtils.getMetaString(spellNode, "args");
    }

    public static String getBrush(ItemStack item) {
        if (InventoryUtils.isEmpty(item)) {
            return null;
        }
        Object brushNode = InventoryUtils.getNode(item, "brush");
        if (brushNode == null) {
            return null;
        }
        return InventoryUtils.getMetaString(brushNode, "key");
    }

    protected void updateInventoryName(ItemStack item, boolean activeName) {
        if (Wand.isSpell(item)) {
            MageSpell spell = this.mage.getSpell(Wand.getSpell(item));
            if (spell != null) {
                Wand.updateSpellName(this.controller.getMessages(), item, spell, activeName ? this : null, this.activeBrush);
            }
        } else if (Wand.isBrush(item)) {
            Wand.updateBrushName(this.controller.getMessages(), item, Wand.getBrush(item), activeName ? this : null);
        }
    }

    public static void updateSpellItem(Messages messages, ItemStack itemStack, SpellTemplate spell, String args, Wand wand, String activeMaterial, boolean isItem) {
        Wand.updateSpellItem(messages, itemStack, spell, args, wand == null ? null : wand.getActiveMage(), wand, activeMaterial, isItem);
    }

    public static void updateSpellName(Messages messages, ItemStack itemStack, SpellTemplate spell, Wand wand, String activeMaterial) {
        String displayName = wand != null && !wand.isQuickCast() ? wand.getActiveWandName(spell) : Wand.getSpellDisplayName(messages, spell, com.elmakers.mine.bukkit.block.MaterialBrush.parseMaterialKey(activeMaterial));
        CompatibilityUtils.setDisplayName(itemStack, displayName);
    }

    public static void updateSpellItem(Messages messages, ItemStack itemStack, SpellTemplate spell, String args, com.elmakers.mine.bukkit.api.magic.Mage mage, Wand wand, String activeMaterial, boolean isItem) {
        Wand.updateSpellName(messages, itemStack, spell, wand, activeMaterial);
        ArrayList<String> lore = new ArrayList<String>();
        Wand.addSpellLore(messages, spell, lore, mage, wand);
        if (isItem) {
            ConfigurationUtils.addIfNotEmpty(messages.get("wand.spell_item_description"), lore);
        }
        CompatibilityUtils.setLore(itemStack, lore);
        Object spellNode = CompatibilityUtils.createNode(itemStack, "spell");
        CompatibilityUtils.setMeta(spellNode, "key", spell.getKey());
        CompatibilityUtils.setMeta(spellNode, "args", args);
        if (SpellGlow) {
            CompatibilityUtils.addGlow(itemStack);
        }
    }

    public static void updateBrushName(Messages messages, ItemStack itemStack, String materialKey, Wand wand) {
        Wand.updateBrushName(messages, itemStack, com.elmakers.mine.bukkit.block.MaterialBrush.parseMaterialKey(materialKey), wand);
    }

    public static void updateBrushName(Messages messages, ItemStack itemStack, com.elmakers.mine.bukkit.block.MaterialBrush brush, Wand wand) {
        Spell activeSpell;
        String displayName = wand != null ? ((activeSpell = wand.getActiveSpell()) != null && activeSpell.usesBrush() ? wand.getActiveWandName(brush) : ChatColor.RED + brush.getName(messages)) : brush.getName(messages);
        CompatibilityUtils.setDisplayName(itemStack, displayName);
    }

    public static void updateBrushItem(Messages messages, ItemStack itemStack, String materialKey, Wand wand) {
        Wand.updateBrushItem(messages, itemStack, com.elmakers.mine.bukkit.block.MaterialBrush.parseMaterialKey(materialKey), wand);
    }

    public static void updateBrushItem(Messages messages, ItemStack itemStack, com.elmakers.mine.bukkit.block.MaterialBrush brush, Wand wand) {
        Wand.updateBrushName(messages, itemStack, brush, wand);
        Object brushNode = CompatibilityUtils.createNode(itemStack, "brush");
        CompatibilityUtils.setMeta(brushNode, "key", brush.getKey());
    }

    public void updateHotbar() {
        if (this.mage == null) {
            return;
        }
        if (!this.isInventoryOpen()) {
            return;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return;
        }
        if (!this.hasStoredInventory()) {
            return;
        }
        WandMode wandMode = this.getMode();
        if (wandMode == WandMode.INVENTORY) {
            PlayerInventory inventory = player.getInventory();
            this.updateHotbar(inventory);
            DeprecatedUtils.updateInventory(player);
        }
    }

    private void updateInventory() {
        if (this.mage == null) {
            return;
        }
        if (!this.isInventoryOpen()) {
            return;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return;
        }
        WandMode wandMode = this.getMode();
        if (wandMode == WandMode.INVENTORY) {
            if (!this.hasStoredInventory()) {
                return;
            }
            PlayerInventory inventory = player.getInventory();
            if (!this.updateHotbar(inventory)) {
                for (int i = 0; i < 9; ++i) {
                    if (i == inventory.getHeldItemSlot()) continue;
                    inventory.setItem(i, null);
                }
            }
            this.updateInventory((Inventory)inventory);
            this.updateName();
        } else if (wandMode == WandMode.CHEST || wandMode == WandMode.SKILLS) {
            Inventory inventory = this.getDisplayInventory();
            inventory.clear();
            this.updateInventory(inventory);
        }
    }

    private boolean updateHotbar(PlayerInventory playerInventory) {
        if (this.getMode() != WandMode.INVENTORY) {
            return false;
        }
        Inventory hotbar = this.getHotbar();
        if (hotbar == null) {
            return false;
        }
        ItemStack currentItem = playerInventory.getItem(this.heldSlot);
        if (currentItem == null || !currentItem.getItemMeta().equals(this.item.getItemMeta())) {
            this.controller.getLogger().warning("Trying to update hotbar but the wand has gone missing");
            return false;
        }
        int targetOffset = 0;
        for (int hotbarSlot = 0; hotbarSlot < 8; ++hotbarSlot) {
            if (hotbarSlot == this.heldSlot) {
                targetOffset = 1;
            }
            ItemStack hotbarItem = hotbar.getItem(hotbarSlot);
            this.updateInventoryName(hotbarItem, true);
            playerInventory.setItem(hotbarSlot + targetOffset, hotbarItem);
        }
        return true;
    }

    private void updateInventory(Inventory targetInventory) {
        int currentOffset = this.getHotbarSize() > 0 ? 9 : 0;
        List<Inventory> inventories = this.inventories;
        if (this.openInventoryPage < inventories.size()) {
            Inventory inventory = inventories.get(this.openInventoryPage);
            ItemStack[] contents = inventory.getContents();
            for (int i = 0; i < contents.length; ++i) {
                ItemStack inventoryItem = contents[i];
                this.updateInventoryName(inventoryItem, false);
                targetInventory.setItem(currentOffset, inventoryItem);
                ++currentOffset;
            }
        }
        while (currentOffset < targetInventory.getSize() && currentOffset < 36) {
            targetInventory.setItem(currentOffset, null);
            ++currentOffset;
        }
    }

    protected static void addSpellLore(Messages messages, SpellTemplate spell, List<String> lore, com.elmakers.mine.bukkit.api.magic.Mage mage, Wand wand) {
        spell.addLore(messages, mage, wand, lore);
    }

    protected Inventory getOpenInventory() {
        while (this.openInventoryPage >= this.inventories.size()) {
            this.inventories.add(CompatibilityUtils.createInventory(null, this.getInventorySize(), "Wand"));
        }
        return this.inventories.get(this.openInventoryPage);
    }

    protected Inventory getDisplayInventory() {
        if (this.displayInventory == null || this.displayInventory.getSize() != this.getInventorySize()) {
            this.displayInventory = CompatibilityUtils.createInventory(null, this.getInventorySize(), "Wand");
        }
        return this.displayInventory;
    }

    public void saveChestInventory() {
        if (this.displayInventory == null) {
            return;
        }
        Inventory openInventory = this.getOpenInventory();
        HashMap<String, Integer> previousSlots = new HashMap<String, Integer>();
        HashSet<String> addedBack = new HashSet<String>();
        for (int i = 0; i < this.displayInventory.getSize(); ++i) {
            ItemStack playerItem = this.displayInventory.getItem(i);
            String itemSpellKey = Wand.getSpell(playerItem);
            if (!this.updateSlot(i + this.openInventoryPage * this.getInventorySize(), playerItem)) {
                playerItem = new ItemStack(Material.AIR);
                this.displayInventory.setItem(i, playerItem);
            } else if (itemSpellKey != null) {
                addedBack.add(itemSpellKey);
            }
            ItemStack current = openInventory.getItem(i);
            String spellKey = Wand.getSpell(current);
            if (spellKey != null) {
                previousSlots.put(spellKey, i);
            }
            openInventory.setItem(i, playerItem);
        }
        for (Map.Entry entry : previousSlots.entrySet()) {
            if (addedBack.contains(entry.getKey())) continue;
            ItemStack current = openInventory.getItem(((Integer)entry.getValue()).intValue());
            ItemStack itemStack = Wand.createSpellItem(this.controller.getSpellTemplate((String)entry.getKey()), "", this.controller, this.getActiveMage(), this, false);
            if (current == null || current.getType() == Material.AIR) {
                openInventory.setItem(((Integer)entry.getValue()).intValue(), itemStack);
                continue;
            }
            openInventory.addItem(new ItemStack[]{itemStack});
        }
    }

    public void saveInventory() {
        if (this.mage == null) {
            return;
        }
        if (this.getMode() == WandMode.SKILLS) {
            this.saveChestInventory();
            return;
        }
        if (!this.isInventoryOpen()) {
            return;
        }
        if (this.mage.getPlayer() == null) {
            return;
        }
        if (this.getMode() != WandMode.INVENTORY) {
            return;
        }
        if (!this.hasStoredInventory()) {
            return;
        }
        if (this.mage.isDead()) {
            return;
        }
        Player player = this.mage.getPlayer();
        PlayerInventory playerInventory = player.getInventory();
        Inventory hotbar = this.getHotbar();
        if (hotbar != null) {
            int saveOffset = 0;
            for (int i = 0; i < 9; ++i) {
                ItemStack playerItem = playerInventory.getItem(i);
                if (Wand.isWand(playerItem)) {
                    saveOffset = -1;
                    continue;
                }
                int hotbarOffset = i + saveOffset;
                if (hotbarOffset >= hotbar.getSize()) break;
                if (!this.updateSlot(i + saveOffset + this.currentHotbar * 8, playerItem)) {
                    playerItem = new ItemStack(Material.AIR);
                    playerInventory.setItem(i, playerItem);
                }
                hotbar.setItem(i + saveOffset, playerItem);
            }
        }
        int hotbarOffset = this.getHotbarSize();
        Inventory openInventory = this.getOpenInventory();
        for (int i = 0; i < openInventory.getSize(); ++i) {
            ItemStack playerItem = playerInventory.getItem(i + 9);
            if (!this.updateSlot(i + hotbarOffset + this.openInventoryPage * this.getInventorySize(), playerItem)) {
                playerItem = new ItemStack(Material.AIR);
                playerInventory.setItem(i + 9, playerItem);
            }
            openInventory.setItem(i, playerItem);
        }
    }

    protected boolean updateSlot(int slot, ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return true;
        }
        String spellKey = Wand.getSpell(item);
        if (spellKey != null) {
            SpellKey key = new SpellKey(spellKey);
            this.spellInventory.put(key.getBaseKey(), slot);
        } else {
            String brushKey = Wand.getBrush(item);
            if (brushKey != null) {
                this.brushInventory.put(brushKey, slot);
            } else if (this.mage != null) {
                this.mage.giveItem(item);
                return false;
            }
        }
        return true;
    }

    @Override
    public int enchant(int totalLevels, com.elmakers.mine.bukkit.api.magic.Mage mage, boolean addSpells) {
        return this.randomize(totalLevels, true, mage, addSpells);
    }

    @Override
    public int enchant(int totalLevels, com.elmakers.mine.bukkit.api.magic.Mage mage) {
        return this.randomize(totalLevels, true, mage, true);
    }

    @Override
    public int enchant(int totalLevels) {
        return this.randomize(totalLevels, true, null, true);
    }

    protected int randomize(int totalLevels, boolean additive, com.elmakers.mine.bukkit.api.magic.Mage enchanter, boolean addSpells) {
        if (enchanter == null && this.mage != null) {
            enchanter = this.mage;
        }
        if (this.maxEnchantCount > 0 && this.enchantCount >= this.maxEnchantCount) {
            if (enchanter != null && addSpells) {
                enchanter.sendMessage(this.getMessage("max_enchanted").replace("$wand", this.getName()));
            }
            return 0;
        }
        WandUpgradePath path = this.getPath();
        if (path == null) {
            if (enchanter != null && addSpells) {
                enchanter.sendMessage(this.getMessage("no_path").replace("$wand", this.getName()));
            }
            return 0;
        }
        int minLevel = path.getMinLevel();
        if (totalLevels < minLevel) {
            if (enchanter != null && addSpells) {
                String levelMessage = this.getMessage("need_more_levels");
                levelMessage = levelMessage.replace("$levels", Integer.toString(minLevel));
                enchanter.sendMessage(levelMessage);
            }
            return 0;
        }
        int maxLevel = path.getMaxLevel();
        totalLevels = Math.min(totalLevels, maxLevel * 50);
        int addLevels = Math.min(totalLevels, maxLevel);
        int levels = 0;
        boolean modified = true;
        while (addLevels >= minLevel && modified) {
            WandUpgradePath nextPath;
            boolean hasUpgrade = path.hasUpgrade();
            WandLevel level = path.getLevel(addLevels);
            if (!path.canEnchant(this) && (path.hasSpells() || path.hasMaterials())) {
                nextPath = path.getUpgrade();
                if (nextPath != null) {
                    if (!path.checkUpgradeRequirements(this, addSpells ? enchanter : null)) break;
                    path.upgrade(this, enchanter);
                    break;
                }
                if (enchanter == null || !addSpells) break;
                enchanter.sendMessage(this.getMessage("fully_enchanted").replace("$wand", this.getName()));
                break;
            }
            modified = level.randomizeWand(enchanter, this, additive, hasUpgrade, addSpells);
            totalLevels -= maxLevel;
            if (modified) {
                if (enchanter != null) {
                    path.enchanted(enchanter);
                }
                levels += addLevels;
                nextPath = path.getUpgrade();
                if (nextPath != null && path.checkUpgradeRequirements(this, null) && !path.canEnchant(this)) {
                    path.upgrade(this, enchanter);
                    path = nextPath;
                }
            } else if (path.canEnchant(this)) {
                if (enchanter != null && levels == 0 && addSpells) {
                    String message = this.getMessage("require_more_levels");
                    enchanter.sendMessage(message);
                }
            } else if (hasUpgrade) {
                if (path.checkUpgradeRequirements(this, addSpells ? enchanter : null)) {
                    path.upgrade(this, enchanter);
                    levels += addLevels;
                }
            } else if (enchanter != null && addSpells) {
                enchanter.sendMessage(this.getMessage("fully_enchanted").replace("$wand", this.getName()));
            }
            addLevels = Math.min(totalLevels, maxLevel);
            additive = true;
        }
        if (levels > 0) {
            ++this.enchantCount;
            this.setProperty("enchant_count", this.enchantCount);
        }
        this.saveState();
        this.updateName();
        this.updateLore();
        return levels;
    }

    public static ItemStack createItem(MagicController controller, String templateName) {
        Wand wand;
        ItemStack item = Wand.createSpellItem(templateName, controller, null, true);
        if (item == null && (item = Wand.createBrushItem(templateName, controller, null, true)) == null && (wand = Wand.createWand(controller, templateName)) != null) {
            item = wand.getItem();
        }
        return item;
    }

    public static Wand createWand(MagicController controller, String templateName) {
        if (controller == null) {
            return null;
        }
        Wand wand = null;
        try {
            wand = new Wand(controller, templateName);
        }
        catch (UnknownWandException unknownWandException) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return wand;
    }

    public static Wand createWand(MagicController controller, ItemStack itemStack) {
        if (controller == null) {
            return null;
        }
        Wand wand = null;
        try {
            wand = controller.getWand(InventoryUtils.makeReal(itemStack));
            wand.saveState();
            wand.updateName();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return wand;
    }

    public boolean add(Wand other) {
        return this.add(other, (com.elmakers.mine.bukkit.api.magic.Mage)this.mage);
    }

    @Override
    public boolean add(com.elmakers.mine.bukkit.api.wand.Wand other, com.elmakers.mine.bukkit.api.magic.Mage mage) {
        if (other instanceof Wand) {
            return this.add((Wand)other, mage);
        }
        return false;
    }

    public boolean add(Wand other, com.elmakers.mine.bukkit.api.magic.Mage mage) {
        if (!(this.isModifiable() || other.isUpgrade() && other.path != null && this.path != null && !other.path.isEmpty() && !this.path.isEmpty() && other.path.equals(this.path))) {
            return false;
        }
        if (this.hasUses || other.hasUses) {
            return false;
        }
        if (this.isHeroes || other.isHeroes) {
            return false;
        }
        ConfigurationSection templateConfig = this.controller.getWandTemplateConfiguration(other.getTemplateKey());
        if (other.isForcedUpgrade()) {
            if (templateConfig == null) {
                return false;
            }
            templateConfig = ConfigurationUtils.cloneConfiguration(templateConfig);
            templateConfig.set("name", (Object)templateConfig.getString("upgrade_name"));
            templateConfig.set("description", (Object)templateConfig.getString("upgrade_description"));
            templateConfig.set("force", null);
            templateConfig.set("upgrade", null);
            templateConfig.set("icon", (Object)templateConfig.getString("upgrade_icon"));
            templateConfig.set("indestructible", null);
            templateConfig.set("upgrade_icon", null);
            this.configure(templateConfig);
            return true;
        }
        if (!(!other.isUpgrade() || other.path == null || other.path.isEmpty() || this.path != null && this.path.equals(other.path))) {
            return false;
        }
        ConfigurationSection upgradeConfig = ConfigurationUtils.cloneConfiguration(other.getEffectiveConfiguration());
        upgradeConfig.set("id", null);
        upgradeConfig.set("indestructible", null);
        upgradeConfig.set("upgrade", null);
        upgradeConfig.set("icon", other.upgradeIcon == null ? null : other.upgradeIcon.getKey());
        upgradeConfig.set("upgrade_icon", null);
        upgradeConfig.set("template", (Object)other.upgradeTemplate);
        Messages messages = this.controller.getMessages();
        if (other.rename && templateConfig != null) {
            String newName = messages.get("wands." + other.template + ".name");
            newName = templateConfig.getString("name", newName);
            upgradeConfig.set("name", (Object)newName);
        } else {
            upgradeConfig.set("name", null);
        }
        if (other.renameDescription && templateConfig != null) {
            String newDescription = messages.get("wands." + other.template + ".description");
            newDescription = templateConfig.getString("description", newDescription);
            upgradeConfig.set("description", (Object)newDescription);
        } else {
            upgradeConfig.set("description", null);
        }
        return this.upgrade(upgradeConfig);
    }

    public boolean isForcedUpgrade() {
        return this.isUpgrade && this.forceUpgrade;
    }

    public boolean keepOnDeath() {
        return this.keep;
    }

    public static WandMode parseWandMode(String modeString, WandMode defaultValue) {
        if (modeString != null && !modeString.isEmpty()) {
            try {
                defaultValue = WandMode.valueOf(modeString.toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static WandAction parseWandAction(String actionString, WandAction defaultValue) {
        if (actionString != null && !actionString.isEmpty()) {
            try {
                defaultValue = WandAction.valueOf(actionString.toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private void updateActiveMaterial() {
        if (this.mage == null) {
            return;
        }
        if (this.activeBrush == null) {
            this.mage.clearBuildingMaterial();
        } else {
            MaterialBrush brush = this.mage.getBrush();
            brush.update(this.activeBrush);
        }
    }

    public void cycleActive(int direction) {
        Player player;
        Player player2 = player = this.mage != null ? this.mage.getPlayer() : null;
        if (player != null && player.isSneaking()) {
            Spell activeSpell = this.getActiveSpell();
            boolean cycleMaterials = false;
            if (activeSpell != null) {
                cycleMaterials = activeSpell.usesBrushSelection();
            }
            if (cycleMaterials) {
                this.cycleMaterials(direction);
            } else {
                this.cycleSpells(direction);
            }
        } else {
            this.cycleSpells(direction);
        }
    }

    public void toggleInventory() {
        MageSpell brushSelect;
        if (this.mage != null && this.mage.cancelSelection()) {
            this.mage.playSoundEffect(noActionSound);
            return;
        }
        Player player = this.mage == null ? null : this.mage.getPlayer();
        boolean isSneaking = player != null && player.isSneaking();
        Spell currentSpell = this.getActiveSpell();
        if (this.getBrushMode() == WandMode.CHEST && brushSelectSpell != null && !brushSelectSpell.isEmpty() && isSneaking && currentSpell != null && currentSpell.usesBrushSelection() && (brushSelect = this.mage.getSpell(brushSelectSpell)) != null) {
            brushSelect.cast();
            return;
        }
        if (!this.hasInventory) {
            if (this.activeSpell == null || this.activeSpell.length() == 0) {
                this.updateHasInventory();
                if (this.spells.size() > 0) {
                    this.setActiveSpell(this.spells.iterator().next());
                }
            }
            this.updateName();
            return;
        }
        if (!this.isInventoryOpen()) {
            this.openInventory();
        } else {
            this.closeInventory();
        }
    }

    public void updateHasInventory() {
        int inventorySize = this.getSpells().size() + this.getBrushes().size();
        this.hasInventory = inventorySize > 1 || inventorySize == 1 && this.hasSpellProgression;
    }

    public void cycleInventory(int direction) {
        if (!this.hasInventory) {
            return;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
            int inventoryCount = this.inventories.size();
            this.setOpenInventoryPage(inventoryCount == 0 ? 0 : (this.openInventoryPage + inventoryCount + direction) % inventoryCount);
            this.updateInventory();
            if (this.mage != null && this.inventories.size() > 1) {
                if (!this.playPassiveEffects("cycle") && inventoryCycleSound != null) {
                    this.mage.playSoundEffect(inventoryCycleSound);
                }
                DeprecatedUtils.updateInventory(this.mage.getPlayer());
            }
        }
    }

    @Override
    public void cycleHotbar() {
        this.cycleHotbar(1);
    }

    public void cycleHotbar(int direction) {
        if (!this.hasInventory || this.getMode() != WandMode.INVENTORY) {
            return;
        }
        if (this.isInventoryOpen() && this.mage != null && this.hotbars.size() > 1) {
            this.saveInventory();
            int hotbarCount = this.hotbars.size();
            this.setCurrentHotbar(hotbarCount == 0 ? 0 : (this.currentHotbar + hotbarCount + direction) % hotbarCount);
            this.updateHotbar();
            if (!this.playPassiveEffects("cycle") && inventoryCycleSound != null) {
                this.mage.playSoundEffect(inventoryCycleSound);
            }
            this.sendMessage("hotbar_changed");
            this.updateHotbarStatus();
            DeprecatedUtils.updateInventory(this.mage.getPlayer());
        }
    }

    public void cycleInventory() {
        this.cycleInventory(1);
    }

    public void openInventory() {
        if (this.mage == null) {
            return;
        }
        if (System.currentTimeMillis() < this.mage.getWandDisableTime()) {
            return;
        }
        WandMode wandMode = this.getMode();
        if (wandMode == WandMode.CHEST || wandMode == WandMode.SKILLS) {
            this.inventoryIsOpen = true;
            if (!this.playPassiveEffects("open") && inventoryOpenSound != null) {
                this.mage.playSoundEffect(inventoryOpenSound);
            }
            this.updateInventory();
            this.mage.getPlayer().openInventory(this.getDisplayInventory());
        } else if (wandMode == WandMode.INVENTORY) {
            if (this.hasStoredInventory()) {
                return;
            }
            if (this.storeInventory()) {
                this.inventoryIsOpen = true;
                this.showActiveIcon(true);
                if (!this.playPassiveEffects("open") && inventoryOpenSound != null) {
                    this.mage.playSoundEffect(inventoryOpenSound);
                }
                this.updateInventory();
                this.updateHotbarStatus();
            }
        }
    }

    @Override
    public void closeInventory() {
        if (!this.isInventoryOpen()) {
            return;
        }
        this.controller.disableItemSpawn();
        this.inventoryWasOpen = true;
        WandMode mode = this.getMode();
        try {
            this.saveInventory();
            this.updateSpellInventory();
            this.updateBrushInventory();
            this.inventoryIsOpen = false;
            if (this.mage != null) {
                if (!this.playPassiveEffects("close") && inventoryCloseSound != null) {
                    this.mage.playSoundEffect(inventoryCloseSound);
                }
                if (mode == WandMode.INVENTORY) {
                    this.restoreInventory();
                    this.showActiveIcon(false);
                } else {
                    this.mage.getPlayer().closeInventory();
                }
                PlayerInventory inventory = this.mage.getPlayer().getInventory();
                ItemStack testItem = inventory.getHelmet();
                if (Wand.isSpell(testItem) || Wand.isBrush(testItem)) {
                    inventory.setHelmet(new ItemStack(Material.AIR));
                    DeprecatedUtils.updateInventory(this.mage.getPlayer());
                }
                if (Wand.isSpell(testItem = inventory.getBoots()) || Wand.isBrush(testItem)) {
                    inventory.setBoots(new ItemStack(Material.AIR));
                    DeprecatedUtils.updateInventory(this.mage.getPlayer());
                }
                if (Wand.isSpell(testItem = inventory.getLeggings()) || Wand.isBrush(testItem)) {
                    inventory.setLeggings(new ItemStack(Material.AIR));
                    DeprecatedUtils.updateInventory(this.mage.getPlayer());
                }
                if (Wand.isSpell(testItem = inventory.getChestplate()) || Wand.isBrush(testItem)) {
                    inventory.setChestplate(new ItemStack(Material.AIR));
                    DeprecatedUtils.updateInventory(this.mage.getPlayer());
                }
                if (Wand.isSpell(testItem = inventory.getItemInOffHand()) && !Wand.isSkill(testItem) || Wand.isBrush(testItem)) {
                    inventory.setItemInOffHand(new ItemStack(Material.AIR));
                    DeprecatedUtils.updateInventory(this.mage.getPlayer());
                }
            }
        }
        catch (Throwable ex) {
            this.restoreInventory();
        }
        if (mode == WandMode.INVENTORY && this.mage != null) {
            try {
                this.mage.getPlayer().closeInventory();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        this.controller.enableItemSpawn();
        this.inventoryWasOpen = false;
    }

    @Override
    public boolean fill(Player player) {
        return this.fill(player, 0);
    }

    @Override
    public boolean fill(Player player, int maxLevel) {
        this.closeInventory();
        ArrayList currentSpells = new ArrayList(this.getSpells());
        for (String spellKey : currentSpells) {
            SpellTemplate spell = this.controller.getSpellTemplate(spellKey);
            if (spell.hasCastPermission((CommandSender)player)) continue;
            this.removeSpell(spellKey);
        }
        Collection<SpellTemplate> allSpells = this.controller.getPlugin().getSpellTemplates();
        Mage mage = this.mage;
        this.mage = null;
        for (SpellTemplate spell : allSpells) {
            String key = spell.getKey();
            if (maxLevel > 0 && spell.getSpellKey().getLevel() > maxLevel || key.startsWith("heroes*") || !spell.hasCastPermission((CommandSender)player) || !spell.hasIcon() || spell.isHidden()) continue;
            this.addSpell(key);
        }
        this.mage = mage;
        if (this.autoFill) {
            this.setProperty("fill", false);
        }
        this.autoFill = false;
        this.updateSpells();
        this.saveState();
        return true;
    }

    protected void randomize() {
        ConfigurationSection wandConfig;
        if (this.template != null && this.template.length() > 0 && (wandConfig = this.controller.getWandTemplateConfiguration(this.template)) != null && wandConfig.contains("icon")) {
            String iconKey = wandConfig.getString("icon");
            if (iconKey.contains(",")) {
                Random r = new Random();
                String[] keys = StringUtils.split((String)iconKey, (char)',');
                iconKey = keys[r.nextInt(keys.length)];
            }
            this.setIcon(ConfigurationUtils.toMaterialAndData(iconKey));
            this.updateIcon();
            this.playEffects("randomize");
        }
    }

    protected void checkActiveMaterial() {
        Collection materials;
        if ((this.activeBrush == null || this.activeBrush.length() == 0) && (materials = this.getBrushes()).size() > 0) {
            this.activeBrush = (String)materials.iterator().next();
        }
    }

    @Override
    public boolean addItem(ItemStack item) {
        Integer sp;
        if (this.isUpgrade) {
            return false;
        }
        if (this.isModifiable() && Wand.isSpell(item) && !Wand.isSkill(item)) {
            String spell = Wand.getSpell(item);
            SpellKey spellKey = new SpellKey(spell);
            Integer currentLevel = this.spellLevels.get(spellKey.getBaseKey());
            if ((currentLevel == null || currentLevel < spellKey.getLevel()) && this.addSpell(spell)) {
                return true;
            }
        } else if (this.isModifiable() && Wand.isBrush(item)) {
            String materialKey = Wand.getBrush(item);
            Collection materials = this.getBrushes();
            if (!materials.contains(materialKey) && this.addBrush(materialKey)) {
                return true;
            }
        } else if (Wand.isUpgrade(item)) {
            Wand wand = this.controller.getWand(item);
            return this.add(wand);
        }
        if (this.mage != null && !this.mage.isAtMaxSkillPoints() && this.controller.skillPointItemsEnabled() && (sp = Wand.getSP(item)) != null) {
            int amount = (int)Math.floor(this.mage.getSPMultiplier() * (float)sp.intValue() * (float)item.getAmount());
            this.mage.addSkillPoints(amount);
            return true;
        }
        return false;
    }

    protected void updateEffects() {
        this.updateEffects(this.mage);
    }

    public void updateEffects(Mage mage) {
        double speedSquared;
        Vector velocity;
        double velocitySquared;
        boolean velocityCheck;
        boolean playEffects;
        if (mage == null) {
            return;
        }
        Player player = mage.getPlayer();
        if (player == null) {
            return;
        }
        if (this.effectBubbles && this.effectColor != null) {
            Location potionEffectLocation = player.getLocation();
            potionEffectLocation.setX(potionEffectLocation.getX() + random.nextDouble() - 0.5);
            potionEffectLocation.setY(potionEffectLocation.getY() + random.nextDouble() * player.getEyeHeight());
            potionEffectLocation.setZ(potionEffectLocation.getZ() + random.nextDouble() - 0.5);
            ParticleEffect.SPELL_MOB.display(potionEffectLocation, this.effectColor.getColor(), 24.0);
        }
        Location location = mage.getLocation();
        long now = System.currentTimeMillis();
        boolean bl = playEffects = !this.activeEffectsOnly || this.inventoryIsOpen || this.isInOffhand;
        if (playEffects && this.effectParticle != null && this.effectParticleInterval > 0 && this.effectParticleCount > 0) {
            velocityCheck = true;
            if (this.effectParticleMinVelocity > 0.0) {
                velocitySquared = this.effectParticleMinVelocity * this.effectParticleMinVelocity;
                velocity = mage.getVelocity().clone();
                velocity.setY(0);
                speedSquared = velocity.lengthSquared();
                boolean bl2 = velocityCheck = speedSquared > velocitySquared;
            }
            if (velocityCheck && (this.lastParticleEffect == 0L || now > this.lastParticleEffect + (long)this.effectParticleInterval)) {
                this.lastParticleEffect = now;
                Location effectLocation = player.getLocation();
                Location eyeLocation = player.getEyeLocation();
                effectLocation.setY(eyeLocation.getY() + this.effectParticleOffset);
                if (this.effectPlayer == null) {
                    this.effectPlayer = new EffectRing((Plugin)this.controller.getPlugin());
                    this.effectPlayer.setParticleCount(1);
                    this.effectPlayer.setIterations(1);
                    this.effectPlayer.setParticleOffset(0.0f, 0.0f, 0.0f);
                }
                this.effectPlayer.setMaterial(location.getBlock().getRelative(BlockFace.DOWN));
                if (this.effectParticleData == 0.0f) {
                    this.effectPlayer.setColor(this.getEffectColor());
                } else {
                    this.effectPlayer.setColor(null);
                }
                this.effectPlayer.setParticleType(this.effectParticle);
                this.effectPlayer.setParticleData(this.effectParticleData);
                this.effectPlayer.setSize(this.effectParticleCount);
                this.effectPlayer.setRadius((float)this.effectParticleRadius);
                this.effectPlayer.start(effectLocation, null);
            }
        }
        if (this.castSpell != null && this.castInterval > 0 && (this.lastSpellCast == 0L || now > this.lastSpellCast + (long)this.castInterval)) {
            velocityCheck = true;
            if (this.castMinVelocity > 0.0) {
                velocitySquared = this.castMinVelocity * this.castMinVelocity;
                velocity = mage.getVelocity();
                if (this.castVelocityDirection != null) {
                    velocity = velocity.clone().multiply(this.castVelocityDirection);
                    if (this.castVelocityDirection.getY() < 0.0) {
                        velocityCheck = velocity.getY() < 0.0;
                    } else {
                        boolean bl3 = velocityCheck = velocity.getY() > 0.0;
                    }
                }
                if (velocityCheck) {
                    speedSquared = velocity.lengthSquared();
                    boolean bl4 = velocityCheck = speedSquared > velocitySquared;
                }
            }
            if (velocityCheck) {
                this.lastSpellCast = now;
                MageSpell spell = mage.getSpell(this.castSpell);
                if (spell != null) {
                    if (this.castParameters == null) {
                        this.castParameters = new MemoryConfiguration();
                    }
                    this.castParameters.set("passive", (Object)true);
                    mage.setCostFree(true);
                    mage.setQuiet(true);
                    try {
                        spell.cast(this.castParameters);
                    }
                    catch (Exception ex) {
                        this.controller.getLogger().log(Level.WARNING, "Error casting aura spell " + spell.getKey(), ex);
                    }
                    mage.setCostFree(false);
                    mage.setQuiet(false);
                }
            }
        }
        if (playEffects && this.effectSound != null && this.controller.soundsEnabled() && this.effectSoundInterval > 0 && (this.lastSoundEffect == 0L || now > this.lastSoundEffect + (long)this.effectSoundInterval)) {
            this.lastSoundEffect = now;
            this.effectSound.play((Plugin)this.controller.getPlugin(), (Entity)mage.getPlayer());
        }
    }

    protected void updateDurability() {
        short maxDurability = this.item.getType().getMaxDurability();
        if (maxDurability > 0 && this.effectiveManaMax > 0) {
            int durability = (int)(this.getMana() * (float)maxDurability / (float)this.effectiveManaMax);
            if ((durability = maxDurability - durability) >= maxDurability) {
                durability = maxDurability - 1;
            } else if (durability < 0) {
                durability = 0;
            }
            this.item.setDurability((short)durability);
        }
    }

    public boolean usesXPBar() {
        return this.usesSP() && spMode.useXP() || this.usesMana() && manaMode.useXP();
    }

    public boolean usesXPNumber() {
        return this.usesSP() && spMode.useXPNumber() && this.controller.isSPEnabled() || this.usesMana() && manaMode.useXP();
    }

    public boolean hasSpellProgression() {
        return this.hasSpellProgression;
    }

    public boolean usesXPDisplay() {
        return this.usesXPBar() || this.usesXPNumber();
    }

    @Override
    public void updateMana() {
        Player player;
        Player player2 = player = this.mage == null ? null : this.mage.getPlayer();
        if (player == null) {
            return;
        }
        float mana = this.getMana();
        if (this.usesMana()) {
            if (manaMode.useGlow()) {
                if (mana == (float)this.effectiveManaMax) {
                    CompatibilityUtils.addGlow(this.item);
                } else {
                    CompatibilityUtils.removeGlow(this.item);
                }
            }
            if (manaMode.useDurability()) {
                this.updateDurability();
            }
        }
        if (this.usesXPDisplay()) {
            int playerLevel = player.getLevel();
            float playerProgress = player.getExp();
            if (this.usesMana() && manaMode.useXPNumber()) {
                playerLevel = (int)mana;
            }
            if (this.usesMana() && manaMode.useXPBar()) {
                playerProgress = Math.max(0.0f, mana / (float)this.effectiveManaMax);
            }
            if (this.usesSP() && spMode.useXPNumber()) {
                playerLevel = this.mage.getSkillPoints();
            }
            this.mage.sendExperience(playerProgress, playerLevel);
        }
    }

    @Override
    public boolean isInventoryOpen() {
        return this.mage != null && this.inventoryIsOpen;
    }

    public boolean wasInventoryOpen() {
        return this.inventoryWasOpen;
    }

    @Override
    public void unbind() {
        if (!this.bound) {
            return;
        }
        Mage owningMage = this.mage;
        this.deactivate();
        if (this.ownerId != null) {
            if (owningMage == null || !owningMage.getId().equals(this.ownerId)) {
                owningMage = this.controller.getRegisteredMage(this.ownerId);
            }
            if (owningMage != null) {
                owningMage.unbind(this);
            }
            this.ownerId = null;
        }
        this.bound = false;
        this.owner = null;
        this.setProperty("bound", false);
        this.setProperty("owner", null);
        this.setProperty("owner_id", null);
        this.saveState();
        this.updateLore();
        this.updateName();
    }

    @Override
    public void bind() {
        if (this.bound) {
            return;
        }
        Mage holdingMage = this.mage;
        this.deactivate();
        this.bound = true;
        this.setProperty("bound", true);
        this.saveState();
        if (holdingMage != null) {
            holdingMage.checkWand();
        }
    }

    @Override
    public void deactivate() {
        if (this.mage == null) {
            return;
        }
        this.playPassiveEffects("deactivate");
        Mage mage = this.mage;
        if (this.isInventoryOpen()) {
            this.closeInventory();
        }
        this.showActiveIcon(false);
        this.storedInventory = null;
        if (this.usesXPNumber() || this.usesXPBar()) {
            mage.resetSentExperience();
        }
        this.saveState();
        mage.deactivateWand(this);
        this.mage = null;
        this.updateMaxMana(true);
    }

    @Override
    public Spell getActiveSpell() {
        if (this.mage == null) {
            return null;
        }
        String activeSpellKey = this.getActiveSpellKey();
        if (activeSpellKey == null || activeSpellKey.length() == 0) {
            return null;
        }
        return this.mage.getSpell(activeSpellKey);
    }

    public Spell getAlternateSpell() {
        if (this.mage == null || this.alternateSpell == null || this.alternateSpell.length() == 0) {
            return null;
        }
        return this.mage.getSpell(this.alternateSpell);
    }

    public Spell getAlternateSpell2() {
        if (this.mage == null || this.alternateSpell2 == null || this.alternateSpell2.length() == 0) {
            return null;
        }
        return this.mage.getSpell(this.alternateSpell2);
    }

    @Override
    public SpellTemplate getBaseSpell(String spellName) {
        return this.getBaseSpell(new SpellKey(spellName));
    }

    public SpellTemplate getBaseSpell(SpellKey key) {
        if (!this.spells.contains(key.getBaseKey())) {
            return null;
        }
        SpellKey baseKey = new SpellKey(key.getBaseKey(), this.getSpellLevel(key.getBaseKey()));
        return this.controller.getSpellTemplate(baseKey.getKey());
    }

    @Override
    public String getActiveSpellKey() {
        String activeSpellKey = this.activeSpell;
        Integer level = this.spellLevels.get(activeSpellKey);
        if (level != null) {
            activeSpellKey = new SpellKey(activeSpellKey, level).getKey();
        }
        return activeSpellKey;
    }

    @Override
    public String getActiveBrushKey() {
        return this.activeBrush;
    }

    @Override
    public void damageDealt(double damage, Entity target) {
        if (this.manaPerDamage > 0.0f) {
            int manaMax = this.getEffectiveManaMax();
            float mana = this.getMana();
            if (manaMax > 0 && mana < (float)manaMax) {
                this.setMana(Math.min((float)manaMax, mana + (float)damage * this.manaPerDamage));
                this.updateMana();
            }
        }
    }

    @Override
    public boolean cast() {
        return this.cast(this.getActiveSpell());
    }

    public boolean alternateCast() {
        return this.cast(this.getAlternateSpell());
    }

    public boolean alternateCast2() {
        return this.cast(this.getAlternateSpell2());
    }

    public boolean cast(Spell spell) {
        if (spell != null) {
            ArrayList<String> castParameters = null;
            if (this.castOverrides != null && this.castOverrides.size() > 0) {
                castParameters = new ArrayList<String>();
                for (Map.Entry<String, String> entry : this.castOverrides.entrySet()) {
                    String[] key = StringUtils.split((String)entry.getKey(), (char)'.');
                    if (key.length == 0 || key.length == 2 && !key[0].equals("default") && !key[0].equals(spell.getSpellKey().getBaseKey()) && !key[0].equals(spell.getSpellKey().getKey())) continue;
                    castParameters.add(key.length == 2 ? key[1] : key[0]);
                    castParameters.add(entry.getValue());
                }
            }
            if (spell.cast(castParameters == null ? null : castParameters.toArray(EMPTY_PARAMETERS))) {
                Color spellColor = spell.getColor();
                this.use();
                if (spellColor != null && this.effectColor != null) {
                    this.effectColor = this.effectColor.mixColor(spellColor, (double)this.effectColorSpellMixWeight);
                    this.setProperty("effect_color", this.effectColor.toString());
                }
                this.updateHotbarStatus();
                return true;
            }
        }
        return false;
    }

    protected void use() {
        if (this.hasUses) {
            this.findItem();
            ItemStack item = this.getItem();
            if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
            } else {
                if (this.uses > 0) {
                    --this.uses;
                }
                if (this.uses <= 0 && this.mage != null) {
                    Player player = this.mage.getPlayer();
                    this.deactivate();
                    PlayerInventory playerInventory = player.getInventory();
                    if (item.getAmount() > 1) {
                        item.setAmount(item.getAmount() - 1);
                    } else if (this.isInOffhand) {
                        playerInventory.setItemInOffHand(new ItemStack(Material.AIR, 1));
                    } else {
                        playerInventory.setItemInMainHand(new ItemStack(Material.AIR, 1));
                    }
                    DeprecatedUtils.updateInventory(player);
                }
                this.setProperty("uses", this.uses);
                this.saveState();
                this.updateName();
                this.updateLore();
            }
        }
    }

    public static int getExpToLevel(int expLevel) {
        return expLevel >= 30 ? 112 + (expLevel - 30) * 9 : (expLevel >= 15 ? 37 + (expLevel - 15) * 5 : 7 + expLevel * 2);
    }

    public static int getExperience(int expLevel, float expProgress) {
        int xp = 0;
        for (int level = 0; level < expLevel; ++level) {
            xp += Wand.getExpToLevel(level);
        }
        return xp + (int)(expProgress * (float)Wand.getExpToLevel(expLevel));
    }

    protected void updateHotbarStatus() {
        Player player;
        Player player2 = player = this.mage == null ? null : this.mage.getPlayer();
        if (player != null && LiveHotbar && this.getMode() == WandMode.INVENTORY && this.isInventoryOpen()) {
            this.mage.updateHotbarStatus();
        }
    }

    @Override
    public boolean tickMana() {
        if (this.isHeroes) {
            HeroesManager heroes = this.controller.getHeroes();
            if (heroes != null && this.mage != null && this.mage.isPlayer()) {
                Player player = this.mage.getPlayer();
                this.effectiveManaMax = heroes.getMaxMana(player);
                this.effectiveManaRegeneration = heroes.getManaRegen(player);
                this.setManaMax(this.effectiveManaMax);
                this.setManaRegeneration(this.effectiveManaRegeneration);
                this.setMana(heroes.getMana(player));
                return true;
            }
            return false;
        }
        return super.tickMana();
    }

    @Override
    public void tick() {
        if (this.mage == null) {
            return;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return;
        }
        super.tick();
        if (this.usesMana() && !this.isInOffhand) {
            this.updateMana();
        }
        if (player.isBlocking() && this.blockMageCooldown > 0) {
            this.mage.setRemainingCooldown(this.blockMageCooldown);
        }
        if (!this.isInOffhand) {
            this.updateHotbarStatus();
        }
        if (!this.passive) {
            this.updateEffects();
        }
    }

    @Override
    public void armorUpdated() {
        this.updateMaxMana(true);
    }

    protected void updateMaxMana(boolean updateLore) {
        if (this.isHeroes) {
            return;
        }
        if (!this.hasOwnMana() && this.mageClass != null) {
            if (this.mageClass.updateMaxMana(this.mage) && updateLore) {
                this.updateLore();
            }
            this.effectiveManaMax = this.mageClass.getEffectiveManaMax();
            this.effectiveManaRegeneration = this.mageClass.getEffectiveManaRegeneration();
        } else if (super.updateMaxMana(this.mage) && updateLore) {
            this.updateLore();
        }
    }

    public void cycleSpells(int direction) {
        ArrayList<String> spells = new ArrayList<String>(this.spells);
        if (spells.size() == 0) {
            return;
        }
        if (this.activeSpell == null) {
            this.setActiveSpell(spells.get(0));
            return;
        }
        int spellIndex = 0;
        for (int i = 0; i < spells.size(); ++i) {
            if (!spells.get(i).equals(this.activeSpell)) continue;
            spellIndex = i;
            break;
        }
        spellIndex = (spellIndex + direction) % spells.size();
        this.setActiveSpell(spells.get(spellIndex));
    }

    public void cycleMaterials(int direction) {
        Collection materialsSet = this.getBrushes();
        ArrayList materials = new ArrayList(materialsSet);
        if (materials.size() == 0) {
            return;
        }
        if (this.activeBrush == null) {
            this.setActiveBrush(StringUtils.split((String)((String)materials.get(0)), (char)'@')[0]);
            return;
        }
        int materialIndex = 0;
        for (int i = 0; i < materials.size(); ++i) {
            if (!StringUtils.split((String)((String)materials.get(i)), (char)'@')[0].equals(this.activeBrush)) continue;
            materialIndex = i;
            break;
        }
        materialIndex = (materialIndex + direction) % materials.size();
        this.setActiveBrush(StringUtils.split((String)((String)materials.get(materialIndex)), (char)'@')[0]);
    }

    public Mage getActiveMage() {
        return this.mage;
    }

    public void setActiveMage(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        if (mage instanceof Mage) {
            this.mage = (Mage)mage;
            this.armorUpdated();
        }
    }

    @Override
    public Color getEffectColor() {
        return this.effectColor == null ? null : this.effectColor.getColor();
    }

    public ParticleEffect getEffectParticle() {
        return this.effectParticle;
    }

    @Override
    public String getEffectParticleName() {
        return this.effectParticle == null ? null : this.effectParticle.name();
    }

    public Inventory getHotbar() {
        if (this.hotbars.size() == 0) {
            return null;
        }
        if (this.currentHotbar < 0 || this.currentHotbar >= this.hotbars.size()) {
            this.setCurrentHotbar(this.currentHotbar);
        }
        return this.hotbars.get(this.currentHotbar);
    }

    public int getHotbarCount() {
        if (this.getMode() != WandMode.INVENTORY) {
            return 0;
        }
        return this.hotbars.size();
    }

    public List<Inventory> getHotbars() {
        return this.hotbars;
    }

    @Override
    public boolean isQuickCastDisabled() {
        return this.quickCastDisabled;
    }

    public boolean isManualQuickCastDisabled() {
        return this.manualQuickCastDisabled;
    }

    @Override
    public boolean isQuickCast() {
        return this.quickCast;
    }

    public WandMode getMode() {
        return this.mode;
    }

    public WandMode getBrushMode() {
        return this.brushMode;
    }

    public void setMode(WandMode mode) {
        this.mode = mode;
    }

    public void setBrushMode(WandMode mode) {
        this.brushMode = mode;
    }

    @Override
    public boolean showCastMessages() {
        return this.quietLevel == 0;
    }

    @Override
    public boolean showMessages() {
        return this.quietLevel < 2;
    }

    public boolean isStealth() {
        return this.quietLevel > 2;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
        this.setProperty("path", path);
    }

    @Override
    public boolean isLost(com.elmakers.mine.bukkit.api.wand.LostWand lostWand) {
        return this.id != null && this.id.equals(lostWand.getId());
    }

    @Override
    public LostWand makeLost(Location location) {
        this.checkId();
        this.saveState();
        return new LostWand(this, location);
    }

    @Override
    @Deprecated
    public void activate(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        if (mage instanceof Mage) {
            this.activate((Mage)mage);
        }
    }

    protected void showActiveIcon(boolean show) {
        if (this.icon == null || this.inactiveIcon == null || this.inactiveIcon.getMaterial() == Material.AIR || this.inactiveIcon.getMaterial() == null) {
            return;
        }
        if (this.icon.getMaterial() == Material.AIR || this.icon.getMaterial() == null) {
            this.icon.setMaterial(DefaultWandMaterial);
        }
        if (show) {
            if (this.inactiveIconDelay > 0) {
                MagicPlugin plugin = this.controller.getPlugin();
                plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

                    @Override
                    public void run() {
                        Wand.this.findItem();
                        Wand.this.icon.applyToItem(Wand.this.item);
                    }
                }, (long)(this.inactiveIconDelay * 20 / 1000));
            } else {
                this.findItem();
                this.icon.applyToItem(this.item);
            }
        } else {
            this.findItem();
            this.inactiveIcon.applyToItem(this.item);
        }
    }

    public boolean activate(Mage mage) {
        return this.activate(mage, false);
    }

    public boolean activateOffhand(Mage mage) {
        return this.activate(mage, true);
    }

    public boolean activate(Mage mage, boolean offhand) {
        HeroesManager heroes;
        if (mage == null) {
            return false;
        }
        Player player = mage.getPlayer();
        if (player == null) {
            return false;
        }
        if (!this.controller.hasWandPermission(player, this)) {
            return false;
        }
        if (this.mageClassKey != null && !this.mageClassKey.isEmpty()) {
            MageClass mageClass = mage.getClass(this.mageClassKey);
            if (mageClass == null) {
                Integer lastSlot = mage.getLastActivatedSlot();
                if (!(offhand || lastSlot != null && lastSlot.intValue() == player.getInventory().getHeldItemSlot())) {
                    mage.setLastActivatedSlot(player.getInventory().getHeldItemSlot());
                    mage.sendMessage(this.controller.getMessages().get("mage.no_class").replace("$name", this.getName()));
                }
                return false;
            }
            this.setMageClass(mageClass);
            if (!offhand) {
                mage.setActiveClass(this.mageClassKey);
            }
            this.loadProperties();
        }
        mage.setLastActivatedSlot(player.getInventory().getHeldItemSlot());
        InventoryView openInventory = player.getOpenInventory();
        InventoryType inventoryType = openInventory.getType();
        if (inventoryType == InventoryType.ENCHANTING || inventoryType == InventoryType.ANVIL) {
            return false;
        }
        if (this.hasUses && this.uses <= 0) {
            if (offhand) {
                player.getInventory().setItemInOffHand(new ItemStack(Material.AIR, 1));
            } else {
                player.getInventory().setItemInMainHand(new ItemStack(Material.AIR, 1));
            }
            return false;
        }
        if (!this.canUse(player)) {
            mage.sendMessage(this.getMessage("bound").replace("$name", this.getOwner()));
            return false;
        }
        if (this.isUpgrade) {
            this.controller.getLogger().warning("Activated an upgrade item- this shouldn't happen");
            return false;
        }
        WandPreActivateEvent preActivateEvent = new WandPreActivateEvent(mage, this);
        Bukkit.getPluginManager().callEvent((Event)preActivateEvent);
        if (preActivateEvent.isCancelled()) {
            return false;
        }
        boolean needsSave = false;
        if (this.hasId) {
            needsSave = this.checkId() || needsSave;
        } else {
            this.setProperty("id", null);
        }
        this.mage = mage;
        this.isInOffhand = offhand;
        this.heldSlot = offhand ? 40 : player.getInventory().getHeldItemSlot();
        String replacementTemplate = this.getString("replace_on_activate", "");
        if (!replacementTemplate.isEmpty() && !replacementTemplate.equals(this.template)) {
            this.playEffects("replace");
            this.setTemplate(replacementTemplate);
            this.loadProperties();
            this.saveState();
            return this.activate(mage, offhand);
        }
        if (this.getMode() != WandMode.INVENTORY || offhand) {
            MagicPlugin plugin = this.controller.getPlugin();
            plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

                @Override
                public void run() {
                    Wand.this.showActiveIcon(true);
                    Wand.this.playPassiveEffects("open");
                }
            }, 1L);
        }
        if (!this.isUpgrade && (this.controller.fillWands() || this.autoFill)) {
            this.fill(mage.getPlayer(), this.controller.getMaxWandFillLevel());
            needsSave = true;
        }
        if (this.isHeroes && (heroes = this.controller.getHeroes()) != null) {
            Set<String> skills = heroes.getSkills(player);
            ArrayList currentSpells = new ArrayList(this.getSpells());
            for (String spellKey : currentSpells) {
                if (!spellKey.startsWith("heroes*") || skills.contains(spellKey.substring(7))) continue;
                this.removeSpell(spellKey);
            }
            this.mage = null;
            for (String skillKey : skills) {
                String heroesKey = "heroes*" + skillKey;
                if (this.spells.contains(heroesKey)) continue;
                this.addSpell(heroesKey);
            }
            this.mage = mage;
        }
        if (this.autoOrganize && !this.isUpgrade) {
            this.organizeInventory(mage);
            needsSave = true;
        }
        if (this.autoAlphabetize && !this.isUpgrade) {
            this.alphabetizeInventory();
            needsSave = true;
        }
        boolean forceUpdate = false;
        if (this.checkInventoryForUpgrades()) {
            forceUpdate = true;
            needsSave = true;
        }
        if (this.bound) {
            boolean ownerRenamed;
            String mageName = ChatColor.stripColor((String)mage.getPlayer().getDisplayName());
            String mageId = mage.getId();
            boolean bl = ownerRenamed = this.owner != null && this.ownerId != null && this.ownerId.equals(mageId) && !this.owner.equals(mageName);
            if (this.ownerId == null || this.ownerId.length() == 0 || this.owner == null || ownerRenamed) {
                this.takeOwnership(mage.getPlayer());
                needsSave = true;
            }
        }
        if (this.randomizeOnActivate) {
            this.randomize();
            this.randomizeOnActivate = false;
            forceUpdate = true;
            needsSave = true;
        }
        if (offhand) {
            mage.setOffhandWand(this);
        } else {
            mage.setActiveWand(this);
        }
        this.buildInventory();
        this.updateMaxMana(false);
        this.tick();
        if (!this.isInOffhand) {
            this.updateMana();
        }
        this.checkActiveMaterial();
        if (needsSave) {
            this.saveState();
        }
        this.updateActiveMaterial();
        this.updateName();
        this.updateLore();
        this.playPassiveEffects("activate");
        this.lastSoundEffect = 0L;
        this.lastParticleEffect = 0L;
        this.lastSpellCast = 0L;
        if (forceUpdate) {
            DeprecatedUtils.updateInventory(player);
        }
        return true;
    }

    public boolean checkInventoryForUpgrades() {
        Player player;
        boolean updated = false;
        Player player2 = player = this.mage == null ? null : this.mage.getPlayer();
        if (player == null || this.mage.hasStoredInventory()) {
            return false;
        }
        PlayerInventory inventory = player.getInventory();
        ItemStack[] items = inventory.getContents();
        for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            if (!this.addItem(item)) continue;
            inventory.setItem(i, null);
            updated = true;
        }
        return updated;
    }

    @Override
    public boolean organizeInventory() {
        if (this.mage != null) {
            return this.organizeInventory(this.mage);
        }
        return false;
    }

    private void setOpenInventoryPage(int page) {
        this.openInventoryPage = page;
        this.setProperty("page", page);
    }

    @Override
    public boolean organizeInventory(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        WandOrganizer organizer = new WandOrganizer(this, mage);
        this.closeInventory();
        organizer.organize();
        this.setOpenInventoryPage(0);
        this.setCurrentHotbar(this.currentHotbar);
        if (this.autoOrganize) {
            this.setProperty("organize", false);
        }
        this.autoOrganize = false;
        this.updateSpellInventory();
        this.updateBrushInventory();
        if (mage != null) {
            this.saveState();
            this.loadProperties();
            this.updateInventory();
        }
        return true;
    }

    @Override
    public boolean alphabetizeInventory() {
        WandOrganizer organizer = new WandOrganizer(this);
        this.closeInventory();
        organizer.alphabetize();
        this.setOpenInventoryPage(0);
        this.setCurrentHotbar(0);
        if (this.autoAlphabetize) {
            this.setProperty("alphabetize", false);
        }
        this.autoAlphabetize = false;
        this.updateSpellInventory();
        this.updateBrushInventory();
        if (this.mage != null) {
            this.saveState();
            this.loadProperties();
            this.updateInventory();
        }
        return true;
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.Wand duplicate() {
        ItemStack newItem = InventoryUtils.getCopy(this.item);
        Wand newWand = this.controller.getWand(newItem);
        newWand.saveState();
        return newWand;
    }

    @Override
    @Deprecated
    public boolean configure(Map<String, Object> properties) {
        HashMap<String, Object> convertedProperties = new HashMap<String, Object>(properties);
        this.configure(ConfigurationUtils.toConfigurationSection(convertedProperties));
        return true;
    }

    @Override
    @Deprecated
    public boolean upgrade(Map<String, Object> properties) {
        HashMap<String, Object> convertedProperties = new HashMap<String, Object>(properties);
        return this.upgrade(ConfigurationUtils.toConfigurationSection(convertedProperties));
    }

    @Override
    public void updated() {
        this.loadProperties();
        this.saveState();
        this.updateMaxMana(false);
        this.updateName();
        this.updateLore();
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public boolean upgradesAllowed() {
        return !this.locked || this.lockedAllowUpgrades;
    }

    @Override
    public void unlock() {
        this.locked = false;
        this.setProperty("locked", false);
    }

    public boolean isPassive() {
        return this.passive;
    }

    @Override
    public boolean canUse(Player player) {
        if (!this.bound || this.ownerId == null || this.ownerId.length() == 0) {
            return true;
        }
        if (this.controller.hasPermission(player, "Magic.wand.override_bind", false)) {
            return true;
        }
        String playerId = this.controller.getMageIdentifier().fromEntity((Entity)player);
        if (this.ownerId.equalsIgnoreCase(playerId)) {
            return true;
        }
        return this.ownerId.equals(player.getUniqueId().toString());
    }

    @Override
    public boolean addSpell(String spellName) {
        if (!this.isModifiable()) {
            return false;
        }
        return this.forceAddSpell(spellName);
    }

    @Override
    public boolean forceAddSpell(String spellName) {
        SpellKey spellKey = new SpellKey(spellName);
        if (this.hasSpell(spellKey)) {
            return false;
        }
        this.saveInventory();
        SpellTemplate template = this.controller.getSpellTemplate(spellName);
        if (template == null) {
            this.controller.getLogger().warning("Tried to add unknown spell to wand: " + spellName);
            return false;
        }
        if (this.hasSpell(template.getKey())) {
            return false;
        }
        ItemStack spellItem = this.createSpellIcon(template);
        if (spellItem == null) {
            return false;
        }
        spellKey = template.getSpellKey();
        int level = spellKey.getLevel();
        int inventoryCount = this.inventories.size();
        int spellCount = this.spells.size();
        Integer inventorySlot = this.spellInventory.get(spellKey.getBaseKey());
        SpellTemplate currentSpell = this.getBaseSpell(spellKey);
        this.clearSlot(inventorySlot);
        Collection<SpellKey> spellsToRemove = template.getSpellsToRemove();
        if (!spellsToRemove.isEmpty()) {
            List<Inventory> allInventories = this.getAllInventories();
            for (Inventory inventory : allInventories) {
                ItemStack[] items = inventory.getContents();
                for (int index = 0; index < items.length; ++index) {
                    ItemStack itemStack = items[index];
                    if (!Wand.isSpell(itemStack)) continue;
                    SpellKey checkKey = new SpellKey(Wand.getSpell(itemStack));
                    for (SpellKey key : spellsToRemove) {
                        if (!checkKey.getBaseKey().equals(key.getBaseKey())) continue;
                        inventory.setItem(index, null);
                        this.spells.remove(key.getKey());
                        this.spellLevels.remove(key.getBaseKey());
                    }
                }
            }
        }
        this.setSpellLevel(spellKey.getBaseKey(), level);
        this.spells.add(spellKey.getBaseKey());
        if (this.activeSpell == null || this.activeSpell.isEmpty()) {
            this.setActiveSpell(spellKey.getBaseKey());
        }
        this.addToInventory(spellItem, inventorySlot);
        this.updateInventory();
        this.updateHasInventory();
        this.updateSpells();
        this.saveState();
        this.updateLore();
        if (this.mage != null) {
            if (currentSpell != null) {
                String levelDescription = template.getLevelDescription();
                if (levelDescription == null || levelDescription.isEmpty()) {
                    levelDescription = template.getName();
                }
                this.sendLevelMessage("spell_upgraded", currentSpell.getName(), levelDescription);
                this.mage.sendMessage(template.getUpgradeDescription().replace("$name", currentSpell.getName()));
                SpellUpgradeEvent upgradeEvent = new SpellUpgradeEvent(this.mage, this, currentSpell, template);
                Bukkit.getPluginManager().callEvent((Event)upgradeEvent);
            } else {
                if (this.mage.getActiveGUI() == null) {
                    this.sendAddMessage("spell_added", template.getName());
                }
                AddSpellEvent addEvent = new AddSpellEvent(this.mage, this, template);
                Bukkit.getPluginManager().callEvent((Event)addEvent);
            }
            if (this.spells.size() != spellCount) {
                if (spellCount == 0) {
                    if (this.leftClickAction == WandAction.CAST) {
                        String message = this.getMessage("spell_instructions", "").replace("$wand", this.getName());
                        this.mage.sendMessage(message.replace("$spell", template.getName()));
                    }
                } else if (spellCount == 1) {
                    String controlKey = this.getControlKey(WandAction.TOGGLE);
                    String inventoryMessage = null;
                    switch (this.getMode()) {
                        case INVENTORY: {
                            inventoryMessage = "inventory_instructions";
                            break;
                        }
                        case CHEST: {
                            inventoryMessage = "chest_instructions";
                            break;
                        }
                        case SKILLS: {
                            inventoryMessage = "skills_instructions";
                            break;
                        }
                        case CYCLE: {
                            inventoryMessage = "cycle_instructions";
                            if (controlKey != null) break;
                            controlKey = this.getControlKey(WandAction.CYCLE);
                            break;
                        }
                    }
                    if (controlKey != null && inventoryMessage != null) {
                        controlKey = this.controller.getMessages().get("controls." + controlKey);
                        this.mage.sendMessage(this.getMessage(inventoryMessage, "").replace("$wand", this.getName()).replace("$toggle", controlKey).replace("$cycle", controlKey));
                    }
                }
                if (inventoryCount == 1 && this.inventories.size() > 1) {
                    this.mage.sendMessage(this.getMessage("page_instructions", "").replace("$wand", this.getName()));
                }
            }
        }
        return true;
    }

    private void clearSlot(Integer slot) {
        if (slot != null) {
            Inventory inventory = this.getInventory(slot);
            slot = this.getInventorySlot(slot);
            inventory.setItem(slot.intValue(), null);
        }
    }

    @Override
    protected void sendAddMessage(String messageKey, String nameParam) {
        if (this.mage == null || nameParam == null || nameParam.isEmpty()) {
            return;
        }
        String message = this.getMessage(messageKey).replace("$name", nameParam).replace("$wand", this.getName());
        this.mage.sendMessage(message);
    }

    protected void sendLevelMessage(String messageKey, String nameParam, String level) {
        if (this.mage == null || nameParam == null || nameParam.isEmpty()) {
            return;
        }
        String message = this.getMessage(messageKey).replace("$name", nameParam).replace("$wand", this.getName()).replace("$level", level);
        this.mage.sendMessage(message);
    }

    @Override
    protected void sendMessage(String messageKey) {
        if (this.mage == null || messageKey == null || messageKey.isEmpty()) {
            return;
        }
        String message = this.getMessage(messageKey).replace("$wand", this.getName());
        if (messageKey.equals("hotbar_count_usage")) {
            String controlKey = this.getControlKey(WandAction.CYCLE_HOTBAR);
            if (controlKey != null) {
                controlKey = this.controller.getMessages().get("controls." + controlKey);
                message = message.replace("$cycle_hotbar", controlKey);
            } else {
                return;
            }
        }
        this.mage.sendMessage(message);
    }

    @Override
    public String getMessage(String key, String defaultValue) {
        return this.controller.getMessages().get(this.getMessageKey(key), defaultValue);
    }

    protected String getMessageKey(String key) {
        String wandKey = "wands." + this.template + "." + key;
        if (this.template != null && !this.template.isEmpty() && this.controller.getMessages().containsKey(wandKey)) {
            return wandKey;
        }
        return "wand." + key;
    }

    @Override
    protected void sendDebug(String debugMessage) {
        if (this.mage != null) {
            this.mage.sendDebugMessage(debugMessage);
        }
    }

    @Override
    public boolean add(com.elmakers.mine.bukkit.api.wand.Wand other) {
        if (other instanceof Wand) {
            return this.add((Wand)other);
        }
        return false;
    }

    @Override
    public boolean hasBrush(String materialKey) {
        return this.getBrushes().contains(materialKey);
    }

    @Override
    public boolean hasSpell(String spellName) {
        return this.hasSpell(new SpellKey(spellName));
    }

    @Override
    public boolean hasSpell(SpellKey spellKey) {
        if (!this.spells.contains(spellKey.getBaseKey())) {
            return false;
        }
        int level = this.getSpellLevel(spellKey.getBaseKey());
        return level >= spellKey.getLevel();
    }

    @Override
    public boolean addBrush(String materialKey) {
        if (!this.isModifiable()) {
            return false;
        }
        if (this.hasBrush(materialKey)) {
            return false;
        }
        this.saveInventory();
        ItemStack itemStack = this.createBrushIcon(materialKey);
        if (itemStack == null) {
            return false;
        }
        int inventoryCount = this.inventories.size();
        int brushCount = this.brushes.size();
        this.brushInventory.put(materialKey, null);
        this.brushes.add(materialKey);
        this.addToInventory(itemStack);
        if (this.activeBrush == null || this.activeBrush.length() == 0) {
            this.activateBrush(materialKey);
        } else {
            this.updateInventory();
        }
        this.updateHasInventory();
        this.updateBrushes();
        this.saveState();
        this.updateLore();
        if (this.mage != null) {
            String controlKey;
            Messages messages = this.controller.getMessages();
            String materialName = com.elmakers.mine.bukkit.block.MaterialBrush.getMaterialName(messages, materialKey);
            if (materialName == null) {
                this.mage.getController().getLogger().warning("Invalid material: " + materialKey);
                materialName = materialKey;
            }
            this.sendAddMessage("brush_added", materialName);
            if (brushCount == 0 && (controlKey = this.getControlKey(WandAction.TOGGLE)) != null) {
                controlKey = this.controller.getMessages().get("controls." + controlKey);
                this.mage.sendMessage(this.getMessage("brush_instructions").replace("$wand", this.getName()).replace("$toggle", controlKey));
            }
            if (inventoryCount == 1 && this.inventories.size() > 1) {
                this.mage.sendMessage(this.getMessage("page_instructions").replace("$wand", this.getName()));
            }
        }
        return true;
    }

    @Override
    public void setActiveBrush(String materialKey) {
        this.activateBrush(materialKey);
        if (materialKey == null || this.mage == null) {
            return;
        }
        MaterialBrush brush = this.mage.getBrush();
        if (brush == null) {
            return;
        }
        boolean eraseWasActive = brush.isEraseModifierActive();
        brush.activate(this.mage.getLocation(), materialKey);
        BrushMode mode = brush.getMode();
        if (mode == BrushMode.CLONE) {
            this.mage.sendMessage(this.getMessage("clone_material_activated"));
        } else if (mode == BrushMode.REPLICATE) {
            this.mage.sendMessage(this.getMessage("replicate_material_activated"));
        }
        if (!eraseWasActive && brush.isEraseModifierActive()) {
            this.mage.sendMessage(this.getMessage("erase_modifier_activated"));
        }
    }

    public void setActiveBrush(ItemStack itemStack) {
        if (!Wand.isBrush(itemStack)) {
            return;
        }
        this.setActiveBrush(Wand.getBrush(itemStack));
    }

    public void activateBrush(String materialKey) {
        this.activeBrush = materialKey;
        this.setProperty("active_brush", this.activeBrush);
        this.saveState();
        this.updateActiveMaterial();
        this.updateName();
        this.updateHotbar();
    }

    @Override
    public void setActiveSpell(String activeSpell) {
        if (activeSpell != null) {
            SpellKey spellKey = new SpellKey(activeSpell);
            this.activeSpell = spellKey.getBaseKey();
        } else {
            this.activeSpell = null;
        }
        this.checkActiveSpell();
        this.setProperty("active_spell", this.activeSpell);
        this.saveState();
        this.updateName();
    }

    protected void checkActiveSpell() {
        if (this.activeSpell != null && !this.spells.isEmpty() && !this.spells.contains(this.activeSpell)) {
            this.activeSpell = null;
        }
    }

    @Override
    public boolean removeBrush(String materialKey) {
        if (!this.isModifiable() || materialKey == null) {
            return false;
        }
        this.saveInventory();
        if (materialKey.equals(this.activeBrush)) {
            this.activeBrush = null;
        }
        this.clearSlot(this.brushInventory.get(materialKey));
        this.brushInventory.remove(materialKey);
        boolean found = this.brushes.remove(materialKey);
        if (this.activeBrush == null && this.brushes.size() > 0) {
            this.activeBrush = this.brushes.iterator().next();
        }
        this.updateActiveMaterial();
        this.updateInventory();
        this.updateBrushes();
        this.updateBrushInventory();
        this.saveState();
        this.updateName();
        this.updateLore();
        return found;
    }

    @Override
    public boolean removeSpell(String spellName) {
        if (!this.isModifiable()) {
            return false;
        }
        SpellKey spellKey = new SpellKey(spellName);
        if (!this.spells.contains(spellKey.getBaseKey())) {
            return false;
        }
        this.saveInventory();
        if (this.activeSpell != null) {
            SpellKey activeKey = new SpellKey(this.activeSpell);
            if (spellKey.getBaseKey().equals(activeKey.getBaseKey())) {
                this.setActiveSpell(null);
            }
        }
        this.clearSlot(this.spellInventory.get(spellKey.getBaseKey()));
        this.spells.remove(spellKey.getBaseKey());
        this.spellLevels.remove(spellKey.getBaseKey());
        this.spellInventory.remove(spellKey.getBaseKey());
        if (this.activeSpell == null && this.spells.size() > 0) {
            this.setActiveSpell(this.spells.iterator().next());
        }
        this.updateInventory();
        this.updateHasInventory();
        this.updateSpells();
        this.updateSpellInventory();
        this.saveState();
        this.updateName();
        this.updateLore();
        return true;
    }

    @Override
    public Map<String, String> getOverrides() {
        return this.castOverrides == null ? new HashMap<String, String>() : new HashMap<String, String>(this.castOverrides);
    }

    @Override
    public void setOverrides(Map<String, String> overrides) {
        this.castOverrides = overrides == null ? null : new HashMap<String, String>(overrides);
        this.updateOverrides();
    }

    @Override
    public void removeOverride(String key) {
        if (this.castOverrides != null) {
            this.castOverrides.remove(key);
            this.updateOverrides();
        }
    }

    @Override
    public void setOverride(String key, String value) {
        if (this.castOverrides == null) {
            this.castOverrides = new HashMap<String, String>();
        }
        if (value == null || value.length() == 0) {
            this.castOverrides.remove(key);
        } else {
            this.castOverrides.put(key, value);
        }
        this.updateOverrides();
    }

    @Override
    public boolean addOverride(String key, String value) {
        if (this.castOverrides == null) {
            this.castOverrides = new HashMap<String, String>();
        }
        boolean modified = false;
        if (value == null || value.length() == 0) {
            modified = this.castOverrides.containsKey(key);
            this.castOverrides.remove(key);
        } else {
            String current = this.castOverrides.get(key);
            modified = current == null || !current.equals(value);
            this.castOverrides.put(key, value);
        }
        if (modified) {
            this.updateOverrides();
        }
        return modified;
    }

    protected void updateOverrides() {
        if (this.castOverrides != null && !this.castOverrides.isEmpty()) {
            this.setProperty("overrides", this.castOverrides);
        } else {
            this.setProperty("overrides", null);
        }
    }

    public boolean hasStoredInventory() {
        return this.storedInventory != null;
    }

    public Inventory getStoredInventory() {
        return this.storedInventory;
    }

    public boolean addToStoredInventory(ItemStack item) {
        if (this.storedInventory == null) {
            return false;
        }
        HashMap remainder = this.storedInventory.addItem(new ItemStack[]{item});
        return remainder.size() == 0;
    }

    public void setHeldSlot(int slot) {
        this.heldSlot = slot;
    }

    public boolean storeInventory() {
        if (this.storedInventory != null) {
            if (this.mage != null) {
                this.mage.sendMessage("Your wand contains a previously stored inventory and will not activate, let go of it to clear.");
            }
            this.controller.getLogger().warning("Tried to store an inventory with one already present: " + (this.mage == null ? "?" : this.mage.getName()));
            return false;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return false;
        }
        PlayerInventory inventory = player.getInventory();
        this.storedInventory = CompatibilityUtils.createInventory(null, 36, "Stored Inventory");
        for (int i = 0; i < 36; ++i) {
            ItemStack item = inventory.getItem(i);
            this.storedInventory.setItem(i, item);
            if (i == this.heldSlot) continue;
            inventory.setItem(i, null);
        }
        return true;
    }

    public boolean restoreInventory() {
        if (this.storedInventory == null) {
            return false;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return false;
        }
        PlayerInventory inventory = player.getInventory();
        for (int i = 0; i < this.storedInventory.getSize(); ++i) {
            if (i == this.heldSlot) continue;
            inventory.setItem(i, this.storedInventory.getItem(i));
        }
        this.storedInventory = null;
        inventory.setHeldItemSlot(this.heldSlot);
        return true;
    }

    @Override
    @Deprecated
    public boolean isSoul() {
        return false;
    }

    @Override
    public boolean isBound() {
        return this.bound;
    }

    @Override
    public Spell getSpell(String spellKey, com.elmakers.mine.bukkit.api.magic.Mage mage) {
        if (mage == null) {
            return null;
        }
        SpellKey key = new SpellKey(spellKey);
        if (!this.spells.contains(spellKey = key.getBaseKey())) {
            return null;
        }
        Integer level = this.spellLevels.get(spellKey);
        if (level != null) {
            spellKey = new SpellKey(spellKey, level).getKey();
        }
        return mage.getSpell(spellKey);
    }

    @Override
    public SpellTemplate getSpellTemplate(String spellKey) {
        SpellKey key = new SpellKey(spellKey);
        if (!this.spells.contains(spellKey = key.getBaseKey())) {
            return null;
        }
        Integer level = this.spellLevels.get(spellKey);
        if (level != null) {
            spellKey = new SpellKey(spellKey, level).getKey();
        }
        return this.controller.getSpellTemplate(spellKey);
    }

    @Override
    public Spell getSpell(String spellKey) {
        return this.getSpell(spellKey, this.mage);
    }

    private void setSpellLevel(String spellKey, int level) {
        if (level <= 1) {
            this.spellLevels.remove(spellKey);
        } else {
            this.spellLevels.put(spellKey, level);
        }
    }

    @Override
    public int getSpellLevel(String spellKey) {
        Integer level = this.spellLevels.get(spellKey);
        return level == null ? 1 : level;
    }

    @Override
    public MageController getController() {
        return this.controller;
    }

    protected Map<String, Integer> getSpellInventory() {
        return new HashMap<String, Integer>(this.spellInventory);
    }

    protected Map<String, Integer> getBrushInventory() {
        return new HashMap<String, Integer>(this.brushInventory);
    }

    protected void updateSpellInventory(Map<String, Integer> updateSpells) {
        for (Map.Entry<String, Integer> spellEntry : this.spellInventory.entrySet()) {
            String spellKey = spellEntry.getKey();
            Integer slot = updateSpells.get(spellKey);
            if (slot == null) continue;
            spellEntry.setValue(slot);
        }
    }

    protected void updateBrushInventory(Map<String, Integer> updateBrushes) {
        for (Map.Entry<String, Integer> brushEntry : this.brushInventory.entrySet()) {
            String brushKey = brushEntry.getKey();
            Integer slot = updateBrushes.get(brushKey);
            if (slot == null) continue;
            brushEntry.setValue(slot);
        }
    }

    public Map<PotionEffectType, Integer> getPotionEffects() {
        return this.potionEffects;
    }

    @Override
    public float getHealthRegeneration() {
        Integer level = this.potionEffects.get(PotionEffectType.REGENERATION);
        return level != null && level > 0 ? (float)level.intValue() : 0.0f;
    }

    @Override
    public float getHungerRegeneration() {
        Integer level = this.potionEffects.get(PotionEffectType.SATURATION);
        return level != null && level > 0 ? (float)level.intValue() : 0.0f;
    }

    @Override
    public WandTemplate getTemplate() {
        if (this.template == null || this.template.isEmpty()) {
            return null;
        }
        return this.controller.getWandTemplate(this.template);
    }

    public boolean playPassiveEffects(String effects) {
        WandTemplate wandTemplate = this.getTemplate();
        if (wandTemplate != null && this.mage != null) {
            boolean offhandActive = this.mage.setOffhandActive(this.isInOffhand);
            boolean result = false;
            try {
                result = wandTemplate.playEffects(this, effects);
            }
            catch (Exception ex) {
                result = false;
                this.controller.getLogger().log(Level.WARNING, "Error playing effects " + effects + " from wand " + this.template, ex);
            }
            this.mage.setOffhandActive(offhandActive);
            return result;
        }
        return false;
    }

    @Override
    public boolean playEffects(String effects) {
        if (this.activeEffectsOnly && !this.inventoryIsOpen) {
            return false;
        }
        return this.playPassiveEffects(effects);
    }

    @Override
    public WandAction getDropAction() {
        return this.dropAction;
    }

    @Override
    public WandAction getRightClickAction() {
        return this.rightClickAction;
    }

    @Override
    public WandAction getLeftClickAction() {
        return this.leftClickAction;
    }

    @Override
    public WandAction getSwapAction() {
        return this.swapAction;
    }

    @Override
    public boolean performAction(WandAction action) {
        WandMode mode = this.getMode();
        switch (action) {
            case CAST: {
                this.cast();
                break;
            }
            case ALT_CAST: {
                this.alternateCast();
                break;
            }
            case ALT_CAST2: {
                this.alternateCast2();
                break;
            }
            case TOGGLE: {
                if (mode == WandMode.CYCLE) {
                    this.cycleActive(1);
                    return true;
                }
                if (mode != WandMode.CHEST && mode != WandMode.INVENTORY && mode != WandMode.SKILLS) {
                    return false;
                }
                this.toggleInventory();
                break;
            }
            case CYCLE: {
                this.cycleActive(1);
                break;
            }
            case CYCLE_REVERSE: {
                this.cycleActive(-1);
                break;
            }
            case CYCLE_HOTBAR: {
                if (mode != WandMode.INVENTORY || !this.isInventoryOpen()) {
                    return false;
                }
                if (this.getHotbarCount() > 1) {
                    this.cycleHotbar(1);
                    break;
                }
                this.closeInventory();
                break;
            }
            case CYCLE_HOTBAR_REVERSE: {
                if (mode != WandMode.INVENTORY) {
                    return false;
                }
                if (this.getHotbarCount() > 1) {
                    this.cycleHotbar(-1);
                    break;
                }
                if (this.isInventoryOpen()) {
                    this.closeInventory();
                    break;
                }
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean checkAndUpgrade(boolean quiet) {
        WandUpgradePath nextPath;
        WandUpgradePath path = this.getPath();
        WandUpgradePath wandUpgradePath = nextPath = path != null ? path.getUpgrade() : null;
        if (nextPath == null) {
            return true;
        }
        if (this.canProgress()) {
            return true;
        }
        if (!path.checkUpgradeRequirements(this, quiet ? null : this.mage)) {
            return false;
        }
        path.upgrade(this, this.mage);
        return true;
    }

    @Override
    public boolean hasUpgrade() {
        WandUpgradePath path = this.getPath();
        return path != null && path.hasUpgrade();
    }

    @Override
    public boolean checkUpgrade(boolean quiet) {
        WandUpgradePath path = this.getPath();
        return path == null || !path.hasUpgrade() ? false : path.checkUpgradeRequirements(this, quiet ? null : this.mage);
    }

    @Override
    public boolean upgrade(boolean quiet) {
        WandUpgradePath path = this.getPath();
        if (path == null) {
            return false;
        }
        path.upgrade(this, quiet ? null : this.mage);
        return true;
    }

    @Override
    public boolean isBlocked(double angle) {
        boolean isBlocked;
        if (this.mage == null) {
            return false;
        }
        if (this.blockChance == 0.0f) {
            return false;
        }
        if (this.blockFOV > 0.0f && angle > (double)this.blockFOV) {
            return false;
        }
        long lastBlock = this.mage.getLastBlockTime();
        if (this.blockCooldown > 0 && lastBlock > 0L && lastBlock + (long)this.blockCooldown > System.currentTimeMillis()) {
            return false;
        }
        boolean bl = isBlocked = Math.random() <= (double)this.blockChance;
        if (isBlocked) {
            this.playEffects("spell_blocked");
            this.mage.setLastBlockTime(System.currentTimeMillis());
        }
        return isBlocked;
    }

    @Override
    public boolean isReflected(double angle) {
        boolean isReflected;
        if (this.mage == null) {
            return false;
        }
        if (this.blockReflectChance == 0.0f) {
            return false;
        }
        if (this.blockFOV > 0.0f && angle > (double)this.blockFOV) {
            return false;
        }
        long lastBlock = this.mage.getLastBlockTime();
        if (this.blockCooldown > 0 && lastBlock > 0L && lastBlock + (long)this.blockCooldown > System.currentTimeMillis()) {
            return false;
        }
        boolean bl = isReflected = Math.random() <= (double)this.blockReflectChance;
        if (isReflected) {
            this.playEffects("spell_reflected");
            if (this.mage != null) {
                this.mage.setLastBlockTime(System.currentTimeMillis());
            }
        }
        return isReflected;
    }

    @Override
    public Location getLocation() {
        if (this.mage == null) {
            return null;
        }
        Location wandLocation = this.mage.getEyeLocation();
        wandLocation = this.mage.getOffsetLocation(wandLocation, this.isInOffhand, this.castLocation == null ? DEFAULT_CAST_OFFSET : this.castLocation);
        return wandLocation;
    }

    @Override
    public Mage getMage() {
        return this.mage;
    }

    @Override
    @Nullable
    public MageClass getMageClass() {
        return this.mageClass;
    }

    @Override
    @Nullable
    public String getMageClassKey() {
        return this.mageClassKey;
    }

    public void setCurrentHotbar(int hotbar) {
        this.currentHotbar = hotbar;
        this.setProperty("hotbar", this.currentHotbar);
    }

    public int getInventorySize() {
        WandMode mode = this.getMode();
        if (mode == WandMode.CHEST || mode == WandMode.SKILLS) {
            return 9 * this.inventoryRows;
        }
        return 27;
    }

    public float getSPMultiplier() {
        return this.spMultiplier;
    }

    public boolean usesSP() {
        return this.hasSpellProgression && this.controller.isSPEnabled() && this.controller.isSPEarnEnabled() && this.spMultiplier > 0.0f;
    }

    @Override
    public int getHeldSlot() {
        return this.heldSlot;
    }

    @Override
    protected BaseMagicConfigurable getStorage(MagicPropertyType propertyType) {
        switch (propertyType) {
            case WAND: {
                return this;
            }
            case SUBCLASS: {
                return this.mageClass;
            }
            case CLASS: {
                return this.mageClass.getRoot();
            }
            case MAGE: {
                return this.mage.getProperties();
            }
        }
        return null;
    }

    @Override
    public boolean isPlayer() {
        return this.mage == null ? false : this.mage.isPlayer();
    }

    @Override
    public Player getPlayer() {
        return this.mage == null ? null : this.mage.getPlayer();
    }

    @Override
    @Nonnull
    public CastContext getEffectsContext() {
        if (this.effectsContext == null || this.effectsContext.getMage() != this.mage) {
            this.effectsContext = new com.elmakers.mine.bukkit.action.CastContext(this.mage, this);
        }
        return this.effectsContext;
    }
}

