/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib.math;

import com.elmakers.mine.bukkit.slikey.effectlib.math.Transform;
import com.elmakers.mine.bukkit.slikey.exp4j.Expression;
import com.elmakers.mine.bukkit.slikey.exp4j.ExpressionBuilder;
import com.elmakers.mine.bukkit.slikey.exp4j.function.Function;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;

public class EquationTransform
implements Transform {
    private Expression expression;
    private static Function randFunction;
    private final Set<String> inputVariables;
    private boolean quiet;
    private Exception exception;

    @Override
    public void load(ConfigurationSection parameters) {
        this.setEquation(parameters.getString("equation", ""));
    }

    public EquationTransform() {
        this.inputVariables = new HashSet<String>();
    }

    public EquationTransform(String equation) {
        this(equation, "t");
    }

    public EquationTransform(String equation, String inputVariable) {
        this.inputVariables = new HashSet<String>();
        this.inputVariables.add(inputVariable);
        this.setEquation(equation);
    }

    public EquationTransform(String equation, String ... inputVariables) {
        this.inputVariables = new HashSet<String>();
        for (String inputVariable : inputVariables) {
            this.inputVariables.add(inputVariable);
        }
        this.setEquation(equation);
    }

    public EquationTransform(String equation, Set<String> inputVariables) {
        this.inputVariables = inputVariables;
        this.setEquation(equation);
    }

    public EquationTransform(String equation, Set<String> inputVariables, boolean quiet) {
        this.quiet = quiet;
        this.inputVariables = inputVariables;
        this.setEquation(equation);
    }

    public boolean setEquation(String equation) {
        block3: {
            try {
                this.exception = null;
                if (randFunction == null) {
                    randFunction = new Function("rand", 2){
                        private Random random;
                        {
                            this.random = new Random();
                        }

                        @Override
                        public double apply(double ... args) {
                            return this.random.nextDouble() * (args[1] - args[0]) + args[0];
                        }
                    };
                }
                this.expression = new ExpressionBuilder(equation).function(randFunction).variables(this.inputVariables).build();
            }
            catch (Exception ex) {
                this.expression = null;
                this.exception = ex;
                if (this.quiet) break block3;
                Bukkit.getLogger().log(Level.WARNING, ex.getMessage());
            }
        }
        return this.exception == null;
    }

    @Override
    public double get(double t) {
        if (this.expression == null) {
            return 0.0;
        }
        for (String inputVariable : this.inputVariables) {
            this.expression.setVariable(inputVariable, t);
        }
        return this.get();
    }

    public double get(double ... t) {
        if (this.expression == null) {
            return 0.0;
        }
        int index = 0;
        for (String inputVariable : this.inputVariables) {
            this.expression.setVariable(inputVariable, t[index]);
            if (index >= t.length - 1) continue;
            ++index;
        }
        return this.get();
    }

    public void addVariable(String key) {
        this.inputVariables.add(key);
    }

    public void setVariable(String key, double value) {
        if (this.expression != null) {
            this.expression.setVariable(key, value);
        }
    }

    public double get() {
        double value;
        block3: {
            if (this.expression == null) {
                return Double.NaN;
            }
            value = Double.NaN;
            try {
                this.exception = null;
                value = this.expression.evaluate();
            }
            catch (Exception ex) {
                this.exception = ex;
                if (this.quiet) break block3;
                Bukkit.getLogger().log(Level.WARNING, ex.getMessage());
            }
        }
        return value;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isValid() {
        return this.exception == null;
    }

    public Set<String> getParameters() {
        return this.inputVariables;
    }
}

