/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.magic.ParameterizedConfiguration;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemorySection;
import org.bukkit.util.NumberConversions;

public class ParameterizedConfigurationSection
extends MemorySection {
    protected ParameterizedConfigurationSection() {
    }

    protected ParameterizedConfigurationSection(ConfigurationSection parent, String path) {
        super(parent, path);
    }

    public void wrap(ConfigurationSection wrap) {
        Map<String, Object> data = NMSUtils.getMap(wrap);
        if (data != null) {
            NMSUtils.setMap((ConfigurationSection)this, data);
        }
    }

    public ConfigurationSection createSection(String path) {
        int i2;
        Validate.notEmpty((String)path, (String)"Cannot create section at empty path");
        Configuration root = this.getRoot();
        if (root == null) {
            throw new IllegalStateException("Cannot create section without a root");
        }
        char separator = root.options().pathSeparator();
        int i1 = -1;
        ParameterizedConfigurationSection section = this;
        while ((i1 = path.indexOf(separator, i2 = i1 + 1)) != -1) {
            String node = path.substring(i2, i1);
            ConfigurationSection subSection = section.getConfigurationSection(node);
            if (subSection == null) {
                section = section.createSection(node);
                continue;
            }
            section = subSection;
        }
        String key = path.substring(i2);
        if (section == this) {
            ParameterizedConfigurationSection result = new ParameterizedConfigurationSection((ConfigurationSection)this, key);
            this.map.put(key, result);
            return result;
        }
        return section.createSection(key);
    }

    public int getInt(String path, int def) {
        Object val = this.get(path, def);
        if (val instanceof String && this.getRoot() instanceof ParameterizedConfiguration) {
            val = ((ParameterizedConfiguration)this.getRoot()).evaluate((String)val);
        }
        return val instanceof Number ? NumberConversions.toInt((Object)val) : def;
    }

    public double getDouble(String path, double def) {
        Object val = this.get(path, def);
        if (val instanceof String && this.getRoot() instanceof ParameterizedConfiguration) {
            val = ((ParameterizedConfiguration)this.getRoot()).evaluate((String)val);
        }
        return val instanceof Number ? NumberConversions.toDouble((Object)val) : def;
    }

    public long getLong(String path, long def) {
        Object val = this.get(path, def);
        if (val instanceof String && this.getRoot() instanceof ParameterizedConfiguration) {
            val = ((ParameterizedConfiguration)this.getRoot()).evaluate((String)val);
        }
        return val instanceof Number ? NumberConversions.toLong((Object)val) : def;
    }
}

