/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action;

import com.elmakers.mine.bukkit.action.ActionHandlerContext;
import com.elmakers.mine.bukkit.api.action.ActionHandler;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.effect.EffectPlay;
import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageClass;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.TargetType;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import com.elmakers.mine.bukkit.spell.UndoableSpell;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class CastContext
implements com.elmakers.mine.bukkit.api.action.CastContext {
    protected static Random random;
    private final Location location;
    private final Entity entity;
    private Location targetLocation;
    private Location targetSourceLocation;
    private Location targetCenterLocation;
    private Entity targetEntity;
    private com.elmakers.mine.bukkit.api.block.UndoList undoList;
    private String targetName = null;
    private SpellResult result = SpellResult.NO_ACTION;
    private SpellResult initialResult = SpellResult.CAST;
    private Vector direction = null;
    private Boolean targetCaster = null;
    private Set<UUID> targetMessagesSent = null;
    private Collection<EffectPlay> currentEffects = null;
    private Spell spell;
    private BaseSpell baseSpell;
    private BlockSpell blockSpell;
    private BrushSpell brushSpell;
    private TargetingSpell targetingSpell;
    private UndoableSpell undoSpell;
    private MaterialBrush brush;
    private CastContext base;
    private Mage mage;
    private MageClass mageClass;
    private Wand wand;
    private List<ActionHandlerContext> handlers = null;
    private List<ActionHandlerContext> finishedHandlers = null;
    private Map<String, String> messageParameters = null;
    private int workAllowed = 500;
    private int actionsPerformed;
    private boolean finished = false;

    public CastContext() {
        this.location = null;
        this.entity = null;
        this.base = this;
        this.result = SpellResult.NO_ACTION;
        this.targetMessagesSent = new HashSet<UUID>();
        this.currentEffects = new ArrayList<EffectPlay>();
        this.messageParameters = new HashMap<String, String>();
    }

    public CastContext(Mage mage) {
        this.mage = mage;
        this.entity = mage.getEntity();
        this.location = null;
        this.base = this;
        this.result = SpellResult.NO_ACTION;
        this.targetMessagesSent = new HashSet<UUID>();
        this.currentEffects = new ArrayList<EffectPlay>();
        this.messageParameters = new HashMap<String, String>();
    }

    public CastContext(Mage mage, Wand wand) {
        this(mage);
        this.wand = wand;
    }

    public CastContext(com.elmakers.mine.bukkit.api.action.CastContext copy) {
        this(copy, copy.getEntity(), copy instanceof CastContext ? ((CastContext)copy).location : null);
    }

    public CastContext(com.elmakers.mine.bukkit.api.action.CastContext copy, Entity sourceEntity) {
        this(copy, sourceEntity, null);
    }

    public CastContext(com.elmakers.mine.bukkit.api.action.CastContext copy, Location sourceLocation) {
        this(copy, null, sourceLocation);
    }

    public CastContext(com.elmakers.mine.bukkit.api.action.CastContext copy, Entity sourceEntity, Location sourceLocation) {
        this.location = sourceLocation;
        this.entity = sourceEntity;
        this.setSpell(copy.getSpell());
        this.targetEntity = copy.getTargetEntity();
        this.targetLocation = copy.getTargetLocation();
        this.undoList = copy.getUndoList();
        this.targetName = copy.getTargetName();
        this.brush = copy.getBrush();
        this.targetMessagesSent = copy.getTargetMessagesSent();
        this.currentEffects = copy.getCurrentEffects();
        this.result = copy.getResult();
        this.wand = copy.getWand();
        this.mageClass = copy.getMageClass();
        Location centerLocation = copy.getTargetCenterLocation();
        if (centerLocation != null) {
            this.targetCenterLocation = centerLocation;
        }
        if (copy instanceof CastContext) {
            this.base = ((CastContext)copy).base;
            this.initialResult = ((CastContext)copy).initialResult;
            this.direction = ((CastContext)copy).direction;
            this.messageParameters = ((CastContext)copy).messageParameters;
        } else {
            this.base = this;
        }
    }

    public void setSpell(Spell spell) {
        this.spell = spell;
        if (spell instanceof BaseSpell) {
            this.baseSpell = (BaseSpell)spell;
        }
        if (spell instanceof MageSpell) {
            MageSpell mageSpell = (MageSpell)spell;
            this.mage = mageSpell.getMage();
            this.wand = this.mage.getActiveWand();
            MageClass mageClass = this.mageClass = this.wand == null ? this.mage.getActiveClass() : this.wand.getMageClass();
        }
        if (spell instanceof UndoableSpell) {
            this.undoSpell = (UndoableSpell)spell;
            this.undoList = this.undoSpell.getUndoList();
        }
        if (spell instanceof TargetingSpell) {
            this.targetingSpell = (TargetingSpell)spell;
        }
        if (spell instanceof BlockSpell) {
            this.blockSpell = (BlockSpell)spell;
        }
        if (spell instanceof BrushSpell) {
            this.brushSpell = (BrushSpell)spell;
        }
    }

    @Override
    public Location getCastLocation() {
        Location castLocation;
        if (this.location != null) {
            return this.location;
        }
        Location location = castLocation = this.wand == null ? null : this.wand.getLocation();
        if (castLocation == null) {
            Location location2 = castLocation = this.baseSpell != null ? this.baseSpell.getCastLocation() : this.getEyeLocation();
        }
        if (castLocation != null && this.direction != null) {
            castLocation.setDirection(this.direction);
        }
        return castLocation;
    }

    @Override
    public Location getWandLocation() {
        return this.getCastLocation();
    }

    @Override
    public Location getEyeLocation() {
        if (this.location != null) {
            return this.location;
        }
        if (this.entity != null) {
            if (this.entity instanceof LivingEntity) {
                return ((LivingEntity)this.entity).getEyeLocation();
            }
            return this.entity.getLocation();
        }
        return this.spell.getEyeLocation();
    }

    @Override
    public Entity getEntity() {
        if (this.entity != null) {
            return this.entity;
        }
        return this.spell.getEntity();
    }

    @Override
    public LivingEntity getLivingEntity() {
        Entity entity = this.getEntity();
        return entity instanceof LivingEntity ? (LivingEntity)entity : null;
    }

    @Override
    public Location getLocation() {
        if (this.location != null) {
            return this.location;
        }
        if (this.entity != null) {
            return this.entity.getLocation();
        }
        return this.spell.getLocation();
    }

    @Override
    public Location getTargetLocation() {
        return this.targetLocation;
    }

    @Override
    public Location getTargetSourceLocation() {
        return this.targetSourceLocation == null ? this.targetLocation : this.targetSourceLocation;
    }

    @Override
    public Block getTargetBlock() {
        return this.targetLocation == null ? null : this.targetLocation.getBlock();
    }

    @Override
    public Entity getTargetEntity() {
        return this.targetEntity;
    }

    @Override
    public Vector getDirection() {
        if (this.direction != null) {
            return this.direction.clone();
        }
        return this.getLocation().getDirection();
    }

    @Override
    public BlockFace getFacingDirection() {
        if (this.baseSpell != null) {
            return BaseSpell.getFacing(this.getLocation());
        }
        return BlockFace.UP;
    }

    @Override
    public void setDirection(Vector direction) {
        this.direction = direction;
    }

    @Override
    public World getWorld() {
        Location location = this.getLocation();
        return location == null ? null : location.getWorld();
    }

    @Override
    public void setTargetEntity(Entity targetEntity) {
        this.targetEntity = targetEntity;
    }

    @Override
    public void setTargetLocation(Location targetLocation) {
        this.targetLocation = targetLocation;
    }

    @Override
    public void setTargetSourceLocation(Location targetLocation) {
        this.targetSourceLocation = targetLocation;
    }

    @Override
    public Spell getSpell() {
        return this.spell;
    }

    @Override
    public Mage getMage() {
        return this.mage;
    }

    @Override
    @Nullable
    public MageClass getMageClass() {
        return this.mageClass;
    }

    @Override
    public Wand getWand() {
        return this.wand;
    }

    @Override
    public CasterProperties getActiveProperties() {
        if (this.wand != null) {
            return this.wand;
        }
        return this.mage.getActiveProperties();
    }

    @Override
    public MageController getController() {
        Mage mage = this.getMage();
        return mage == null ? null : mage.getController();
    }

    @Override
    public void registerForUndo(Runnable runnable) {
        this.addWork(1);
        if (this.undoList != null) {
            this.undoList.add(runnable);
        }
    }

    @Override
    public void registerModified(Entity entity) {
        this.addWork(5);
        if (this.undoList != null) {
            this.undoList.modify(entity);
        }
    }

    @Override
    public void registerDamaged(Entity entity) {
        this.addWork(5);
        if (this.undoList != null) {
            this.undoList.damage(entity);
        }
    }

    @Override
    public void registerForUndo(Entity entity) {
        this.addWork(5);
        if (this.undoList != null) {
            this.undoList.add(entity);
        }
    }

    @Override
    public void clearAttachables(Block block) {
        this.addWork(50);
        if (this.undoList != null) {
            this.undoList.clearAttachables(block);
        }
    }

    @Override
    public void registerForUndo(Block block) {
        this.addWork(10);
        if (this.undoList != null) {
            this.undoList.add(block);
        }
    }

    @Override
    public void updateBlock(Block block) {
        MageController controller = this.getController();
        if (controller != null) {
            controller.updateBlock(block);
        }
    }

    @Override
    public void registerVelocity(Entity entity) {
        this.addWork(5);
        if (this.undoList != null) {
            this.undoList.modifyVelocity(entity);
        }
    }

    @Override
    public void registerMoved(Entity entity) {
        this.addWork(5);
        if (this.undoList != null) {
            this.undoList.move(entity);
        }
    }

    @Override
    public void registerPotionEffects(Entity entity) {
        this.addWork(5);
        if (this.undoList != null) {
            this.undoList.addPotionEffects(entity);
        }
    }

    @Override
    public Block getPreviousBlock() {
        return this.targetingSpell != null ? this.targetingSpell.getPreviousBlock() : null;
    }

    @Override
    public boolean isIndestructible(Block block) {
        return this.blockSpell != null ? this.blockSpell.isIndestructible(block) : true;
    }

    @Override
    public boolean hasBuildPermission(Block block) {
        return this.baseSpell != null ? this.baseSpell.hasBuildPermission(block) : false;
    }

    @Override
    public boolean hasBreakPermission(Block block) {
        return this.baseSpell != null ? this.baseSpell.hasBreakPermission(block) : false;
    }

    @Override
    public boolean hasEffects(String key) {
        return this.baseSpell != null ? this.baseSpell.hasEffects(key) : false;
    }

    @Override
    public void playEffects(String key) {
        this.playEffects(key, 1.0f);
    }

    @Override
    public Collection<EffectPlayer> getEffects(String effectKey) {
        Collection<EffectPlayer> effects = this.spell.getEffects(effectKey);
        if (effects.size() == 0) {
            return effects;
        }
        HashMap<String, String> parameterMap = null;
        ConfigurationSection workingParameters = this.spell.getWorkingParameters();
        if (workingParameters != null) {
            Set keys = workingParameters.getKeys(false);
            parameterMap = new HashMap<String, String>();
            for (String key : keys) {
                parameterMap.put("$" + key, workingParameters.getString(key));
            }
        }
        for (EffectPlayer player : effects) {
            player.setEffectPlayList(this.currentEffects);
            player.setMaterial(this.spell.getEffectMaterial());
            player.setColor(this.getEffectColor());
            player.setParticleOverride(this.getEffectParticle());
            player.setParameterMap(parameterMap);
        }
        return effects;
    }

    public Color getEffectColor() {
        Color color;
        Color color2 = color = this.wand == null ? null : this.wand.getEffectColor();
        if (color == null) {
            color = this.spell.getEffectColor();
        }
        return color;
    }

    public String getEffectParticle() {
        String particle;
        String string = particle = this.wand == null ? null : this.wand.getEffectParticleName();
        if (particle == null) {
            particle = this.spell.getEffectParticle();
        }
        return particle;
    }

    @Override
    public void playEffects(String effectName, float scale) {
        this.playEffects(effectName, scale, null, this.getEntity(), null, this.getTargetEntity());
    }

    @Override
    public void playEffects(String effectName, float scale, Block sourceBlock) {
        this.playEffects(effectName, scale, null, this.getEntity(), null, this.getTargetEntity(), sourceBlock);
    }

    @Override
    public void playEffects(String effectName, float scale, Location sourceLocation, Entity sourceEntity, Location targetLocation, Entity targetEntity) {
        this.playEffects(effectName, scale, sourceLocation, sourceEntity, targetLocation, targetEntity, null);
    }

    @Override
    public void playEffects(String effectName, float scale, Location sourceLocation, Entity sourceEntity, Location targetLocation, Entity targetEntity, Block sourceBlock) {
        Collection<EffectPlayer> effects;
        if (targetEntity != null) {
            String entityKey = effectName + "_" + targetEntity.getType().name().toLowerCase();
            if (this.baseSpell != null && this.baseSpell.hasEffects(entityKey)) {
                effectName = entityKey;
            }
        }
        if ((effects = this.getEffects(effectName)).size() > 0) {
            Location location = this.getLocation();
            Collection<Entity> targeted = this.getTargetedEntities();
            for (EffectPlayer player : effects) {
                Location target;
                player.setScale(scale);
                Mage mage = this.getMage();
                Location source = sourceLocation;
                if (source == null) {
                    source = mage.getEntity() == sourceEntity && player.playsAtOrigin() ? player.getSourceLocation(this) : location;
                }
                if ((target = targetLocation) == null) {
                    target = player.getTargetLocation(this);
                }
                if (sourceBlock != null) {
                    player.setMaterial(sourceBlock);
                }
                player.start(source, sourceEntity, target, targetEntity, targeted);
            }
        }
    }

    @Override
    public void cancelEffects() {
        for (EffectPlay player : this.currentEffects) {
            player.cancel();
        }
        this.currentEffects.clear();
    }

    @Override
    public String getMessage(String key) {
        return this.getMessage(key, "");
    }

    @Override
    public String getMessage(String key, String def) {
        return this.baseSpell != null ? this.baseSpell.getMessage(key, def) : def;
    }

    @Override
    public Location findPlaceToStand(Location target, int verticalSearchDistance, boolean goUp) {
        return this.baseSpell != null ? this.baseSpell.findPlaceToStand(target, goUp, verticalSearchDistance) : this.location;
    }

    @Override
    public Location findPlaceToStand(Location targetLoc, int verticalSearchDistance) {
        return this.baseSpell != null ? this.baseSpell.findPlaceToStand(targetLoc, verticalSearchDistance, verticalSearchDistance) : this.location;
    }

    @Override
    public int getVerticalSearchDistance() {
        return this.baseSpell != null ? this.baseSpell.getVerticalSearchDistance() : 4;
    }

    @Override
    public boolean isOkToStandIn(Material material) {
        return this.baseSpell != null ? this.baseSpell.isOkToStandIn(material) : true;
    }

    @Override
    public boolean isWater(Material mat) {
        return mat == Material.WATER || mat == Material.STATIONARY_WATER;
    }

    @Override
    public boolean isOkToStandOn(Material material) {
        return material != Material.AIR && material != Material.LAVA && material != Material.STATIONARY_LAVA;
    }

    @Override
    public boolean allowPassThrough(Material material) {
        return this.baseSpell != null ? this.baseSpell.allowPassThrough(material) : true;
    }

    @Override
    public void castMessageKey(String key) {
        if (this.baseSpell != null) {
            this.baseSpell.castMessage(this.getMessage(key));
        }
    }

    @Override
    public void sendMessageKey(String key) {
        if (this.baseSpell != null) {
            this.baseSpell.sendMessage(this.getMessage(key));
        }
    }

    @Override
    public void showMessage(String key, String def) {
        Mage mage = this.getMage();
        if (mage != null) {
            mage.sendMessage(this.getMessage(key, def));
        }
    }

    @Override
    public void showMessage(String message) {
        Mage mage = this.getMage();
        if (mage != null) {
            mage.sendMessage(message);
        }
    }

    @Override
    public void castMessage(String message) {
        if (this.baseSpell != null) {
            this.baseSpell.castMessage(message);
        }
    }

    @Override
    public void sendMessage(String message) {
        if (this.baseSpell != null) {
            this.baseSpell.sendMessage(message);
        }
    }

    @Override
    public void setTargetedLocation(Location location) {
        if (this.targetingSpell != null) {
            this.targetingSpell.setTarget(location);
        }
    }

    @Override
    public Block findBlockUnder(Block block) {
        if (this.targetingSpell != null) {
            block = this.targetingSpell.findBlockUnder(block);
        }
        return block;
    }

    @Override
    public Block findSpaceAbove(Block block) {
        if (this.targetingSpell != null) {
            block = this.targetingSpell.findSpaceAbove(block);
        }
        return block;
    }

    @Override
    public boolean isTransparent(Material material) {
        if (this.targetingSpell != null) {
            return this.targetingSpell.isTransparent(material);
        }
        return material.isTransparent();
    }

    @Override
    public boolean isPassthrough(Material material) {
        if (this.baseSpell != null) {
            return this.baseSpell.isPassthrough(material);
        }
        return material.isTransparent();
    }

    @Override
    public boolean isDestructible(Block block) {
        if (this.blockSpell != null) {
            return this.blockSpell.isDestructible(block);
        }
        return true;
    }

    @Override
    public boolean areAnyDestructible(Block block) {
        if (this.blockSpell != null) {
            return this.blockSpell.areAnyDestructible(block);
        }
        return true;
    }

    @Override
    public boolean isTargetable(Block block) {
        if (this.targetingSpell != null) {
            return this.targetingSpell.isTargetable(this, block);
        }
        return true;
    }

    @Override
    public TargetType getTargetType() {
        TargetType targetType = TargetType.NONE;
        if (this.targetingSpell != null) {
            targetType = this.targetingSpell.getTargetType();
        }
        return targetType;
    }

    @Override
    public boolean getTargetsCaster() {
        if (this.targetCaster != null) {
            return this.targetCaster;
        }
        if (this.baseSpell != null) {
            return this.baseSpell.getTargetsCaster();
        }
        return false;
    }

    @Override
    public void setTargetsCaster(boolean target) {
        this.targetCaster = target;
    }

    @Override
    public boolean isConsumeFree() {
        if (this.baseSpell != null) {
            return this.baseSpell.getConsumeReduction() >= 1.0f;
        }
        return false;
    }

    @Override
    public boolean canTarget(Entity entity) {
        return this.targetingSpell == null ? true : this.targetingSpell.canTarget(entity);
    }

    @Override
    public boolean canTarget(Entity entity, Class<?> targetType) {
        return this.targetingSpell == null ? true : this.targetingSpell.canTarget(entity, targetType);
    }

    @Override
    public MaterialBrush getBrush() {
        if (this.brush != null) {
            return this.brush;
        }
        return this.brushSpell == null ? null : this.brushSpell.getBrush();
    }

    @Override
    public void setBrush(MaterialBrush brush) {
        this.brush = brush;
    }

    @Override
    public Collection<Entity> getTargetedEntities() {
        if (this.undoList == null) {
            return new ArrayList<Entity>();
        }
        return this.undoList.getAllEntities();
    }

    @Override
    public void messageTargets(String messageKey) {
        Mage mage = this.getMage();
        if (mage.isStealth()) {
            return;
        }
        Collection<Entity> targets = this.getTargetedEntities();
        if (targets == null || targets.isEmpty()) {
            return;
        }
        MageController controller = this.getController();
        LivingEntity sourceEntity = mage.getLivingEntity();
        String playerMessage = this.getMessage(messageKey);
        if (playerMessage.length() > 0) {
            playerMessage = playerMessage.replace("$spell", this.spell.getName());
            for (Entity target : targets) {
                UUID targetUUID = target.getUniqueId();
                if (!(target instanceof Player) || target == sourceEntity || this.targetMessagesSent.contains(targetUUID)) continue;
                this.targetMessagesSent.add(targetUUID);
                Mage targetMage = controller.getRegisteredMage(target);
                if (targetMage == null) continue;
                targetMage.sendMessage(playerMessage);
            }
        }
    }

    public String parameterizeMessage(String message) {
        for (Map.Entry<String, String> entry : this.messageParameters.entrySet()) {
            message = message.replace("$" + entry.getKey(), entry.getValue());
        }
        return message;
    }

    @Override
    public Block getInteractBlock() {
        Location location = this.getEyeLocation();
        if (location == null) {
            return null;
        }
        Block playerBlock = location.getBlock();
        if (this.isTargetable(playerBlock)) {
            return playerBlock;
        }
        Vector direction = location.getDirection().normalize();
        return location.add(direction).getBlock();
    }

    @Override
    public Random getRandom() {
        if (random == null) {
            random = new Random();
        }
        return random;
    }

    @Override
    public com.elmakers.mine.bukkit.api.block.UndoList getUndoList() {
        return this.undoList;
    }

    @Override
    public String getTargetName() {
        return this.targetName;
    }

    @Override
    public void setTargetName(String name) {
        this.targetName = name;
    }

    @Override
    public Logger getLogger() {
        return this.getController().getLogger();
    }

    @Override
    public int getWorkAllowed() {
        return this.base.workAllowed;
    }

    @Override
    public void setWorkAllowed(int work) {
        this.base.workAllowed = work;
    }

    @Override
    public void addWork(int work) {
        this.base.workAllowed -= work;
    }

    @Override
    public void performedActions(int count) {
        this.base.actionsPerformed += count;
    }

    @Override
    public int getActionsPerformed() {
        return this.base.actionsPerformed;
    }

    @Override
    public void finish() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        Mage mage = this.getMage();
        if (this.finishedHandlers != null) {
            for (ActionHandlerContext context : this.finishedHandlers) {
                context.finish();
            }
            this.finishedHandlers = null;
        }
        if (this.undoSpell != null && this.undoSpell.isUndoable()) {
            if (!this.undoList.isScheduled()) {
                this.getController().update(this.undoList);
            }
            mage.registerForUndo(this.undoList);
        }
        this.result = this.result.max(this.initialResult);
        if (this.spell != null) {
            mage.sendDebugMessage(ChatColor.WHITE + "Finish " + ChatColor.GOLD + this.spell.getName() + ChatColor.WHITE + ": " + ChatColor.AQUA + this.result.name().toLowerCase(), 2);
            this.spell.finish(this);
        }
        String resultName = this.result.name().toLowerCase();
        this.castMessageKey(resultName + "_finish");
        this.playEffects(resultName + "_finish");
    }

    @Override
    public void retarget(double range, double fov, double closeRange, double closeFOV, boolean useHitbox) {
        if (this.targetingSpell != null) {
            this.targetingSpell.retarget(this, range, fov, closeRange, closeFOV, useHitbox);
            this.setTargetEntity(this.targetingSpell.getTargetEntity());
            this.setTargetLocation(this.targetingSpell.getTargetLocation());
        }
    }

    @Override
    public void retarget(double range, double fov, double closeRange, double closeFOV, boolean useHitbox, int yOffset, boolean targetSpaceRequired, int targetMinOffset) {
        if (this.targetingSpell != null) {
            this.targetingSpell.retarget(range, fov, closeRange, closeFOV, useHitbox, yOffset, targetSpaceRequired, targetMinOffset);
            this.setTargetEntity(this.targetingSpell.getTargetEntity());
            this.setTargetLocation(this.targetingSpell.getTargetLocation());
        }
    }

    @Override
    public com.elmakers.mine.bukkit.api.action.CastContext getBaseContext() {
        return this.base;
    }

    @Override
    public Location getTargetCenterLocation() {
        return this.targetCenterLocation == null ? this.targetLocation : this.targetCenterLocation;
    }

    @Override
    public void setTargetCenterLocation(Location location) {
        this.targetCenterLocation = location;
    }

    @Override
    public Set<UUID> getTargetMessagesSent() {
        return this.targetMessagesSent;
    }

    @Override
    public Collection<EffectPlay> getCurrentEffects() {
        return this.currentEffects;
    }

    @Override
    public Plugin getPlugin() {
        MageController controller = this.getController();
        return controller == null ? null : controller.getPlugin();
    }

    @Override
    public boolean teleport(Entity entity, Location location, int verticalSearchDistance, boolean preventFall) {
        return this.teleport(entity, location, verticalSearchDistance, preventFall, true);
    }

    @Override
    public boolean teleport(Entity entity, Location location, int verticalSearchDistance, boolean preventFall, boolean safe) {
        Location targetLocation;
        Chunk chunk = location.getBlock().getChunk();
        if (!chunk.isLoaded()) {
            chunk.load(true);
        }
        if ((targetLocation = this.findPlaceToStand(location, verticalSearchDistance)) == null && !preventFall) {
            Block block = location.getBlock();
            Block blockOneUp = block.getRelative(BlockFace.UP);
            if (!safe || this.isOkToStandIn(blockOneUp.getType()) && this.isOkToStandIn(block.getType())) {
                targetLocation = location;
            }
        }
        if (targetLocation != null) {
            targetLocation.setX(location.getX() - (double)location.getBlockX() + (double)targetLocation.getBlockX());
            targetLocation.setZ(location.getZ() - (double)location.getBlockZ() + (double)targetLocation.getBlockZ());
            this.registerMoved(entity);
            boolean isWorldChange = !targetLocation.getWorld().equals(entity.getWorld());
            entity.teleport(targetLocation);
            if (isWorldChange) {
                entity.teleport(targetLocation);
            }
        } else {
            this.castMessageKey("teleport_failed");
            this.playEffects("teleport_failed");
            return false;
        }
        this.setTargetLocation(targetLocation);
        this.castMessageKey("teleport");
        this.playEffects("teleport");
        return true;
    }

    @Override
    public boolean teleport(Entity entity, Location location, int verticalSearchDistance) {
        return this.teleport(entity, location, verticalSearchDistance, true);
    }

    @Override
    public void setSpellParameters(ConfigurationSection parameters) {
        if (this.baseSpell != null) {
            this.baseSpell.processParameters(parameters);
        }
    }

    @Override
    public Set<Material> getMaterialSet(String key) {
        return this.getController().getMaterialSet(key);
    }

    @Override
    public SpellResult getResult() {
        return this.result;
    }

    @Override
    public void setResult(SpellResult result) {
        this.result = result;
    }

    @Override
    public void addResult(SpellResult result) {
        if (result != SpellResult.PENDING) {
            this.result = this.result.min(result);
        }
    }

    public void setInitialResult(SpellResult result) {
        this.initialResult = result;
    }

    @Override
    public boolean canCast(Location location) {
        if (this.baseSpell != null) {
            return this.baseSpell.canCast(location);
        }
        return true;
    }

    @Override
    public boolean isBreakable(Block block) {
        return UndoList.getRegistry().isBreakable(block);
    }

    @Override
    public Double getBreakable(Block block) {
        return UndoList.getRegistry().getBreakable(block);
    }

    @Override
    public void clearBreakable(Block block) {
        UndoList.getRegistry().unregisterBreakable(block);
    }

    @Override
    public void clearReflective(Block block) {
        UndoList.getRegistry().unregisterReflective(block);
    }

    @Override
    public boolean isReflective(Block block) {
        if (block == null) {
            return false;
        }
        if (this.targetingSpell != null && this.targetingSpell.isReflective(block.getType())) {
            return true;
        }
        return UndoList.getRegistry().isReflective(block);
    }

    @Override
    public Double getReflective(Block block) {
        if (block == null) {
            return null;
        }
        if (this.targetingSpell != null && this.targetingSpell.isReflective(block.getType())) {
            return 1.0;
        }
        return UndoList.getRegistry().getReflective(block);
    }

    @Override
    public void registerBreakable(Block block, double breakable) {
        UndoList.getRegistry().registerBreakable(block, breakable);
        this.undoList.setUndoBreakable(true);
    }

    @Override
    public void registerReflective(Block block, double reflectivity) {
        UndoList.getRegistry().registerReflective(block, reflectivity);
        this.undoList.setUndoReflective(true);
    }

    @Override
    public double registerBreaking(Block block, double addAmount) {
        double breakAmount = UndoList.getRegistry().registerBreaking(block, addAmount);
        this.undoList.setUndoBreaking(true);
        return breakAmount;
    }

    @Override
    public void unregisterBreaking(Block block) {
        UndoList.getRegistry().unregisterBreaking(block);
    }

    @Override
    public String parameterize(String command) {
        Entity targetEntity;
        Location targetLocation;
        Location location = this.getLocation();
        Mage mage = this.getMage();
        MageController controller = this.getController();
        command = command.replace("@_", " ").replace("@spell", this.getSpell().getName()).replace("@pd", mage.getDisplayName()).replace("@pn", mage.getName()).replace("@uuid", mage.getId()).replace("@p", mage.getName());
        if (location != null) {
            command = command.replace("@world", location.getWorld().getName()).replace("@x", Double.toString(location.getX())).replace("@y", Double.toString(location.getY())).replace("@z", Double.toString(location.getZ()));
        }
        if ((targetLocation = this.getTargetLocation()) != null) {
            command = command.replace("@tworld", targetLocation.getWorld().getName()).replace("@tx", Double.toString(targetLocation.getX())).replace("@ty", Double.toString(targetLocation.getY())).replace("@tz", Double.toString(targetLocation.getZ()));
        }
        if ((targetEntity = this.getTargetEntity()) != null) {
            if (controller.isMage(targetEntity)) {
                Mage targetMage = controller.getMage(targetEntity);
                command = command.replace("@td", targetMage.getDisplayName()).replace("@tn", targetMage.getName()).replace("@tuuid", targetMage.getId()).replace("@t", targetMage.getName());
            } else {
                command = command.replace("@td", controller.getEntityDisplayName(targetEntity)).replace("@tn", controller.getEntityName(targetEntity)).replace("@tuuid", targetEntity.getUniqueId().toString()).replace("@t", controller.getEntityName(targetEntity));
            }
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)command);
    }

    @Override
    public void addHandler(ActionHandler handler) {
        if (this.base.handlers == null) {
            this.base.handlers = new ArrayList<ActionHandlerContext>();
        }
        this.base.handlers.add(new ActionHandlerContext(handler, this));
    }

    @Override
    public boolean hasHandlers() {
        return this.handlers != null;
    }

    @Override
    public SpellResult processHandlers() {
        SpellResult result = SpellResult.NO_ACTION;
        if (this.handlers == null) {
            return result;
        }
        if (this.finishedHandlers == null) {
            this.finishedHandlers = new ArrayList<ActionHandlerContext>();
        }
        int startingWork = this.getWorkAllowed();
        int splitWork = Math.max(1, startingWork / this.handlers.size());
        Iterator<ActionHandlerContext> iterator = this.handlers.iterator();
        while (iterator.hasNext()) {
            ActionHandlerContext handler = iterator.next();
            handler.setWorkAllowed(splitWork);
            SpellResult actionResult = handler.perform();
            if (actionResult == SpellResult.PENDING) continue;
            result = result.min(actionResult);
            this.finishedHandlers.add(handler);
            iterator.remove();
        }
        if (this.handlers.isEmpty()) {
            this.handlers = null;
            return result;
        }
        return SpellResult.PENDING;
    }

    @Override
    public void addMessageParameter(String key, String value) {
        this.messageParameters.put(key, value);
    }
}

