/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.item;

import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;

public class ItemData
implements com.elmakers.mine.bukkit.api.item.ItemData {
    private String key;
    private ItemStack item;
    private double worth;
    private Set<String> categories = ImmutableSet.of();
    private String creatorId;
    private String creator;

    public ItemData(ItemStack itemStack) {
        this.item = NMSUtils.getCopy(itemStack);
        this.key = itemStack.getType().toString();
    }

    public ItemData(String materialKey) throws Exception {
        MaterialAndData material = new MaterialAndData(materialKey);
        if (material.isValid()) {
            this.item = material.getItemStack(1);
        }
        if (this.item == null) {
            throw new Exception("Invalid item key: " + materialKey);
        }
        this.key = materialKey;
    }

    public ItemData(String key, ConfigurationSection configuration) throws Exception {
        List<String> categoriesList;
        if (configuration.isItemStack("item")) {
            this.item = configuration.getItemStack("item");
        } else if (configuration.isConfigurationSection("item")) {
            ConfigurationSection itemConfiguration = configuration.getConfigurationSection("item");
            String materialKey = itemConfiguration.getString("type", key);
            MaterialAndData material = new MaterialAndData(materialKey);
            if (material.isValid()) {
                this.item = material.getItemStack(1);
            }
            if (this.item == null) {
                throw new Exception("Invalid item key: " + materialKey);
            }
            ConfigurationSection tagSection = itemConfiguration.getConfigurationSection("tags");
            if (tagSection != null) {
                this.item = CompatibilityUtils.makeReal(this.item);
                InventoryUtils.saveTagsToItem(tagSection, this.item);
            }
        } else {
            String materialKey = configuration.getString("item", key);
            MaterialAndData material = new MaterialAndData(materialKey);
            if (material.isValid()) {
                this.item = material.getItemStack(1);
            }
            if (this.item == null) {
                throw new Exception("Invalid item key: " + materialKey);
            }
        }
        if (this.item == null) {
            throw new Exception("Invalid item configuration: " + key);
        }
        this.key = key;
        this.worth = configuration.getDouble("worth", 0.0);
        this.creator = configuration.getString("creator");
        this.creatorId = configuration.getString("creator_id");
        String customName = configuration.getString("name");
        if (customName != null) {
            ItemMeta meta = this.item.getItemMeta();
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)customName));
            this.item.setItemMeta(meta);
        }
        if ((categoriesList = ConfigurationUtils.getStringList(configuration, "categories")) != null) {
            this.categories = ImmutableSet.copyOf(categoriesList);
        }
    }

    public ItemData(String key, ItemStack item, double worth) throws Exception {
        if (item == null) {
            throw new Exception("Invalid item");
        }
        this.key = key;
        this.item = item;
        this.worth = worth;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public double getWorth() {
        return this.worth;
    }

    @Override
    public Set<String> getCategories() {
        return this.categories;
    }

    @Override
    public ItemStack getItemStack(int amount) {
        ItemStack newItem = InventoryUtils.getCopy(this.item);
        if (newItem == null) {
            return null;
        }
        newItem.setAmount(amount);
        return newItem;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public String getCreatorId() {
        return this.creatorId;
    }

    @Override
    public Material getType() {
        return this.item == null ? Material.AIR : this.item.getType();
    }

    @Override
    public MaterialData getMaterialData() {
        if (this.item == null) {
            return null;
        }
        MaterialData materialData = this.item.getData();
        materialData.setData((byte)this.item.getDurability());
        return materialData;
    }

    @Override
    public ItemMeta getItemMeta() {
        return this.item == null ? null : this.item.getItemMeta();
    }
}

