/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.essentials;

import com.earth2me.essentials.ItemDb;
import com.elmakers.mine.bukkit.api.spell.SpellCategory;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.wand.Wand;
import net.ess3.api.IEssentials;
import org.bukkit.inventory.ItemStack;

public class MagicItemDb
extends ItemDb {
    private final MagicController controller;

    public MagicItemDb(MagicController controller, Object ess) {
        super((IEssentials)ess);
        this.controller = controller;
        this.reloadConfig();
    }

    public ItemStack get(String id) throws Exception {
        if (id.startsWith("m:")) {
            String itemId = id.replace("m:", "");
            return this.controller.createItem(itemId);
        }
        if (id.startsWith("magic:")) {
            String itemId = id.replace("magic:", "");
            return this.controller.createItem(itemId);
        }
        if (id.equals("wand")) {
            Wand wand = Wand.createWand(this.controller, "");
            if (wand != null) {
                return wand.getItem();
            }
        } else if (id.startsWith("wand:")) {
            String wandId = id.replace("wand:", "");
            Wand wand = Wand.createWand(this.controller, wandId.trim());
            if (wand != null) {
                return wand.getItem();
            }
        } else if (id.startsWith("w:")) {
            String wandId = id.replace("w:", "");
            Wand wand = Wand.createWand(this.controller, wandId.trim());
            if (wand != null) {
                return wand.getItem();
            }
        } else if (id.startsWith("book:")) {
            ItemStack bookItem;
            String bookCategory = id.replace("book:", "");
            SpellCategory category = null;
            if (bookCategory.length() > 0 && !bookCategory.equalsIgnoreCase("all")) {
                category = this.controller.getCategory(bookCategory);
            }
            if ((bookItem = this.controller.getSpellBook(category, 1)) != null) {
                return bookItem;
            }
        } else if (id.startsWith("spell:")) {
            String spellKey = id.replace("spell:", "");
            ItemStack itemStack = Wand.createSpellItem(spellKey, this.controller, null, true);
            if (itemStack != null) {
                return itemStack;
            }
        } else if (id.startsWith("s:")) {
            String spellKey = id.replace("s:", "");
            ItemStack itemStack = Wand.createSpellItem(spellKey, this.controller, null, true);
            if (itemStack != null) {
                return itemStack;
            }
        } else if (id.startsWith("brush:")) {
            String brushKey = id.replace("brush:", "");
            ItemStack itemStack = Wand.createBrushItem(brushKey, this.controller, null, true);
            if (itemStack != null) {
                return itemStack;
            }
        } else if (id.startsWith("upgrade:")) {
            String wandId = id.replace("upgrade:", "");
            Wand wand = Wand.createWand(this.controller, wandId.trim());
            if (wand != null) {
                wand.makeUpgrade();
                return wand.getItem();
            }
        } else if (id.startsWith("item:")) {
            String wandId = id.replace("item:", "");
            return this.controller.createItem(wandId);
        }
        return super.get(id);
    }
}

