/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.entity;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.entity.EntityExtraData;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.ItemStack;

public class EntityHorseData
extends EntityExtraData {
    public Horse.Color color;
    public Horse.Style style;
    public ItemStack saddle;
    public ItemStack armor;
    public Integer domestication;
    public Integer maxDomestication;
    public Double jumpStrength;
    public Boolean tamed;

    public EntityHorseData() {
    }

    public EntityHorseData(ConfigurationSection parameters, MageController controller) {
        Logger log = controller.getLogger();
        if (parameters.contains("horse_color")) {
            try {
                String colorString = parameters.getString("horse_color");
                this.color = Horse.Color.valueOf((String)colorString.toUpperCase());
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Invalid horse_color: " + parameters.getString("horse_color"), ex);
            }
        }
        if (parameters.contains("horse_style")) {
            try {
                String styleString = parameters.getString("horse_style");
                this.style = Horse.Style.valueOf((String)styleString.toUpperCase());
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Invalid horse_style: " + parameters.getString("horse_style"), ex);
            }
        }
        if (parameters.contains("horse_jump_strength")) {
            this.jumpStrength = parameters.getDouble("horse_jump_strength");
        }
        if (parameters.contains("tamed")) {
            this.tamed = parameters.getBoolean("tamed");
        }
    }

    public EntityHorseData(Horse horse) {
        this.color = horse.getColor();
        this.style = horse.getStyle();
        this.saddle = horse.getInventory().getSaddle();
        this.armor = horse.getInventory().getArmor();
        this.domestication = horse.getDomestication();
        this.maxDomestication = horse.getMaxDomestication();
        this.jumpStrength = horse.getJumpStrength();
        this.tamed = horse.isTamed();
    }

    @Override
    public void apply(Entity entity) {
        if (!(entity instanceof Horse)) {
            return;
        }
        Horse horse = (Horse)entity;
        horse.getInventory().setSaddle(this.saddle);
        horse.getInventory().setArmor(this.armor);
        if (this.color != null) {
            horse.setColor(this.color);
        }
        if (this.style != null) {
            horse.setStyle(this.style);
        }
        if (this.domestication != null) {
            horse.setDomestication(this.domestication.intValue());
        }
        if (this.maxDomestication != null) {
            horse.setMaxDomestication(this.maxDomestication.intValue());
        }
        if (this.jumpStrength != null) {
            horse.setJumpStrength(this.jumpStrength.doubleValue());
        }
        if (this.tamed != null) {
            horse.setTamed(this.tamed.booleanValue());
        }
    }

    @Override
    public EntityExtraData clone() {
        EntityHorseData copy = new EntityHorseData();
        copy.saddle = this.saddle == null ? null : this.saddle.clone();
        copy.armor = this.armor == null ? null : this.armor.clone();
        copy.color = this.color;
        copy.domestication = this.domestication;
        copy.style = this.style;
        copy.maxDomestication = this.maxDomestication;
        copy.jumpStrength = this.jumpStrength;
        copy.tamed = this.tamed;
        return copy;
    }

    @Override
    public void removed(Entity entity) {
    }
}

