/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.BlockData;
import com.elmakers.mine.bukkit.block.BlockFace;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public class RecurseAction
extends CompoundAction {
    protected int recursionDepth;
    protected List<BlockFace> directions;
    protected Set<MaterialAndData> replaceable = null;
    protected boolean checker;
    protected boolean replace;
    protected Deque<StackEntry> stack;
    protected Set<Long> touched;
    public static final String[] EXAMPLE_DIRECTIONS = new String[]{"cardinal", "all", "plane", "up", "down", "north", "south", "east", "west"};
    private static final List<BlockFace> cardinalDirections = Arrays.asList(BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN);
    private static final List<BlockFace> allDirections = Arrays.asList(BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH_EAST, BlockFace.NORTH_WEST, BlockFace.SOUTH_EAST, BlockFace.SOUTH_WEST, BlockFace.UP_NORTH, BlockFace.UP_EAST, BlockFace.UP_SOUTH, BlockFace.UP_WEST, BlockFace.UP_NORTH_EAST, BlockFace.UP_NORTH_WEST, BlockFace.UP_SOUTH_EAST, BlockFace.UP_SOUTH_WEST, BlockFace.DOWN_NORTH, BlockFace.DOWN_EAST, BlockFace.DOWN_SOUTH, BlockFace.DOWN_WEST, BlockFace.DOWN_NORTH_EAST, BlockFace.DOWN_NORTH_WEST, BlockFace.DOWN_SOUTH_EAST, BlockFace.DOWN_SOUTH_WEST);
    private static final List<BlockFace> planeDirections = Arrays.asList(BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH_EAST, BlockFace.NORTH_WEST, BlockFace.SOUTH_EAST, BlockFace.SOUTH_WEST);

    protected BlockFace getBlockFace(String name) {
        try {
            return BlockFace.valueOf(name.toUpperCase());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected List<BlockFace> getDirections(String name) {
        if (name == null) {
            return null;
        }
        if (name.equalsIgnoreCase("cardinal")) {
            return cardinalDirections;
        }
        if (name.equalsIgnoreCase("all")) {
            return allDirections;
        }
        if (name.equalsIgnoreCase("plane")) {
            return planeDirections;
        }
        BlockFace single = this.getBlockFace(name);
        if (single == null) {
            return null;
        }
        ArrayList<BlockFace> singleSet = new ArrayList<BlockFace>();
        singleSet.add(single);
        return singleSet;
    }

    protected List<BlockFace> getDirections(ConfigurationSection parameters, String key) {
        if (parameters.isString(key)) {
            String name = parameters.getString(key);
            return this.getDirections(name);
        }
        List<String> faceList = ConfigurationUtils.getStringList(parameters, key);
        if (faceList == null) {
            return null;
        }
        ArrayList<BlockFace> faceSet = new ArrayList<BlockFace>();
        for (String face : faceList) {
            faceSet.addAll(this.getDirections(face));
        }
        return faceSet;
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.touched.clear();
        this.stack.clear();
        if (this.checker) {
            this.stack.add(new StackEntry(context.getTargetBlock(), 0));
        } else {
            this.stack.add(new StackEntry(context.getTargetBlock(), -1));
        }
    }

    @Override
    public void finish(CastContext context) {
        super.finish(context);
        this.touched.clear();
        this.stack.clear();
    }

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        this.directions = this.getDirections(parameters, "faces");
        if (this.directions == null) {
            this.directions = cardinalDirections;
        }
        this.replaceable = null;
        this.touched = new HashSet<Long>();
        this.stack = new ArrayDeque<StackEntry>();
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.checker = parameters.getBoolean("checkered", false);
        this.replace = parameters.getBoolean("replace", false);
        this.recursionDepth = parameters.getInt("size", 32);
        this.recursionDepth = parameters.getInt("depth", this.recursionDepth);
        if (this.replace) {
            int i;
            if (this.replaceable == null) {
                this.replaceable = new HashSet<MaterialAndData>();
            }
            Block targetBlock = context.getTargetBlock();
            this.replaceable.clear();
            if (targetBlock == null) {
                return;
            }
            MaterialAndData targetMaterialAndData = new MaterialAndData(targetBlock);
            if (targetMaterialAndData.isValid()) {
                this.replaceable.add(targetMaterialAndData);
            }
            Material targetMaterial = targetBlock.getType();
            if (parameters.getBoolean("auto_water", true) && (targetMaterial == Material.STATIONARY_WATER || targetMaterial == Material.WATER)) {
                for (i = 0; i < 15; i = (int)((byte)(i + 1))) {
                    this.replaceable.add(new MaterialAndData(Material.STATIONARY_WATER, (short)i));
                    this.replaceable.add(new MaterialAndData(Material.WATER, (short)i));
                }
            }
            if (parameters.getBoolean("auto_lava", true) && (targetMaterial == Material.STATIONARY_LAVA || targetMaterial == Material.LAVA)) {
                for (i = 0; i < 15; i = (int)((byte)(i + 1))) {
                    this.replaceable.add(new MaterialAndData(Material.STATIONARY_LAVA, (short)i));
                    this.replaceable.add(new MaterialAndData(Material.LAVA, (short)i));
                }
            }
            if (parameters.getBoolean("auto_snow", true) && targetMaterial == Material.SNOW) {
                for (i = 0; i < 15; i = (int)((byte)(i + 1))) {
                    this.replaceable.add(new MaterialAndData(Material.SNOW, (short)i));
                }
            }
        } else {
            this.replaceable = null;
        }
    }

    @Override
    public boolean next(CastContext context) {
        StackEntry current = this.stack.peek();
        while (!this.stack.isEmpty() && current.face >= this.directions.size()) {
            this.stack.pop();
            current = this.stack.peek();
        }
        return !this.stack.isEmpty();
    }

    @Override
    public SpellResult step(CastContext context) {
        long id;
        int faceIndex;
        StackEntry current = this.stack.peek();
        Block block = current.block;
        if ((faceIndex = current.face++) >= 0) {
            block = this.directions.get(faceIndex).getRelative(block);
        }
        if (this.touched.contains(id = BlockData.getBlockId(block))) {
            return SpellResult.NO_TARGET;
        }
        if (!context.isDestructible(block)) {
            return SpellResult.NO_TARGET;
        }
        if (this.replaceable != null && !this.replaceable.contains(new MaterialAndData(block))) {
            return SpellResult.NO_TARGET;
        }
        if (faceIndex >= 0 && this.stack.size() <= this.recursionDepth) {
            if (this.checker) {
                BlockFace direction = this.directions.get(faceIndex);
                block = direction.getRelative(block);
            }
            this.stack.push(new StackEntry(block));
        }
        this.touched.add(id);
        this.actionContext.setTargetLocation(block.getLocation());
        this.actionContext.playEffects("recurse");
        return this.startActions();
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("depth");
        parameters.add("size");
        parameters.add("faces");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("faces")) {
            examples.addAll(Arrays.asList(EXAMPLE_DIRECTIONS));
        } else if (parameterKey.equals("depth") || parameterKey.equals("size")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public int getActionCount() {
        return this.recursionDepth * super.getActionCount();
    }

    private class StackEntry {
        public Block block;
        public int face;

        public StackEntry(Block block) {
            this.block = block;
            this.face = 0;
        }

        public StackEntry(Block block, int face) {
            this.block = block;
            this.face = face;
        }
    }
}

