/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;

public class MagicRecipe {
    private String outputKey;
    private Material outputType;
    private Material substitue;
    private String outputItemType;
    private boolean disableDefaultRecipe;
    private ShapedRecipe recipe;
    private Map<Character, ItemData> ingredients = new HashMap<Character, ItemData>();
    private final MagicController controller;
    private final String key;
    public static boolean FIRST_REGISTER = true;

    public MagicRecipe(String key, MagicController controller) {
        this.key = key;
        this.controller = controller;
    }

    public boolean load(ConfigurationSection configuration) {
        this.outputKey = configuration.getString("output");
        if (this.outputKey == null) {
            return false;
        }
        this.substitue = ConfigurationUtils.getMaterial(configuration, "substitue", null);
        this.disableDefaultRecipe = configuration.getBoolean("disable_default", false);
        if (this.disableDefaultRecipe) {
            this.controller.getLogger().warning("Recipe " + this.key + " has disable_default: true, ignoring because trying to remove a recipe now throws an error.");
            this.disableDefaultRecipe = false;
        }
        this.outputItemType = configuration.getString("output_type", "item");
        ItemStack item = null;
        if (this.outputItemType.equalsIgnoreCase("wand")) {
            Wand wand;
            Wand wand2 = wand = !this.outputKey.isEmpty() ? this.controller.createWand(this.outputKey) : null;
            if (wand != null) {
                item = wand.getItem();
            } else {
                this.controller.getLogger().warning("Unable to load recipe output wand: " + this.outputKey);
            }
        } else if (this.outputItemType.equalsIgnoreCase("spell")) {
            item = this.controller.createSpellItem(this.outputKey);
        } else if (this.outputItemType.equalsIgnoreCase("brush")) {
            item = this.controller.createBrushItem(this.outputKey);
        } else if (this.outputItemType.equalsIgnoreCase("item")) {
            item = this.controller.createItem(this.outputKey);
        } else {
            return false;
        }
        if (item != null) {
            this.outputType = item.getType();
            ShapedRecipe shaped = CompatibilityUtils.createShapedRecipe((Plugin)this.controller.getPlugin(), this.key, item);
            ArrayList<String> rows = new ArrayList<String>();
            for (int i = 1; i <= 3; ++i) {
                String recipeRow = configuration.getString("row_" + i, "");
                if (recipeRow.length() <= 0) continue;
                rows.add(recipeRow);
            }
            if (rows.size() > 0) {
                shaped = shaped.shape(rows.toArray(new String[0]));
                ConfigurationSection materials = configuration.getConfigurationSection("ingredients");
                if (materials == null) {
                    materials = configuration.getConfigurationSection("materials");
                }
                Set keys = materials.getKeys(false);
                for (String key : keys) {
                    String materialKey = materials.getString(key);
                    ItemData ingredient = this.controller.getOrCreateItemOrWand(materialKey);
                    if (NMSUtils.isLegacy()) {
                        MaterialData material;
                        MaterialData materialData = material = ingredient == null ? null : ingredient.getMaterialData();
                        if (material == null) {
                            this.outputType = null;
                            this.controller.getLogger().warning("Unable to load recipe ingredient " + materialKey);
                            return false;
                        }
                        shaped.setIngredient(key.charAt(0), material);
                    } else {
                        shaped.setIngredient(key.charAt(0), ingredient.getType());
                    }
                    this.ingredients.put(Character.valueOf(key.charAt(0)), ingredient);
                }
                this.recipe = shaped;
            }
        }
        return this.outputType != null;
    }

    public void register(MagicController controller, Plugin plugin) {
        if (FIRST_REGISTER && this.disableDefaultRecipe) {
            Iterator it = plugin.getServer().recipeIterator();
            while (it.hasNext()) {
                Recipe defaultRecipe = (Recipe)it.next();
                if (defaultRecipe == null || defaultRecipe.getResult().getType() != this.outputType || defaultRecipe.getResult().getDurability() != 0) continue;
                plugin.getLogger().info("Disabled default crafting recipe for " + this.outputType);
                it.remove();
            }
        }
        if (this.recipe != null) {
            List existing;
            if (!FIRST_REGISTER && (existing = plugin.getServer().getRecipesFor(this.craft())).size() > 0) {
                return;
            }
            controller.info("Adding crafting recipe for " + this.outputKey);
            try {
                plugin.getServer().addRecipe((Recipe)this.recipe);
            }
            catch (Exception ex) {
                plugin.getLogger().log(Level.WARNING, "Failed to add recipe", ex);
            }
        }
    }

    public Material getOutputType() {
        return this.outputType;
    }

    public Material getSubstitute() {
        return this.substitue;
    }

    @Nullable
    public ItemStack craft() {
        if (this.outputKey == null) {
            return null;
        }
        Object item = this.outputItemType.equalsIgnoreCase("wand") ? (this.outputKey != null && !this.outputKey.isEmpty() ? this.controller.createWand(this.outputKey).getItem() : null) : (this.outputItemType.equalsIgnoreCase("spell") ? this.controller.createSpellItem(this.outputKey) : (this.outputItemType.equalsIgnoreCase("brush") ? this.controller.createBrushItem(this.outputKey) : (this.outputItemType.equalsIgnoreCase("item") ? this.controller.createItem(this.outputKey) : null)));
        return item;
    }

    public MatchType getMatchType(ItemStack[] matrix) {
        ItemStack ingredient;
        int i;
        int height;
        if (this.recipe == null || matrix.length < 4) {
            return MatchType.NONE;
        }
        int width = height = (int)Math.sqrt(matrix.length);
        boolean[] rows = new boolean[width];
        boolean[] columns = new boolean[height];
        block0: for (int matrixRow = 0; matrixRow < height; ++matrixRow) {
            for (int matrixColumn = 0; matrixColumn < width; ++matrixColumn) {
                i = matrixRow * height + matrixColumn;
                ingredient = matrix[i];
                if (ingredient == null || ingredient.getType() == Material.AIR) continue;
                rows[matrixRow] = true;
                continue block0;
            }
        }
        block2: for (int matrixColumn = 0; matrixColumn < width; ++matrixColumn) {
            for (int matrixRow = 0; matrixRow < height; ++matrixRow) {
                i = matrixRow * width + matrixColumn;
                ingredient = matrix[i];
                if (ingredient == null || ingredient.getType() == Material.AIR) continue;
                columns[matrixColumn] = true;
                continue block2;
            }
        }
        String[] shape = this.recipe.getShape();
        if (shape == null || shape.length < 1) {
            return MatchType.NONE;
        }
        int shapeRow = 0;
        for (int matrixRow = 0; matrixRow < height; ++matrixRow) {
            if (!rows[matrixRow]) continue;
            int shapeColumn = 0;
            for (int matrixColumn = 0; matrixColumn < width; ++matrixColumn) {
                if (!columns[matrixColumn]) continue;
                if (shapeRow >= shape.length) {
                    return MatchType.NONE;
                }
                String row = shape[shapeRow];
                char charAt = ' ';
                if (shapeColumn >= row.length()) {
                    return MatchType.NONE;
                }
                charAt = row.charAt(shapeColumn);
                ItemData item = this.ingredients.get(Character.valueOf(charAt));
                int i2 = matrixRow * width + matrixColumn;
                ItemStack ingredient2 = matrix[i2];
                if (ingredient2 != null && ingredient2.getType() == Material.AIR) {
                    ingredient2 = null;
                }
                if (item == null && ingredient2 == null) {
                    ++shapeColumn;
                    continue;
                }
                if (item == null && ingredient2 != null) {
                    return MatchType.NONE;
                }
                if (ingredient2 == null && item != null) {
                    return MatchType.NONE;
                }
                if (ingredient2.getType() != item.getType()) {
                    return MatchType.NONE;
                }
                if (ingredient2.getDurability() != item.getMaterialData().getData()) {
                    return MatchType.NONE;
                }
                ItemMeta meta = item.getItemMeta();
                if (meta != null && !this.controller.itemsAreEqual(ingredient2, item.getItemStack())) {
                    return MatchType.PARTIAL;
                }
                ++shapeColumn;
            }
            ++shapeRow;
        }
        return MatchType.MATCH;
    }

    public String getKey() {
        return this.key;
    }

    public static enum MatchType {
        NONE,
        MATCH,
        PARTIAL;

    }
}

