/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.event.AddSpellEvent;
import com.elmakers.mine.bukkit.api.event.SpellUpgradeEvent;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAttribute;
import com.elmakers.mine.bukkit.api.magic.MagicPropertyType;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.magic.ProgressionPath;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.magic.BaseMagicConfigurable;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.ManaController;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public abstract class CasterProperties
extends BaseMagicConfigurable
implements com.elmakers.mine.bukkit.api.magic.CasterProperties {
    protected static int LEGACY_VERSION = 6;
    protected static int CURRENT_VERSION = 7;
    protected int effectiveManaMax = 0;
    protected int effectiveManaRegeneration = 0;

    public static void setLegacyVersion() {
        CURRENT_VERSION = LEGACY_VERSION;
    }

    public CasterProperties(MagicPropertyType type, MageController controller) {
        super(type, controller);
    }

    public boolean hasOwnMana() {
        MagicPropertyType propertyType = (MagicPropertyType)((Object)this.propertyRoutes.get("mana"));
        return propertyType == null || propertyType == this.type;
    }

    @Override
    public int getManaRegeneration() {
        ManaController manaController = this.controller.getManaController();
        if (manaController != null && this.isPlayer()) {
            return manaController.getManaRegen(this.getPlayer());
        }
        return this.getInt("mana_regeneration", this.getInt("xp_regeneration"));
    }

    @Override
    public int getManaMax() {
        ManaController manaController = this.controller.getManaController();
        if (manaController != null && this.isPlayer()) {
            return manaController.getMaxMana(this.getPlayer());
        }
        return this.getInt("mana_max", this.getInt("xp_max"));
    }

    @Override
    public void setMana(float mana) {
        if (this.isCostFree()) {
            this.setProperty("mana", null);
        } else {
            ManaController manaController = this.controller.getManaController();
            if (manaController != null && this.isPlayer()) {
                manaController.setMana(this.getPlayer(), mana);
                return;
            }
            this.setProperty("mana", Float.valueOf(Math.max(0.0f, mana)));
        }
    }

    @Override
    public void setManaMax(int manaMax) {
        this.setProperty("mana_max", Math.max(0, manaMax));
    }

    @Override
    public void setManaRegeneration(int manaRegeneration) {
        this.setProperty("mana_regeneration", Math.max(0, manaRegeneration));
    }

    @Override
    public float getMana() {
        ManaController manaController = this.controller.getManaController();
        if (manaController != null && this.isPlayer()) {
            return manaController.getMana(this.getPlayer());
        }
        return this.getFloat("mana", this.getFloat("xp"));
    }

    @Override
    public void removeMana(float amount) {
        ManaController manaController = this.controller.getManaController();
        if (manaController != null && this.isPlayer()) {
            manaController.removeMana(this.getPlayer(), amount);
            return;
        }
        this.setMana(this.getMana() - amount);
    }

    public float getManaRegenerationBoost() {
        return this.getFloat("mana_regeneration_boost", this.getFloat("xp_regeneration_boost"));
    }

    public float getManaMaxBoost() {
        return this.getFloat("mana_max_boost", this.getFloat("xp_max_boost"));
    }

    public boolean isCostFree() {
        return this.getFloat("cost_reduction") > 1.0f;
    }

    public boolean isCooldownFree() {
        return this.getFloat("cooldown_reduction") > 1.0f;
    }

    @Override
    public int getEffectiveManaMax() {
        ManaController manaController = this.controller.getManaController();
        if (manaController != null && this.isPlayer()) {
            return manaController.getMaxMana(this.getPlayer());
        }
        return this.effectiveManaMax;
    }

    @Override
    public int getEffectiveManaRegeneration() {
        ManaController manaController = this.controller.getManaController();
        if (manaController != null && this.isPlayer()) {
            return manaController.getManaRegen(this.getPlayer());
        }
        return this.effectiveManaRegeneration;
    }

    protected long getLastManaRegeneration() {
        return this.getLong("mana_timestamp");
    }

    public void passiveEffectsUpdated() {
    }

    public boolean updateMaxMana(Mage mage) {
        if (!this.usesMana()) {
            return false;
        }
        int currentMana = this.effectiveManaMax;
        int currentManaRegen = this.effectiveManaRegeneration;
        this.effectiveManaMax = this.getManaMax();
        this.effectiveManaRegeneration = this.getManaRegeneration();
        if (mage != null && this.getBoolean("boostable", true)) {
            this.effectiveManaMax = (int)((float)this.effectiveManaMax * mage.getManaMaxMultiplier());
            this.effectiveManaRegeneration = (int)((float)this.effectiveManaRegeneration * mage.getManaRegenerationMultiplier());
        }
        return currentMana != this.effectiveManaMax || this.effectiveManaRegeneration != currentManaRegen;
    }

    public boolean usesMana() {
        if (this.isCostFree()) {
            return false;
        }
        return this.getManaMax() > 0;
    }

    public boolean tickMana() {
        boolean updated = false;
        if (this.usesMana() && this.hasOwnMana()) {
            long now = System.currentTimeMillis();
            if (!this.getMage().isManaRegenerationDisabled()) {
                int effectiveManaRegeneration = this.getEffectiveManaRegeneration();
                long lastManaRegeneration = this.getLastManaRegeneration();
                if (lastManaRegeneration > 0L && effectiveManaRegeneration > 0) {
                    long delta = now - lastManaRegeneration;
                    int effectiveManaMax = this.getEffectiveManaMax();
                    int manaMax = this.getManaMax();
                    float mana = this.getMana();
                    if (effectiveManaMax == 0 && manaMax > 0) {
                        effectiveManaMax = manaMax;
                    }
                    this.setMana(Math.min((float)effectiveManaMax, mana + (float)effectiveManaRegeneration * (float)delta / 1000.0f));
                    updated = true;
                }
            }
            this.setProperty("mana_timestamp", now);
        }
        return updated;
    }

    public void tick() {
        this.tickMana();
    }

    @Override
    public boolean setSpelLLevel(String spellKey, int level) {
        BaseMagicConfigurable storage = this.getStorage("spell_levels");
        if (storage != this && storage != null && storage instanceof com.elmakers.mine.bukkit.api.magic.CasterProperties) {
            return ((com.elmakers.mine.bukkit.api.magic.CasterProperties)((Object)storage)).setSpelLLevel(spellKey, level);
        }
        if (!this.hasSpell(spellKey)) {
            return false;
        }
        Map<String, Integer> spellLevels = this.getSpellLevels();
        Integer existingLevel = spellLevels.get(spellKey);
        boolean modified = false;
        if (existingLevel == null || level != existingLevel) {
            modified = true;
            spellLevels.put(spellKey, level);
            this.setProperty("spell_levels", spellLevels);
        }
        return modified;
    }

    @Override
    public boolean addSpell(String spellKey) {
        return this.forceAddSpell(spellKey);
    }

    @Override
    public boolean forceAddSpell(String spellKey) {
        BaseMagicConfigurable storage = this.getStorage("spells");
        if (storage != this && storage != null) {
            return storage.addSpell(spellKey);
        }
        SpellTemplate template = this.controller.getSpellTemplate(spellKey);
        if (template == null) {
            this.controller.getLogger().warning("Tried to add unknown spell: " + spellKey);
            return false;
        }
        spellKey = template.getKey();
        this.preUpdate();
        Collection<String> spells = this.getBaseSpells();
        SpellKey key = new SpellKey(spellKey);
        SpellTemplate currentSpell = this.getSpellTemplate(spellKey);
        boolean modified = spells.add(key.getBaseKey());
        if (modified) {
            this.setProperty("spells", new ArrayList<String>(spells));
        }
        boolean levelModified = false;
        if (key.getLevel() > 1) {
            levelModified = this.upgradeSpellLevel(key.getBaseKey(), key.getLevel());
        }
        if (!modified && !levelModified) {
            return false;
        }
        Collection<SpellKey> spellsToRemove = template.getSpellsToRemove();
        for (SpellKey removeKey : spellsToRemove) {
            this.removeSpell(removeKey.getBaseKey());
        }
        Mage mage = this.getMage();
        if (mage != null) {
            if (currentSpell != null) {
                String levelDescription = template.getLevelDescription();
                if (levelDescription == null || levelDescription.isEmpty()) {
                    levelDescription = template.getName();
                }
                this.sendLevelMessage("spell_upgraded", currentSpell.getName(), levelDescription);
                String upgradeDescription = template.getUpgradeDescription().replace("$name", currentSpell.getName());
                if (!upgradeDescription.isEmpty()) {
                    mage.sendMessage(this.controller.getMessages().get("spell.upgrade_description_prefix"), upgradeDescription);
                }
                if (!mage.isLoading()) {
                    SpellUpgradeEvent upgradeEvent = new SpellUpgradeEvent(mage, this.getWand(), currentSpell, template);
                    Bukkit.getPluginManager().callEvent((Event)upgradeEvent);
                }
            } else {
                if (mage.getActiveGUI() == null) {
                    this.sendAddMessage("spell_added", template.getName());
                }
                if (!mage.isLoading()) {
                    AddSpellEvent addEvent = new AddSpellEvent(mage, this.getWand(), template);
                    Bukkit.getPluginManager().callEvent((Event)addEvent);
                }
            }
        }
        this.updated();
        return true;
    }

    @Override
    public boolean addBrush(String brushKey) {
        BaseMagicConfigurable storage = this.getStorage("brushes");
        if (storage != this && storage != null) {
            return storage.addBrush(brushKey);
        }
        this.preUpdate();
        Collection brushes = this.getBrushes();
        boolean modified = brushes.add(brushKey);
        if (modified) {
            this.setProperty("brushes", new ArrayList(brushes));
        }
        Mage mage = this.getMage();
        if (modified && mage != null) {
            Messages messages = this.controller.getMessages();
            String materialName = MaterialBrush.getMaterialName(messages, brushKey);
            if (materialName == null) {
                mage.getController().getLogger().warning("Invalid material: " + brushKey);
                materialName = brushKey;
            }
            this.sendAddMessage("brush_added", materialName);
        }
        if (modified) {
            this.updated();
        }
        return modified;
    }

    public boolean removeSpell(String spellKey) {
        this.preUpdate();
        Collection<String> spells = this.getBaseSpells();
        SpellKey key = new SpellKey(spellKey);
        boolean modified = spells.remove(key.getBaseKey());
        if (modified) {
            this.setProperty("spells", new ArrayList<String>(spells));
            Map<String, Integer> spellLevels = this.getSpellLevels();
            if (spellLevels.remove(key.getBaseKey()) != null) {
                this.setProperty("spell_levels", spellLevels);
            }
            this.updated();
        }
        return modified;
    }

    public boolean removeBrush(String brushKey) {
        this.preUpdate();
        Collection brushes = this.getBrushes();
        boolean modified = brushes.remove(brushKey);
        if (modified) {
            this.setProperty("brushes", new ArrayList(brushes));
            this.updated();
        }
        return modified;
    }

    @Override
    public int getSpellLevel(String spellKey) {
        Map<String, Integer> spellLevels = this.getSpellLevels();
        Integer level = spellLevels.get(spellKey);
        return level == null ? 1 : level;
    }

    @Override
    @Nullable
    public SpellTemplate getSpellTemplate(String spellKey) {
        SpellKey key = new SpellKey(spellKey);
        Collection<String> spells = this.getBaseSpells();
        if (!spells.contains(key.getBaseKey())) {
            return null;
        }
        SpellKey baseKey = new SpellKey(key.getBaseKey(), this.getSpellLevel(key.getBaseKey()));
        return this.controller.getSpellTemplate(baseKey.getKey());
    }

    public void updateMana() {
    }

    @Override
    public boolean hasSpell(String key) {
        SpellKey spellKey = new SpellKey(key);
        if (!this.getBaseSpells().contains(spellKey.getBaseKey())) {
            return false;
        }
        int level = this.getSpellLevel(spellKey.getBaseKey());
        return level >= spellKey.getLevel();
    }

    public Collection<String> getBaseSpells() {
        Object existingSpells = this.getObject("spells");
        HashSet<String> spells = new HashSet<String>();
        if (existingSpells != null) {
            if (!(existingSpells instanceof List)) {
                this.controller.getLogger().warning("Spell list in " + (Object)((Object)this.type) + " is " + existingSpells.getClass().getName() + ", expected List");
            } else {
                List existingList = (List)existingSpells;
                spells.addAll(existingList);
            }
        }
        return spells;
    }

    public Set<String> getSpells() {
        HashSet<String> spellSet = new HashSet<String>();
        Collection<String> spells = this.getBaseSpells();
        Map<String, Integer> spellLevels = this.getSpellLevels();
        for (String key : spells) {
            Integer level = spellLevels.get(key);
            if (level != null) {
                spellSet.add(new SpellKey(key, level).getKey());
                continue;
            }
            spellSet.add(key);
        }
        return spellSet;
    }

    @Override
    @Nullable
    public Spell getSpell(String spellKey) {
        Mage mage = this.getMage();
        if (mage == null) {
            return null;
        }
        SpellKey key = new SpellKey(spellKey);
        spellKey = key.getBaseKey();
        Collection spells = this.getSpells();
        if (!spells.contains(spellKey)) {
            return null;
        }
        Map<String, Integer> spellLevels = this.getSpellLevels();
        Integer level = spellLevels.get(spellKey);
        if (level != null) {
            spellKey = new SpellKey(spellKey, level).getKey();
        }
        return mage.getSpell(spellKey);
    }

    public Set<String> getBrushes() {
        Object existingBrushes = this.getObject("brushes");
        HashSet<String> brushes = new HashSet<String>();
        if (existingBrushes != null) {
            if (!(existingBrushes instanceof List)) {
                this.controller.getLogger().warning("Brush list in " + (Object)((Object)this.type) + " is " + existingBrushes.getClass().getName() + ", expected List");
            } else {
                List existingList = (List)existingBrushes;
                brushes.addAll(existingList);
            }
        }
        return brushes;
    }

    @Override
    @Nullable
    public ProgressionPath getPath() {
        String pathKey = this.getString("path");
        if (pathKey != null && !pathKey.isEmpty()) {
            return this.controller.getPath(pathKey);
        }
        return null;
    }

    @Override
    public void setPath(String path) {
        this.setProperty("path", path);
    }

    @Override
    public boolean canProgress() {
        ProgressionPath path = this.getPath();
        return path != null && path.canProgress(this);
    }

    protected float stackPassiveProperty(float property, float stackProperty) {
        boolean stack = this.getBoolean("stack");
        if (!stack && stackProperty != 0.0f) {
            property = Math.max(property, stackProperty);
        }
        return property;
    }

    @Override
    protected boolean upgradeInternal(String key, Object value) {
        if (key.equals("path")) {
            ProgressionPath path = this.getPath();
            if (path != null && path.hasPath(value.toString())) {
                return false;
            }
            this.setProperty(key, value);
            return true;
        }
        return super.upgradeInternal(key, value);
    }

    @Override
    @Nullable
    public Double getAttribute(String attributeKey) {
        MagicAttribute defaultSetting;
        Double value;
        ConfigurationSection attributes = this.getConfigurationSection("attributes");
        Double d = value = attributes == null || !attributes.contains(attributeKey) ? null : Double.valueOf(attributes.getDouble(attributeKey));
        if (value == null && (defaultSetting = this.controller.getAttribute(attributeKey)) != null) {
            value = defaultSetting.getDefault();
        }
        return value;
    }

    @Override
    public void setAttribute(String attributeKey, Double attributeValue) {
        this.preUpdate();
        ConfigurationSection attributes = this.getConfigurationSection("attributes");
        if (attributes == null) {
            if (attributeValue == null) {
                return;
            }
            attributes = new MemoryConfiguration();
        }
        attributes.set(attributeKey, (Object)attributeValue);
        this.setProperty("attributes", attributes);
        Mage mage = this.getMage();
        if (mage != null) {
            mage.attributesUpdated();
        }
        this.updated();
    }

    protected void cleanUpgradeConfig(ConfigurationSection upgradeConfig) {
        upgradeConfig.set("id", null);
        upgradeConfig.set("indestructible", null);
        upgradeConfig.set("upgrade", null);
        upgradeConfig.set("icon", null);
        upgradeConfig.set("upgrade_icon", null);
        upgradeConfig.set("template", null);
        upgradeConfig.set("description", null);
        upgradeConfig.set("name", null);
    }

    @Override
    public boolean add(com.elmakers.mine.bukkit.api.wand.Wand wandUpgrade) {
        if (!(wandUpgrade instanceof Wand)) {
            return false;
        }
        Wand wand = (Wand)wandUpgrade;
        ConfigurationSection upgradeConfig = ConfigurationUtils.cloneConfiguration(wand.getEffectiveConfiguration());
        this.cleanUpgradeConfig(upgradeConfig);
        return this.upgrade(upgradeConfig);
    }

    @Override
    public boolean addItem(ItemStack item) {
        Integer sp;
        Mage mage;
        if (Wand.isSpell(item) && !Wand.isSkill(item)) {
            String spell = Wand.getSpell(item);
            SpellKey spellKey = new SpellKey(spell);
            Map<String, Integer> spellLevels = this.getSpellLevels();
            Integer currentLevel = spellLevels.get(spellKey.getBaseKey());
            if ((currentLevel == null || currentLevel < spellKey.getLevel()) && this.addSpell(spell)) {
                return true;
            }
        } else if (Wand.isBrush(item)) {
            String materialKey = Wand.getBrush(item);
            Collection materials = this.getBrushes();
            if (!materials.contains(materialKey) && this.addBrush(materialKey)) {
                return true;
            }
        } else if (Wand.isUpgrade(item)) {
            Wand wand = this.controller.getWand(item);
            return this.add(wand);
        }
        if ((mage = this.getMage()) != null && !mage.isAtMaxSkillPoints() && this.controller.skillPointItemsEnabled() && (sp = Wand.getSP(item)) != null) {
            int amount = (int)Math.floor(mage.getEarnMultiplier() * (float)sp.intValue() * (float)item.getAmount());
            mage.addSkillPoints(amount);
            return true;
        }
        return false;
    }

    protected void sendLevelMessage(String messageKey, String nameParam, String level) {
        Mage mage = this.getMage();
        if (mage == null || nameParam == null || nameParam.isEmpty()) {
            return;
        }
        String message = this.getMessage(messageKey).replace("$name", nameParam).replace("$level", level);
        mage.sendMessage(message);
    }

    @Override
    protected void sendAddMessage(String messageKey, String nameParam) {
        Mage mage = this.getMage();
        if (mage == null || nameParam == null || nameParam.isEmpty()) {
            return;
        }
        String message = this.getMessage(messageKey).replace("$name", nameParam);
        mage.sendMessage(message);
    }

    @Override
    protected void sendMessage(String messageKey) {
        Mage mage = this.getMage();
        if (mage == null || messageKey == null || messageKey.isEmpty()) {
            return;
        }
        mage.sendMessage(this.getMessage(messageKey));
    }

    @Override
    protected void sendDebug(String debugMessage) {
        Mage mage = this.getMage();
        if (mage != null) {
            mage.sendDebugMessage(debugMessage);
        }
    }

    @Nullable
    protected Wand getWand() {
        return null;
    }

    public abstract boolean isPlayer();

    @Nullable
    public abstract Player getPlayer();

    @Override
    @Nullable
    public abstract Mage getMage();

    @Override
    public MageController getController() {
        return this.controller;
    }

    protected void migrateBrushes(ConfigurationSection configuration) {
        Object brushesRaw;
        Object brushInventoryRaw = configuration.get("brush_inventory");
        if (brushInventoryRaw != null) {
            Map<String, Object> brushInventory = null;
            HashMap<String, Integer> newBrushInventory = new HashMap<String, Integer>();
            if (brushInventoryRaw instanceof Map) {
                brushInventory = (Map<String, Object>)brushInventoryRaw;
            } else if (brushInventoryRaw instanceof ConfigurationSection) {
                brushInventory = NMSUtils.getMap((ConfigurationSection)brushInventoryRaw);
            }
            if (brushInventory != null) {
                for (Map.Entry<String, Object> brushEntry : brushInventory.entrySet()) {
                    Object slot = brushEntry.getValue();
                    if (slot == null || !(slot instanceof Integer)) continue;
                    String materialKey = brushEntry.getKey();
                    materialKey = CompatibilityUtils.migrateMaterial(materialKey);
                    newBrushInventory.put(materialKey, (Integer)slot);
                }
                configuration.set("brush_inventory", newBrushInventory);
            }
        }
        if ((brushesRaw = this.getObject("brushes", this.getObject("materials"))) != null) {
            List<String> brushes = null;
            if (brushesRaw instanceof String) {
                String[] brushNames = StringUtils.split((String)((String)brushesRaw), (char)',');
                brushes = Arrays.asList(brushNames);
            } else if (brushesRaw instanceof Collection) {
                brushes = (List<String>)brushesRaw;
            }
            if (brushes != null) {
                configuration.set("brushes", new ArrayList<String>(brushes));
            }
        }
    }

    protected void migrate(int version, ConfigurationSection configuratoin) {
        if (version <= 6) {
            this.migrateBrushes(configuratoin);
        }
        configuratoin.set("version", (Object)CURRENT_VERSION);
    }

    @Override
    public void load(@Nullable ConfigurationSection configuration) {
        int version = configuration.getInt("version", 0);
        if (version < CURRENT_VERSION) {
            this.migrate(version, configuration);
        }
        super.load(configuration);
    }

    @Override
    public boolean upgradesAllowed() {
        return true;
    }

    @Override
    public boolean checkAndUpgrade(boolean quiet) {
        ProgressionPath nextPath;
        ProgressionPath path = this.getPath();
        ProgressionPath progressionPath = nextPath = path != null ? path.getNextPath() : null;
        if (nextPath == null) {
            return true;
        }
        if (this.canProgress()) {
            return true;
        }
        if (!path.checkUpgradeRequirements(this.getWand(), quiet ? null : this.getMage())) {
            return false;
        }
        path.upgrade(this.getMage(), this.getWand());
        return true;
    }
}

