/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.entity;

import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.entity.EntityExtraData;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;

public class EntityFallingBlockData
extends EntityExtraData {
    @Nullable
    private com.elmakers.mine.bukkit.api.block.MaterialAndData material;
    private boolean dropItems;
    private boolean hurtEntities;

    private EntityFallingBlockData(com.elmakers.mine.bukkit.api.block.MaterialAndData material) {
        this.material = material;
    }

    public EntityFallingBlockData(ConfigurationSection configuration) {
        this.material = ConfigurationUtils.getMaterialAndData(configuration, "material");
        this.dropItems = configuration.getBoolean("drop_items", false);
        this.hurtEntities = configuration.getBoolean("hurt_entities", true);
    }

    public EntityFallingBlockData(FallingBlock fallingBlock) {
        byte data = NMSUtils.getBlockData(fallingBlock);
        this.material = new MaterialAndData(fallingBlock.getMaterial(), data);
        fallingBlock.setDropItem(this.dropItems);
        fallingBlock.setHurtEntities(this.hurtEntities);
    }

    @Override
    public void apply(Entity entity) {
    }

    @Override
    public EntityExtraData clone() {
        EntityFallingBlockData copy = new EntityFallingBlockData(this.material);
        return copy;
    }

    public void setMaterialAndData(@Nonnull com.elmakers.mine.bukkit.api.block.MaterialAndData material) {
        this.material = material;
    }

    @Nullable
    public com.elmakers.mine.bukkit.api.block.MaterialAndData getMaterialAndData() {
        return this.material;
    }

    @Nullable
    public Material getMaterial() {
        return this.material == null ? null : this.material.getMaterial();
    }

    public byte getData() {
        if (this.material == null) {
            return 0;
        }
        Byte data = this.material.getBlockData();
        return data == null ? (byte)0 : data;
    }
}

