/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.batch.Batch;
import com.elmakers.mine.bukkit.api.batch.SpellBatch;
import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.data.SpellData;
import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.event.CastEvent;
import com.elmakers.mine.bukkit.api.event.EarnEvent;
import com.elmakers.mine.bukkit.api.event.PreCastEvent;
import com.elmakers.mine.bukkit.api.event.StartCastEvent;
import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.magic.MaterialSetManager;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.magic.ProgressionPath;
import com.elmakers.mine.bukkit.api.magic.Trigger;
import com.elmakers.mine.bukkit.api.magic.VariableScope;
import com.elmakers.mine.bukkit.api.requirements.Requirement;
import com.elmakers.mine.bukkit.api.spell.CooldownReducer;
import com.elmakers.mine.bukkit.api.spell.CostReducer;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.PrerequisiteSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellCategory;
import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.spell.TargetType;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.item.Cost;
import com.elmakers.mine.bukkit.magic.MageClass;
import com.elmakers.mine.bukkit.magic.SpellParameters;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationStore;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationTransform;
import com.elmakers.mine.bukkit.spell.CastingCost;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class BaseSpell
implements MageSpell,
Cloneable {
    public static String DEFAULT_DISABLED_ICON_URL = "";
    public static Material DEFAULT_SPELL_ICON = Material.STICK;
    protected static final double LOOK_THRESHOLD = 0.98;
    protected static final int MIN_Y = 1;
    protected static final Material DEFAULT_EFFECT_MATERIAL = Material.WATER;
    public static final String[] EXAMPLE_VECTOR_COMPONENTS = new String[]{"-1", "-0.5", "0", "0.5", "1", "~-1", "~-0.5", "~0", "~0.5", "*1", "*-1", "*-0.5", "*0.5", "*1"};
    public static final String[] EXAMPLE_SIZES = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "12", "16", "32", "64"};
    public static final String[] EXAMPLE_INTEGERS = new String[]{"-10", "-5", "-1", "1", "5", "10"};
    public static final String[] EXAMPLE_BOOLEANS = new String[]{"true", "false"};
    public static final String[] EXAMPLE_DURATIONS = new String[]{"500", "1000", "2000", "5000", "10000", "60000", "120000"};
    public static final String[] EXAMPLE_PERCENTAGES = new String[]{"0", "0.1", "0.25", "0.5", "0.75", "1"};
    public static final String[] OTHER_PARAMETERS = new String[]{"transparent", "target", "target_type", "range", "duration", "player"};
    public static final String[] WORLD_PARAMETERS = new String[]{"pworld", "tworld", "otworld", "t2world"};
    protected static final Set<String> worldParameterMap = new HashSet<String>(Arrays.asList(WORLD_PARAMETERS));
    public static final String[] VECTOR_PARAMETERS = new String[]{"px", "py", "pz", "pdx", "pdy", "pdz", "tx", "ty", "tz", "otx", "oty", "otz", "t2x", "t2y", "t2z", "otdx", "otdy", "otdz"};
    protected static final Set<String> vectorParameterMap = new HashSet<String>(Arrays.asList(VECTOR_PARAMETERS));
    public static final String[] BOOLEAN_PARAMETERS = new String[]{"allow_max_range", "prevent_passthrough", "reverse_targeting", "passthrough", "bypass_protection", "bypass", "bypass_build", "bypass_break", "bypass_pvp", "target_npc", "ignore_blocks", "target_self", "disable_mana_regeneration"};
    protected static final Set<String> booleanParameterMap = new HashSet<String>(Arrays.asList(BOOLEAN_PARAMETERS));
    public static final String[] PERCENTAGE_PARAMETERS = new String[]{"fizzle_chance", "backfire_chance", "cooldown_reduction"};
    protected static final Set<String> percentageParameterMap = new HashSet<String>(Arrays.asList(PERCENTAGE_PARAMETERS));
    public static final String[] COMMON_PARAMETERS = (String[])ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])VECTOR_PARAMETERS, (Object[])BOOLEAN_PARAMETERS), (Object[])OTHER_PARAMETERS), (Object[])WORLD_PARAMETERS), (Object[])PERCENTAGE_PARAMETERS);
    protected MageController controller;
    protected Mage mage;
    protected MageClass mageClass;
    protected Location location;
    protected com.elmakers.mine.bukkit.action.CastContext currentCast;
    protected UndoList toggleUndo;
    private SpellKey spellKey;
    private SpellData spellData;
    private String inheritKey;
    private String name;
    private String alias;
    private String description;
    private String extendedDescription;
    private String levelDescription;
    private String progressDescription;
    private String upgradeDescription;
    private String usage;
    private String creatorId;
    private String creatorName;
    private Cost cost;
    private Cost earns;
    private Color color;
    private String particle;
    private SpellCategory category;
    private Set<String> tags;
    private BaseSpell template;
    private long requiredUpgradeCasts;
    private String requiredUpgradePath;
    private Set<String> requiredUpgradeTags;
    private Collection<PrerequisiteSpell> requiredSpells;
    private List<SpellKey> removesSpells;
    private MaterialAndData icon = null;
    private MaterialAndData disabledIcon = null;
    private String iconURL = null;
    private String iconDisabledURL = null;
    protected Set<EntityType> friendlyEntityTypes = null;
    private double requiredHealth;
    private List<com.elmakers.mine.bukkit.api.spell.CastingCost> costs = null;
    private List<com.elmakers.mine.bukkit.api.spell.CastingCost> activeCosts = null;
    private List<Trigger> triggers = null;
    private Collection<ConfigurationSection> variablesList;
    private ConfigurationSection variablesSection;
    protected double cancelOnDamage = 0.0;
    protected boolean cancelOnDeath = false;
    protected boolean cancelOnCastOther = false;
    protected boolean cancelOnNoPermission = false;
    protected boolean cancelOnNoWand = false;
    protected boolean creativeRestricted = false;
    protected boolean pvpRestricted = false;
    protected boolean disguiseRestricted = false;
    protected boolean worldBorderRestricted = true;
    protected boolean glideRestricted = false;
    protected boolean glideExclusive = false;
    protected boolean usesBrushSelection = false;
    protected boolean bypassFriendlyFire = false;
    protected boolean onlyFriendlyFire = false;
    protected boolean bypassPvpRestriction = false;
    protected boolean bypassBuildRestriction = false;
    protected boolean bypassBreakRestriction = false;
    protected boolean bypassProtection = false;
    protected boolean bypassConfusion = true;
    protected boolean bypassWeakness = true;
    protected boolean bypassPermissions = false;
    protected boolean bypassRegionPermission = false;
    protected boolean ignoreRegionOverrides = false;
    protected boolean castOnNoTarget = true;
    protected boolean refundOnNoTarget = false;
    protected boolean bypassDeactivate = false;
    protected boolean bypassAll = false;
    protected boolean quiet = false;
    protected boolean loud = false;
    protected ToggleType toggle = ToggleType.NONE;
    protected boolean disableManaRegeneration = false;
    protected boolean messageTargets = true;
    protected boolean targetSelf = false;
    protected boolean showUndoable = true;
    protected boolean cancellable = true;
    protected boolean quickCast = false;
    protected boolean cancelEffects = false;
    protected boolean commandBlockAllowed = true;
    protected int verticalSearchDistance = 8;
    private boolean backfired = false;
    private boolean hidden = false;
    private boolean passive = false;
    private boolean toggleable = true;
    protected ConfigurationSection progressLevels = null;
    protected ConfigurationSection progressLevelParameters = null;
    protected SpellParameters parameters;
    protected ConfigurationSection workingParameters = null;
    protected ConfigurationSection configuration = null;
    protected Collection<Requirement> requirements = null;
    protected static Random random = new Random();
    private long requiredCastsPerLevel = 0L;
    private long maxLevels = 0L;
    private Map<String, EquationTransform> progressLevelEquations = new HashMap<String, EquationTransform>();
    private float cooldownReduction = 0.0f;
    private float costReduction = 0.0f;
    private float consumeReduction = 0.0f;
    private boolean bypassMageCooldown = false;
    private boolean bypassCooldown = false;
    private int mageCooldown = 0;
    private int cooldown = 0;
    private int displayCooldown = -1;
    private int warmup = 0;
    private int earnCooldown = 0;
    private int duration = 0;
    private int totalDuration = -1;
    private long lastActiveCost = 0L;
    private float activeCostScale = 1.0f;
    private Map<String, Collection<EffectPlayer>> effects = new HashMap<String, Collection<EffectPlayer>>();
    private float fizzleChance = 0.0f;
    private float backfireChance = 0.0f;
    private long lastMessageSent = 0L;
    private MaterialSet preventPassThroughMaterials = null;
    private MaterialSet passthroughMaterials = null;
    private MaterialSet unsafeMaterials = null;
    private Mage reducerMage = null;
    private Wand reducerWand = null;

    @Deprecated
    public boolean allowPassThrough(Material mat) {
        if (this.mage != null && this.mage.isSuperPowered()) {
            return true;
        }
        if (this.passthroughMaterials != null && this.passthroughMaterials.testMaterial(mat)) {
            return true;
        }
        return this.preventPassThroughMaterials == null || !this.preventPassThroughMaterials.testMaterial(mat);
    }

    public boolean allowPassThrough(Block block) {
        if (this.mage != null && this.mage.isSuperPowered()) {
            return true;
        }
        if (this.passthroughMaterials != null && this.passthroughMaterials.testBlock(block)) {
            return true;
        }
        return this.preventPassThroughMaterials == null || !this.preventPassThroughMaterials.testBlock(block);
    }

    @Deprecated
    public boolean isPassthrough(Material mat) {
        return this.passthroughMaterials != null && this.passthroughMaterials.testMaterial(mat);
    }

    public boolean isPassthrough(Block block) {
        return this.passthroughMaterials != null && this.passthroughMaterials.testBlock(block);
    }

    @Deprecated
    public boolean isOkToStandIn(Material mat) {
        if (this.isHalfBlock(mat)) {
            return false;
        }
        return this.passthroughMaterials.testMaterial(mat) && !this.unsafeMaterials.testMaterial(mat);
    }

    public boolean isOkToStandIn(Block block) {
        if (this.isHalfBlock(block.getType())) {
            return false;
        }
        return this.passthroughMaterials.testBlock(block) && !this.unsafeMaterials.testBlock(block);
    }

    public boolean isWater(Material mat) {
        return DefaultMaterials.isWater(mat);
    }

    public boolean isOkToStandOn(Block block) {
        return this.isOkToStandOn(block.getType());
    }

    @Deprecated
    public boolean isOkToStandOn(Material mat) {
        if (this.isHalfBlock(mat)) {
            return true;
        }
        return mat != Material.AIR && !this.unsafeMaterials.testMaterial(mat) && !this.passthroughMaterials.testMaterial(mat);
    }

    protected boolean isHalfBlock(Material mat) {
        return DefaultMaterials.isHalfBlock(mat);
    }

    public boolean isSafeLocation(Block block) {
        if (!block.getChunk().isLoaded()) {
            block.getChunk().load(true);
            return false;
        }
        if (block.getY() > CompatibilityUtils.getMaxHeight(block.getWorld())) {
            return false;
        }
        Block blockOneUp = block.getRelative(BlockFace.UP);
        Block blockOneDown = block.getRelative(BlockFace.DOWN);
        if (this.isUnderwater() && this.isWater(blockOneDown.getType()) && blockOneUp.getType() == Material.AIR && block.getType() == Material.AIR) {
            return true;
        }
        Player player = this.mage.getPlayer();
        return (this.isOkToStandOn(blockOneDown) || player != null && player.isFlying()) && this.isOkToStandIn(blockOneUp) && this.isOkToStandIn(block);
    }

    public boolean isSafeLocation(Location loc) {
        return this.isSafeLocation(loc.getBlock());
    }

    @Nullable
    public Location tryFindPlaceToStand(Location targetLoc) {
        int maxHeight = CompatibilityUtils.getMaxHeight(targetLoc.getWorld());
        return this.tryFindPlaceToStand(targetLoc, maxHeight, maxHeight);
    }

    @Nullable
    public Location tryFindPlaceToStand(Location targetLoc, int maxDownDelta, int maxUpDelta) {
        Location location = this.findPlaceToStand(targetLoc, maxDownDelta, maxUpDelta);
        return location == null ? targetLoc : location;
    }

    @Nullable
    public Location findPlaceToStand(Location targetLoc) {
        return this.findPlaceToStand(targetLoc, this.verticalSearchDistance, this.verticalSearchDistance);
    }

    @Nullable
    public Location findPlaceToStand(Location targetLoc, int maxDownDelta, int maxUpDelta) {
        int targetY;
        if (!targetLoc.getBlock().getChunk().isLoaded()) {
            return null;
        }
        int minY = 1;
        int maxY = CompatibilityUtils.getMaxHeight(targetLoc.getWorld());
        if (this.isHalfBlock(targetLoc.getBlock().getType())) {
            targetLoc.setY(Math.floor(targetLoc.getY() + 1.0));
        }
        if ((targetY = targetLoc.getBlockY()) >= minY && targetY <= maxY && this.isSafeLocation(targetLoc)) {
            return this.checkForHalfBlock(targetLoc);
        }
        Location location = null;
        if (targetY < minY) {
            location = targetLoc.clone();
            location.setY((double)minY);
            location = this.findPlaceToStand(location, true, maxUpDelta);
        } else if (targetY > maxY) {
            location = targetLoc.clone();
            location.setY((double)maxY);
            location = this.findPlaceToStand(location, false, maxDownDelta);
        } else {
            int testMaxY = Math.min(maxUpDelta, 3);
            location = this.findPlaceToStand(targetLoc, true, testMaxY);
            if (location == null) {
                int testMinY = Math.min(maxDownDelta, 4);
                location = this.findPlaceToStand(targetLoc, false, testMinY);
            }
            if (location == null) {
                location = this.findPlaceToStand(targetLoc, true, maxUpDelta);
            }
            if (location == null) {
                location = this.findPlaceToStand(targetLoc, false, maxDownDelta);
            }
        }
        return location;
    }

    @Nullable
    public Location findPlaceToStand(Location target, boolean goUp) {
        return this.findPlaceToStand(target, goUp, this.verticalSearchDistance);
    }

    @Nullable
    public Location findPlaceToStand(Location target, boolean goUp, int maxDelta) {
        int direction = goUp ? 1 : -1;
        Location targetLocation = target.clone();
        boolean minY = true;
        int maxY = CompatibilityUtils.getMaxHeight(targetLocation.getWorld());
        for (int yDelta = 0; (double)minY <= targetLocation.getY() && targetLocation.getY() <= (double)maxY && yDelta < maxDelta; ++yDelta) {
            Block block = targetLocation.getBlock();
            if (!this.allowPassThrough(block)) {
                return null;
            }
            if (this.isSafeLocation(block)) {
                return this.checkForHalfBlock(targetLocation);
            }
            targetLocation.setY(targetLocation.getY() + (double)direction);
        }
        return null;
    }

    protected Location checkForHalfBlock(Location location) {
        Block downBlock = location.getBlock().getRelative(BlockFace.DOWN);
        Material material = downBlock.getType();
        if (this.isHalfBlock(material)) {
            location.setY(location.getY() - 0.5);
        }
        return location;
    }

    @Nullable
    public Block getPlayerBlock() {
        Location location = this.getLocation();
        if (location == null) {
            return null;
        }
        return location.getBlock().getRelative(BlockFace.DOWN);
    }

    public BlockFace getPlayerFacing() {
        return BaseSpell.getFacing(this.getLocation());
    }

    public static BlockFace getFacing(Location location) {
        float playerRot;
        for (playerRot = location.getYaw(); playerRot < 0.0f; playerRot += 360.0f) {
        }
        while (playerRot > 360.0f) {
            playerRot -= 360.0f;
        }
        BlockFace direction = BlockFace.NORTH;
        if (playerRot <= 45.0f || playerRot > 315.0f) {
            direction = BlockFace.SOUTH;
        } else if (playerRot > 45.0f && playerRot <= 135.0f) {
            direction = BlockFace.WEST;
        } else if (playerRot > 135.0f && playerRot <= 225.0f) {
            direction = BlockFace.NORTH;
        } else if (playerRot > 225.0f && playerRot <= 315.0f) {
            direction = BlockFace.EAST;
        }
        return direction;
    }

    @Override
    public void castMessage(String message) {
        Wand activeWand = this.mage.getActiveWand();
        if (!this.loud && activeWand != null && !activeWand.showCastMessages()) {
            return;
        }
        if (!this.quiet && this.canSendMessage() && message != null && message.length() > 0) {
            this.mage.castMessage(message);
            this.lastMessageSent = System.currentTimeMillis();
        }
    }

    @Override
    public void sendMessage(String message) {
        Wand activeWand = this.mage.getActiveWand();
        if (!this.loud && activeWand != null && !activeWand.showMessages()) {
            return;
        }
        if (!this.quiet && message != null && message.length() > 0) {
            this.mage.sendMessage(message);
            this.lastMessageSent = System.currentTimeMillis();
        }
    }

    @Override
    @Nullable
    public Location getLocation() {
        if (this.location != null) {
            return this.location.clone();
        }
        if (this.mage != null) {
            return this.mage.getLocation();
        }
        return null;
    }

    @Nullable
    public Location getWandLocation() {
        if (this.location != null) {
            return this.location.clone();
        }
        return this.mage.getWandLocation();
    }

    @Nullable
    public Location getCastLocation() {
        if (this.location != null) {
            return this.location.clone();
        }
        return this.mage.getCastLocation();
    }

    @Override
    public Location getEyeLocation() {
        if (this.location != null) {
            return this.location.clone();
        }
        return this.mage.getEyeLocation();
    }

    @Override
    public Vector getDirection() {
        if (this.location == null) {
            return this.mage.getDirection();
        }
        return this.location.getDirection();
    }

    public boolean isLookingUp() {
        Vector direction = this.getDirection();
        if (direction == null) {
            return false;
        }
        return direction.getY() > 0.98;
    }

    public boolean isLookingDown() {
        Vector direction = this.getDirection();
        if (direction == null) {
            return false;
        }
        return direction.getY() < -0.98;
    }

    @Nullable
    public World getWorld() {
        Location location = this.getLocation();
        if (location != null) {
            return location.getWorld();
        }
        return null;
    }

    public boolean isUnderwater() {
        Block playerBlock = this.getPlayerBlock();
        if (playerBlock == null) {
            return false;
        }
        playerBlock = playerBlock.getRelative(BlockFace.UP);
        Block eyeBlock = playerBlock.getRelative(BlockFace.UP);
        return this.isWater(playerBlock.getType()) && this.isWater(eyeBlock.getType());
    }

    @Nullable
    protected String getBlockSkin(Material blockType) {
        return this.controller.getBlockSkin(blockType);
    }

    @Nullable
    protected String getMobSkin(EntityType mobType) {
        return this.controller.getMobSkin(mobType);
    }

    public static Collection<PotionEffect> getPotionEffects(ConfigurationSection parameters) {
        return BaseSpell.getPotionEffects(parameters, null);
    }

    public static Collection<PotionEffect> getPotionEffects(ConfigurationSection parameters, Integer duration) {
        return BaseSpell.getPotionEffects(parameters, duration, true, true);
    }

    public static Collection<PotionEffect> getPotionEffects(ConfigurationSection parameters, Integer duration, boolean ambient, boolean particles) {
        PotionEffectType[] effectTypes;
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (PotionEffectType effectType : effectTypes = PotionEffectType.values()) {
            String parameterName;
            if (effectType == null || !parameters.contains(parameterName = "effect_" + effectType.getName().toLowerCase())) continue;
            String value = parameters.getString(parameterName);
            int ticks = 10;
            int power = 1;
            try {
                if (value.contains(",")) {
                    String[] pieces = StringUtils.split((String)value, (char)',');
                    ticks = (int)Float.parseFloat(pieces[0]);
                    power = (int)Float.parseFloat(pieces[1]);
                } else {
                    power = (int)Float.parseFloat(value);
                    if (duration != null) {
                        ticks = duration / 50;
                    }
                }
            }
            catch (Exception ex) {
                Bukkit.getLogger().warning("Error parsing potion effect for " + effectType + ": " + value);
            }
            PotionEffect effect = new PotionEffect(effectType, ticks, power, ambient, particles);
            effects.add(effect);
        }
        return effects;
    }

    public boolean isInCircle(int x, int z, int r) {
        return x * x + z * z - r * r <= 0;
    }

    private boolean canSendMessage() {
        if (this.lastMessageSent == 0L) {
            return true;
        }
        int throttle = this.controller.getMessageThrottle();
        long now = System.currentTimeMillis();
        return this.lastMessageSent < now - (long)throttle;
    }

    protected Location getEffectLocation() {
        return this.getEyeLocation();
    }

    @Override
    public boolean hasBrushOverride() {
        return false;
    }

    @Override
    public boolean usesBrush() {
        return false;
    }

    @Override
    public boolean usesBrushSelection() {
        return (this.usesBrushSelection || this.usesBrush()) && !this.hasBrushOverride();
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public boolean isScheduledUndo() {
        return false;
    }

    public void checkActiveCosts() {
        if (this.activeCosts == null) {
            return;
        }
        long now = System.currentTimeMillis();
        this.activeCostScale = (float)((double)(now - this.lastActiveCost) / 1000.0);
        this.lastActiveCost = now;
        CooldownReducer caster = null;
        if (this.currentCast != null && (caster = this.currentCast.getWand()) == null) {
            caster = this.currentCast.getMageClass();
        }
        for (com.elmakers.mine.bukkit.api.spell.CastingCost cost : this.activeCosts) {
            if (!cost.has(this.mage, (CasterProperties)((Object)caster), (CostReducer)this)) {
                this.deactivate();
                break;
            }
            cost.deduct(this.mage, (CasterProperties)((Object)caster), (CostReducer)this);
        }
        this.activeCostScale = 1.0f;
    }

    public void checkActiveDuration() {
        if (this.duration > 0 && this.spellData.getLastCast() < System.currentTimeMillis() - (long)this.duration) {
            this.deactivate();
        }
    }

    @Nullable
    protected List<com.elmakers.mine.bukkit.api.spell.CastingCost> parseCosts(ConfigurationSection node) {
        if (node == null) {
            return null;
        }
        ArrayList<com.elmakers.mine.bukkit.api.spell.CastingCost> castingCosts = new ArrayList<com.elmakers.mine.bukkit.api.spell.CastingCost>();
        Set costKeys = node.getKeys(false);
        for (String key : costKeys) {
            castingCosts.add(new CastingCost(this.controller, key, node.getInt(key, 1)));
        }
        return castingCosts;
    }

    @Override
    public void loadTemplate(String key, ConfigurationSection node) {
        this.spellKey = new SpellKey(key);
        MemoryConfiguration castVariables = new MemoryConfiguration();
        MemoryConfiguration mageVariables = new MemoryConfiguration();
        this.parameters = new SpellParameters((MageSpell)this, (ConfigurationSection)mageVariables, (ConfigurationSection)castVariables);
        this.configuration = node;
        this.loadTemplate(node, this.parameters);
    }

    protected void loadTemplate(ConfigurationSection node, SpellParameters parameters) {
        this.variablesList = ConfigurationUtils.getNodeList(node, "variables");
        this.variablesSection = node.getConfigurationSection("variables");
        this.initializeVariables(parameters);
        this.loadTemplate(node);
    }

    protected void loadTemplate(ConfigurationSection node) {
        Collection<ConfigurationSection> requirementConfigurations;
        String baseKey = this.spellKey.getBaseKey();
        this.name = this.controller.getMessages().get("spells." + baseKey + ".name", baseKey);
        this.description = this.controller.getMessages().get("spells." + baseKey + ".description", "");
        this.extendedDescription = this.controller.getMessages().get("spells." + baseKey + ".extended_description", "");
        this.usage = this.controller.getMessages().get("spells." + baseKey + ".usage", "");
        this.creatorName = node.getString("creator");
        this.creatorId = node.getString("creator_id");
        this.requiredUpgradePath = node.getString("upgrade_required_path");
        if (this.requiredUpgradePath != null && this.requiredUpgradePath.isEmpty()) {
            this.requiredUpgradePath = null;
        }
        this.requiredUpgradeCasts = node.getLong("upgrade_required_casts");
        List<String> pathTags = ConfigurationUtils.getStringList(node, "upgrade_required_path_tags");
        this.requiredUpgradeTags = pathTags == null || pathTags.isEmpty() ? null : new HashSet<String>(pathTags);
        this.requiredSpells = new ArrayList<PrerequisiteSpell>();
        List<String> removesSpellKeys = ConfigurationUtils.getStringList(node, "removes_spells");
        if (removesSpellKeys != null) {
            this.removesSpells = new ArrayList<SpellKey>(removesSpellKeys.size());
            for (String key : removesSpellKeys) {
                this.removesSpells.add(new SpellKey(key));
            }
        } else {
            this.removesSpells = new ArrayList<SpellKey>(0);
        }
        this.inheritKey = node.getString("inherit");
        this.progressDescription = this.controller.getMessages().get("spell.progress_description", this.progressDescription);
        this.levelDescription = this.controller.getMessages().get("spells." + baseKey + ".level_description", this.levelDescription);
        this.progressDescription = this.controller.getMessages().get("spells." + baseKey + ".progress_description", this.progressDescription);
        this.upgradeDescription = this.controller.getMessages().get("spells." + baseKey + ".upgrade_description", this.upgradeDescription);
        if (this.spellKey.isVariant()) {
            this.levelDescription = this.controller.getMessages().get("spell.level_description", this.levelDescription);
            String variantKey = this.spellKey.getKey();
            this.name = this.controller.getMessages().get("spells." + variantKey + ".name", this.name);
            this.description = this.controller.getMessages().get("spells." + variantKey + ".description", this.description);
            this.extendedDescription = this.controller.getMessages().get("spells." + variantKey + ".extended_description", this.extendedDescription);
            this.usage = this.controller.getMessages().get("spells." + variantKey + ".usage", this.usage);
            this.levelDescription = this.controller.getMessages().get("spells." + variantKey + ".level_description", this.levelDescription);
            this.progressDescription = this.controller.getMessages().get("spells." + variantKey + ".progress_description", this.progressDescription);
            this.upgradeDescription = this.controller.getMessages().get("spells." + variantKey + ".upgrade_description", this.upgradeDescription);
        }
        this.name = node.getString("name", this.name);
        this.alias = node.getString("alias", "");
        this.extendedDescription = node.getString("extended_description", this.extendedDescription);
        this.description = node.getString("description", this.description);
        this.levelDescription = node.getString("level_description", this.levelDescription);
        this.progressDescription = node.getString("progress_description", this.progressDescription);
        if (this.levelDescription != null && !this.levelDescription.isEmpty()) {
            this.levelDescription = this.levelDescription.replace("$level", Integer.toString(this.spellKey.getLevel()));
        }
        this.icon = this.loadIcon(node.getString("icon"));
        this.disabledIcon = this.loadIcon(node.getString("icon_disabled"));
        this.iconURL = node.getString("icon_url");
        this.iconDisabledURL = node.getString("icon_disabled_url");
        if (this.icon == null && (this.iconURL == null || this.iconURL.isEmpty())) {
            this.icon = new com.elmakers.mine.bukkit.block.MaterialAndData(DEFAULT_SPELL_ICON);
        }
        this.color = ConfigurationUtils.getColor(node, "color", null);
        if (node.contains("worth_sp")) {
            double worth = node.getDouble("worth_sp", 0.0) * this.controller.getWorthSkillPoints();
            this.cost = new Cost(this.controller, "sp", worth);
        } else {
            String costType = node.getString("worth_type", "sp");
            this.cost = Cost.parseCost(this.controller, node.getString("worth"), costType);
        }
        int spEarns = node.getInt("earns_sp", 0);
        if (spEarns > 0) {
            this.earns = new Cost(this.controller, "sp", spEarns);
        } else {
            String earnsType = node.getString("earns_type", "sp");
            this.earns = Cost.parseCost(this.controller, node.getString("earns"), earnsType);
        }
        this.earnCooldown = node.getInt("earns_cooldown", 0);
        this.category = this.controller.getCategory(node.getString("category"));
        List<String> tagList = ConfigurationUtils.getStringList(node, "tags");
        this.tags = tagList != null ? new HashSet<String>(tagList) : null;
        this.requiredHealth = node.getDouble("require_health_percentage", 0.0);
        this.costs = this.parseCosts(node.getConfigurationSection("costs"));
        this.activeCosts = this.parseCosts(node.getConfigurationSection("active_costs"));
        this.pvpRestricted = node.getBoolean("pvp_restricted", false);
        this.quickCast = node.getBoolean("quick_cast", false);
        this.passive = node.getBoolean("passive", false);
        this.toggleable = node.getBoolean("toggleable", true);
        this.disguiseRestricted = node.getBoolean("disguise_restricted", false);
        this.creativeRestricted = node.getBoolean("creative_restricted", false);
        this.glideRestricted = node.getBoolean("glide_restricted", false);
        this.glideExclusive = node.getBoolean("glide_exclusive", false);
        this.worldBorderRestricted = node.getBoolean("world_border_restricted", false);
        this.usesBrushSelection = node.getBoolean("brush_selection", false);
        this.castOnNoTarget = node.getBoolean("cast_on_no_target", true);
        this.refundOnNoTarget = node.getBoolean("refund_on_no_target", false);
        this.hidden = node.getBoolean("hidden", false);
        this.showUndoable = node.getBoolean("show_undoable", true);
        this.cancellable = node.getBoolean("cancellable", true);
        this.cancelEffects = node.getBoolean("cancel_effects", false);
        this.disableManaRegeneration = node.getBoolean("disable_mana_regeneration", false);
        String toggleString = node.getString("toggle", "NONE");
        try {
            this.toggle = ToggleType.valueOf(toggleString.toUpperCase());
        }
        catch (Exception ex) {
            this.controller.getLogger().warning("Invalid toggle type: " + toggleString);
        }
        Collection<ConfigurationSection> triggersConfiguration = ConfigurationUtils.getNodeList(node, "triggers");
        if (triggersConfiguration != null) {
            this.triggers = new ArrayList<Trigger>();
            for (ConfigurationSection triggerConfiguration : triggersConfiguration) {
                this.triggers.add(new Trigger(this.controller, triggerConfiguration));
            }
        }
        if ((requirementConfigurations = ConfigurationUtils.getNodeList(node, "requirements")) != null) {
            this.requirements = new ArrayList<Requirement>();
            for (ConfigurationSection configurationSection : requirementConfigurations) {
                this.requirements.add(new Requirement(configurationSection));
            }
        }
        this.progressLevels = node.getConfigurationSection("progress_levels");
        if (this.progressLevels != null) {
            this.requiredCastsPerLevel = this.progressLevels.getLong("required_casts_per_level");
            this.maxLevels = this.progressLevels.getLong("max_levels");
            if (this.requiredCastsPerLevel <= 0L && this.maxLevels > 0L) {
                if (this.requiredUpgradeCasts <= 0L) {
                    this.maxLevels = 0L;
                } else {
                    this.requiredCastsPerLevel = this.requiredUpgradeCasts / this.maxLevels;
                }
            }
            this.progressLevelParameters = this.progressLevels.getConfigurationSection("parameters");
            if (this.progressLevelParameters != null) {
                Set keys = this.progressLevelParameters.getKeys(true);
                this.progressLevelEquations = new HashMap<String, EquationTransform>(keys.size());
                for (String key : keys) {
                    if (!this.progressLevelParameters.isString(key)) continue;
                    String value = this.progressLevelParameters.getString(key, "");
                    this.progressLevelEquations.put(key, EquationStore.getInstance().getTransform(value));
                }
            }
        }
        this.parameters.wrap(node.getConfigurationSection("parameters"));
        this.updateTemplateParameters();
        this.effects.clear();
        ConfigurationSection effectsNode = node.getConfigurationSection("effects");
        if (effectsNode != null) {
            Set set = effectsNode.getKeys(false);
            for (String effectKey : set) {
                if (effectsNode.isString(effectKey)) {
                    String referenceKey = effectsNode.getString(effectKey);
                    if (this.effects.containsKey(referenceKey)) {
                        this.effects.put(effectKey, new ArrayList<EffectPlayer>(this.effects.get(referenceKey)));
                        continue;
                    }
                    this.effects.put(effectKey, this.controller.getEffects(referenceKey));
                    continue;
                }
                this.effects.put(effectKey, this.controller.loadEffects(effectsNode, effectKey));
            }
        } else if (node.contains("effects")) {
            this.controller.getLogger().warning("Invalid effects section in spell " + this.getKey() + ", did you forget to add cast: ?");
        }
    }

    @Nullable
    private MaterialAndData loadIcon(String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        ItemData itemData = this.controller.getOrCreateItem(key);
        return itemData == null ? null : itemData.getMaterialAndData();
    }

    @Override
    public void loadPrerequisites(ConfigurationSection node) {
        this.requiredSpells.addAll(ConfigurationUtils.getPrerequisiteSpells(this.controller, node, "required_spells", "spell " + this.getKey(), true));
    }

    protected void preCast() {
    }

    protected void reset() {
        Location mageLocation;
        Location location = mageLocation = this.mage != null ? this.mage.getLocation() : null;
        if (this.location != null && mageLocation != null) {
            this.location.setPitch(mageLocation.getPitch());
            this.location.setYaw(mageLocation.getYaw());
        }
        this.backfired = false;
        if (!this.spellData.isActive()) {
            this.currentCast = null;
        }
    }

    @Override
    public boolean cast(@Nullable String[] extraParameters, @Nullable Location defaultLocation) {
        MemoryConfiguration parameters = null;
        if (extraParameters != null && extraParameters.length > 0) {
            parameters = new MemoryConfiguration();
            ConfigurationUtils.addParameters(extraParameters, (ConfigurationSection)parameters);
        }
        return this.cast((ConfigurationSection)parameters, defaultLocation);
    }

    @Override
    public boolean cast(@Nullable ConfigurationSection parameters) {
        return this.cast(parameters, null);
    }

    @Override
    public boolean cast(@Nullable ConfigurationSection extraParameters, @Nullable Location defaultLocation) {
        double healthPercentage;
        LivingEntity li;
        CommandSender sender;
        Set<String> overrides;
        Set keys;
        if (this.mage.isPlayer() && this.mage.getPlayer().getGameMode() == GameMode.SPECTATOR) {
            if (this.mage.getDebugLevel() > 0 && extraParameters != null) {
                this.mage.sendDebugMessage("Cannot cast in spectator mode.");
            }
            return false;
        }
        if (this.toggle != ToggleType.NONE && this.isActive()) {
            this.mage.sendDebugMessage(ChatColor.DARK_BLUE + "Deactivating " + ChatColor.GOLD + this.getName());
            this.deactivate(true, true);
            this.processResult(SpellResult.DEACTIVATE, (ConfigurationSection)this.parameters);
            return true;
        }
        if (this.mage.getDebugLevel() > 5 && extraParameters != null && (keys = extraParameters.getKeys(false)).size() > 0) {
            this.mage.sendDebugMessage(ChatColor.BLUE + "Cast " + ChatColor.GOLD + this.getName() + " " + ChatColor.GREEN + ConfigurationUtils.getParameters(extraParameters));
        }
        this.reset();
        Location location = this.mage.getLocation();
        if (location != null && (overrides = this.controller.getSpellOverrides(this.mage, location)) != null && !overrides.isEmpty()) {
            if (extraParameters == null) {
                extraParameters = new MemoryConfiguration();
            }
            for (String entry : overrides) {
                String fullKey;
                String[] key;
                String[] pieces = StringUtils.split((String)entry, (char)' ');
                if (pieces.length < 2 || (key = StringUtils.split((String)(fullKey = pieces[0]), (char)'.')).length == 0 || key.length == 2 && !key[0].equals("default") && !key[0].equals(this.spellKey.getBaseKey()) && !key[0].equals(this.spellKey.getKey())) continue;
                fullKey = key.length == 2 ? key[1] : key[0];
                ConfigurationUtils.set(extraParameters, fullKey, pieces[1]);
            }
        }
        if (this.currentCast == null) {
            this.getCurrentCast();
        }
        this.location = defaultLocation;
        this.workingParameters = new SpellParameters((MageSpell)this, this.currentCast);
        ConfigurationUtils.addConfigurations(this.workingParameters, (ConfigurationSection)this.parameters);
        ConfigurationUtils.addConfigurations(this.workingParameters, extraParameters);
        this.currentCast.setWorkingParameters(this.workingParameters);
        this.initializeVariables((SpellParameters)this.workingParameters);
        this.processParameters(this.workingParameters);
        if (!this.commandBlockAllowed && (sender = this.mage.getCommandSender()) != null && sender instanceof BlockCommandSender) {
            Block block = this.mage.getLocation().getBlock();
            if (DefaultMaterials.isCommand(block.getType())) {
                block.setType(Material.AIR);
            }
            return false;
        }
        PreCastEvent preCast = new PreCastEvent(this.mage, this);
        Bukkit.getPluginManager().callEvent((Event)preCast);
        if (preCast.isCancelled()) {
            this.processResult(SpellResult.CANCELLED, this.workingParameters);
            this.sendCastMessage(SpellResult.CANCELLED, " (no cast)");
            return false;
        }
        this.bypassConfusion = this.workingParameters.getBoolean("bypass_confusion", this.bypassConfusion);
        this.bypassWeakness = this.workingParameters.getBoolean("bypass_weakness", this.bypassWeakness);
        LivingEntity livingEntity = this.mage.getLivingEntity();
        if (livingEntity != null && !this.mage.isSuperPowered()) {
            if (!this.bypassConfusion && livingEntity.hasPotionEffect(PotionEffectType.CONFUSION)) {
                this.processResult(SpellResult.CURSED, this.workingParameters);
                this.sendCastMessage(SpellResult.CURSED, " (no cast)");
                return false;
            }
            if (!this.bypassWeakness && livingEntity.hasPotionEffect(PotionEffectType.WEAKNESS)) {
                this.processResult(SpellResult.CURSED, this.workingParameters);
                this.sendCastMessage(SpellResult.CURSED, " (no cast)");
                return false;
            }
        }
        if (!this.canCast(this.getLocation())) {
            this.processResult(SpellResult.INSUFFICIENT_PERMISSION, this.workingParameters);
            if (this.creativeRestricted && this.mage.isPlayer() && this.mage.getPlayer().getGameMode() == GameMode.CREATIVE) {
                String creativeMessage = this.getMessage("creative_fail");
                this.mage.sendMessage(creativeMessage);
            } else {
                this.sendCastMessage(SpellResult.INSUFFICIENT_PERMISSION, " (no cast)");
            }
            if (this.mage.getDebugLevel() > 1) {
                CommandSender messageTarget = this.mage.getDebugger();
                if (messageTarget == null) {
                    messageTarget = this.mage.getCommandSender();
                }
                if (messageTarget != null) {
                    this.mage.debugPermissions(messageTarget, this);
                }
            }
            return false;
        }
        this.preCast();
        this.bypassPvpRestriction = this.workingParameters.getBoolean("bypass_pvp", false);
        this.bypassPvpRestriction = this.workingParameters.getBoolean("bp", this.bypassPvpRestriction);
        this.bypassPermissions = this.workingParameters.getBoolean("bypass_permissions", this.bypassPermissions);
        this.bypassFriendlyFire = this.workingParameters.getBoolean("bypass_friendly_fire", false);
        this.onlyFriendlyFire = this.workingParameters.getBoolean("only_friendly", false);
        this.cooldown = this.workingParameters.getInt("cooldown", this.cooldown);
        this.cooldown = this.workingParameters.getInt("cool", this.cooldown);
        this.mageCooldown = this.workingParameters.getInt("cooldown_mage", this.mageCooldown);
        this.color = ConfigurationUtils.getColor(this.workingParameters, "color", this.color);
        this.particle = this.workingParameters.getString("particle", null);
        long cooldownRemaining = this.getRemainingCooldown();
        String timeDescription = "";
        if (cooldownRemaining > 0L) {
            timeDescription = this.controller.getMessages().getTimeDescription(cooldownRemaining, "wait", "cooldown");
            this.castMessage(this.getMessage("cooldown").replace("$time", timeDescription));
            this.processResult(SpellResult.COOLDOWN, this.workingParameters);
            this.sendCastMessage(SpellResult.COOLDOWN, " (no cast)");
            return false;
        }
        com.elmakers.mine.bukkit.api.spell.CastingCost required = this.getRequiredCost();
        if (required != null) {
            String baseMessage = this.getMessage("insufficient_resources");
            String costDescription = required.getDescription(this.controller.getMessages(), this.mage);
            if (required.isItem()) {
                this.sendMessage(baseMessage.replace("$cost", costDescription));
            } else {
                this.castMessage(baseMessage.replace("$cost", costDescription));
            }
            this.processResult(SpellResult.INSUFFICIENT_RESOURCES, this.workingParameters);
            this.sendCastMessage(SpellResult.INSUFFICIENT_RESOURCES, " (no cast)");
            return false;
        }
        if (this.requiredHealth > 0.0 && (li = this.mage.getLivingEntity()) != null && (healthPercentage = 100.0 * li.getHealth() / CompatibilityUtils.getMaxHealth((Damageable)li)) < this.requiredHealth) {
            this.processResult(SpellResult.INSUFFICIENT_RESOURCES, this.workingParameters);
            this.sendCastMessage(SpellResult.INSUFFICIENT_RESOURCES, " (no cast)");
            return false;
        }
        if (this.controller.isSpellProgressionEnabled()) {
            long progressLevel = this.getProgressLevel();
            for (Map.Entry<String, EquationTransform> entry : this.progressLevelEquations.entrySet()) {
                this.workingParameters.set(entry.getKey(), (Object)entry.getValue().get((double)progressLevel));
            }
        }
        if (!this.passive) {
            Iterator<Batch> iterator = this.mage.getPendingBatches().iterator();
            while (iterator.hasNext()) {
                SpellBatch spellBatch;
                Spell spell;
                Batch batch = iterator.next();
                if (!(batch instanceof SpellBatch) || !(spell = (spellBatch = (SpellBatch)batch).getSpell()).cancelOnCastOther()) continue;
                spell.cancel();
                batch.finish();
                iterator.remove();
            }
        }
        return this.finalizeCast(this.workingParameters);
    }

    @Override
    public boolean cast() {
        return this.cast((ConfigurationSection)null, null);
    }

    @Override
    public boolean cast(String[] extraParameters) {
        return this.cast(extraParameters, null);
    }

    public void initializeVariables(SpellParameters parameters) {
        block4: {
            block3: {
                if (this.variablesSection == null) break block3;
                ConfigurationSection variables = parameters.getVariables(VariableScope.CAST);
                if (variables == null) break block4;
                Set keys = this.variablesSection.getKeys(false);
                for (String variable : keys) {
                    if (variables.contains(variable)) continue;
                    variables.set(variable, this.variablesSection.get(variable));
                }
                break block4;
            }
            if (this.variablesList != null && !this.variablesList.isEmpty()) {
                for (ConfigurationSection variableConfig : this.variablesList) {
                    String variable;
                    VariableScope scope = ConfigurationUtils.parseScope(variableConfig.getString("scope"), VariableScope.CAST, this.controller.getLogger());
                    ConfigurationSection variables = parameters.getVariables(scope);
                    if (variables == null || variables.contains(variable = variableConfig.getString("variable"))) continue;
                    variables.set(variable, variableConfig.get("value"));
                }
            }
        }
    }

    @Override
    public long getProgressLevel() {
        if (this.requiredCastsPerLevel == 0L) {
            return 1L;
        }
        return Math.min(this.getCastCount() / this.requiredCastsPerLevel + 1L, this.maxLevels);
    }

    @Override
    public long getMaxProgressLevel() {
        return this.maxLevels;
    }

    private long getPreviousCastProgressLevel() {
        return Math.min(Math.max(this.getCastCount() - 1L, 0L) / this.requiredCastsPerLevel + 1L, this.maxLevels);
    }

    @Override
    public boolean canCast(Location location) {
        Boolean personalPermission;
        Boolean regionPermission;
        if (this.bypassAll) {
            return true;
        }
        if (!this.hasCastPermission(this.mage.getCommandSender())) {
            return false;
        }
        Entity entity = this.mage.getEntity();
        if (this.disguiseRestricted && entity != null && entity instanceof Player && this.controller.isDisguised(entity)) {
            return false;
        }
        if (this.glideRestricted && entity != null && entity instanceof LivingEntity && ((LivingEntity)entity).isGliding()) {
            return false;
        }
        if (this.glideExclusive && entity != null && entity instanceof LivingEntity && !((LivingEntity)entity).isGliding()) {
            return false;
        }
        if (this.creativeRestricted && entity != null && entity instanceof Player && ((Player)entity).getGameMode() == GameMode.CREATIVE) {
            return false;
        }
        if (location == null) {
            return true;
        }
        Boolean bl = regionPermission = this.bypassRegionPermission ? null : this.controller.getRegionCastPermission(this.mage.getPlayer(), this, location);
        if (regionPermission != null && !this.ignoreRegionOverrides && regionPermission.booleanValue()) {
            return true;
        }
        Boolean bl2 = personalPermission = this.bypassRegionPermission ? null : this.controller.getPersonalCastPermission(this.mage.getPlayer(), this, location);
        if (personalPermission != null && !this.ignoreRegionOverrides && personalPermission.booleanValue()) {
            return true;
        }
        if (regionPermission != null && !regionPermission.booleanValue()) {
            return false;
        }
        if (this.requiresBuildPermission() && !this.hasBuildPermission(location.getBlock())) {
            return false;
        }
        if (this.requiresBreakPermission() && !this.hasBreakPermission(location.getBlock())) {
            return false;
        }
        if (this.worldBorderRestricted) {
            WorldBorder border = location.getWorld().getWorldBorder();
            double borderSize = border.getSize() / 2.0 - (double)border.getWarningDistance();
            Location offset = location.clone().subtract(border.getCenter());
            if (offset.getX() < -borderSize || offset.getX() > borderSize || offset.getZ() < -borderSize || offset.getZ() > borderSize) {
                return false;
            }
        }
        return !this.pvpRestricted || this.bypassPvpRestriction || this.mage.isPVPAllowed(location);
    }

    @Override
    public boolean isPvpRestricted() {
        return this.pvpRestricted && !this.bypassPvpRestriction;
    }

    @Override
    public boolean isDisguiseRestricted() {
        return this.disguiseRestricted;
    }

    @Override
    public boolean requiresBuildPermission() {
        return false;
    }

    @Override
    public boolean requiresBreakPermission() {
        return false;
    }

    public boolean hasBreakPermission(Location location) {
        if (location == null) {
            return true;
        }
        return this.hasBreakPermission(location.getBlock());
    }

    public boolean hasBreakPermission(Block block) {
        if (this.bypassBuildRestriction || this.bypassRegionPermission || this.bypassAll) {
            return true;
        }
        if (!this.ignoreRegionOverrides) {
            Boolean castPermission = this.controller.getRegionCastPermission(this.mage.getPlayer(), this, block.getLocation());
            if (castPermission != null && castPermission.booleanValue()) {
                return true;
            }
            if (castPermission != null && !castPermission.booleanValue()) {
                return false;
            }
        }
        return this.mage.hasBreakPermission(block);
    }

    public boolean hasBuildPermission(Location location) {
        if (location == null) {
            return true;
        }
        return this.hasBuildPermission(location.getBlock());
    }

    public boolean hasBuildPermission(Block block) {
        if (this.bypassBuildRestriction || this.bypassRegionPermission || this.bypassAll) {
            return true;
        }
        if (!this.ignoreRegionOverrides) {
            Boolean castPermission = this.controller.getRegionCastPermission(this.mage.getPlayer(), this, block.getLocation());
            if (castPermission != null && castPermission.booleanValue()) {
                return true;
            }
            if (castPermission != null && !castPermission.booleanValue()) {
                return false;
            }
        }
        return this.mage.hasBuildPermission(block);
    }

    protected void onBackfire() {
    }

    protected void backfire() {
        if (!this.backfired) {
            this.onBackfire();
        }
        this.backfired = true;
    }

    protected boolean finalizeCast(ConfigurationSection parameters) {
        Entity targetEntity;
        LivingEntity sourceEntity;
        SpellResult result = null;
        this.controller.disablePhysics(parameters.getInt("disable_physics", 0));
        if (!this.mage.isSuperPowered()) {
            if (this.backfireChance > 0.0f && random.nextDouble() < (double)this.backfireChance) {
                this.backfire();
            } else if (this.fizzleChance > 0.0f && random.nextDouble() < (double)this.fizzleChance) {
                result = SpellResult.FIZZLE;
            }
        }
        if (result == null) {
            result = this.onCast(parameters);
        }
        if (this.backfired) {
            result = SpellResult.BACKFIRE;
        }
        if (result == SpellResult.CAST && (sourceEntity = this.mage.getLivingEntity()) == (targetEntity = this.getTargetEntity())) {
            result = SpellResult.CAST_SELF;
        }
        this.processResult(result, parameters);
        boolean success = result.isSuccess(this.castOnNoTarget);
        boolean free = result.isFree(this.castOnNoTarget);
        if (!free) {
            if (this.costs != null && !this.mage.isCostFree()) {
                UndoList undoList = this.currentCast.getUndoList();
                for (com.elmakers.mine.bukkit.api.spell.CastingCost cost : this.costs) {
                    if (undoList != null && cost.isItem() && this.currentCast != null) {
                        undoList.setConsumed(true);
                    }
                    cost.use(this);
                }
            }
            if (this.toggle == ToggleType.NONE) {
                this.updateCooldown();
            }
        }
        if (success && this.toggle != ToggleType.NONE) {
            this.activate();
        }
        StartCastEvent castEvent = new StartCastEvent(this.mage, this, result, success);
        Bukkit.getPluginManager().callEvent((Event)castEvent);
        this.sendCastMessage(result, " (" + success + ")");
        return success;
    }

    protected void updateCooldown() {
        int reducedCooldown;
        Wand wand = this.currentCast != null ? this.currentCast.getWand() : null;
        boolean isCooldownFree = wand != null ? wand.isCooldownFree() : this.mage.isCooldownFree();
        double cooldownReduction = wand != null ? (double)wand.getCooldownReduction() : (double)this.mage.getCooldownReduction();
        cooldownReduction += (double)this.cooldownReduction;
        this.spellData.setLastCast(System.currentTimeMillis());
        if (!isCooldownFree && !this.bypassCooldown && this.cooldown > 0 && cooldownReduction < 1.0) {
            reducedCooldown = (int)Math.ceil((1.0 - cooldownReduction) * (double)this.cooldown);
            this.spellData.setCooldownExpiration(Math.max(this.spellData.getCooldownExpiration(), System.currentTimeMillis() + (long)reducedCooldown));
        }
        if (!isCooldownFree && this.mageCooldown > 0 && cooldownReduction < 1.0 && !this.bypassMageCooldown) {
            reducedCooldown = (int)Math.ceil((1.0 - cooldownReduction) * (double)this.mageCooldown);
            this.mage.setRemainingCooldown(reducedCooldown);
        }
    }

    protected void sendCastMessage(SpellResult result, String message) {
        Location source = this.getEyeLocation();
        if (this.mage == null || source == null) {
            return;
        }
        this.mage.sendDebugMessage(ChatColor.WHITE + "Cast " + ChatColor.GOLD + this.getName() + ChatColor.WHITE + " from " + ChatColor.GRAY + source.getBlockX() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + source.getBlockY() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + source.getBlockZ() + ChatColor.WHITE + ": " + ChatColor.AQUA + result.name().toLowerCase() + ChatColor.DARK_AQUA + message);
    }

    @Override
    public String getMessage(String messageKey) {
        return this.getMessage(messageKey, "");
    }

    public String getMessage(String messageKey, String def) {
        String message = this.controller.getMessages().get("spells.default." + messageKey, def);
        if (this.inheritKey != null && !this.inheritKey.isEmpty()) {
            message = this.controller.getMessages().get("spells." + this.inheritKey + "." + messageKey, message);
        }
        message = this.controller.getMessages().get("spells." + this.spellKey.getBaseKey() + "." + messageKey, message);
        if (this.spellKey.isVariant()) {
            message = this.controller.getMessages().get("spells." + this.spellKey.getKey() + "." + messageKey, message);
        }
        if (message == null) {
            message = "";
        } else if (!message.isEmpty()) {
            String playerName = this.mage.getName();
            message = message.replace("$player", playerName);
            if ((message = message.replace("$caster", playerName)).contains("$material")) {
                String materialName = this.getDisplayMaterialName();
                materialName = materialName == null ? "None" : materialName;
                message = message.replace("$material", materialName);
            }
            if (this.currentCast != null) {
                message = this.currentCast.parameterizeMessage(message);
            }
        }
        return message;
    }

    protected String getDisplayMaterialName() {
        return "None";
    }

    protected void processResult(SpellResult result, ConfigurationSection parameters) {
        this.mage.onCast(this, result);
        String resultName = result.name().toLowerCase();
        if (!this.mage.isQuiet()) {
            if (result.isSuccess()) {
                String message = null;
                if (result != SpellResult.CAST) {
                    message = this.getMessage("cast");
                }
                if (result.isAlternate() && result != SpellResult.ALTERNATE) {
                    message = this.getMessage("alternate", message);
                }
                message = this.getMessage(resultName, message);
                if (!this.currentCast.getTargetedEntities().isEmpty()) {
                    message = this.getMessage("cast_target", message);
                }
                LivingEntity sourceEntity = this.mage.getLivingEntity();
                Entity targetEntity = this.getTargetEntity();
                if (targetEntity == sourceEntity) {
                    message = this.getMessage("cast_self", message);
                } else if (targetEntity instanceof Player) {
                    message = this.getMessage("cast_player", message);
                } else if (targetEntity instanceof LivingEntity) {
                    message = this.getMessage("cast_livingentity", message);
                } else if (targetEntity != null) {
                    message = this.getMessage("cast_entity", message);
                }
                this.castMessage(message);
            } else if (result != SpellResult.INSUFFICIENT_RESOURCES && result != SpellResult.COOLDOWN) {
                String message = null;
                if (result.isFailure() && result != SpellResult.FAIL) {
                    message = this.getMessage("fail");
                }
                if (result.isFailure()) {
                    this.sendMessage(this.getMessage(resultName, message));
                } else {
                    this.castMessage(this.getMessage(resultName, message));
                }
            }
        }
        this.playEffects(resultName);
        if (this.currentCast != null) {
            if (this.isLegacy()) {
                this.currentCast.addResult(result);
            }
            if (!this.isBatched()) {
                this.currentCast.finish();
            }
        }
    }

    protected boolean isBatched() {
        return false;
    }

    protected boolean isLegacy() {
        return true;
    }

    @Override
    public void messageTargets(String messageKey) {
        if (this.messageTargets && this.currentCast != null) {
            this.currentCast.messageTargets(messageKey);
        }
    }

    public void playEffects(String effectName, float scale, Block sourceBlock) {
        this.playEffects(effectName, this.getCurrentCast(), scale, sourceBlock);
    }

    public void playEffects(String effectName, float scale) {
        this.playEffects(effectName, this.getCurrentCast(), scale, null);
    }

    @Override
    public void playEffects(String effectName) {
        this.playEffects(effectName, 1.0f);
    }

    @Override
    public void playEffects(String effectName, CastContext context) {
        this.playEffects(effectName, context, 1.0f);
    }

    public void playEffects(String effectName, CastContext context, float scale, Block block) {
        context.playEffects(effectName, scale, block);
    }

    @Override
    public void playEffects(String effectName, CastContext context, float scale) {
        this.playEffects(effectName, context, scale, null);
    }

    @Override
    public void target() {
    }

    @Override
    @Nullable
    public Location getTargetLocation() {
        return null;
    }

    @Override
    public boolean canTarget(Entity entity) {
        Player magePlayer;
        if (this.bypassAll) {
            return true;
        }
        if (!this.bypassPvpRestriction && entity instanceof Player && (magePlayer = this.mage.getPlayer()) != null && !magePlayer.hasPermission("Magic.bypass_pvp")) {
            if (!this.controller.isPVPAllowed((Player)entity, entity.getLocation())) {
                return false;
            }
            if (!this.controller.isPVPAllowed(magePlayer, entity.getLocation())) {
                return false;
            }
            if (!this.controller.isPVPAllowed(magePlayer, this.mage.getLocation())) {
                return false;
            }
        }
        if (this.onlyFriendlyFire && (this.friendlyEntityTypes == null || !this.friendlyEntityTypes.contains(entity.getType()))) {
            return this.controller.isFriendly(this.mage.getEntity(), entity);
        }
        if (!this.bypassProtection && !this.bypassFriendlyFire) {
            return this.controller.canTarget(this.mage.getEntity(), entity);
        }
        return true;
    }

    @Override
    @Nullable
    public Entity getTargetEntity() {
        return null;
    }

    @Override
    public MaterialAndData getEffectMaterial() {
        return new com.elmakers.mine.bukkit.block.MaterialAndData(DEFAULT_EFFECT_MATERIAL);
    }

    @Override
    public void updateTemplateParameters() {
        this.processTemplateParameters((ConfigurationSection)this.parameters);
    }

    protected void processTemplateParameters(ConfigurationSection parameters) {
        this.bypassMageCooldown = parameters.getBoolean("bypass_mage_cooldown", false);
        this.bypassCooldown = parameters.getBoolean("bypass_cooldown", false);
        this.warmup = parameters.getInt("warmup", 0);
        this.cooldown = parameters.getInt("cooldown", 0);
        this.cooldown = parameters.getInt("cool", this.cooldown);
        this.mageCooldown = parameters.getInt("cooldown_mage", 0);
        this.displayCooldown = parameters.getInt("display_cooldown", -1);
        this.bypassPvpRestriction = parameters.getBoolean("bypass_pvp", false);
        this.bypassPvpRestriction = parameters.getBoolean("bp", this.bypassPvpRestriction);
        this.bypassPermissions = parameters.getBoolean("bypass_permissions", false);
        this.bypassBuildRestriction = parameters.getBoolean("bypass_build", false);
        this.bypassBuildRestriction = parameters.getBoolean("bb", this.bypassBuildRestriction);
        this.ignoreRegionOverrides = parameters.getBoolean("ignore_region_overrides", false);
        this.bypassBreakRestriction = parameters.getBoolean("bypass_break", false);
        this.bypassProtection = parameters.getBoolean("bypass_protection", false);
        this.bypassProtection = parameters.getBoolean("bp", this.bypassProtection);
        this.bypassAll = parameters.getBoolean("bypass", false);
        this.duration = parameters.getInt("duration", 0);
        this.totalDuration = parameters.getInt("total_duration", -1);
        this.costReduction = (float)parameters.getDouble("cost_reduction", 0.0);
        this.consumeReduction = (float)parameters.getDouble("consume_reduction", 0.0);
        this.cooldownReduction = (float)parameters.getDouble("cooldown_reduction", 0.0);
        if (parameters.getBoolean("free", false)) {
            this.costReduction = 2.0f;
            this.consumeReduction = 2.0f;
        }
    }

    public void processParameters(ConfigurationSection parameters) {
        this.processTemplateParameters(parameters);
        this.fizzleChance = (float)parameters.getDouble("fizzle_chance", 0.0);
        this.backfireChance = (float)parameters.getDouble("backfire_chance", 0.0);
        Location defaultLocation = this.location == null ? this.mage.getLocation() : this.location;
        Location locationOverride = ConfigurationUtils.overrideLocation(parameters, "p", defaultLocation, this.controller.canCreateWorlds());
        if (locationOverride != null) {
            this.location = locationOverride;
        }
        this.cancelOnDamage = parameters.getDouble("cancel_on_damage", 0.0);
        this.cancelOnCastOther = parameters.getBoolean("cancel_on_cast_other", false);
        this.cancelOnDeath = parameters.getBoolean("cancel_on_death", false);
        this.cancelOnNoPermission = parameters.getBoolean("cancel_on_no_permission", false);
        this.cancelOnNoWand = parameters.getBoolean("cancel_on_no_wand", false);
        this.commandBlockAllowed = parameters.getBoolean("command_block_allowed", true);
        this.passive = parameters.getBoolean("passive", this.passive);
        MaterialSetManager materials = this.controller.getMaterialSetManager();
        this.preventPassThroughMaterials = materials.getMaterialSetEmpty("indestructible");
        this.preventPassThroughMaterials = materials.fromConfig(parameters.getString("prevent_passthrough"), this.preventPassThroughMaterials);
        this.passthroughMaterials = materials.getMaterialSetEmpty("passthrough");
        this.passthroughMaterials = materials.fromConfig(parameters.getString("passthrough"), this.passthroughMaterials);
        this.unsafeMaterials = materials.getMaterialSetEmpty("unsafe");
        this.unsafeMaterials = materials.fromConfig(parameters.getString("unsafe"), this.unsafeMaterials);
        this.bypassDeactivate = parameters.getBoolean("bypass_deactivate", false);
        this.quiet = parameters.getBoolean("quiet", false);
        this.loud = parameters.getBoolean("loud", false);
        this.targetSelf = parameters.getBoolean("target_self", false);
        this.messageTargets = parameters.getBoolean("message_targets", true);
        this.verticalSearchDistance = parameters.getInt("vertical_range", 8);
        String nameOverride = parameters.getString("name", "");
        if (!nameOverride.isEmpty()) {
            this.name = ChatColor.translateAlternateColorCodes((char)'&', (String)nameOverride).replace('_', ' ');
        }
        this.friendlyEntityTypes = null;
        if (parameters.contains("friendly_types")) {
            this.friendlyEntityTypes = new HashSet<EntityType>();
            List<String> typeKeys = ConfigurationUtils.getStringList(parameters, "friendly_types");
            for (String typeKey : typeKeys) {
                try {
                    EntityType entityType = EntityType.valueOf((String)typeKey.toUpperCase());
                    this.friendlyEntityTypes.add(entityType);
                }
                catch (Throwable ex) {
                    this.controller.getLogger().warning("Unknown entity type in friendly_types of " + this.getKey() + ": " + typeKey);
                }
            }
        }
    }

    @Override
    public void reloadParameters(CastContext context) {
        this.processParameters(context.getWorkingParameters());
    }

    @Override
    public boolean brushIsErase() {
        return false;
    }

    @Override
    public String getPermissionNode() {
        return "Magic.cast." + this.spellKey.getBaseKey();
    }

    public boolean onCancelSelection() {
        return false;
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
    }

    public void onPlayerDeath(EntityDeathEvent event) {
    }

    public void onPlayerDamage(EntityDamageEvent event) {
    }

    @Override
    public void initialize(MageController instance) {
        this.controller = instance;
    }

    @Override
    public long getCastCount() {
        return this.spellData.getCastCount();
    }

    @Override
    public void setCastCount(long count) {
        this.spellData.setCastCount(count);
    }

    public void onActivate() {
    }

    public void onDeactivate() {
    }

    @Nullable
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    @Override
    public float getConsumeReduction() {
        CostReducer reducer;
        CostReducer costReducer = this.mageClass != null ? this.mageClass : (reducer = this.currentCast != null ? this.currentCast.getWand() : this.mage);
        if (reducer == null) {
            reducer = this.mage;
        }
        if (reducer == null) {
            return this.consumeReduction;
        }
        return this.consumeReduction + reducer.getConsumeReduction();
    }

    @Override
    public float getCostReduction() {
        CooldownReducer reducer;
        CooldownReducer cooldownReducer = reducer = this.reducerWand == null ? this.reducerMage : this.reducerWand;
        if (reducer == null) {
            CooldownReducer cooldownReducer2 = this.mageClass != null ? this.mageClass : (reducer = this.currentCast != null ? this.currentCast.getWand() : this.mage);
        }
        if (reducer == null) {
            reducer = this.mage;
        }
        if (reducer == null) {
            return this.costReduction;
        }
        return this.costReduction + reducer.getCostReduction();
    }

    @Override
    public float getCostScale() {
        return this.activeCostScale;
    }

    @Override
    @Nullable
    @Deprecated
    public Spell createSpell() {
        return this.createMageSpell(null);
    }

    @Override
    @Nullable
    public MageSpell createMageSpell(Mage mage) {
        BaseSpell spell = null;
        try {
            spell = (BaseSpell)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            spell.setMage(mage);
            spell.initialize(this.controller);
            spell.loadTemplate(this.spellKey.getKey(), this.configuration);
            spell.loadPrerequisites(this.configuration);
            spell.template = this;
        }
        catch (Throwable ex) {
            this.controller.getLogger().log(Level.WARNING, "Error creating spell " + this.spellKey.getKey(), ex);
        }
        return spell;
    }

    @Override
    public final String getKey() {
        return this.spellKey.getKey();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getAlias() {
        return this.alias;
    }

    @Override
    public boolean isQuickCast() {
        return this.quickCast;
    }

    @Override
    public final MaterialAndData getIcon() {
        return this.icon;
    }

    @Override
    public final MaterialAndData getDisabledIcon() {
        return this.disabledIcon;
    }

    @Override
    public boolean hasIcon() {
        return this.icon != null && this.icon.getMaterial() != Material.AIR;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final String getExtendedDescription() {
        return this.extendedDescription;
    }

    @Override
    public final String getLevelDescription() {
        return this.levelDescription;
    }

    public final String getProgressDescription() {
        return this.progressDescription;
    }

    @Override
    public final SpellKey getSpellKey() {
        return this.spellKey;
    }

    @Override
    public final String getUsage() {
        return this.usage;
    }

    @Override
    public final double getWorth() {
        return this.cost == null ? 0.0 : this.cost.getAmount();
    }

    @Override
    @Nullable
    public Cost getCost() {
        return this.cost;
    }

    @Override
    public final double getEarns() {
        return this.earns == null ? 0.0 : this.earns.getAmount();
    }

    @Override
    public final SpellCategory getCategory() {
        return this.category;
    }

    @Override
    public boolean hasTag(String tag) {
        if (this.category != null && this.category.getKey().equals(tag)) {
            return true;
        }
        return this.tags != null && this.tags.contains(tag);
    }

    @Override
    public boolean hasAnyTag(Collection<String> tagSet) {
        if (this.category != null && tagSet.contains(this.category.getKey())) {
            return true;
        }
        return this.tags != null && !Collections.disjoint(tagSet, this.tags);
    }

    public boolean hasEffects(String key) {
        Collection<EffectPlayer> effectList = this.effects.get(key);
        return effectList != null && effectList.size() > 0;
    }

    @Override
    public Collection<EffectPlayer> getEffects(SpellResult result) {
        return this.getEffects(result.name().toLowerCase());
    }

    @Override
    public Collection<EffectPlayer> getEffects(String key) {
        Collection<EffectPlayer> effectList = this.effects.get(key);
        if (effectList == null) {
            return this.controller.getEffects(key);
        }
        return new ArrayList<EffectPlayer>(effectList);
    }

    @Override
    @Nullable
    public Collection<com.elmakers.mine.bukkit.api.spell.CastingCost> getCosts() {
        if (this.costs == null) {
            return null;
        }
        ArrayList<com.elmakers.mine.bukkit.api.spell.CastingCost> copy = new ArrayList<com.elmakers.mine.bukkit.api.spell.CastingCost>();
        copy.addAll(this.costs);
        return copy;
    }

    @Override
    @Nullable
    public Collection<com.elmakers.mine.bukkit.api.spell.CastingCost> getActiveCosts() {
        if (this.activeCosts == null) {
            return null;
        }
        ArrayList<com.elmakers.mine.bukkit.api.spell.CastingCost> copy = new ArrayList<com.elmakers.mine.bukkit.api.spell.CastingCost>();
        copy.addAll(this.activeCosts);
        return copy;
    }

    @Override
    public ConfigurationSection getWorkingParameters() {
        return this.workingParameters;
    }

    @Override
    public void getParameters(Collection<String> parameters) {
        parameters.addAll(Arrays.asList(COMMON_PARAMETERS));
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        if (parameterKey.equals("duration")) {
            examples.addAll(Arrays.asList(EXAMPLE_DURATIONS));
        } else if (parameterKey.equals("range")) {
            examples.addAll(Arrays.asList(EXAMPLE_SIZES));
        } else if (parameterKey.equals("transparent")) {
            examples.addAll(this.controller.getMaterialSetManager().getMaterialSets());
        } else if (parameterKey.equals("player")) {
            examples.addAll(this.controller.getPlayerNames());
        } else if (parameterKey.equals("target")) {
            TargetType[] targetTypes;
            for (TargetType targetType : targetTypes = TargetType.values()) {
                examples.add(targetType.name().toLowerCase());
            }
        } else if (parameterKey.equals("target")) {
            TargetType[] targetTypes;
            for (TargetType targetType : targetTypes = TargetType.values()) {
                examples.add(targetType.name().toLowerCase());
            }
        } else if (parameterKey.equals("target_type")) {
            EntityType[] entityTypes;
            for (EntityType entityType : entityTypes = EntityType.values()) {
                examples.add(entityType.name().toLowerCase());
            }
        } else if (booleanParameterMap.contains(parameterKey)) {
            examples.addAll(Arrays.asList(EXAMPLE_BOOLEANS));
        } else if (vectorParameterMap.contains(parameterKey)) {
            examples.addAll(Arrays.asList(EXAMPLE_VECTOR_COMPONENTS));
        } else if (worldParameterMap.contains(parameterKey)) {
            List worlds = Bukkit.getWorlds();
            for (World world : worlds) {
                examples.add(world.getName());
            }
        } else if (percentageParameterMap.contains(parameterKey)) {
            examples.addAll(Arrays.asList(EXAMPLE_PERCENTAGES));
        }
    }

    @Override
    @Nullable
    public String getMageCooldownDescription() {
        return this.getCooldownDescription(this.controller.getMessages(), this.mageCooldown, this.mage, null);
    }

    @Nullable
    public String getMageCooldownDescription(Mage mage, Wand wand) {
        return this.getCooldownDescription(this.controller.getMessages(), this.mageCooldown, mage, wand);
    }

    @Override
    @Nullable
    public String getCooldownDescription() {
        return this.getCooldownDescription(this.controller.getMessages(), this.getDisplayCooldown(), this.mage, null);
    }

    @Nullable
    public String getCooldownDescription(Mage mage, Wand wand) {
        return this.getCooldownDescription(this.controller.getMessages(), this.getDisplayCooldown(), mage, wand);
    }

    @Nullable
    protected String getCooldownDescription(Messages messages, int cooldown, Mage mage, Wand wand) {
        CostReducer reducer;
        CostReducer costReducer = this.mageClass != null ? this.mageClass : (reducer = wand != null ? wand : mage);
        if (reducer != null) {
            if (reducer.isCooldownFree() || this.bypassCooldown) {
                cooldown = 0;
            }
            double cooldownReduction = reducer.getCooldownReduction();
            cooldownReduction += (double)this.cooldownReduction;
            if (cooldown > 0 && cooldownReduction < 1.0) {
                cooldown = (int)Math.ceil((1.0 - cooldownReduction) * (double)cooldown);
            }
        }
        return this.getTimeDescription(messages, cooldown);
    }

    @Nullable
    public String getWarmupDescription() {
        return this.getTimeDescription(this.controller.getMessages(), this.warmup);
    }

    private int getDisplayCooldown() {
        return this.displayCooldown != -1 ? this.displayCooldown : this.cooldown;
    }

    @Nullable
    private String getTimeDescription(Messages messages, int time) {
        if (time > 0) {
            return this.controller.getMessages().getTimeDescription(time, "description", "cooldown");
        }
        return null;
    }

    @Override
    public long getCooldown() {
        return this.cooldown;
    }

    @Override
    @Nullable
    public com.elmakers.mine.bukkit.api.spell.CastingCost getRequiredCost() {
        if (!(this.mage.isCostFree() || this.mageClass != null && this.mageClass.isCostFree())) {
            CostReducer caster;
            CostReducer costReducer = caster = this.mageClass != null ? this.mageClass : this.getCurrentCast().getWand();
            if (this.costs != null && !this.spellData.isActive()) {
                for (com.elmakers.mine.bukkit.api.spell.CastingCost cost : this.costs) {
                    if (cost.has(this.mage, (CasterProperties)((Object)caster), (CostReducer)this)) continue;
                    return cost;
                }
            }
        }
        return null;
    }

    @Override
    public void clearCooldown() {
        this.spellData.setCooldownExpiration(0L);
    }

    @Override
    public void setRemainingCooldown(long ms) {
        this.spellData.setCooldownExpiration(Math.max(ms + System.currentTimeMillis(), this.spellData.getCooldownExpiration()));
    }

    @Override
    public void reduceRemainingCooldown(long ms) {
        this.spellData.setCooldownExpiration(Math.max(0L, this.spellData.getCooldownExpiration() - ms));
    }

    @Override
    public long getRemainingCooldown() {
        Wand wand;
        long remaining = 0L;
        if (this.mage.isCooldownFree()) {
            return 0L;
        }
        if (this.mageClass != null && this.mageClass.isCooldownFree()) {
            return 0L;
        }
        if (this.mageClass == null && (wand = this.mage.getActiveWand()) != null && wand.isCooldownFree()) {
            return 0L;
        }
        if (this.spellData.getCooldownExpiration() > 0L && !this.bypassCooldown) {
            long now = System.currentTimeMillis();
            if (this.spellData.getCooldownExpiration() > now) {
                remaining = this.spellData.getCooldownExpiration() - now;
            } else {
                this.spellData.setCooldownExpiration(0L);
            }
        }
        return this.bypassMageCooldown ? remaining : Math.max(this.mage.getRemainingCooldown(), remaining);
    }

    @Override
    public long getDuration() {
        if (this.totalDuration >= 0) {
            return this.totalDuration;
        }
        return this.duration;
    }

    @Override
    public double getRange() {
        return 0.0;
    }

    @Override
    public void setMage(Mage mage) {
        this.mage = mage;
    }

    @Override
    public boolean cancelSelection() {
        boolean cancelled = this.onCancelSelection();
        if (cancelled) {
            this.cancel();
        }
        return cancelled;
    }

    @Override
    public boolean cancel() {
        if (this.isActive()) {
            this.sendMessage(this.getMessage("cancel"));
        }
        if (this.currentCast != null) {
            this.currentCast.cancelEffects();
        }
        return true;
    }

    @Override
    public void setActive(boolean active) {
        if (active && !this.spellData.isActive()) {
            this.onActivate();
        } else if (!active && this.spellData.isActive()) {
            this.onDeactivate();
        }
        this.spellData.setIsActive(active);
        this.lastActiveCost = System.currentTimeMillis();
    }

    @Override
    public void activate() {
        if (!this.spellData.isActive()) {
            this.mage.activateSpell(this);
        }
        if (this.currentCast != null) {
            this.toggleUndo = this.currentCast.getUndoList();
        }
    }

    @Override
    public boolean deactivate() {
        if (this.currentCast == null || !this.currentCast.getResult().isFree()) {
            this.updateCooldown();
        }
        return this.deactivate(false, false);
    }

    @Override
    public boolean deactivate(boolean force, boolean quiet) {
        if (!force && this.bypassDeactivate) {
            return false;
        }
        if (this.spellData.isActive()) {
            this.spellData.setIsActive(false);
            this.onDeactivate();
            this.playEffects("deactivate");
            this.mage.deactivateSpell(this);
            if (!quiet) {
                this.sendMessage(this.getMessage("deactivate"));
            }
            if (this.currentCast != null) {
                this.currentCast.addResult(SpellResult.DEACTIVATE);
                this.currentCast.cancelEffects();
                if ((this.toggle == ToggleType.UNDO || this.toggle == ToggleType.UNDO_IF_ACTIVE) && this.toggleUndo != null && !this.toggleUndo.isUndone() && this.isActive()) {
                    this.toggleUndo.undo();
                }
                this.toggleUndo = null;
            }
            if (this.toggle != ToggleType.NONE) {
                this.mage.cancelPending(this.getSpellKey().getBaseKey(), true);
            }
        }
        return true;
    }

    @Override
    public Mage getMage() {
        return this.mage;
    }

    @Override
    public SpellData getSpellData() {
        return this.spellData;
    }

    @Override
    public void setSpellData(SpellData data) {
        this.spellData = data;
        if (this.parameters != null) {
            this.parameters.setSpellVariables(this.getVariables());
            if (this.mage != null) {
                this.parameters.setMageVariables(this.mage.getVariables());
            }
        }
    }

    @Override
    public void tick() {
        this.checkActiveDuration();
        this.checkActiveCosts();
    }

    @Override
    public boolean isActive() {
        return this.spellData.isActive();
    }

    @Override
    public int compareTo(SpellTemplate other) {
        return this.name.compareTo(other.getName());
    }

    @Override
    public boolean hasCastPermission(CommandSender sender) {
        if (sender == null || this.bypassPermissions) {
            return true;
        }
        return this.controller.hasCastPermission(sender, this);
    }

    @Override
    @Nullable
    public Color getColor() {
        if (this.color != null) {
            return this.color;
        }
        if (this.category != null) {
            return this.category.getColor();
        }
        return null;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public SpellResult onCast(ConfigurationSection parameters) {
        throw new UnsupportedOperationException("The onCast method has not been implemented");
    }

    @Override
    public MageController getController() {
        return this.controller;
    }

    @Override
    public String getIconURL() {
        return this.iconURL;
    }

    @Override
    public String getDisabledIconURL() {
        return this.iconDisabledURL == null ? DEFAULT_DISABLED_ICON_URL : this.iconDisabledURL;
    }

    @Override
    public String getRequiredUpgradePath() {
        return this.requiredUpgradePath;
    }

    @Override
    public Set<String> getRequiredUpgradeTags() {
        return this.requiredUpgradeTags;
    }

    @Override
    public long getRequiredUpgradeCasts() {
        return this.requiredUpgradeCasts;
    }

    @Override
    public Collection<PrerequisiteSpell> getPrerequisiteSpells() {
        return this.requiredSpells;
    }

    @Override
    public Collection<SpellKey> getSpellsToRemove() {
        return this.removesSpells;
    }

    @Override
    public String getUpgradeDescription() {
        return this.upgradeDescription == null ? "" : this.upgradeDescription;
    }

    @Override
    @Nullable
    public SpellTemplate getUpgrade() {
        if (this.requiredUpgradeCasts <= 0L && (this.requiredUpgradePath == null || this.requiredUpgradePath.isEmpty()) && (this.requiredUpgradeTags == null || this.requiredUpgradeTags.isEmpty())) {
            return null;
        }
        SpellKey upgradeKey = new SpellKey(this.spellKey.getBaseKey(), this.spellKey.getLevel() + 1);
        return this.controller.getSpellTemplate(upgradeKey.getKey());
    }

    @Override
    public ConfigurationSection getConfiguration() {
        return this.configuration;
    }

    @Override
    public CastContext getCurrentCast() {
        if (this.currentCast == null) {
            this.currentCast = new com.elmakers.mine.bukkit.action.CastContext(this);
            this.currentCast.initialize();
        }
        return this.currentCast;
    }

    @Override
    public Entity getEntity() {
        return this.mage.getEntity();
    }

    @Override
    @Nullable
    public String getEffectParticle() {
        if (this.particle == null) {
            return this.mage.getEffectParticleName();
        }
        return this.particle;
    }

    @Override
    @Nullable
    public Color getEffectColor() {
        if (this.color == null) {
            return this.mage.getEffectColor();
        }
        return this.color;
    }

    @Override
    public boolean showUndoable() {
        return this.showUndoable;
    }

    public int getVerticalSearchDistance() {
        return this.verticalSearchDistance;
    }

    @Override
    public void addLore(Messages messages, Mage mage, Wand wand, List<String> lore) {
        String toggleText;
        Iterator<com.elmakers.mine.bukkit.api.spell.CastingCost> brushText;
        String effectiveDuration;
        double range;
        String mageCooldownDescription;
        String cooldownDescription;
        String warmupDescription;
        String quickCastText;
        String disabledText;
        String passiveText;
        String descriptionTemplate;
        if (this.levelDescription != null && this.levelDescription.length() > 0 && !(descriptionTemplate = messages.get("spell.level_lore", "")).isEmpty()) {
            InventoryUtils.wrapText(descriptionTemplate.replace("$level", this.levelDescription), lore);
        }
        if (this.description != null && this.description.length() > 0 && !(descriptionTemplate = messages.get("spell.description_lore", "")).isEmpty()) {
            InventoryUtils.wrapText(descriptionTemplate.replace("$description", this.description), lore);
        }
        if (this.usage != null && this.usage.length() > 0) {
            InventoryUtils.wrapText(this.usage, lore);
        }
        if (this.category != null) {
            String categoryLore = messages.get("spell.category", "");
            String categoryName = this.category.getName();
            if (!categoryLore.isEmpty() && !categoryName.isEmpty()) {
                lore.add(categoryLore.replace("$category", categoryName));
            }
        }
        if (this.passive && !(passiveText = messages.get("spell.passive", "")).isEmpty()) {
            lore.add(passiveText);
        }
        if (!this.isEnabled() && !(disabledText = messages.get("spell.disabled", "")).isEmpty()) {
            lore.add(disabledText);
        }
        if (this.quickCast && wand != null && !wand.isQuickCastDisabled() && wand.hasInventory() && !(quickCastText = messages.get("spell.quick_cast", "")).isEmpty()) {
            lore.add(quickCastText);
        }
        if ((warmupDescription = this.getWarmupDescription()) != null && !warmupDescription.isEmpty()) {
            lore.add(messages.get("warmup.description").replace("$time", warmupDescription));
        }
        if ((cooldownDescription = this.getCooldownDescription(mage, wand)) != null && !cooldownDescription.isEmpty()) {
            lore.add(messages.get("cooldown.description").replace("$time", cooldownDescription));
        }
        if ((mageCooldownDescription = this.getMageCooldownDescription(mage, wand)) != null && !mageCooldownDescription.isEmpty()) {
            lore.add(messages.get("cooldown.mage_description").replace("$time", mageCooldownDescription));
        }
        if ((range = this.getRange()) > 0.0) {
            lore.add(ChatColor.GRAY + messages.getRangeDescription(range, "wand.range_description"));
        }
        if ((effectiveDuration = this.getDurationDescription(messages)) != null) {
            lore.add(ChatColor.GRAY + effectiveDuration);
        } else if (this.showUndoable()) {
            String undoableText;
            if (this.isUndoable()) {
                undoableText = messages.get("spell.undoable", "");
                if (!undoableText.isEmpty()) {
                    lore.add(undoableText);
                }
            } else {
                undoableText = messages.get("spell.not_undoable", "");
                if (!undoableText.isEmpty()) {
                    lore.add(undoableText);
                }
            }
        }
        if (this.usesBrush() && !((String)((Object)(brushText = messages.get("spell.brush")))).isEmpty()) {
            lore.add(ChatColor.GOLD + (String)((Object)brushText));
        }
        this.reducerMage = mage;
        this.reducerWand = wand;
        if (this.costs != null) {
            for (com.elmakers.mine.bukkit.api.spell.CastingCost cost : this.costs) {
                if (cost.isEmpty(this)) continue;
                lore.add(ChatColor.YELLOW + messages.get("wand.costs_description").replace("$description", cost.getFullDescription(messages, this)));
            }
        }
        if (this.activeCosts != null) {
            for (com.elmakers.mine.bukkit.api.spell.CastingCost cost : this.activeCosts) {
                if (cost.isEmpty(this)) continue;
                lore.add(ChatColor.YELLOW + messages.get("wand.active_costs_description").replace("$description", cost.getFullDescription(messages, this)));
            }
        }
        this.reducerMage = null;
        this.reducerWand = null;
        if (this.toggle != ToggleType.NONE && !(toggleText = messages.get("spell.toggle", "")).isEmpty()) {
            lore.add(toggleText);
        }
        if (this.earns != null && this.controller.isSPEnabled() && this.controller.isSPEarnEnabled()) {
            int scaledEarn = this.earns.getRoundedAmount();
            if (mage != null) {
                scaledEarn = (int)Math.floor(mage.getEarnMultiplier() * (float)scaledEarn);
            }
            if (scaledEarn > 0) {
                Cost scaled = new Cost(this.earns);
                scaled.setAmount(scaledEarn);
                String earnsText = messages.get("spell.earns").replace("$earns", scaled.getFullDescription(this.controller.getMessages()));
                if (!earnsText.isEmpty()) {
                    lore.add(earnsText);
                }
            }
        }
        if (this.controller.isSpellProgressionEnabled() && this.progressDescription != null && this.progressDescription.length() > 0 && this.maxLevels > 0L && this.template != null) {
            InventoryUtils.wrapText(this.progressDescription.replace("$level", Long.toString(Math.max(0L, this.getProgressLevel()))).replace("$max_level", Long.toString(this.maxLevels)), lore);
        }
    }

    @Override
    @Nullable
    public MaterialBrush getBrush() {
        if (this.mage == null) {
            return null;
        }
        return this.mage.getBrush();
    }

    @Override
    public boolean isCancellable() {
        return this.cancellable;
    }

    @Override
    public void finish(CastContext context) {
        SpellResult result = context.getResult();
        CastEvent castEvent = new CastEvent(this.mage, this, result);
        Bukkit.getPluginManager().callEvent((Event)castEvent);
        if (result.isSuccess() && (this.loud || !this.mage.isQuiet() && !this.quiet)) {
            this.messageTargets("cast_player_message");
        }
        if (result.shouldRefundCooldown(this.castOnNoTarget)) {
            this.clearCooldown();
        }
        if (result.shouldRefundCosts(this.castOnNoTarget, this.refundOnNoTarget) && this.costs != null && !this.mage.isCostFree()) {
            for (com.elmakers.mine.bukkit.api.spell.CastingCost cost : this.costs) {
                cost.refund(this);
            }
        }
        if (this.cancelEffects) {
            context.cancelEffects();
        }
        if (result.isSuccess()) {
            this.spellData.addCast();
            if (this.template != null && this.template.spellData != null) {
                this.template.spellData.addCast();
                SpellCategory category = this.template.getCategory();
                if (category != null) {
                    category.addCast();
                }
            }
            Wand wand = context.getWand();
            CasterProperties activeProperties = this.mage.getActiveProperties();
            if (wand != null) {
                activeProperties = wand;
            }
            ProgressionPath path = activeProperties.getPath();
            if (this.earns != null && path != null && path.earnsSP() && this.controller.isSPEnabled() && this.controller.isSPEarnEnabled()) {
                long now = System.currentTimeMillis();
                int scaledEarn = this.earns.getRoundedAmount();
                boolean scaled = false;
                if (this.spellData.getLastEarn() > 0L && this.earnCooldown > 0 && now < this.spellData.getLastEarn() + (long)this.earnCooldown) {
                    scaledEarn = (int)Math.floor((double)scaledEarn * (double)(now - this.spellData.getLastEarn()) / (double)this.earnCooldown);
                    scaled = true;
                }
                if (scaledEarn > 0) {
                    Cost earnCost = new Cost(this.earns);
                    earnCost.setAmount(Math.floor(this.mage.getEarnMultiplier() * (float)scaledEarn));
                    EarnEvent event = new EarnEvent(this.mage, this.earns.getType(), earnCost.getAmount(), EarnEvent.EarnCause.SPELL_CAST);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (!event.isCancelled() && earnCost.give(this.mage, activeProperties)) {
                        if (scaled) {
                            context.playEffects("earn_scaled_sp");
                        } else {
                            context.playEffects("earn_sp");
                        }
                        this.spellData.setLastEarn(now);
                    }
                }
            }
            if (activeProperties.upgradesAllowed() && activeProperties.getSpellLevel(this.spellKey.getBaseKey()) == this.spellKey.getLevel()) {
                if (this.controller.isSpellUpgradingEnabled()) {
                    SpellTemplate upgrade = this.getUpgrade();
                    long requiredCasts = this.getRequiredUpgradeCasts();
                    String upgradePath = this.getRequiredUpgradePath();
                    ProgressionPath currentPath = activeProperties.getPath();
                    Set<String> upgradeTags = this.getRequiredUpgradeTags();
                    if (upgrade != null && requiredCasts > 0L && this.getCastCount() >= requiredCasts && (upgradePath == null || upgradePath.isEmpty() || currentPath != null && currentPath.hasPath(upgradePath)) && (upgradeTags == null || upgradeTags.isEmpty() || currentPath != null && currentPath.hasAllTags(upgradeTags)) && PrerequisiteSpell.hasPrerequisites(activeProperties, upgrade)) {
                        MageSpell newSpell = this.mage.getSpell(upgrade.getKey());
                        if (this.isActive()) {
                            this.deactivate(true, true);
                            if (newSpell != null) {
                                newSpell.activate();
                            }
                        }
                        activeProperties.forceAddSpell(upgrade.getKey());
                        this.playEffects("upgrade");
                        if (this.controller.isPathUpgradingEnabled()) {
                            activeProperties.checkAndUpgrade(true);
                        }
                        this.mage.updatePassiveEffects();
                        return;
                    }
                }
                if (this.maxLevels > 0L && this.controller.isSpellProgressionEnabled()) {
                    long previousLevel = this.getPreviousCastProgressLevel();
                    long currentLevel = this.getProgressLevel();
                    if (currentLevel != previousLevel) {
                        activeProperties.addSpell(this.getKey());
                        if (currentLevel > previousLevel) {
                            Messages messages = this.controller.getMessages();
                            String progressDescription = this.getProgressDescription();
                            this.playEffects("progress");
                            if (progressDescription != null && !progressDescription.isEmpty()) {
                                this.mage.sendMessage(messages.get("wand.spell_progression").replace("$name", this.getName()).replace("$wand", this.getName()).replace("$level", Long.toString(this.getProgressLevel())).replace("$max_level", Long.toString(this.maxLevels)));
                            }
                        }
                        if (this.controller.isPathUpgradingEnabled()) {
                            activeProperties.checkAndUpgrade(true);
                        }
                        this.mage.updatePassiveEffects();
                    }
                }
            }
        }
    }

    public boolean getTargetsCaster() {
        return this.targetSelf;
    }

    public void setTargetsCaster(boolean target) {
        this.targetSelf = target;
    }

    @Override
    public double cancelOnDamage() {
        return this.cancelOnDamage;
    }

    @Override
    public boolean cancelOnDeath() {
        return this.cancelOnDeath;
    }

    @Override
    public boolean cancelOnCastOther() {
        return this.cancelOnCastOther;
    }

    @Override
    public boolean cancelOnNoPermission() {
        return this.cancelOnNoPermission;
    }

    @Override
    public boolean cancelOnNoWand() {
        return this.cancelOnNoWand;
    }

    @Override
    @Nullable
    public ConfigurationSection getHandlerParameters(String handlerKey) {
        return null;
    }

    @Override
    public boolean hasHandlerParameters(String handlerKey) {
        return false;
    }

    public boolean isBypassRegionPermission() {
        return this.bypassRegionPermission;
    }

    public void setBypassRegionPermission(boolean bypass) {
        this.bypassRegionPermission = bypass;
    }

    @Override
    public ConfigurationSection getSpellParameters() {
        return this.parameters;
    }

    @Override
    public Collection<Requirement> getRequirements() {
        return this.requirements;
    }

    @Override
    @Nullable
    public String getDurationDescription(Messages messages) {
        String description = null;
        long effectiveDuration = this.getDuration();
        if (effectiveDuration > 0L) {
            long seconds = effectiveDuration / 1000L;
            if (seconds > 3600L) {
                long hours = seconds / 3600L;
                description = messages.get("duration.lasts_hours").replace("$hours", Long.valueOf(hours).toString());
            } else if (seconds == 3600L) {
                description = messages.get("duration.lasts_hour").replace("$hours", "1");
            } else if (seconds > 60L) {
                long minutes = seconds / 60L;
                description = messages.get("duration.lasts_minutes").replace("$minutes", Long.valueOf(minutes).toString());
            } else {
                description = seconds == 60L ? messages.get("duration.lasts_minute").replace("$minutes", "1") : (seconds == 1L ? messages.get("duration.lasts_second").replace("$seconds", Long.valueOf(seconds).toString()) : messages.get("duration.lasts_seconds").replace("$seconds", Long.valueOf(seconds).toString()));
            }
        }
        return description;
    }

    @Override
    @Nullable
    public Double getAttribute(String attributeKey) {
        Double data;
        Double d = data = this.mage == null ? null : this.mage.getAttribute(attributeKey);
        if (data == null && this.workingParameters != null && this.workingParameters.contains(attributeKey)) {
            data = this.workingParameters.getDouble(attributeKey);
        }
        return data;
    }

    public void setMageClass(MageClass mageClass) {
        this.mageClass = mageClass;
    }

    @Override
    public boolean disableManaRegenerationWhenActive() {
        return this.disableManaRegeneration;
    }

    public boolean isIndestructible(Block block) {
        return false;
    }

    public boolean isDestructible(Block block) {
        return false;
    }

    @Override
    @Nullable
    public String getCreator() {
        return this.creatorName;
    }

    @Override
    @Nullable
    public String getCreatorId() {
        return this.creatorId;
    }

    @Override
    @Nonnull
    public ConfigurationSection getVariables() {
        if (this.spellData == null) {
            this.spellData = new SpellData(this.getKey());
        }
        return this.spellData.getVariables();
    }

    @Override
    public boolean isPassive() {
        return this.passive;
    }

    @Override
    public boolean isEnabled() {
        return this.spellData.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.spellData.setIsEnabled(enabled);
    }

    @Override
    public boolean isToggleable() {
        return this.toggleable;
    }

    @Override
    @Nullable
    public Collection<Trigger> getTriggers() {
        return this.triggers;
    }

    public static enum ToggleType {
        NONE,
        CANCEL,
        UNDO,
        UNDO_IF_ACTIVE;

    }
}

