/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.npc;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.block.BlockData;
import com.elmakers.mine.bukkit.entity.EntityData;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.TextUtils;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class MagicNPC
implements com.elmakers.mine.bukkit.api.npc.MagicNPC {
    @Nonnull
    private final MagicController controller;
    @Nullable
    private Location location;
    @Nonnull
    private EntityData entityData;
    @Nonnull
    private String mobKey;
    @Nonnull
    private String name;
    @Nonnull
    private UUID uuid;
    private long createdAt;
    private String creatorId;
    private String creatorName;
    private Integer importedId;
    @Nonnull
    private ConfigurationSection parameters;
    @Nullable
    private ConfigurationSection parentParameters;

    public MagicNPC(MagicController controller, ConfigurationSection configuration) {
        EntityData entity;
        ConfigurationSection location;
        this.controller = controller;
        String template = configuration.getString("inherit", "base_npc");
        if (!template.isEmpty()) {
            EntityData entityData = controller.getMob(template);
            this.parentParameters = entityData == null ? null : entityData.getConfiguration();
        }
        this.mobKey = configuration.getString("mob", this.mobKey);
        String uuidString = configuration.getString("uuid");
        if (uuidString != null && !uuidString.isEmpty()) {
            this.uuid = UUID.fromString(uuidString);
        }
        this.name = configuration.getString("name", this.name);
        this.createdAt = configuration.getLong("created", this.createdAt);
        this.creatorId = configuration.getString("creator", this.creatorId);
        this.creatorName = configuration.getString("creator_name", this.creatorName);
        if (configuration.contains("imported_id")) {
            this.importedId = configuration.getInt("imported_id");
        }
        if ((location = ConfigurationUtils.getConfigurationSection(configuration, "location")) != null) {
            World world;
            double x = location.getDouble("x");
            double y = location.getDouble("y");
            double z = location.getDouble("z");
            float yaw = (float)location.getDouble("yaw");
            float pitch = (float)location.getDouble("pitch");
            String worldName = location.getString("world");
            if (worldName == null || worldName.isEmpty()) {
                worldName = "world";
                controller.getLogger().warning("NPC missing world name, defaulting to 'world'");
            }
            if ((world = Bukkit.getWorld((String)worldName)) == null) {
                controller.getLogger().warning("NPC has unknown world: " + worldName + ", will be removed!");
            }
            this.location = new Location(world, x, y, z, yaw, pitch);
        } else {
            this.location = null;
        }
        this.parameters = ConfigurationUtils.getConfigurationSection(configuration, "parameters");
        if (this.parameters == null) {
            this.parameters = new MemoryConfiguration();
        }
        boolean hasMobKey = this.mobKey != null && !this.mobKey.isEmpty();
        EntityData entityData = entity = hasMobKey ? controller.getMob(this.mobKey) : null;
        if (entity == null) {
            String defaultType;
            String string = defaultType = this.parentParameters == null ? "villager" : this.parentParameters.getString("type", "villager");
            if (hasMobKey) {
                controller.getLogger().warning("NPC has unknown mob type: " + this.mobKey + ", will change to " + defaultType);
            }
            entity = controller.getMob(defaultType);
        }
        if (entity == null) {
            controller.getLogger().warning("NPC has unknown mob type: " + this.mobKey + ", and no deafult mob type was available. Defaulting to villager.");
            entity = new EntityData(EntityType.VILLAGER);
        }
        this.setEntityData(entity);
    }

    public MagicNPC(MagicController controller, Mage creator, Location location, String name) {
        this(controller, (ConfigurationSection)new MemoryConfiguration());
        this.location = location.clone();
        this.name = name;
        this.createdAt = System.currentTimeMillis();
        this.creatorId = creator.getId();
        this.creatorName = creator.getName();
        this.update();
    }

    protected void defaultMob() {
        this.entityData = new EntityData(EntityType.VILLAGER);
        this.configureEntityData();
    }

    protected boolean isLocationValid() {
        return this.location != null && this.location.getWorld() != null;
    }

    public boolean isValid() {
        return this.entityData != null && this.isLocationValid();
    }

    public long getId() {
        return BlockData.getBlockId(this.getLocation());
    }

    @Override
    public boolean setType(@Nonnull String mobKey) {
        EntityData newEntityData = this.controller.getMob(mobKey);
        if (newEntityData == null) {
            return false;
        }
        this.setEntityData(newEntityData);
        this.mobKey = mobKey;
        Entity entity = this.getEntity();
        if (entity != null && entity.isValid()) {
            entity.remove();
            this.restore();
        }
        return true;
    }

    protected void setEntityData(EntityData templateData) {
        this.entityData = templateData.clone();
        this.configureEntityData();
    }

    protected void configureEntityData() {
        ConfigurationSection effectiveParameters;
        if (this.parentParameters != null) {
            effectiveParameters = ConfigurationUtils.cloneConfiguration(this.parentParameters);
            effectiveParameters = ConfigurationUtils.addConfigurations(effectiveParameters, this.parameters);
        } else {
            effectiveParameters = ConfigurationUtils.cloneConfiguration(this.parameters);
        }
        effectiveParameters.set("type", null);
        effectiveParameters.set("name", (Object)this.name);
        this.entityData.load(this.controller, effectiveParameters);
    }

    @Override
    @Nullable
    public Entity getEntity() {
        return this.uuid == null ? null : CompatibilityUtils.getEntity(this.location.getWorld(), this.uuid);
    }

    @Override
    public void teleport(@Nonnull Location location) {
        this.location = location.clone();
        Entity entity = this.getEntity();
        if (entity != null && entity.isValid()) {
            entity.teleport(location);
        }
    }

    @Override
    @Nullable
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void remove() {
        Entity entity = this.getEntity();
        if (entity != null) {
            entity.remove();
        }
    }

    @Nullable
    public Entity restore() {
        Entity entity = this.getEntity();
        if (entity == null || !entity.isValid()) {
            entity = this.entityData.spawn(this.controller, this.location);
        } else {
            this.entityData.modify(this.controller, entity);
            entity.teleport(this.location);
        }
        if (entity == null) {
            this.controller.getLogger().warning("Failed to restore NPC entity");
            return null;
        }
        entity.setCustomName(this.name);
        this.uuid = entity.getUniqueId();
        return entity;
    }

    public void save(ConfigurationSection configuration) {
        configuration.set("uuid", (Object)this.uuid.toString());
        configuration.set("mob", (Object)this.mobKey);
        configuration.set("name", (Object)this.name);
        configuration.set("created", (Object)this.createdAt);
        configuration.set("creator", (Object)this.creatorId);
        configuration.set("creator_name", (Object)this.creatorName);
        configuration.set("imported_id", (Object)this.importedId);
        ConfigurationSection locationSection = configuration.createSection("location");
        locationSection.set("world", (Object)this.location.getWorld().getName());
        locationSection.set("x", (Object)this.location.getX());
        locationSection.set("y", (Object)this.location.getY());
        locationSection.set("z", (Object)this.location.getZ());
        locationSection.set("yaw", (Object)Float.valueOf(this.location.getYaw()));
        locationSection.set("pitch", (Object)Float.valueOf(this.location.getPitch()));
        configuration.set("parameters", (Object)this.parameters);
    }

    @Override
    @Nonnull
    public EntityData getEntityData() {
        return this.entityData;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(@Nonnull String name) {
        this.name = name;
        this.restore();
    }

    @Override
    @Nonnull
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public void configure(String key, Object value) {
        value = ConfigurationUtils.convertProperty(value);
        this.parameters.set(key, value);
        this.update();
    }

    @Override
    public void update() {
        this.configureEntityData();
        this.restore();
    }

    @Override
    @Nonnull
    public ConfigurationSection getParameters() {
        return this.parameters;
    }

    @Override
    public void describe(CommandSender sender) {
        ConfigurationSection parameters;
        String mobTypeName = this.mobKey == null ? "Default Mob Type" : this.mobKey;
        sender.sendMessage(ChatColor.GOLD + this.name + ChatColor.DARK_GRAY + " (" + ChatColor.GRAY + mobTypeName + ChatColor.DARK_GRAY + ")");
        sender.sendMessage(ChatColor.AQUA + "Location: " + ChatColor.WHITE + TextUtils.printLocation(this.location));
        sender.sendMessage(ChatColor.AQUA + "Created By: " + ChatColor.WHITE + this.creatorName);
        if (this.parentParameters != null) {
            parameters = ConfigurationUtils.cloneConfiguration(this.parentParameters);
            parameters = ConfigurationUtils.addConfigurations(parameters, this.parameters);
        } else {
            parameters = ConfigurationUtils.cloneConfiguration(this.parameters);
        }
        parameters.set("type", null);
        String interactSpell = parameters.getString("interact_spell");
        if (interactSpell != null && !interactSpell.isEmpty()) {
            SpellTemplate template = this.controller.getSpellTemplate(interactSpell);
            String spellName = template == null ? ChatColor.RED + interactSpell : ChatColor.YELLOW + template.getName();
            sender.sendMessage(ChatColor.AQUA + "Casts" + ChatColor.GRAY + ": " + spellName);
            parameters.set("interact_spell", null);
        }
        Set keys = parameters.getKeys(false);
        for (String key : keys) {
            Object value = parameters.get(key);
            if (value == null) continue;
            ChatColor propertyColor = ChatColor.GRAY;
            if (this.parameters.contains(key)) {
                propertyColor = ChatColor.DARK_AQUA;
            }
            sender.sendMessage(propertyColor.toString() + key + ChatColor.GRAY + ": " + ChatColor.WHITE + InventoryUtils.describeProperty(value, InventoryUtils.MAX_PROPERTY_DISPLAY_LENGTH));
        }
    }

    @Override
    @Nullable
    public Integer getImportedId() {
        return this.importedId;
    }

    public void setImportedId(int importedId) {
        this.importedId = importedId;
    }
}

