/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.npc.MagicNPC;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.citizens.CitizensController;
import com.elmakers.mine.bukkit.effect.NPCTargetingContext;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.Target;
import com.elmakers.mine.bukkit.utility.Targeting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class MagicNPCCommandExecutor
extends MagicTabExecutor {
    private static final int npcsPerPage = 10;
    private static final int selectRange = 32;
    private final Targeting targeting = new Targeting();

    public MagicNPCCommandExecutor(MagicAPI api) {
        super(api, "mnpc");
        MemoryConfiguration targetingParameters = new MemoryConfiguration();
        targetingParameters.set("range", (Object)32);
        targetingParameters.set("target", (Object)"other_entity");
        targetingParameters.set("ignore_blocks", (Object)true);
        this.targeting.processParameters((ConfigurationSection)targetingParameters);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        MagicNPC npc;
        if (!this.api.hasPermission(sender, this.getPermissionNode())) {
            this.sendNoPermission(sender);
            return true;
        }
        if (args.length == 0) {
            return false;
        }
        String subCommand = args[0];
        if (subCommand.equalsIgnoreCase("import")) {
            this.onImportNPCs(sender);
            return true;
        }
        if (subCommand.equalsIgnoreCase("list")) {
            int pageNumber = 1;
            if (args.length > 1) {
                try {
                    pageNumber = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException ex) {
                    sender.sendMessage(ChatColor.RED + "Invalid page number: " + pageNumber);
                    return true;
                }
            }
            this.onListNPCs(sender, pageNumber);
            return true;
        }
        Mage mage = this.controller.getMage(sender);
        Object[] parameters = Arrays.copyOfRange(args, 1, args.length);
        if (subCommand.equalsIgnoreCase("add") || subCommand.equalsIgnoreCase("create")) {
            if (parameters.length == 0) {
                sender.sendMessage(ChatColor.RED + "Usage: mnpc add <name>");
                return true;
            }
            if (!mage.isPlayer()) {
                sender.sendMessage(ChatColor.RED + "This command may only be used in-game");
                return true;
            }
            this.onAddNPC(mage, StringUtils.join((Object[])parameters, (String)" "));
            return true;
        }
        if (subCommand.equalsIgnoreCase("select")) {
            String targetName = null;
            if (parameters.length > 0) {
                targetName = StringUtils.join((Object[])parameters, (String)" ");
            }
            this.onSelectNPC(mage, targetName);
            return true;
        }
        MagicNPC magicNPC = npc = mage == null ? null : mage.getSelectedNPC();
        if (npc == null) {
            sender.sendMessage(ChatColor.RED + "Select an NPC first using /mnpc select");
            return true;
        }
        if (subCommand.equalsIgnoreCase("rename") || subCommand.equalsIgnoreCase("name")) {
            if (parameters.length == 0) {
                sender.sendMessage(ChatColor.RED + "Usage: mnpc rename <name>");
                return true;
            }
            this.onRenameNPC(mage, npc, StringUtils.join((Object[])parameters, (String)" "));
            return true;
        }
        if (subCommand.equalsIgnoreCase("type")) {
            if (parameters.length == 0) {
                sender.sendMessage(ChatColor.RED + "Usage: mnpc type <mob type>");
                return true;
            }
            this.onChangeNPCType(mage, npc, StringUtils.join((Object[])parameters, (String)" "));
            return true;
        }
        if (subCommand.equalsIgnoreCase("cast") || subCommand.equalsIgnoreCase("spell")) {
            this.onChangeNPCSpell(mage, npc, (String[])parameters);
            return true;
        }
        if (subCommand.equalsIgnoreCase("tp")) {
            this.onTPNPC(mage, npc);
            return true;
        }
        if (subCommand.equalsIgnoreCase("tphere")) {
            this.onTPNPCHere(mage, npc);
            return true;
        }
        if (subCommand.equalsIgnoreCase("configure")) {
            this.onConfigureNPC(mage, npc, (String[])parameters);
            return true;
        }
        if (subCommand.equalsIgnoreCase("costs")) {
            this.onNPCCost(mage, npc, (String[])parameters);
            return true;
        }
        if (subCommand.equalsIgnoreCase("describe")) {
            this.onDescribeNPC(mage, npc);
            return true;
        }
        if (subCommand.equalsIgnoreCase("player")) {
            if (parameters.length == 0) {
                sender.sendMessage(ChatColor.RED + "Usage: mnpc player <player name>");
                return true;
            }
            this.onPlayerNPC(mage, npc, (String)parameters[0]);
            return true;
        }
        if (subCommand.equalsIgnoreCase("remove") || subCommand.equalsIgnoreCase("delete")) {
            this.onRemoveNPC(mage, npc);
            return true;
        }
        if (subCommand.equalsIgnoreCase("dialog") || subCommand.equalsIgnoreCase("text")) {
            this.onNPCDialog(mage, npc);
            return true;
        }
        sender.sendMessage(ChatColor.RED + "Unknown subcommand: mnpc " + subCommand);
        return true;
    }

    protected void onImportNPCs(CommandSender sender) {
        MagicController magic = (MagicController)this.controller;
        CitizensController citizens = magic.getCitizensController();
        if (citizens == null) {
            sender.sendMessage(ChatColor.RED + "Citizens is not installed");
            return;
        }
        citizens.importAll(magic, this.controller.getMage(sender));
        sender.sendMessage(ChatColor.GREEN + "Finished importing! If everything looks OK now you can safely remove the Citizens plugin.");
        sender.sendMessage(ChatColor.GREEN + "Until then, all of your NPCs will be doubled up");
    }

    protected List<MagicNPC> getNPCList() {
        Collection<MagicNPC> npcs = this.controller.getNPCs();
        if (npcs instanceof List) {
            return (List)npcs;
        }
        ArrayList<MagicNPC> list = new ArrayList<MagicNPC>(npcs);
        return list;
    }

    protected void onListNPCs(CommandSender sender, int pageNumber) {
        int startIndex;
        List<MagicNPC> npcs = this.getNPCList();
        for (int i = startIndex = (pageNumber - 1) * 10; i < startIndex + 10 && i < npcs.size(); ++i) {
            MagicNPC npc = npcs.get(i);
            sender.sendMessage(ChatColor.YELLOW + Integer.toString(i) + ChatColor.GRAY + ": " + ChatColor.GOLD + npc.getName());
        }
        if (npcs.size() > 10) {
            int pages = npcs.size() / 10 + 1;
            sender.sendMessage("  " + ChatColor.GRAY + "Page " + ChatColor.YELLOW + pageNumber + ChatColor.GRAY + "/" + ChatColor.GOLD + pages);
        }
    }

    protected void onAddNPC(Mage mage, String name) {
        MagicNPC npc = this.controller.addNPC(mage, name);
        mage.setSelectedNPC(npc);
        mage.sendMessage(ChatColor.GREEN + "Created npc: " + ChatColor.GOLD + npc.getName());
    }

    protected void onRenameNPC(Mage mage, MagicNPC npc, String name) {
        mage.sendMessage(ChatColor.GREEN + "Changed name of npc " + ChatColor.GOLD + npc.getName() + ChatColor.GREEN + " to " + ChatColor.YELLOW + name);
        npc.setName(name);
    }

    protected void onChangeNPCType(Mage mage, MagicNPC npc, String typeKey) {
        if (npc.setType(typeKey)) {
            mage.sendMessage(ChatColor.GREEN + "Changed type of npc " + ChatColor.GOLD + npc.getName() + ChatColor.GREEN + " to " + ChatColor.YELLOW + typeKey);
        } else {
            mage.sendMessage(ChatColor.RED + "Unknown mob type: " + ChatColor.YELLOW + typeKey);
        }
    }

    protected void onChangeNPCSpell(Mage mage, MagicNPC npc, String[] parameters) {
        ConfigurationSection currentParameters = npc.getParameters();
        if (parameters.length == 0) {
            String previousSpell = currentParameters.getString("interact_spell");
            if (previousSpell == null || previousSpell.isEmpty()) {
                mage.sendMessage(ChatColor.DARK_AQUA + "NPC has no spell set: " + ChatColor.GOLD);
                return;
            }
            ConfigurationSection previousParameters = ConfigurationUtils.getConfigurationSection(currentParameters, "interact_spell_parameters");
            npc.configure("interact_spell", null);
            mage.sendMessage(ChatColor.DARK_AQUA + "Cleared spell cast for npc " + ChatColor.GOLD);
            mage.sendMessage(ChatColor.AQUA + "Was: " + ChatColor.WHITE + previousSpell);
            if (previousParameters != null) {
                mage.sendMessage(InventoryUtils.describeProperty(previousParameters));
            }
        } else {
            currentParameters.set("interact_spell", (Object)parameters[0]);
            mage.sendMessage(ChatColor.GREEN + "Changed npc " + ChatColor.GOLD + npc.getName() + ChatColor.GREEN + " to cast " + ChatColor.YELLOW + parameters[0]);
            if (parameters.length > 1) {
                mage.sendMessage(ChatColor.GREEN + " With parameters:");
                MemoryConfiguration spellParameters = new MemoryConfiguration();
                ConfigurationUtils.addParameters(Arrays.copyOfRange(parameters, 1, parameters.length), (ConfigurationSection)spellParameters);
                currentParameters.set("interact_spell_parameters", (Object)spellParameters);
                Set keys = spellParameters.getKeys(false);
                for (String key : keys) {
                    Object value = spellParameters.get(key);
                    mage.sendMessage(ChatColor.DARK_AQUA + key + ChatColor.GRAY + ": " + ChatColor.WHITE + InventoryUtils.describeProperty(value, InventoryUtils.MAX_PROPERTY_DISPLAY_LENGTH));
                }
            }
        }
        npc.update();
    }

    @Nullable
    protected MagicNPC findNPC(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        List<MagicNPC> npcs = this.getNPCList();
        for (MagicNPC npc : npcs) {
            if (!npc.getName().equalsIgnoreCase(name)) continue;
            return npc;
        }
        try {
            int index = Integer.parseInt(name);
            if (index >= 0 && index < npcs.size()) {
                return npcs.get(index);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    protected void onSelectNPC(Mage mage, String name) {
        MagicNPC npc = this.findNPC(name);
        if (npc == null && mage.isPlayer()) {
            NPCTargetingContext context = new NPCTargetingContext(mage);
            this.targeting.reset();
            Target target = this.targeting.target(context, 32.0);
            if (target != null && target.hasEntity()) {
                npc = this.controller.getNPC(target.getEntity());
            }
        }
        if (npc == null) {
            if (name == null || name.isEmpty()) {
                if (!mage.isPlayer()) {
                    mage.sendMessage(ChatColor.RED + "When using from console, must provide NPC name");
                } else {
                    mage.sendMessage(ChatColor.RED + "There is no NPC in front of you");
                }
            } else {
                mage.sendMessage(ChatColor.RED + "Could not find NPC: " + ChatColor.GOLD + name);
            }
        } else {
            Entity entity = npc.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity li = (LivingEntity)entity;
                li.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, 100, 1, true, false));
            }
            mage.setSelectedNPC(npc);
            mage.sendMessage(ChatColor.GRAY + "Selected NPC: " + ChatColor.GOLD + npc.getName());
        }
    }

    protected void onRemoveNPC(Mage mage, MagicNPC npc) {
        this.controller.removeNPC(npc);
        mage.setSelectedNPC(null);
        mage.sendMessage(ChatColor.GREEN + " Removed npc: " + ChatColor.GOLD + npc.getName());
    }

    protected void onNPCDialog(Mage mage, MagicNPC npc) {
        if (!mage.isPlayer()) {
            mage.sendMessage(ChatColor.RED + "This command may only be used in-game");
            return;
        }
        ItemStack item = mage.getPlayer().getInventory().getItemInMainHand();
        if (InventoryUtils.hasMeta(item, "npc")) {
            BookMeta meta = (BookMeta)item.getItemMeta();
            List pages = meta.getPages();
            boolean isEmpty = true;
            for (String page : pages) {
                if (page.trim().isEmpty()) continue;
                isEmpty = false;
                break;
            }
            if (isEmpty) {
                pages = null;
                mage.sendMessage(ChatColor.GREEN + "NPC dialog script cleared for " + ChatColor.GOLD + npc.getName());
            } else {
                mage.sendMessage(ChatColor.GREEN + "NPC dialog script set for " + ChatColor.GOLD + npc.getName());
            }
            npc.configure("dialog", pages);
            mage.getPlayer().getInventory().setItemInMainHand(new ItemStack(Material.AIR));
            return;
        }
        Material bookMaterial = DefaultMaterials.getWriteableBook();
        if (bookMaterial == null) {
            mage.sendMessage(ChatColor.RED + "Could not create writable book");
            return;
        }
        ItemStack book = new ItemStack(bookMaterial);
        BookMeta meta = (BookMeta)book.getItemMeta();
        meta.setTitle("NPC Script: " + npc.getName());
        meta.setAuthor(mage.getDisplayName());
        ArrayList<String> pages = npc.getParameters().getStringList("dialog");
        if (pages == null) {
            pages = new ArrayList<String>();
        }
        if (pages.isEmpty()) {
            pages.add("");
        }
        meta.setPages(pages);
        book.setItemMeta((ItemMeta)meta);
        book = InventoryUtils.makeReal(book);
        InventoryUtils.setMeta(book, "npc", npc.getUUID().toString());
        mage.giveItem(book);
        mage.sendMessage(ChatColor.GREEN + "Edit the script book and use this command again while holding the book to set the NPC's chat dialog");
    }

    protected void onTPNPC(Mage mage, MagicNPC npc) {
        if (!mage.isPlayer()) {
            mage.sendMessage(ChatColor.RED + "This command may only be used in-game");
            return;
        }
        mage.getEntity().teleport(npc.getLocation());
    }

    protected void onTPNPCHere(Mage mage, MagicNPC npc) {
        if (!mage.isPlayer()) {
            mage.sendMessage(ChatColor.RED + "This command may only be used in-game");
            return;
        }
        npc.teleport(mage.getEntity().getLocation());
    }

    protected void onDescribeNPC(Mage mage, MagicNPC npc) {
        npc.describe(mage.getCommandSender());
    }

    protected void onPlayerNPC(Mage mage, MagicNPC npc, String playerName) {
        if (!this.controller.hasDisguises()) {
            mage.sendMessage(ChatColor.RED + "Player NPCs require LibsDisguises");
            return;
        }
        ConfigurationSection parameters = npc.getParameters();
        ConfigurationSection disguise = parameters.getConfigurationSection("disguise");
        disguise.set("skin", (Object)playerName);
        disguise.set("type", (Object)"player");
        npc.update();
    }

    protected void onNPCCost(Mage mage, MagicNPC npc, String[] parameters) {
        String costType;
        if (parameters.length == 0) {
            mage.sendMessage(ChatColor.GREEN + " Configured npc " + ChatColor.GOLD + npc.getName() + ChatColor.GREEN + ", cleared costs");
            npc.configure("interact_costs", null);
            return;
        }
        double value = 0.0;
        try {
            value = Double.parseDouble(parameters[0]);
        }
        catch (Exception ex) {
            mage.sendMessage(ChatColor.RED + "Invalid cost amount: " + parameters[0]);
            return;
        }
        String string = costType = parameters.length > 1 ? parameters[1] : "currency";
        if (this.controller.getCurrency(costType) == null) {
            mage.sendMessage(ChatColor.RED + "Invalid cost type: " + costType);
            return;
        }
        MemoryConfiguration costSection = new MemoryConfiguration();
        costSection.set(costType, (Object)value);
        npc.configure("interact_costs", costSection);
        mage.sendMessage(ChatColor.GREEN + " Configured npc " + ChatColor.GOLD + npc.getName() + ChatColor.GREEN + " to cost " + ChatColor.WHITE + (int)value + ChatColor.YELLOW + " " + costType);
    }

    protected void onConfigureNPC(Mage mage, MagicNPC npc, String[] parameters) {
        if (parameters.length == 0 || parameters[0].isEmpty()) {
            mage.sendMessage(ChatColor.RED + "Missing parameter name");
            return;
        }
        String key = parameters[0];
        String value = null;
        if (parameters.length == 2) {
            value = parameters[1];
        } else if (parameters.length > 2) {
            value = StringUtils.join((Object[])Arrays.copyOfRange(parameters, 1, parameters.length), (String)" ");
        }
        if (key.equals("spell") || key.equals("cast")) {
            key = "interact_spell";
        } else if (key.equals("command") || key.equals("commands")) {
            key = "interact_commands";
        } else if (key.equals("cast_source")) {
            key = "interact_spell_source";
        } else if (key.equals("cast_target")) {
            key = "interact_spell_target";
        } else if (key.equals("command_source")) {
            key = "interact_command_source";
        } else if (key.equals("permission")) {
            key = "interact_permission";
        }
        npc.configure(key, value);
        if (value == null) {
            mage.sendMessage(ChatColor.GREEN + " Configured npc " + ChatColor.GOLD + npc.getName() + ChatColor.GREEN + ", cleared " + ChatColor.AQUA + key);
        } else {
            mage.sendMessage(ChatColor.GREEN + " Configured npc " + ChatColor.GOLD + npc.getName() + ChatColor.GREEN + ", set " + ChatColor.AQUA + key + ChatColor.GREEN + " to " + ChatColor.YELLOW + value);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        ArrayList<String> options;
        block15: {
            block25: {
                block24: {
                    block23: {
                        block22: {
                            block21: {
                                block20: {
                                    block19: {
                                        block18: {
                                            block17: {
                                                block16: {
                                                    void var7_22;
                                                    block14: {
                                                        options = new ArrayList<String>();
                                                        if (!sender.hasPermission("Magic.commands.mnpc")) {
                                                            return options;
                                                        }
                                                        if (args.length != 1) break block14;
                                                        options.add("add");
                                                        options.add("configure");
                                                        options.add("list");
                                                        options.add("name");
                                                        options.add("describe");
                                                        options.add("type");
                                                        options.add("remove");
                                                        options.add("tp");
                                                        options.add("tphere");
                                                        options.add("import");
                                                        options.add("select");
                                                        options.add("cast");
                                                        options.add("costs");
                                                        options.add("player");
                                                        options.add("dialog");
                                                        break block15;
                                                    }
                                                    if (args.length != 2 || !args[0].equals("type")) break block16;
                                                    options.addAll(this.controller.getMobKeys());
                                                    EntityType[] entityTypeArray = EntityType.values();
                                                    int n = entityTypeArray.length;
                                                    boolean bl = false;
                                                    while (var7_22 < n) {
                                                        EntityType entityType = entityTypeArray[var7_22];
                                                        if (entityType.isAlive() && entityType.isSpawnable()) {
                                                            options.add(entityType.name().toLowerCase());
                                                        }
                                                        ++var7_22;
                                                    }
                                                    break block15;
                                                }
                                                if (args.length != 2 || !args[0].equals("select")) break block17;
                                                for (MagicNPC magicNPC : this.controller.getNPCs()) {
                                                    options.add(magicNPC.getName());
                                                }
                                                break block15;
                                            }
                                            if (args.length != 2 || !args[0].equals("configure")) break block18;
                                            options.add("ai");
                                            options.add("gravity");
                                            options.add("cast_source");
                                            options.add("command_source");
                                            options.add("cast_target");
                                            options.add("commands");
                                            options.add("permission");
                                            options.add("helmet");
                                            options.add("item");
                                            options.add("offhand");
                                            options.add("chestplate");
                                            options.add("boots");
                                            options.add("leggings");
                                            break block15;
                                        }
                                        if (!(args.length == 3 && args[0].equals("configure") && args[1].equals("interact_spell") || args.length == 2 && args[0].equals("cast")) && (args.length != 2 || !args[0].equals("spell"))) break block19;
                                        for (SpellTemplate spellTemplate : this.controller.getSpellTemplates(true)) {
                                            options.add(spellTemplate.getKey());
                                        }
                                        break block15;
                                    }
                                    if (args.length != 3 || !args[0].equals("configure") || !args[1].equals("ai") && !args[1].equals("gravity") && !args[1].equals("interact_spell_caster")) break block20;
                                    options.add("true");
                                    options.add("false");
                                    break block15;
                                }
                                if (args.length != 3 || !args[0].equals("configure") || !args[1].equals("interact_spell_target") && !args[1].equals("cast_target")) break block21;
                                options.add("none");
                                options.add("npc");
                                options.add("player");
                                break block15;
                            }
                            if (args.length != 3 || !args[0].equals("configure") || !args[1].equals("interact_spell_source") && !args[1].equals("cast_source") && !args[1].equals("interact_command_source") && !args[1].equals("command_source")) break block22;
                            options.add("npc");
                            options.add("player");
                            break block15;
                        }
                        if (args.length != 3 || !args[0].equals("configure") || !args[1].equals("helmet") && !args[1].equals("item") && !args[1].equals("offhand") && !args[1].equals("chestplate") && !args[1].equals("boots") && !args[1].equals("leggings")) break block23;
                        Collection<SpellTemplate> spellList = this.api.getSpellTemplates(true);
                        for (SpellTemplate spellTemplate : spellList) {
                            options.add(spellTemplate.getKey());
                        }
                        Collection<String> collection = this.api.getWandKeys();
                        for (String wandKey : collection) {
                            options.add(wandKey);
                        }
                        for (Material material : Material.values()) {
                            options.add(material.name().toLowerCase());
                        }
                        Set<String> set = this.api.getController().getItemKeys();
                        for (String itemKey : set) {
                            options.add(itemKey);
                        }
                        break block15;
                    }
                    if (args.length != 2 || !args[0].equals("player")) break block24;
                    for (Player player : this.controller.getPlugin().getServer().getOnlinePlayers()) {
                        options.add(player.getName());
                    }
                    break block15;
                }
                if (args.length != 2 || !args[0].equals("costs")) break block25;
                options.add("1");
                options.add("10");
                options.add("100");
                break block15;
            }
            if (args.length != 3 || !args[0].equals("costs")) break block15;
            for (String string : this.controller.getCurrencyKeys()) {
                options.add(string);
            }
            Collection<String> allWands = this.api.getWandKeys();
            for (String string : allWands) {
                options.add(string);
            }
            for (Material material : Material.values()) {
                options.add(material.name().toLowerCase());
            }
            Set<String> set = this.api.getController().getItemKeys();
            for (String itemKey : set) {
                options.add(itemKey);
            }
        }
        return options;
    }
}

