/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.magic.ParameterizedConfiguration;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class MageParameters
extends ParameterizedConfiguration {
    private static Set<String> attributes;
    @Nullable
    private final Mage mage;

    public MageParameters(Mage mage, String context) {
        super(context);
        this.mage = mage;
    }

    public MageParameters(MageParameters copy) {
        super(copy);
        this.mage = copy.mage;
    }

    @Nullable
    protected MageController getController() {
        return this.mage == null ? null : this.mage.getController();
    }

    @Nullable
    protected Mage getMage() {
        return this.mage;
    }

    public static void initializeAttributes(Set<String> attrs) {
        attributes = new HashSet<String>(attrs);
    }

    @Override
    @Nullable
    protected Double evaluate(String expression) {
        if (this.mage != null && this.mage.isPlayer()) {
            expression = this.mage.getController().setPlaceholders(this.mage.getPlayer(), expression);
        }
        return super.evaluate(expression);
    }

    @Override
    protected double getParameter(String parameter) {
        Double value = this.mage == null ? null : this.mage.getAttribute(parameter);
        return value == null || Double.isNaN(value) || Double.isInfinite(value) ? 0.0 : value;
    }

    @Override
    protected Set<String> getParameters() {
        return attributes;
    }
}

