/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.action.TeleportTask;
import com.elmakers.mine.bukkit.api.action.GUIAction;
import com.elmakers.mine.bukkit.api.attributes.AttributeProvider;
import com.elmakers.mine.bukkit.api.batch.Batch;
import com.elmakers.mine.bukkit.api.batch.SpellBatch;
import com.elmakers.mine.bukkit.api.batch.UndoBatch;
import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.data.BrushData;
import com.elmakers.mine.bukkit.api.data.MageData;
import com.elmakers.mine.bukkit.api.data.SpellData;
import com.elmakers.mine.bukkit.api.data.UndoData;
import com.elmakers.mine.bukkit.api.economy.Currency;
import com.elmakers.mine.bukkit.api.effect.SoundEffect;
import com.elmakers.mine.bukkit.api.event.WandActivatedEvent;
import com.elmakers.mine.bukkit.api.event.WandDeactivatedEvent;
import com.elmakers.mine.bukkit.api.magic.CastSourceLocation;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAttribute;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.magic.Trigger;
import com.elmakers.mine.bukkit.api.spell.CastingCost;
import com.elmakers.mine.bukkit.api.spell.CostReducer;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellEventType;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.LostWand;
import com.elmakers.mine.bukkit.api.wand.WandAction;
import com.elmakers.mine.bukkit.api.wand.WandUpgradePath;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.block.UndoQueue;
import com.elmakers.mine.bukkit.effect.HoloUtils;
import com.elmakers.mine.bukkit.effect.Hologram;
import com.elmakers.mine.bukkit.effect.MageEffectContext;
import com.elmakers.mine.bukkit.entity.EntityData;
import com.elmakers.mine.bukkit.heroes.HeroesManager;
import com.elmakers.mine.bukkit.integration.VaultController;
import com.elmakers.mine.bukkit.magic.BaseMageModifier;
import com.elmakers.mine.bukkit.magic.CasterProperties;
import com.elmakers.mine.bukkit.magic.CheckWandTask;
import com.elmakers.mine.bukkit.magic.MageClass;
import com.elmakers.mine.bukkit.magic.MageClassTemplate;
import com.elmakers.mine.bukkit.magic.MageConversation;
import com.elmakers.mine.bukkit.magic.MageLoadTask;
import com.elmakers.mine.bukkit.magic.MageModifier;
import com.elmakers.mine.bukkit.magic.MageProperties;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.magic.MaterialSets;
import com.elmakers.mine.bukkit.magic.ModifierTemplate;
import com.elmakers.mine.bukkit.magic.TemplateProperties;
import com.elmakers.mine.bukkit.magic.TemplatedProperties;
import com.elmakers.mine.bukkit.slikey.effectlib.util.VectorUtils;
import com.elmakers.mine.bukkit.spell.ActionSpell;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.spell.TriggeredSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandManaMode;
import com.elmakers.mine.bukkit.wand.WandMode;
import com.elmakers.mine.bukkit.wand.WandTemplate;
import com.google.common.base.Objects;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.WorldBorder;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.util.Vector;

public class Mage
implements CostReducer,
com.elmakers.mine.bukkit.api.magic.Mage {
    protected static int AUTOMATA_ONLINE_TIMEOUT = 5000;
    public static int CHANGE_WORLD_EQUIP_COOLDOWN = 1000;
    public static int JUMP_EFFECT_FLIGHT_EXEMPTION_DURATION = 0;
    public static int OFFHAND_CAST_RANGE = 32;
    public static int OFFHAND_CAST_COOLDOWN = 500;
    public static boolean DEACTIVATE_WAND_ON_WORLD_CHANGE = false;
    public static int DEFAULT_SP = 0;
    public static String DEFAULT_CLASS = "";
    private static String defaultMageName = "Mage";
    private static String SKILL_POINT_KEY = "sp";
    public static CastSourceLocation DEFAULT_CAST_LOCATION = CastSourceLocation.MAINHAND;
    public static Vector DEFAULT_CAST_OFFSET = new Vector(0.5, -0.5, 0.0);
    public static double SNEAKING_CAST_OFFSET = -0.2;
    protected final String id;
    @Nonnull
    private final MageProperties properties;
    private final Map<String, MageClass> classes = new HashMap<String, MageClass>();
    private final Map<String, MageModifier> modifiers = new HashMap<String, MageModifier>();
    private final Set<MageModifier> removeModifiers = new HashSet<MageModifier>();
    private final Map<String, Double> attributes = new HashMap<String, Double>();
    private ConfigurationSection variables;
    private final Map<String, List<TriggeredSpell>> triggers = new HashMap<String, List<TriggeredSpell>>();
    private final Set<String> triggeredSpells = new HashSet<String>();
    private final Set<String> triggeringSpells = new HashSet<String>();
    private final List<TriggeredSpell> processingTriggers = new ArrayList<TriggeredSpell>();
    private final Map<String, Long> lastTriggers = new HashMap<String, Long>();
    protected ConfigurationSection data = new MemoryConfiguration();
    protected Map<String, SpellData> spellData = new HashMap<String, SpellData>();
    protected WeakReference<Player> playerRef;
    protected WeakReference<Entity> entityRef;
    protected WeakReference<CommandSender> commandSenderRef;
    protected boolean hasEntity;
    protected String playerName;
    protected final MagicController controller;
    protected CommandSender debugger;
    protected HashMap<String, MageSpell> spells = new HashMap();
    private Wand activeWand = null;
    private Wand offhandWand = null;
    private MageClass activeClass = null;
    private boolean offhandCast = false;
    private Map<String, Wand> boundWands = new HashMap<String, Wand>();
    private final Collection<Listener> quitListeners = new HashSet<Listener>();
    private final Collection<Listener> deathListeners = new HashSet<Listener>();
    private final Collection<Listener> damageListeners = new HashSet<Listener>();
    private final Set<MageSpell> activeSpells = new HashSet<MageSpell>();
    private UndoQueue undoQueue = null;
    private Map<String, UndoData> externalUndoData = null;
    private Deque<Batch> pendingBatches = new ConcurrentLinkedDeque<Batch>();
    private boolean loading = false;
    private boolean unloading = false;
    private int debugLevel = 0;
    private boolean quiet = false;
    private EntityData entityData;
    private long lastTick;
    private Location lastLocation;
    private Vector velocity = new Vector();
    private long lastBlockTime;
    private long ignoreItemActivationUntil = 0L;
    private boolean forget = false;
    private long disableWandOpenUntil = 0L;
    private long created;
    private MageEffectContext effectContext = null;
    private DamagedBy topDamager;
    private DamagedBy lastDamager;
    private Map<UUID, DamagedBy> damagedBy;
    private WeakReference<Entity> lastDamageTarget;
    private Map<Player, MageConversation> conversations = new WeakHashMap<Player, MageConversation>();
    private Map<PotionEffectType, Integer> effectivePotionEffects = new HashMap<PotionEffectType, Integer>();
    private Map<String, Double> protection = new HashMap<String, Double>();
    private Map<String, Double> weakness = new HashMap<String, Double>();
    private Map<String, Double> strength = new HashMap<String, Double>();
    private float costReduction = 0.0f;
    private float cooldownReduction = 0.0f;
    private float consumeReduction = 0.0f;
    private float powerMultiplier = 1.0f;
    private float earnMultiplier = 1.0f;
    private float manaMaxBoost = 0.0f;
    private float manaRegenerationBoost = 0.0f;
    private boolean costFree = false;
    private boolean cooldownFree = false;
    private boolean resourcePackEnabled = true;
    protected boolean isVanished = false;
    protected long superProtectionExpiration = 0L;
    private Map<Integer, Wand> activeArmor = new HashMap<Integer, Wand>();
    private Location location;
    private long cooldownExpiration = 0L;
    private float magePowerBonus = 0.0f;
    private long lastClick = 0L;
    private long lastCast = 0L;
    private long lastOffhandCast = 0L;
    private long blockPlaceTimeout = 0L;
    private Location lastDeathLocation = null;
    private final com.elmakers.mine.bukkit.block.MaterialBrush brush;
    private long fallProtection = 0L;
    private long fallProtectionCount = 1L;
    private BaseSpell fallingSpell = null;
    private boolean isAutomaton = false;
    private boolean gaveWelcomeWand = false;
    private GUIAction gui = null;
    private Hologram hologram;
    private boolean hologramIsVisible = false;
    private boolean isNPC = false;
    private Map<Integer, ItemStack> respawnInventory;
    private Map<Integer, ItemStack> respawnArmor;
    private List<ItemStack> restoreInventory;
    private boolean restoreOpenWand;
    private Float restoreExperience;
    private Integer restoreLevel;
    private boolean virtualExperience = false;
    private float virtualExperienceProgress = 0.0f;
    private int virtualExperienceLevel = 0;
    private boolean glidingAllowed = false;
    private Set<String> tags = new HashSet<String>();
    private String destinationWarp;
    private Integer lastActivatedSlot;
    private String currentDamageType;
    private String lastDamageType;
    private String currentDamageDealtType;
    private String lastDamageDealtType;
    private boolean launchingProjectile;
    private double lastDamage;
    private double lastDamageDealt;
    private double lastBowPull;
    private ItemStack lastBowUsed;
    private boolean cancelLaunch = false;
    private EntityType lastProjectileType;
    private boolean bypassEnabled;

    public Mage(String id, MagicController controller) {
        this.id = id;
        this.controller = controller;
        this.brush = new com.elmakers.mine.bukkit.block.MaterialBrush((com.elmakers.mine.bukkit.api.magic.Mage)this, Material.DIRT, 0);
        this.properties = new MageProperties(this);
        this.playerRef = new WeakReference<Object>(null);
        this.entityRef = new WeakReference<Object>(null);
        this.commandSenderRef = new WeakReference<Object>(null);
        this.hasEntity = false;
        this.created = System.currentTimeMillis();
    }

    @Override
    public boolean hasStoredInventory() {
        return this.activeWand != null && this.activeWand.hasStoredInventory();
    }

    @Override
    public Set<Spell> getActiveSpells() {
        return new HashSet<Spell>(this.activeSpells);
    }

    @Nullable
    public Inventory getStoredInventory() {
        return this.activeWand != null ? this.activeWand.getStoredInventory() : null;
    }

    @Override
    public void setLocation(Location location) {
        LivingEntity entity = this.getLivingEntity();
        if (entity != null && location != null) {
            entity.teleport(location);
            return;
        }
        this.location = location;
    }

    public void setLocation(Location location, boolean direction) {
        if (!direction) {
            if (this.location == null) {
                this.location = location;
            } else {
                this.location.setX(location.getX());
                this.location.setY(location.getY());
                this.location.setZ(location.getZ());
            }
        } else {
            this.location = location;
        }
    }

    public void clearCache() {
        if (this.brush != null) {
            this.brush.clearSchematic();
        }
    }

    @Override
    public void setCostFree(boolean free) {
        this.costFree = free;
    }

    @Override
    public void setCooldownFree(boolean free) {
        this.cooldownFree = free;
    }

    @Override
    public void setPowerMultiplier(float multiplier) {
        this.powerMultiplier = multiplier;
    }

    @Override
    public float getPowerMultiplier() {
        return this.powerMultiplier;
    }

    public boolean usesMana() {
        return this.activeWand == null ? false : this.activeWand.usesMana();
    }

    @Override
    public boolean addToStoredInventory(ItemStack item) {
        return this.activeWand == null ? false : this.activeWand.addToStoredInventory(item);
    }

    public boolean cancelSelection() {
        boolean result = false;
        if (!this.activeSpells.isEmpty()) {
            ArrayList<MageSpell> active = new ArrayList<MageSpell>(this.activeSpells);
            for (MageSpell spell : active) {
                result = spell.cancelSelection() || result;
            }
        }
        return result;
    }

    public void onPlayerQuit(PlayerEvent event) {
        Player player = this.getPlayer();
        if (player == null || player != event.getPlayer()) {
            return;
        }
        ArrayList<Listener> active = new ArrayList<Listener>(this.quitListeners);
        for (Listener listener : active) {
            this.callEvent(listener, (Event)event);
        }
    }

    public void onPlayerDeath(EntityDeathEvent event) {
        Player player = this.getPlayer();
        if (!player.hasMetadata("arena")) {
            this.lastDeathLocation = player.getLocation();
        }
        ArrayList<Listener> active = new ArrayList<Listener>(this.deathListeners);
        for (Listener listener : active) {
            this.callEvent(listener, (Event)event);
        }
    }

    public void onDeath(EntityDeathEvent event) {
        Player player;
        Iterator<Batch> iterator = this.pendingBatches.iterator();
        while (iterator.hasNext()) {
            SpellBatch spellBatch;
            Spell spell;
            Batch batch = iterator.next();
            if (!(batch instanceof SpellBatch) || !(spell = (spellBatch = (SpellBatch)batch).getSpell()).cancelOnDeath()) continue;
            spell.cancel();
            batch.finish();
            iterator.remove();
        }
        if (this.getEntity() == event.getEntity()) {
            this.trigger("death");
        }
        if ((player = this.getPlayer()) != null && player == event.getEntity()) {
            this.onPlayerDeath(event);
            return;
        }
        if (this.effectContext != null) {
            this.effectContext.cancelEffects();
            this.effectContext = null;
        }
    }

    public void onCombust(EntityCombustEvent event) {
        if (this.getProtection("fire") >= 1.0) {
            event.getEntity().setFireTicks(0);
            event.setCancelled(true);
        }
    }

    protected void callEvent(Listener listener, Event event) {
        for (Method method : listener.getClass().getMethods()) {
            Class<?>[] parameters;
            if (!method.isAnnotationPresent(EventHandler.class) || (parameters = method.getParameterTypes()).length != 1 || !parameters[0].isAssignableFrom(event.getClass())) continue;
            try {
                method.invoke((Object)listener, event);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void setTarget(Entity target) {
        if (this.entityData != null && !this.entityData.shouldFocusOnDamager()) {
            return;
        }
        LivingEntity li = this.getLivingEntity();
        if (li != null && li instanceof Creature && target instanceof LivingEntity) {
            Creature creature = (Creature)li;
            if (creature.getTarget() != target) {
                this.sendDebugMessage("Now targeting " + target.getName(), 6);
            }
            creature.setTarget((LivingEntity)target);
        }
    }

    @Override
    @Nullable
    public Collection<Entity> getDamagers() {
        if (this.damagedBy == null) {
            return null;
        }
        ArrayList<Entity> damagers = new ArrayList<Entity>();
        for (DamagedBy damager : this.damagedBy.values()) {
            Entity entity = damager.getEntity();
            if (entity == null) continue;
            damagers.add(entity);
        }
        return damagers;
    }

    @Override
    @Nullable
    public Entity getLastDamager() {
        return this.lastDamager == null ? null : this.lastDamager.getEntity();
    }

    @Override
    @Nullable
    public Entity getLastDamageTarget() {
        return this.lastDamageTarget == null ? null : (Entity)this.lastDamageTarget.get();
    }

    @Override
    @Nullable
    public Entity getTopDamager() {
        if (this.topDamager == null) {
            return null;
        }
        Entity topEntity = this.topDamager.getEntity();
        if (topEntity == null && this.damagedBy != null) {
            double topDamage = 0.0;
            Iterator<Map.Entry<UUID, DamagedBy>> it = this.damagedBy.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<UUID, DamagedBy> entry = it.next();
                DamagedBy damaged = entry.getValue();
                Entity entity = damaged.getEntity();
                if (entity != null && entity.isValid() && !entity.isDead()) {
                    boolean withinRange = this.withinRange(entity);
                    if (!withinRange || !(damaged.damage > topDamage)) continue;
                    topEntity = entity;
                    topDamage = damaged.damage;
                    this.topDamager = damaged;
                    continue;
                }
                it.remove();
            }
        }
        return topEntity;
    }

    private boolean withinRange(Entity entity) {
        double rangeSquared;
        boolean withinRange = this.getLocation().getWorld().getName().equals(entity.getLocation().getWorld().getName());
        double d = rangeSquared = this.entityData == null ? 0.0 : this.entityData.getTrackRadiusSquared();
        if (rangeSquared > 0.0 && withinRange) {
            withinRange = this.getLocation().distanceSquared(entity.getLocation()) <= rangeSquared;
        }
        return withinRange;
    }

    @Override
    public void damagedBy(@Nonnull Entity damager, double damage) {
        this.lastDamage = damage;
        if (this.damagedBy == null) {
            return;
        }
        if (!((damager = CompatibilityUtils.getSource(damager)) instanceof Player)) {
            return;
        }
        Player damagingPlayer = (Player)damager;
        this.lastDamager = this.damagedBy.get(damagingPlayer.getUniqueId());
        if (this.lastDamager == null) {
            this.lastDamager = new DamagedBy(damagingPlayer, damage);
            this.damagedBy.put(damagingPlayer.getUniqueId(), this.lastDamager);
        } else {
            this.lastDamager.damage += damage;
        }
        if (this.topDamager != null) {
            if (this.topDamager.getEntity() == null || this.topDamager.damage < this.lastDamager.damage || !this.withinRange(this.topDamager.getEntity())) {
                this.topDamager = this.lastDamager;
                this.setTarget((Entity)damagingPlayer);
            }
        } else {
            this.topDamager = this.lastDamager;
            this.setTarget((Entity)damagingPlayer);
        }
    }

    public void onDamageDealt(EntityDamageEvent event) {
        String damageType = this.currentDamageDealtType;
        this.lastDamageTarget = new WeakReference<Entity>(event.getEntity());
        this.lastDamageDealt = event.getDamage();
        this.currentDamageDealtType = null;
        this.lastDamageDealtType = this.getDamageType(damageType, event.getCause());
        this.trigger("damage_dealt");
    }

    private String getDamageType(String damageType, EntityDamageEvent.DamageCause cause) {
        if (damageType == null) {
            switch (cause) {
                case CONTACT: 
                case ENTITY_ATTACK: {
                    damageType = "physical";
                    break;
                }
                case FIRE: 
                case FIRE_TICK: 
                case LAVA: {
                    damageType = "fire";
                    break;
                }
                case BLOCK_EXPLOSION: 
                case ENTITY_EXPLOSION: {
                    damageType = "explosion";
                    break;
                }
                default: {
                    damageType = cause.name().toLowerCase();
                }
            }
        }
        return damageType;
    }

    public void onDamage(EntityDamageEvent event) {
        double damageReductionFire;
        double defendMultiplier;
        EntityDamageEvent.DamageCause cause;
        String damageType = this.currentDamageType;
        this.currentDamageType = null;
        this.lastDamage = event.getDamage();
        LivingEntity entity = this.getLivingEntity();
        if (entity == null) {
            return;
        }
        ArrayList<Listener> active = new ArrayList<Listener>(this.damageListeners);
        for (Listener listener : active) {
            this.callEvent(listener, (Event)event);
            if (!event.isCancelled()) continue;
            break;
        }
        if ((cause = event.getCause()) == EntityDamageEvent.DamageCause.FALL) {
            if (this.fallProtectionCount > 0L && this.fallProtection > 0L && this.fallProtection > System.currentTimeMillis()) {
                event.setCancelled(true);
                --this.fallProtectionCount;
                if (this.fallingSpell != null) {
                    double scale = 1.0;
                    LivingEntity li = this.getLivingEntity();
                    if (li != null) {
                        scale = event.getDamage() / CompatibilityUtils.getMaxHealth((Damageable)li);
                    }
                    this.fallingSpell.playEffects("land", (float)scale, this.getLocation().getBlock().getRelative(BlockFace.DOWN));
                }
                if (this.fallProtectionCount <= 0L) {
                    this.fallProtection = 0L;
                    this.fallingSpell = null;
                }
                return;
            }
            this.fallingSpell = null;
        }
        if (this.isSuperProtected()) {
            event.setCancelled(true);
            if (entity.getFireTicks() > 0) {
                entity.setFireTicks(0);
            }
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        double reduction = 0.0;
        Double overallProtection = this.protection.get("overall");
        if (overallProtection != null) {
            reduction = overallProtection * this.controller.getMaxDamageReduction("overall");
        }
        double multiplier = 1.0;
        Double overallWeakness = this.weakness.get("overall");
        if (overallWeakness != null && overallWeakness > 0.0 && (defendMultiplier = this.controller.getMaxDefendMultiplier("overall")) > 1.0) {
            defendMultiplier = 1.0 + (defendMultiplier - 1.0) * overallWeakness;
            multiplier *= defendMultiplier;
        }
        if (cause == EntityDamageEvent.DamageCause.FIRE_TICK && (damageReductionFire = this.getProtection("fire")) >= 1.0 && entity.getFireTicks() > 0) {
            entity.setFireTicks(0);
        }
        damageType = this.lastDamageType = this.getDamageType(damageType, cause);
        this.trigger("damage");
        double protection = this.getProtection(damageType);
        double maxReduction = this.controller.getMaxDamageReduction(damageType);
        reduction += protection * maxReduction;
        if (reduction >= 1.0) {
            event.setCancelled(true);
            this.sendDebugMessage(ChatColor.RED + "Damage nullified by " + ChatColor.BLUE + damageType + " (" + cause + ")", 8);
            return;
        }
        double damage = event.getDamage();
        this.sendDebugMessage(ChatColor.RED + "Damaged by " + ChatColor.BLUE + (damageType == null ? "generic" : damageType) + " (" + cause + ")" + ChatColor.RED + " for " + ChatColor.DARK_RED + damage, 10);
        if (reduction > 0.0) {
            damage = (1.0 - reduction) * damage;
            this.sendDebugMessage(ChatColor.DARK_RED + "Damage type " + ChatColor.BLUE + damageType + " reduced by " + ChatColor.AQUA + reduction + ChatColor.DARK_RED + " to " + ChatColor.RED + damage, 9);
            event.setDamage(damage);
        }
        double weakness = this.getWeakness(damageType);
        double maxMultiplier = this.controller.getMaxDefendMultiplier(damageType);
        if (maxMultiplier > 1.0 && weakness > 0.0) {
            weakness = 1.0 + (maxMultiplier - 1.0) * weakness;
            multiplier *= weakness;
        }
        if (multiplier > 1.0) {
            damage = multiplier * damage;
            this.sendDebugMessage(ChatColor.DARK_RED + "Damage type " + ChatColor.BLUE + damageType + " multiplied by " + ChatColor.AQUA + multiplier + ChatColor.DARK_RED + " to " + ChatColor.RED + damage, 9);
            event.setDamage(damage);
        }
        if (damage > 0.0) {
            Iterator<Batch> iterator = this.pendingBatches.iterator();
            while (iterator.hasNext()) {
                SpellBatch spellBatch;
                Spell spell;
                double cancelOnDamage;
                Batch batch = iterator.next();
                if (!(batch instanceof SpellBatch) || !((cancelOnDamage = (spell = (spellBatch = (SpellBatch)batch).getSpell()).cancelOnDamage()) > 0.0) || !(cancelOnDamage < damage)) continue;
                spell.cancel();
                batch.finish();
                iterator.remove();
            }
        }
    }

    public double getProtection(String damageType) {
        Double value = this.protection.get(damageType);
        return value == null ? 0.0 : value;
    }

    public double getWeakness(String damageType) {
        Double value = this.weakness.get(damageType);
        return value == null ? 0.0 : value;
    }

    @Override
    public void unbindAll() {
        this.boundWands.clear();
    }

    @Override
    public void unbind(com.elmakers.mine.bukkit.api.wand.Wand wand) {
        this.unbind(wand.getTemplateKey());
    }

    @Override
    public boolean unbind(String template) {
        if (template != null) {
            return this.boundWands.remove(template) != null;
        }
        return false;
    }

    public void checkActiveSpells(Wand wand) {
        Iterator<Batch> iterator = this.pendingBatches.iterator();
        while (iterator.hasNext()) {
            SpellBatch spellBatch;
            Spell spell;
            Batch batch = iterator.next();
            if (!(batch instanceof SpellBatch) || !(spell = (spellBatch = (SpellBatch)batch).getSpell()).cancelOnNoWand() || spell.getCurrentCast().getWand() != wand) continue;
            spell.cancel();
            batch.finish();
            iterator.remove();
        }
        if (this.activeSpells.isEmpty()) {
            return;
        }
        ArrayList<MageSpell> active = new ArrayList<MageSpell>(this.activeSpells);
        for (MageSpell spell : active) {
            if (!spell.cancelOnNoWand() || spell.getCurrentCast().getWand() != wand) continue;
            spell.deactivate();
        }
    }

    protected void deactivateWand() {
        if (this.activeWand != null) {
            this.activeWand.deactivate();
        }
    }

    public void deactivateWand(Wand wand) {
        if (wand == null) {
            return;
        }
        if (wand == this.activeWand) {
            this.checkActiveSpells(this.activeWand);
            this.setActiveWand(null);
        }
        if (wand == this.offhandWand) {
            this.checkActiveSpells(this.activeWand);
            this.setOffhandWand(null);
        }
        WandDeactivatedEvent event = new WandDeactivatedEvent(this, wand);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public void onTeleport(PlayerTeleportEvent event) {
        if (DEACTIVATE_WAND_ON_WORLD_CHANGE) {
            Location from = event.getFrom();
            Location to = event.getTo();
            if (from.getWorld().equals(to.getWorld())) {
                return;
            }
            this.deactivateWand();
        }
    }

    public void onChangeWorld() {
        this.checkWandNextTick(true);
        if (CHANGE_WORLD_EQUIP_COOLDOWN > 0) {
            this.ignoreItemActivationUntil = System.currentTimeMillis() + (long)CHANGE_WORLD_EQUIP_COOLDOWN;
        }
    }

    public void activateIcon(Wand activeWand, ItemStack icon) {
        if (System.currentTimeMillis() < this.ignoreItemActivationUntil) {
            return;
        }
        if (icon != null && icon.getType() != Material.AIR) {
            MageSpell spell = this.getSpell(Wand.getSpell(icon));
            if (spell != null) {
                boolean isQuickCast = spell.isQuickCast() && !activeWand.isQuickCastDisabled();
                boolean bl = isQuickCast = isQuickCast || activeWand.getMode() == WandMode.CHEST && activeWand.isQuickCast();
                if (spell.isPassive()) {
                    this.toggleSpellEnabled(spell);
                } else if (isQuickCast) {
                    activeWand.cast(spell);
                } else {
                    activeWand.setActiveSpell(spell.getKey());
                }
            } else if (Wand.isBrush(icon)) {
                activeWand.setActiveBrush(icon);
            }
        } else {
            activeWand.setActiveSpell("");
        }
        DeprecatedUtils.updateInventory(this.getPlayer());
    }

    public void setActiveWand(Wand activeWand) {
        if (this.activeWand == activeWand) {
            return;
        }
        this.activeWand = activeWand;
        if (activeWand != null && activeWand.isBound() && activeWand.canUse(this.getPlayer())) {
            this.addBound(activeWand);
        }
        this.blockPlaceTimeout = System.currentTimeMillis() + 200L;
        this.updatePassiveEffects();
        if (activeWand != null && !this.isLoading()) {
            WandActivatedEvent activatedEvent = new WandActivatedEvent(this, activeWand);
            Bukkit.getPluginManager().callEvent((Event)activatedEvent);
        }
    }

    public void setOffhandWand(Wand offhandWand) {
        if (this.offhandWand == offhandWand) {
            return;
        }
        this.offhandWand = offhandWand;
        if (offhandWand != null && offhandWand.isBound() && offhandWand.canUse(this.getPlayer())) {
            this.addBound(offhandWand);
        }
        this.blockPlaceTimeout = System.currentTimeMillis() + 200L;
        this.updatePassiveEffects();
        if (offhandWand != null && !this.isLoading()) {
            WandActivatedEvent activatedEvent = new WandActivatedEvent(this, offhandWand);
            Bukkit.getPluginManager().callEvent((Event)activatedEvent);
        }
    }

    @Override
    public boolean tryToOwn(com.elmakers.mine.bukkit.api.wand.Wand wand) {
        if (this.isPlayer() && wand instanceof Wand && ((Wand)wand).tryToOwn(this.getPlayer())) {
            this.addBound((Wand)wand);
            return true;
        }
        return false;
    }

    protected void addBound(Wand wand) {
        String templateKey;
        WandTemplate template = wand.getTemplate();
        if (template != null && template.isRestorable() && (templateKey = template.getKey()) != null && !templateKey.isEmpty()) {
            this.boundWands.put(templateKey, wand);
        }
    }

    public long getBlockPlaceTimeout() {
        return this.blockPlaceTimeout;
    }

    @Override
    public void castMessage(String message) {
        if (!this.controller.showCastMessages()) {
            return;
        }
        this.sendMessage(this.controller.getCastMessagePrefix(), message);
    }

    @Override
    public void sendMessage(String message) {
        this.sendMessage(this.controller.getMessagePrefix(), message);
    }

    public void sendMessage(String prefix, String message) {
        if (message == null || message.length() == 0 || this.quiet || !this.controller.showMessages()) {
            return;
        }
        Mage.sendMessage(this.getCommandSender(), this.getPlayer(), prefix, message);
    }

    public static void sendMessage(CommandSender sender, Player player, String prefix, String message) {
        String[] messages;
        if (message == null || message.length() == 0 || sender == null) {
            return;
        }
        boolean isTitle = false;
        boolean isActionBar = false;
        if (prefix.startsWith("a:")) {
            isActionBar = true;
            prefix = prefix.substring(2);
        } else if (prefix.startsWith("t:")) {
            isTitle = true;
            prefix = prefix.substring(2);
        }
        if (message.startsWith("t:")) {
            isTitle = true;
            isActionBar = false;
            message = message.substring(2);
        }
        if ((messages = StringUtils.split((String)message, (String)"\n")).length == 0) {
            return;
        }
        if (isTitle && player != null) {
            String fullMessage = prefix + messages[0];
            String subtitle = messages.length > 1 ? prefix + messages[1] : null;
            CompatibilityUtils.sendTitle(player, fullMessage, subtitle, -1, -1, -1);
            if (messages.length > 2) {
                messages = Arrays.copyOfRange(messages, 2, messages.length);
            } else {
                return;
            }
        }
        for (String line : messages) {
            boolean lineIsActionBar = isActionBar;
            if (line.startsWith("a:")) {
                lineIsActionBar = true;
                line = line.substring(2);
            }
            String fullMessage = prefix + line;
            if (lineIsActionBar && player != null) {
                CompatibilityUtils.sendActionBar(player, fullMessage);
                continue;
            }
            sender.sendMessage(fullMessage);
        }
    }

    public void clearBuildingMaterial() {
        this.brush.setMaterial(this.controller.getDefaultMaterial(), (short)1);
    }

    @Override
    public void playSoundEffect(SoundEffect soundEffect) {
        if (!this.controller.soundsEnabled() || soundEffect == null) {
            return;
        }
        soundEffect.play((Plugin)this.controller.getPlugin(), this.getEntity());
    }

    @Override
    public UndoQueue getUndoQueue() {
        if (this.undoQueue == null) {
            this.undoQueue = new UndoQueue(this);
            this.undoQueue.setMaxSize(this.controller.getUndoQueueDepth());
        }
        return this.undoQueue;
    }

    @Override
    @Nullable
    public UndoList getLastUndoList() {
        if (this.undoQueue == null || this.undoQueue.isEmpty()) {
            return null;
        }
        return this.undoQueue.getLast();
    }

    @Override
    public boolean prepareForUndo(UndoList undoList) {
        if (undoList == null) {
            return false;
        }
        if (undoList.bypass()) {
            return false;
        }
        UndoQueue queue = this.getUndoQueue();
        queue.add(undoList);
        return true;
    }

    @Override
    public boolean registerForUndo(UndoList undoList) {
        if (!this.prepareForUndo(undoList)) {
            return false;
        }
        int autoUndo = this.controller.getAutoUndoInterval();
        if (autoUndo > 0 && undoList.getScheduledUndo() == 0) {
            undoList.setScheduleUndo(autoUndo);
        } else {
            undoList.updateScheduledUndo();
        }
        if (!undoList.hasBeenScheduled() && undoList.isScheduled()) {
            if (undoList.hasChanges()) {
                this.controller.scheduleUndo(undoList);
            } else {
                this.undoQueue.skippedUndo(undoList);
            }
        }
        return true;
    }

    @Override
    public void addUndoBatch(UndoBatch batch) {
        this.pendingBatches.addLast(batch);
        this.controller.addPending(this);
    }

    protected void setPlayer(Player player) {
        if (player != null) {
            this.playerName = player.getName();
            this.playerRef = new WeakReference<Player>(player);
            this.entityRef = new WeakReference<Player>(player);
            this.commandSenderRef = new WeakReference<Player>(player);
            this.hasEntity = true;
        } else {
            this.playerRef.clear();
            this.entityRef.clear();
            this.commandSenderRef.clear();
            this.hasEntity = false;
        }
    }

    protected void setEntity(Entity entity) {
        if (entity != null) {
            LivingEntity li;
            String customName;
            this.playerName = entity.getType().name().toLowerCase().replace("_", " ");
            if (entity instanceof LivingEntity && (customName = (li = (LivingEntity)entity).getCustomName()) != null && customName.length() > 0) {
                this.playerName = customName;
            }
            this.entityRef = new WeakReference<Entity>(entity);
            this.hasEntity = true;
            this.isNPC = this.controller.isNPC(entity);
        } else {
            this.entityRef.clear();
            this.hasEntity = false;
            this.isNPC = false;
        }
    }

    protected void setCommandSender(CommandSender sender) {
        if (sender != null) {
            this.commandSenderRef = new WeakReference<CommandSender>(sender);
            if (sender instanceof BlockCommandSender) {
                BlockCommandSender commandBlock = (BlockCommandSender)sender;
                this.playerName = commandBlock.getName();
                Location location = this.getLocation();
                if (location == null) {
                    location = commandBlock.getBlock().getLocation();
                } else {
                    Location blockLocation = commandBlock.getBlock().getLocation();
                    location.setX(blockLocation.getX());
                    location.setY(blockLocation.getY());
                    location.setZ(blockLocation.getZ());
                }
                this.setLocation(location, false);
            } else {
                this.setLocation(null);
            }
        } else {
            this.commandSenderRef.clear();
            this.setLocation(null);
        }
    }

    protected void onLoad(MageData data) {
        try {
            Player player;
            Collection<SpellData> spellDataList;
            Collection<SpellData> collection = spellDataList = data == null ? null : data.getSpellData();
            if (spellDataList != null) {
                for (SpellData spellData : spellDataList) {
                    this.spellData.put(spellData.getKey().getKey(), spellData);
                }
            }
            if ((player = this.getPlayer()) != null) {
                if (this.controller.isInventoryBackupEnabled()) {
                    if (this.restoreInventory != null) {
                        this.controller.getLogger().info("Restoring saved inventory for player " + player.getName() + " - did the server not shut down properly?");
                        if (this.activeWand != null) {
                            this.activeWand.deactivate();
                        }
                        PlayerInventory inventory = player.getInventory();
                        for (int slot = 0; slot < this.restoreInventory.size(); ++slot) {
                            ItemStack item = this.restoreInventory.get(slot);
                            if (item instanceof ItemStack) {
                                inventory.setItem(slot, item);
                                continue;
                            }
                            inventory.setItem(slot, null);
                        }
                        this.restoreInventory = null;
                    }
                    if (this.restoreExperience != null) {
                        player.setExp(this.restoreExperience.floatValue());
                        this.restoreExperience = null;
                    }
                    if (this.restoreLevel != null) {
                        player.setLevel(this.restoreLevel.intValue());
                        this.restoreLevel = null;
                    }
                }
                if (this.activeWand == null) {
                    String welcomeWand = this.controller.getWelcomeWand();
                    if (!this.gaveWelcomeWand && welcomeWand.length() > 0) {
                        this.gaveWelcomeWand = true;
                        Wand wand = Wand.createWand(this.controller, welcomeWand);
                        if (wand != null) {
                            wand.takeOwnership(player);
                            this.giveItem(wand.getItem());
                            this.controller.getLogger().info("Gave welcome wand " + wand.getName() + " to " + player.getName());
                        } else {
                            this.controller.getLogger().warning("Unable to give welcome wand '" + welcomeWand + "' to " + player.getName());
                        }
                    }
                }
                if (this.activeWand != null && this.restoreOpenWand && !this.activeWand.isInventoryOpen()) {
                    this.activeWand.openInventory();
                }
                this.restoreOpenWand = false;
            }
            this.loading = false;
            this.getActiveClass();
            this.armorUpdated();
            this.trigger("join");
        }
        catch (Exception ex) {
            this.controller.getLogger().warning("Error finalizing player data for " + this.playerName + ": " + ex.getMessage());
        }
    }

    protected void finishLoad(MageData data) {
        MageLoadTask loadTask = new MageLoadTask(this, data);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.controller.getPlugin(), (Runnable)loadTask, 1L);
    }

    @Override
    public boolean load(MageData data) {
        try {
            boolean bl;
            if (data == null) {
                this.finishLoad(data);
                return true;
            }
            this.data = data.getExtraData();
            this.properties.load(data.getProperties());
            this.properties.loadProperties();
            this.variables = data.getVariables();
            this.boundWands.clear();
            Map<String, ItemStack> boundWandItems = data.getBoundWands();
            if (boundWandItems != null) {
                for (ItemStack boundWandItem : boundWandItems.values()) {
                    try {
                        Wand wand = this.controller.getWand(boundWandItem);
                        String string = wand.getTemplateKey();
                        if (string == null || string.isEmpty()) continue;
                        this.boundWands.put(string, wand);
                    }
                    catch (Exception exception) {
                        this.controller.getLogger().log(Level.WARNING, "Failed to load bound wand for " + this.playerName + ": " + boundWandItem, exception);
                    }
                }
            }
            this.classes.clear();
            Map<String, ConfigurationSection> classProperties = data.getClassProperties();
            for (Map.Entry entry : classProperties.entrySet()) {
                String string = (String)entry.getKey();
                MageClassTemplate classTemplate = this.controller.getMageClass(string);
                if (classTemplate == null) continue;
                MageClass newClass = new MageClass(this, classTemplate);
                newClass.load((ConfigurationSection)entry.getValue());
                this.classes.put(string, newClass);
            }
            this.modifiers.clear();
            Map<String, ConfigurationSection> modifierProperties = data.getModifierProperties();
            for (Map.Entry<String, ConfigurationSection> entry : modifierProperties.entrySet()) {
                String modifierKey = entry.getKey();
                ModifierTemplate template = this.controller.getModifierTemplate(modifierKey);
                if (template == null) continue;
                MageModifier newModifier = new MageModifier(this, template);
                newModifier.load(entry.getValue());
                this.modifiers.put(modifierKey, newModifier);
            }
            HashSet<String> hashSet = new HashSet<String>();
            boolean bl2 = false;
            while (!bl) {
                ArrayList<MageClass> mageClasses = new ArrayList<MageClass>(this.classes.values());
                for (MageClass mageClass : mageClasses) {
                    if (hashSet.contains(mageClass.getKey())) continue;
                    hashSet.add(mageClass.getKey());
                    this.assignParent(mageClass);
                }
                bl = hashSet.containsAll(this.classes.keySet());
            }
            this.activateClasses();
            this.activateModifiers();
            this.setActiveClass(data.getActiveClass());
            double health = data.getHealth();
            LivingEntity li = this.getLivingEntity();
            if (health > 0.0 && li != null) {
                health = Math.min(health, CompatibilityUtils.getMaxHealth((Damageable)li));
                li.setHealth(health);
            }
            this.cooldownExpiration = data.getCooldownExpiration();
            this.fallProtectionCount = data.getFallProtectionCount();
            this.fallProtection = data.getFallProtectionDuration();
            if (this.fallProtectionCount > 0L && this.fallProtection > 0L) {
                this.fallProtection = System.currentTimeMillis() + this.fallProtection;
            }
            this.resourcePackEnabled = data.getResourcePackEnabled();
            this.gaveWelcomeWand = data.getGaveWelcomeWand();
            this.playerName = data.getName();
            this.lastDeathLocation = data.getLastDeathLocation();
            this.lastCast = data.getLastCast();
            this.created = data.getCreatedTime();
            this.destinationWarp = data.getDestinationWarp();
            if (this.destinationWarp != null) {
                if (!this.destinationWarp.isEmpty()) {
                    Location destination = this.controller.getWarp(this.destinationWarp);
                    if (destination != null) {
                        MagicPlugin plugin = this.controller.getPlugin();
                        this.controller.info("Warping " + this.getEntity().getName() + " to " + this.destinationWarp + " on login");
                        TeleportTask task = new TeleportTask(this.getController(), this.getEntity(), destination, 4, true, true, null);
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, (Runnable)task, 1L);
                    } else {
                        this.controller.info("Failed to warp " + this.getEntity().getName() + " to " + this.destinationWarp + " on login, warp doesn't exist");
                    }
                }
                this.destinationWarp = null;
            }
            this.getUndoQueue().load(data.getUndoData());
            this.externalUndoData = data.getExternalUndoData();
            this.respawnInventory = data.getRespawnInventory();
            this.respawnArmor = data.getRespawnArmor();
            this.restoreOpenWand = data.isOpenWand();
            BrushData brushData = data.getBrushData();
            if (brushData != null) {
                this.brush.load(brushData);
            }
            if (this.controller.isInventoryBackupEnabled()) {
                this.restoreInventory = data.getStoredInventory();
                this.restoreLevel = data.getStoredLevel();
                this.restoreExperience = data.getStoredExperience();
            }
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.WARNING, "Failed to load player data for " + this.playerName, ex);
            return false;
        }
        this.finishLoad(data);
        return true;
    }

    @Override
    @Nullable
    public MageClass getActiveClass() {
        if (this.activeClass == null && !DEFAULT_CLASS.isEmpty()) {
            this.setActiveClass(DEFAULT_CLASS);
        }
        return this.activeClass;
    }

    @Override
    public boolean setActiveClass(String classKey) {
        if (classKey == null) {
            this.activeClass = null;
            return true;
        }
        MageClass targetClass = this.getClass(classKey);
        if (targetClass == null) {
            return false;
        }
        this.activeClass = targetClass;
        this.activeClass.loadProperties();
        this.updatePassiveEffects();
        return true;
    }

    @Override
    public boolean removeClass(String classKey) {
        if (!this.classes.containsKey(classKey)) {
            return false;
        }
        this.classes.get(classKey).onRemoved();
        this.classes.remove(classKey);
        if (this.activeClass != null && this.activeClass.getTemplate().getKey().equals(classKey)) {
            this.activeClass = null;
        }
        return true;
    }

    public boolean canUse(ItemStack itemStack) {
        String lockKey = this.controller.getLockKey(itemStack);
        if (lockKey == null) {
            return true;
        }
        for (MageClass mageClass : this.classes.values()) {
            if (mageClass.isLocked() || !mageClass.canUse(lockKey)) continue;
            return true;
        }
        return false;
    }

    public boolean useArrow(ItemStack itemStack, int slot, ProjectileLaunchEvent event) {
        String spellKey = Wand.getArrowSpell(itemStack);
        if (spellKey == null) {
            return false;
        }
        MageSpell spell = this.getSpell(spellKey);
        if (spell == null) {
            return false;
        }
        event.setCancelled(true);
        String skillClass = Wand.getArrowSpellClass(itemStack);
        if (skillClass != null && !skillClass.isEmpty() && !this.setActiveClass(skillClass)) {
            this.sendMessage(this.controller.getMessages().get("mage.no_class").replace("$name", spell.getName()));
            return false;
        }
        if (!this.canUse(itemStack)) {
            this.sendMessage(this.controller.getMessages().get("mage.no_class").replace("$name", spell.getName()));
            return false;
        }
        if (!this.isCostFree()) {
            if (itemStack.getAmount() <= 1) {
                this.clearSlot(slot);
            } else {
                itemStack.setAmount(itemStack.getAmount() - 1);
            }
        }
        try {
            spell.cast();
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.SEVERE, "Error casting arrow spell", ex);
        }
        return true;
    }

    public boolean useSkill(ItemStack skillItem) {
        MageSpell spell = this.getSpell(Wand.getSpell(skillItem));
        if (spell == null) {
            return false;
        }
        if (spell.isPassive()) {
            if (spell.isToggleable()) {
                spell.setEnabled(!spell.isEnabled());
                Wand.updateSpellItem(this.controller.getMessages(), skillItem, spell, "", null, null, false);
            }
            return true;
        }
        boolean canUse = true;
        String skillClass = Wand.getSpellClass(skillItem);
        if (skillClass != null && !skillClass.isEmpty()) {
            if (!this.setActiveClass(skillClass)) {
                canUse = false;
                this.sendMessage(this.controller.getMessages().get("mage.no_class").replace("$name", spell.getName()));
            } else if (!this.activeClass.hasSpell(spell.getKey())) {
                canUse = false;
                this.sendMessage(this.controller.getMessages().get("mage.no_spell").replace("$name", spell.getName()));
            }
        }
        if (canUse) {
            Wand activeWand = this.activeWand;
            this.activeWand = null;
            spell.cast();
            this.activeWand = activeWand;
        }
        return canUse;
    }

    @Override
    @Nullable
    public MageClass unlockClass(@Nonnull String key) {
        return this.getClass(key, true);
    }

    @Override
    public boolean lockClass(@Nonnull String key) {
        MageClass mageClass = this.getClass(key);
        if (mageClass == null) {
            return false;
        }
        mageClass.lock();
        if (this.activeClass != null && this.activeClass.isLocked()) {
            this.setActiveClass(null);
        }
        this.checkWand();
        this.checkOffhandWand();
        return true;
    }

    @Override
    @Nonnull
    public Collection<com.elmakers.mine.bukkit.api.magic.MageClass> getClasses() {
        ArrayList<com.elmakers.mine.bukkit.api.magic.MageClass> mageClasses = new ArrayList<com.elmakers.mine.bukkit.api.magic.MageClass>();
        mageClasses.addAll(this.classes.values());
        return mageClasses;
    }

    @Override
    @Nonnull
    public Collection<String> getClassKeys() {
        return this.classes.keySet();
    }

    @Override
    @Nullable
    public MageClass getClass(@Nonnull String key) {
        return this.getClass(key, false);
    }

    @Nullable
    private MageClass getClass(@Nonnull String key, boolean unlock) {
        MageClassTemplate template;
        MageClass mageClass = this.classes.get(key);
        if (mageClass == null && (template = this.controller.getMageClass(key)) != null && (unlock || !template.isLocked())) {
            mageClass = new MageClass(this, template);
            this.assignParent(mageClass);
            this.classes.put(key, mageClass);
            mageClass.onUnlocked();
        }
        if (mageClass != null && mageClass.isLocked()) {
            if (unlock) {
                mageClass.unlock();
            } else {
                mageClass = null;
            }
        }
        return mageClass;
    }

    @Override
    public boolean hasClassUnlocked(@Nonnull String key) {
        MageClass mageClass = this.classes.get(key);
        return mageClass != null && !mageClass.isLocked();
    }

    private void assignParent(MageClass mageClass) {
        MageClass parentClass;
        TemplateProperties template = mageClass.getTemplate();
        TemplateProperties parentTemplate = template.getParent();
        if (parentTemplate != null && (parentClass = this.getClass(parentTemplate.getKey(), true)) != null) {
            mageClass.setParent(parentClass);
        }
    }

    @Override
    public boolean save(MageData data) {
        if (this.loading) {
            return false;
        }
        try {
            data.setName(this.getName());
            data.setId(this.getId());
            data.setCreatedTime(this.created);
            data.setLastCast(this.lastCast);
            data.setLastDeathLocation(this.lastDeathLocation);
            data.setLocation(this.location);
            data.setDestinationWarp(this.destinationWarp);
            data.setCooldownExpiration(this.cooldownExpiration);
            long now = System.currentTimeMillis();
            if (this.fallProtectionCount > 0L && this.fallProtection > now) {
                data.setFallProtectionCount(this.fallProtectionCount);
                data.setFallProtectionDuration(this.fallProtection - now);
            } else {
                data.setFallProtectionCount(0L);
                data.setFallProtectionDuration(0L);
            }
            BrushData brushData = new BrushData();
            this.brush.save(brushData);
            data.setBrushData(brushData);
            UndoData undoData = new UndoData();
            this.getUndoQueue().save(undoData);
            data.setUndoData(undoData);
            data.setExternalUndoData(this.externalUndoData);
            data.setSpellData(this.spellData.values());
            if (this.boundWands.size() > 0) {
                HashMap<String, ItemStack> wandItems = new HashMap<String, ItemStack>();
                for (Map.Entry<String, Wand> entry : this.boundWands.entrySet()) {
                    wandItems.put(entry.getKey(), entry.getValue().getItem());
                }
                data.setBoundWands(wandItems);
            }
            data.setRespawnArmor(this.respawnArmor);
            data.setRespawnInventory(this.respawnInventory);
            data.setOpenWand(false);
            if (this.activeWand != null) {
                if (this.activeWand.hasStoredInventory()) {
                    data.setStoredInventory(Arrays.asList(this.activeWand.getStoredInventory().getContents()));
                }
                if (this.activeWand.isInventoryOpen()) {
                    data.setOpenWand(true);
                }
            }
            data.setGaveWelcomeWand(this.gaveWelcomeWand);
            data.setResourcePackEnabled(this.resourcePackEnabled);
            data.setExtraData(this.data);
            data.setProperties(this.properties.getConfiguration());
            data.setVariables(this.variables);
            HashMap<String, ConfigurationSection> classProperties = new HashMap<String, ConfigurationSection>();
            for (Map.Entry<String, TemplatedProperties> entry : this.classes.entrySet()) {
                classProperties.put(entry.getKey(), ((MageClass)entry.getValue()).getConfiguration());
            }
            data.setClassProperties(classProperties);
            HashMap<String, ConfigurationSection> modifierProperties = new HashMap<String, ConfigurationSection>();
            for (Map.Entry<String, MageModifier> entry : this.modifiers.entrySet()) {
                modifierProperties.put(entry.getKey(), entry.getValue().getConfiguration());
            }
            data.setModifierProperties(modifierProperties);
            String string = this.activeClass == null ? null : this.activeClass.getTemplate().getKey();
            data.setActiveClass(string);
            LivingEntity livingEntity = this.getLivingEntity();
            if (livingEntity != null) {
                data.setHealth(livingEntity.getHealth());
            }
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.WARNING, "Failed to save player data for " + this.playerName, ex);
            return false;
        }
        return true;
    }

    public boolean checkLastClick(long maxInterval) {
        long now = System.currentTimeMillis();
        long previous = this.lastClick;
        this.lastClick = now;
        return previous <= 0L || previous + maxInterval < now;
    }

    protected void removeActiveEffects() {
        LivingEntity entity = this.getLivingEntity();
        if (entity == null) {
            return;
        }
        Collection activeEffects = entity.getActivePotionEffects();
        for (PotionEffect effect : activeEffects) {
            if (effect.getDuration() <= 0x3FFFFFFF) continue;
            entity.removePotionEffect(effect.getType());
        }
    }

    public void sendMessageKey(String key) {
        this.sendMessage(this.controller.getMessages().get(key, key));
    }

    @Nullable
    private Wand checkWand(ItemStack itemInHand) {
        ItemStack activeWandItem;
        Player player = this.getPlayer();
        if (this.isLoading() || player == null) {
            return null;
        }
        ItemStack itemStack = activeWandItem = this.activeWand != null ? this.activeWand.getItem() : null;
        if (InventoryUtils.isSameInstance(activeWandItem, itemInHand)) {
            return this.activeWand;
        }
        if (!Wand.isWand(itemInHand)) {
            itemInHand = null;
        }
        if (itemInHand != null && activeWandItem == null || activeWandItem != null && itemInHand == null || activeWandItem != null && itemInHand != null && !itemInHand.equals((Object)activeWandItem)) {
            Wand newActiveWand;
            if (this.activeWand != null) {
                this.activeWand.deactivate();
            }
            if (itemInHand != null && this.controller.hasWandPermission(player) && !(newActiveWand = this.controller.getWand(itemInHand)).activate(this)) {
                this.setActiveWand(null);
            }
        }
        return this.activeWand;
    }

    @Override
    @Nullable
    public Wand checkWand() {
        Player player = this.getPlayer();
        if (this.isLoading() || player == null) {
            return null;
        }
        this.checkOffhandWand();
        return this.checkWand(player.getInventory().getItemInMainHand());
    }

    public boolean offhandCast() {
        long now = System.currentTimeMillis();
        if (this.lastOffhandCast > 0L && now < this.lastOffhandCast + (long)OFFHAND_CAST_COOLDOWN) {
            return false;
        }
        this.lastOffhandCast = now;
        Player player = this.getPlayer();
        if (this.isLoading() || player == null) {
            return false;
        }
        ItemStack itemInOffhand = player.getInventory().getItemInOffHand();
        if (Wand.isWand(itemInOffhand) && this.offhandWand != null && (this.offhandWand.getLeftClickAction() == WandAction.CAST || this.offhandWand.getRightClickAction() == WandAction.CAST)) {
            this.offhandCast = true;
            Wand castingWand = this.offhandWand;
            boolean castResult = false;
            try {
                castingWand.tickMana();
                castingWand.setActiveMage(this);
                castResult = castingWand.cast();
                if (castingWand.getRightClickAction() != WandAction.CAST) {
                    CompatibilityUtils.swingOffhand((Entity)player, OFFHAND_CAST_RANGE);
                }
            }
            catch (Exception ex) {
                this.controller.getLogger().log(Level.WARNING, "Error casting from offhand wand", ex);
            }
            this.offhandCast = false;
            return castResult;
        }
        return false;
    }

    public boolean setOffhandActive(boolean active) {
        boolean wasActive = this.offhandCast;
        this.offhandCast = active;
        return wasActive;
    }

    @Nullable
    private Wand checkOffhandWand() {
        Player player = this.getPlayer();
        if (player == null) {
            return null;
        }
        return this.checkOffhandWand(player.getInventory().getItemInOffHand());
    }

    @Nullable
    private Wand checkOffhandWand(ItemStack itemInHand) {
        ItemStack offhandWandItem;
        Player player = this.getPlayer();
        if (this.isLoading() || player == null) {
            return null;
        }
        ItemStack itemStack = offhandWandItem = this.offhandWand != null ? this.offhandWand.getItem() : null;
        if (InventoryUtils.isSameInstance(offhandWandItem, itemInHand)) {
            return this.offhandWand;
        }
        if (!Wand.isWand(itemInHand)) {
            itemInHand = null;
        }
        if (itemInHand != null && offhandWandItem == null || offhandWandItem != null && itemInHand == null || itemInHand != null && offhandWandItem != null && !itemInHand.equals((Object)offhandWandItem)) {
            Wand newActiveWand;
            if (this.offhandWand != null) {
                this.offhandWand.deactivate();
            }
            if (itemInHand != null && this.controller.hasWandPermission(player) && !(newActiveWand = this.controller.getWand(itemInHand)).activateOffhand(this)) {
                this.setOffhandWand(null);
            }
        }
        return this.offhandWand;
    }

    public void checkWandNextTick(boolean checkAll) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.controller.getPlugin(), (Runnable)new CheckWandTask(this, checkAll));
    }

    public void checkWandNextTick() {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.controller.getPlugin(), (Runnable)new CheckWandTask(this));
    }

    @Override
    public Vector getVelocity() {
        return this.velocity;
    }

    protected void updateVelocity() {
        if (this.lastLocation != null) {
            Location currentLocation = this.getLocation();
            if (currentLocation.getWorld().equals(this.lastLocation.getWorld())) {
                long interval = System.currentTimeMillis() - this.lastTick;
                this.velocity.setX((currentLocation.getX() - this.lastLocation.getX()) * 1000.0 / (double)interval);
                this.velocity.setY((currentLocation.getY() - this.lastLocation.getY()) * 1000.0 / (double)interval);
                this.velocity.setZ((currentLocation.getZ() - this.lastLocation.getZ()) * 1000.0 / (double)interval);
            } else {
                this.velocity.setX(0);
                this.velocity.setY(0);
                this.velocity.setZ(0);
            }
        }
        this.lastLocation = this.getLocation();
    }

    @Override
    public void tick() {
        this.triggeringSpells.clear();
        long now = System.currentTimeMillis();
        if (this.entityData != null) {
            if (this.lastTick != 0L) {
                long tickInterval = this.entityData.getTickInterval();
                if (tickInterval > 0L && now - this.lastTick > tickInterval) {
                    this.updateVelocity();
                    this.entityData.tick(this);
                    this.lastTick = now;
                }
            } else {
                this.lastTick = now;
            }
        } else {
            this.trigger("interval");
            this.updateVelocity();
            this.lastTick = now;
        }
        for (MageModifier mageModifier : this.modifiers.values()) {
            if (!mageModifier.hasDuration() || mageModifier.getTimeRemaining() > 0) continue;
            this.removeModifiers.add(mageModifier);
        }
        for (MageModifier mageModifier : this.removeModifiers) {
            this.modifiers.remove(mageModifier.getKey());
            mageModifier.onRemoved();
        }
        if (!this.removeModifiers.isEmpty()) {
            this.removeModifiers.clear();
            this.updatePassiveEffects();
        }
        if (this.isNPC) {
            return;
        }
        Player player = this.getPlayer();
        if (player != null && player.isOnline()) {
            this.checkWand();
            if (this.activeWand != null) {
                this.activeWand.tick();
            } else if (this.virtualExperience) {
                this.resetSentExperience();
            }
            if (this.offhandWand != null) {
                this.offhandWand.tick();
            }
            if (this.activeClass != null) {
                this.activeClass.tick();
            }
            this.properties.tick();
            if (Wand.LiveHotbarSkills && (this.activeWand == null || !this.activeWand.isInventoryOpen())) {
                this.updateHotbarStatus();
            }
            if (JUMP_EFFECT_FLIGHT_EXEMPTION_DURATION > 0 && player.hasPotionEffect(PotionEffectType.JUMP)) {
                this.controller.addFlightExemption(player, JUMP_EFFECT_FLIGHT_EXEMPTION_DURATION);
            }
            for (Wand armorWand : this.activeArmor.values()) {
                armorWand.updateEffects(this);
            }
            ArrayList<MageSpell> arrayList = new ArrayList<MageSpell>(this.activeSpells);
            for (MageSpell spell : arrayList) {
                spell.tick();
                if (spell.isActive()) continue;
                this.deactivateSpell(spell);
            }
        }
    }

    public int processPendingBatches(int maxWorldAllowed) {
        int updated = 0;
        Iterator<Batch> iterator = this.pendingBatches.iterator();
        while (iterator.hasNext()) {
            Batch batch = iterator.next();
            int batchUpdated = batch.process(Math.max(1, maxWorldAllowed - updated));
            updated += batchUpdated;
            if (!batch.isFinished()) continue;
            iterator.remove();
        }
        return updated;
    }

    public boolean hasPendingBatches() {
        return !this.pendingBatches.isEmpty();
    }

    public void setLastHeldMapId(int mapId) {
        this.brush.setMapId(mapId);
    }

    @Override
    public int getLastHeldMapId() {
        return this.brush.getMapId();
    }

    protected void reloadClasses() {
        Iterator<Map.Entry<String, MageClass>> it = this.classes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, MageClass> entry = it.next();
            String templateKey = entry.getKey();
            MageClass mageClass = entry.getValue();
            MageClassTemplate template = this.controller.getMageClassTemplate(templateKey);
            if (template == null) {
                mageClass.onRemoved();
                if (this.activeClass == mageClass) {
                    this.setActiveClass(null);
                }
                it.remove();
                continue;
            }
            if (!mageClass.isLocked()) {
                mageClass.deactivateAttributes();
            }
            mageClass.setTemplate(template);
            if (mageClass.isLocked()) continue;
            mageClass.activateAttributes();
        }
    }

    protected void reloadModifiers() {
        Iterator<Map.Entry<String, MageModifier>> it = this.modifiers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, MageModifier> entry = it.next();
            String templateKey = entry.getKey();
            MageModifier modifier = entry.getValue();
            ModifierTemplate template = this.controller.getModifierTemplate(templateKey);
            if (template == null) {
                modifier.onRemoved();
                it.remove();
                continue;
            }
            modifier.deactivateAttributes();
            modifier.setTemplate(template);
            modifier.activateAttributes();
        }
    }

    protected void reloadAttributes() {
        for (Map.Entry<String, MageClass> entry : this.classes.entrySet()) {
            MageClass mageClass = entry.getValue();
            if (mageClass.isLocked()) continue;
            mageClass.deactivateAttributes();
            mageClass.activateAttributes();
        }
        for (Map.Entry<String, BaseMageModifier> entry : this.modifiers.entrySet()) {
            MageModifier modifier = (MageModifier)entry.getValue();
            modifier.deactivateAttributes();
            modifier.activateAttributes();
        }
    }

    protected void loadSpells(ConfigurationSection spellConfiguration) {
        if (spellConfiguration == null) {
            return;
        }
        ArrayList<MageSpell> currentSpells = new ArrayList<MageSpell>(this.spells.values());
        for (MageSpell spell : currentSpells) {
            String key = spell.getKey();
            if (spellConfiguration.contains(key)) {
                ConfigurationSection template = spellConfiguration.getConfigurationSection(key);
                String className = template.getString("class");
                if (className == null) {
                    className = ActionSpell.class.getName();
                }
                if (!spell.getClass().getName().contains(className)) {
                    this.spells.remove(key);
                    this.spellData.put(key, spell.getSpellData());
                    continue;
                }
                spell.loadTemplate(key, template);
                spell.loadPrerequisites(template);
                continue;
            }
            this.spells.remove(key);
        }
    }

    @Override
    public Collection<Batch> getPendingBatches() {
        ArrayList<Batch> pending = new ArrayList<Batch>();
        pending.addAll(this.pendingBatches);
        return pending;
    }

    @Override
    public String getName() {
        return this.playerName == null || this.playerName.length() == 0 ? defaultMageName : this.playerName;
    }

    @Override
    public String getDisplayName() {
        Entity entity = this.getEntity();
        if (entity == null) {
            return this.getName();
        }
        if (entity instanceof Player) {
            return ((Player)entity).getDisplayName();
        }
        return this.controller.getEntityDisplayName(entity);
    }

    public void setName(String name) {
        this.playerName = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public Location getLocation() {
        if (this.location != null) {
            return this.location.clone();
        }
        LivingEntity livingEntity = this.getLivingEntity();
        if (livingEntity == null) {
            return null;
        }
        return livingEntity.getLocation();
    }

    @Override
    @Nullable
    public Location getEyeLocation() {
        Entity entity = this.getEntity();
        if (entity != null) {
            return CompatibilityUtils.getEyeLocation(entity);
        }
        return this.getLocation();
    }

    @Override
    @Nullable
    public Location getCastLocation() {
        Location castLocation = this.getEyeLocation();
        if (this.activeWand != null && !this.offhandCast) {
            castLocation = this.activeWand.getLocation();
        } else if (this.offhandWand != null && this.offhandCast) {
            castLocation = this.offhandWand.getLocation();
        } else if (DEFAULT_CAST_LOCATION == CastSourceLocation.MAINHAND) {
            castLocation = this.getOffsetLocation(castLocation, false, DEFAULT_CAST_OFFSET);
        } else if (DEFAULT_CAST_LOCATION == CastSourceLocation.OFFHAND) {
            castLocation = this.getOffsetLocation(castLocation, true, DEFAULT_CAST_OFFSET);
        }
        return castLocation;
    }

    @Override
    @Nullable
    public Location getWandLocation() {
        return this.getCastLocation();
    }

    public Location getOffsetLocation(Location baseLocation, boolean isInOffhand, Vector offset) {
        HumanEntity human;
        Entity entity = this.getEntity();
        if (entity == null) {
            return baseLocation;
        }
        boolean leftHand = isInOffhand;
        if (entity instanceof HumanEntity && (human = (HumanEntity)entity).getMainHand() == MainHand.LEFT) {
            leftHand = !leftHand;
        }
        double sneakOffset = 0.0;
        if (entity instanceof Player && ((Player)entity).isSneaking()) {
            sneakOffset = SNEAKING_CAST_OFFSET;
        }
        if (leftHand) {
            offset = new Vector(offset.getX(), offset.getY() + sneakOffset, -offset.getZ());
        } else if (sneakOffset != 0.0) {
            offset = new Vector(offset.getX(), offset.getY() + sneakOffset, offset.getZ());
        }
        baseLocation.add(VectorUtils.rotateVector(offset, baseLocation));
        return baseLocation;
    }

    @Override
    @Nullable
    public Location getOffhandWandLocation() {
        Location wandLocation = this.getEyeLocation();
        if (this.offhandWand != null) {
            wandLocation = this.offhandWand.getLocation();
        }
        return wandLocation;
    }

    @Override
    public Vector getDirection() {
        Location location = this.getLocation();
        if (location != null) {
            return location.getDirection();
        }
        return new Vector(0, 1, 0);
    }

    @Override
    @Nullable
    public UndoList undo(Block target) {
        return this.getUndoQueue().undo(target);
    }

    @Override
    @Nullable
    public UndoList undo() {
        return this.getUndoQueue().undo();
    }

    @Override
    @Nullable
    public Batch cancelPending() {
        return this.cancelPending(null, true);
    }

    @Override
    @Nullable
    public Batch cancelPending(String spellKey) {
        return this.cancelPending(spellKey, true);
    }

    @Override
    @Nullable
    public Batch cancelPending(boolean force) {
        return this.cancelPending(null, force);
    }

    @Override
    @Nullable
    public Batch cancelPending(String spellKey, boolean force) {
        return this.cancelPending(spellKey, force, true);
    }

    @Override
    @Nullable
    public Batch cancelPending(String spellKey, boolean force, boolean nonBatched) {
        return this.cancelPending(spellKey, force, nonBatched, null);
    }

    @Nullable
    public Batch cancelPending(String spellKey, boolean force, boolean nonBatched, String exceptSpellKey) {
        MageSpell cancelSpell;
        Batch stoppedPending = null;
        if (!this.pendingBatches.isEmpty()) {
            ArrayList<Batch> batches = new ArrayList<Batch>();
            batches.addAll(this.pendingBatches);
            for (Batch batch : batches) {
                SpellBatch spellBatch;
                Spell spell;
                if ((spellKey != null || !force) && (!(batch instanceof SpellBatch) || (spell = (spellBatch = (SpellBatch)batch).getSpell()) == null || !force && !spell.isCancellable() || spellKey != null && !spell.getSpellKey().getBaseKey().equalsIgnoreCase(spellKey)) || exceptSpellKey != null && batch instanceof SpellBatch && (spell = (spellBatch = (SpellBatch)batch).getSpell()) != null && spell.getSpellKey().getBaseKey().equalsIgnoreCase(exceptSpellKey) || batch instanceof com.elmakers.mine.bukkit.batch.UndoBatch) continue;
                if (batch instanceof SpellBatch && (spell = (spellBatch = (SpellBatch)batch).getSpell()) != null) {
                    spell.cancel();
                }
                batch.finish();
                this.pendingBatches.remove(batch);
                stoppedPending = batch;
            }
        }
        if (nonBatched && stoppedPending == null && spellKey != null && !spellKey.isEmpty() && (cancelSpell = this.getSpell(spellKey)) != null) {
            cancelSpell.cancel();
        }
        return stoppedPending;
    }

    @Override
    public int finishPendingUndo() {
        int finished = 0;
        if (!this.pendingBatches.isEmpty()) {
            ArrayList<Batch> batches = new ArrayList<Batch>();
            batches.addAll(this.pendingBatches);
            for (Batch batch : batches) {
                if (!(batch instanceof com.elmakers.mine.bukkit.batch.UndoBatch)) continue;
                ((com.elmakers.mine.bukkit.batch.UndoBatch)batch).complete();
                this.pendingBatches.remove(batch);
                ++finished;
            }
        }
        return finished;
    }

    @Override
    public boolean commit() {
        if (this.externalUndoData != null) {
            this.externalUndoData.clear();
            this.externalUndoData = null;
        }
        return this.getUndoQueue().commit();
    }

    @Override
    public boolean hasCastPermission(Spell spell) {
        return spell.hasCastPermission(this.getCommandSender());
    }

    @Override
    public boolean hasSpell(String key) {
        return this.spells.containsKey(key);
    }

    @Override
    @Nullable
    public MageSpell getSpell(String key) {
        if (this.loading) {
            return null;
        }
        MageSpell playerSpell = this.spells.get(key);
        if (playerSpell == null) {
            playerSpell = this.createSpell(key);
            if (playerSpell != null) {
                SpellData spellData = this.spellData.get(key);
                if (spellData == null) {
                    spellData = new SpellData(key);
                    this.spellData.put(key, spellData);
                }
                playerSpell.setSpellData(spellData);
            }
        } else {
            playerSpell.setMage(this);
        }
        return playerSpell;
    }

    @Nullable
    protected MageSpell createSpell(String key) {
        MageSpell playerSpell = this.spells.get(key);
        if (playerSpell != null) {
            playerSpell.setMage(this);
            return playerSpell;
        }
        SpellTemplate spellTemplate = this.controller.getSpellTemplate(key);
        if (spellTemplate == null) {
            return null;
        }
        playerSpell = spellTemplate.createMageSpell(this);
        if (playerSpell == null) {
            return null;
        }
        this.spells.put(playerSpell.getKey(), playerSpell);
        return playerSpell;
    }

    @Override
    public Collection<Spell> getSpells() {
        ArrayList<Spell> export = new ArrayList<Spell>(this.spells.values());
        return export;
    }

    @Override
    public void activateSpell(Spell spell) {
        if (spell instanceof MageSpell) {
            MageSpell mageSpell = (MageSpell)spell;
            this.activeSpells.add(mageSpell);
            mageSpell.setActive(true);
        }
    }

    @Override
    public void deactivateSpell(Spell spell) {
        this.activeSpells.remove(spell);
        if (spell instanceof MageSpell) {
            ((MageSpell)spell).deactivate();
        }
    }

    @Override
    public void deactivateAllSpells() {
        this.deactivateAllSpells(false, false);
    }

    @Override
    public void deactivateAllSpells(boolean force, boolean quiet) {
        this.deactivateAllSpells(force, quiet, null);
    }

    @Override
    public void deactivateAllSpells(boolean force, boolean quiet, String exceptSpellKey) {
        ArrayList<MageSpell> active = new ArrayList<MageSpell>(this.activeSpells);
        for (MageSpell spell : active) {
            if (exceptSpellKey != null && spell.getSpellKey().getBaseKey().equalsIgnoreCase(exceptSpellKey) || !spell.deactivate(force, quiet)) continue;
            this.activeSpells.remove(spell);
        }
        this.cancelPending(null, false, true, exceptSpellKey);
    }

    @Override
    public boolean isCostFree() {
        if (this.costFree || this.getPlayer() == null) {
            return true;
        }
        return this.getCostReduction() > 1.0f;
    }

    @Override
    public boolean isConsumeFree() {
        return this.activeWand != null && this.activeWand.isConsumeFree();
    }

    @Override
    public boolean isSuperProtected() {
        MageClass activeClass;
        if (this.superProtectionExpiration != 0L) {
            if (System.currentTimeMillis() > this.superProtectionExpiration) {
                this.superProtectionExpiration = 0L;
            } else {
                return true;
            }
        }
        if ((activeClass = this.getActiveClass()) != null && activeClass.getBoolean("protected")) {
            return true;
        }
        if (this.offhandCast && this.offhandWand != null) {
            return this.offhandWand.isSuperProtected();
        }
        return this.activeWand != null && this.activeWand.isSuperProtected();
    }

    @Override
    public boolean isSuperPowered() {
        if (this.activeClass != null && this.activeClass.getBoolean("powered")) {
            return true;
        }
        if (this.offhandCast && this.offhandWand != null) {
            return this.offhandWand.isSuperPowered();
        }
        return this.activeWand != null && this.activeWand.isSuperPowered();
    }

    @Override
    public float getCostReduction() {
        if (this.costFree) {
            return 2.0f;
        }
        return this.costReduction * this.controller.getMaxCostReduction() + this.controller.getCostReduction();
    }

    @Override
    public float getConsumeReduction() {
        return this.consumeReduction;
    }

    @Override
    public float getCostScale() {
        return 1.0f;
    }

    @Override
    public float getCooldownReduction() {
        if (this.cooldownFree) {
            return 2.0f;
        }
        return this.cooldownReduction * this.controller.getMaxCooldownReduction() + this.controller.getCooldownReduction();
    }

    @Override
    public boolean isCooldownFree() {
        return this.cooldownFree || this.getCooldownReduction() > 1.0f;
    }

    @Override
    public long getRemainingCooldown() {
        long remaining = 0L;
        if (this.cooldownExpiration > 0L) {
            long now = System.currentTimeMillis();
            if (this.cooldownExpiration > now) {
                remaining = this.cooldownExpiration - now;
            } else {
                this.cooldownExpiration = 0L;
            }
        }
        return remaining;
    }

    @Override
    public void clearCooldown() {
        this.cooldownExpiration = 0L;
        HeroesManager heroes = this.controller.getHeroes();
        Player player = this.getPlayer();
        if (heroes != null && player != null) {
            heroes.clearCooldown(player);
        }
    }

    @Override
    public void setRemainingCooldown(long ms) {
        this.cooldownExpiration = Math.max(ms + System.currentTimeMillis(), this.cooldownExpiration);
        HeroesManager heroes = this.controller.getHeroes();
        Player player = this.getPlayer();
        if (heroes != null && player != null) {
            heroes.setCooldown(player, ms);
        }
    }

    @Override
    public void reduceRemainingCooldown(long ms) {
        this.cooldownExpiration = Math.max(0L, this.cooldownExpiration - ms);
        HeroesManager heroes = this.controller.getHeroes();
        Player player = this.getPlayer();
        if (heroes != null && player != null) {
            heroes.reduceCooldown(player, ms);
        }
    }

    @Override
    @Nullable
    public Color getEffectColor() {
        if (this.offhandCast && this.offhandWand != null) {
            return this.offhandWand.getEffectColor();
        }
        if (this.activeWand == null) {
            return this.properties.getEffectColor();
        }
        return this.activeWand.getEffectColor();
    }

    @Override
    @Nullable
    public String getEffectParticleName() {
        if (this.offhandCast && this.offhandWand != null) {
            return this.offhandWand.getEffectParticleName();
        }
        if (this.activeWand == null) {
            return null;
        }
        return this.activeWand.getEffectParticleName();
    }

    @Override
    public void onCast(Spell spell, SpellResult result) {
        this.lastCast = System.currentTimeMillis();
        if (spell != null) {
            this.controller.onCast(this, spell, result);
        }
    }

    @Override
    public float getPower() {
        if (this.offhandCast && this.offhandWand != null) {
            float power = Math.min(this.controller.getMaxPower(), this.offhandWand.getPower() + this.getMagePowerBonus());
            return power * this.powerMultiplier;
        }
        float power = Math.min(this.controller.getMaxPower(), this.activeWand == null ? this.getMagePowerBonus() : this.activeWand.getPower() + this.getMagePowerBonus());
        return power * this.powerMultiplier;
    }

    @Override
    public float getMagePowerBonus() {
        return this.magePowerBonus;
    }

    @Override
    public void setMagePowerBonus(float magePowerBonus) {
        this.magePowerBonus = magePowerBonus;
    }

    @Override
    @Deprecated
    public boolean isRestricted(Material material) {
        Player player = this.getPlayer();
        if (this.controller.hasBypassPermission((CommandSender)player)) {
            return false;
        }
        if (player != null && player.hasPermission("Magic.bypass_restricted")) {
            return false;
        }
        return this.controller.isRestricted(material);
    }

    @Override
    public boolean isRestricted(Material material, Short data) {
        Player player = this.getPlayer();
        if (this.controller.hasBypassPermission((CommandSender)player)) {
            return false;
        }
        if (player != null && player.hasPermission("Magic.bypass_restricted")) {
            return false;
        }
        return this.controller.isRestricted(material, data);
    }

    @Override
    public MageController getController() {
        return this.controller;
    }

    @Override
    @Nullable
    @Deprecated
    public Set<Material> getRestrictedMaterials() {
        return MaterialSets.toLegacy(this.getRestrictedMaterialSet());
    }

    @Override
    public MaterialSet getRestrictedMaterialSet() {
        if (this.isSuperPowered()) {
            return MaterialSets.empty();
        }
        return this.controller.getRestrictedMaterialSet();
    }

    @Override
    public boolean isPVPAllowed(Location location) {
        return this.controller.isPVPAllowed(this.getPlayer(), location == null ? this.getLocation() : location);
    }

    @Override
    public boolean hasBuildPermission(Block block) {
        return this.controller.hasBuildPermission(this.getPlayer(), block);
    }

    @Override
    public boolean hasBreakPermission(Block block) {
        return this.controller.hasBreakPermission(this.getPlayer(), block);
    }

    @Override
    public boolean isIndestructible(Block block) {
        return this.controller.isIndestructible(block);
    }

    @Override
    public boolean isDestructible(Block block) {
        return this.controller.isDestructible(block);
    }

    @Override
    public boolean isDead() {
        LivingEntity entity = this.getLivingEntity();
        if (entity != null) {
            return entity.isDead();
        }
        if (this.isAutomaton) {
            return !this.isValid();
        }
        return false;
    }

    @Override
    public boolean isOnline() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.isOnline();
        }
        CommandSender sender = this.getCommandSender();
        if (sender == null || !(sender instanceof BlockCommandSender)) {
            return true;
        }
        return this.lastCast > System.currentTimeMillis() - (long)AUTOMATA_ONLINE_TIMEOUT;
    }

    @Override
    public boolean isPlayer() {
        Player player = this.getPlayer();
        return player != null;
    }

    @Override
    public boolean hasLocation() {
        return this.getLocation() != null;
    }

    @Override
    @Nullable
    public Inventory getInventory() {
        if (this.hasStoredInventory()) {
            return this.getStoredInventory();
        }
        Player player = this.getPlayer();
        if (player != null) {
            return player.getInventory();
        }
        return null;
    }

    @Override
    public int removeItem(ItemStack itemStack, boolean allowVariants) {
        boolean modified;
        ItemStack item;
        int index;
        if (!this.isPlayer()) {
            return 0;
        }
        Integer sp = Wand.getSP(itemStack);
        if (sp != null) {
            sp = sp * itemStack.getAmount();
            int currentSP = this.getSkillPoints();
            int newSP = currentSP - sp;
            sp = currentSP < sp ? Integer.valueOf(sp - currentSP) : Integer.valueOf(0);
            this.setSkillPoints(newSP);
            return sp;
        }
        int amount = itemStack == null ? 0 : itemStack.getAmount();
        Inventory inventory = this.getInventory();
        ItemStack[] contents = inventory.getContents();
        for (int index2 = 0; amount > 0 && index2 < contents.length; ++index2) {
            ItemStack item2 = contents[index2];
            if (!this.isMatch(itemStack, item2, allowVariants)) continue;
            if (amount >= item2.getAmount()) {
                amount -= item2.getAmount();
                inventory.setItem(index2, null);
                continue;
            }
            item2.setAmount(item2.getAmount() - amount);
            amount = 0;
        }
        PlayerInventory playerInventory = this.getPlayer().getInventory();
        if (amount > 0) {
            ItemStack[] extra = playerInventory.getExtraContents();
            for (index = 0; amount > 0 && index < extra.length; ++index) {
                item = extra[index];
                modified = false;
                if (this.isMatch(itemStack, item, allowVariants)) {
                    if (amount >= item.getAmount()) {
                        amount -= item.getAmount();
                        extra[index] = null;
                        modified = true;
                    } else {
                        item.setAmount(item.getAmount() - amount);
                        amount = 0;
                        modified = true;
                    }
                }
                if (!modified) continue;
                playerInventory.setExtraContents(extra);
            }
        }
        if (amount > 0) {
            ItemStack[] armor = playerInventory.getArmorContents();
            for (index = 0; amount > 0 && index < armor.length; ++index) {
                item = armor[index];
                modified = false;
                if (this.isMatch(itemStack, item, allowVariants)) {
                    if (amount >= item.getAmount()) {
                        amount -= item.getAmount();
                        armor[index] = null;
                        modified = true;
                    } else {
                        item.setAmount(item.getAmount() - amount);
                        amount = 0;
                        modified = true;
                    }
                }
                if (!modified) continue;
                playerInventory.setArmorContents(armor);
            }
        }
        return amount;
    }

    @Override
    public int removeItem(ItemStack itemStack) {
        return this.removeItem(itemStack, false);
    }

    protected boolean isMatch(ItemStack itemStack, ItemStack candidate, boolean allowVariants) {
        if (candidate == null || itemStack == null) {
            return false;
        }
        if (!allowVariants) {
            return this.controller.itemsAreEqual(itemStack, candidate);
        }
        if (itemStack.getType() != candidate.getType()) {
            return false;
        }
        if (itemStack.hasItemMeta() != candidate.hasItemMeta()) {
            return false;
        }
        if (itemStack.hasItemMeta()) {
            ItemMeta meta = itemStack.getItemMeta();
            ItemMeta candidateMeta = candidate.getItemMeta();
            if (meta.hasDisplayName() != candidateMeta.hasDisplayName()) {
                return false;
            }
            if (meta.hasDisplayName() && !meta.getDisplayName().equals(candidateMeta.getDisplayName())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasItem(ItemStack itemStack, boolean allowVariants) {
        ItemStack[] extra;
        ItemStack[] armor;
        ItemStack[] contents;
        int amount;
        if (!this.isPlayer()) {
            return false;
        }
        Integer sp = Wand.getSP(itemStack);
        if (sp != null) {
            return this.getSkillPoints() >= sp * itemStack.getAmount();
        }
        int n = amount = itemStack == null ? 0 : itemStack.getAmount();
        if (amount <= 0) {
            return true;
        }
        Inventory inventory = this.getInventory();
        for (ItemStack item : contents = inventory.getContents()) {
            if (!this.isMatch(itemStack, item, allowVariants) || (amount -= item.getAmount()) > 0) continue;
            return true;
        }
        PlayerInventory playerInventory = this.getPlayer().getInventory();
        for (ItemStack item : armor = playerInventory.getArmorContents()) {
            if (!this.isMatch(itemStack, item, allowVariants) || (amount -= item.getAmount()) > 0) continue;
            return true;
        }
        for (ItemStack item : extra = playerInventory.getExtraContents()) {
            if (!this.isMatch(itemStack, item, allowVariants) || (amount -= item.getAmount()) > 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasItem(ItemStack itemStack) {
        return this.hasItem(itemStack, false);
    }

    @Override
    public int getItemCount(ItemStack itemStack, boolean allowDamaged) {
        ItemStack[] extra;
        ItemStack[] armor;
        ItemStack[] contents;
        if (!this.isPlayer()) {
            return 0;
        }
        Integer sp = Wand.getSP(itemStack);
        if (sp != null) {
            return this.getSkillPoints();
        }
        int amount = 0;
        Inventory inventory = this.getInventory();
        for (ItemStack item : contents = inventory.getContents()) {
            if (!this.isMatch(itemStack, item, allowDamaged)) continue;
            amount += item.getAmount();
        }
        PlayerInventory playerInventory = this.getPlayer().getInventory();
        for (ItemStack item : armor = playerInventory.getArmorContents()) {
            if (!this.isMatch(itemStack, item, allowDamaged)) continue;
            amount += item.getAmount();
        }
        for (ItemStack item : extra = playerInventory.getExtraContents()) {
            if (!this.isMatch(itemStack, item, allowDamaged)) continue;
            amount += item.getAmount();
        }
        return amount;
    }

    @Override
    public int getItemCount(ItemStack itemStack) {
        return this.getItemCount(itemStack, false);
    }

    @Override
    @Nullable
    @Deprecated
    public Wand getSoulWand() {
        return null;
    }

    @Override
    public Wand getActiveWand() {
        if (this.offhandCast && this.offhandWand != null) {
            return this.offhandWand;
        }
        return this.activeWand;
    }

    @Override
    public Wand getOffhandWand() {
        return this.offhandWand;
    }

    @Override
    public MaterialBrush getBrush() {
        return this.brush;
    }

    @Override
    public float getDamageMultiplier() {
        double attackMultiplier;
        Double overallMultiplier;
        float multiplier = 1.0f;
        float maxPowerMultiplier = this.controller.getMaxDamagePowerMultiplier() - 1.0f;
        if (maxPowerMultiplier > 0.0f) {
            multiplier = 1.0f + maxPowerMultiplier * this.getPower();
        }
        if ((overallMultiplier = this.strength.get("overall")) != null && overallMultiplier != 0.0 && (attackMultiplier = this.controller.getMaxAttackMultiplier("overall")) > 1.0) {
            attackMultiplier = 1.0 + (attackMultiplier - 1.0) * overallMultiplier;
            multiplier = (float)((double)multiplier * attackMultiplier);
        }
        return Math.max(0.0f, multiplier);
    }

    @Override
    public double getDamageMultiplier(String damageType) {
        double attackMultiplier;
        Double typeMultiplier;
        double overallMultiplier = this.getDamageMultiplier();
        Double d = typeMultiplier = damageType == null || damageType.isEmpty() ? null : this.strength.get(damageType);
        if (typeMultiplier != null && typeMultiplier > 0.0 && (attackMultiplier = this.controller.getMaxAttackMultiplier(damageType)) > 1.0) {
            attackMultiplier = 1.0 + (attackMultiplier - 1.0) * typeMultiplier;
            overallMultiplier *= attackMultiplier;
        }
        return Math.max(0.0, overallMultiplier);
    }

    @Override
    public float getRangeMultiplier() {
        if (this.activeWand == null) {
            return 1.0f;
        }
        float maxPowerMultiplier = this.controller.getMaxRangePowerMultiplier() - 1.0f;
        float maxPowerMultiplierMax = this.controller.getMaxRangePowerMultiplierMax();
        float multiplier = 1.0f + maxPowerMultiplier * this.getPower();
        return Math.min(multiplier, maxPowerMultiplierMax);
    }

    @Override
    public float getConstructionMultiplier() {
        float maxPowerMultiplier = this.controller.getMaxConstructionPowerMultiplier() - 1.0f;
        return 1.0f + maxPowerMultiplier * this.getPower();
    }

    @Override
    public float getRadiusMultiplier() {
        if (this.activeWand == null) {
            return 1.0f;
        }
        float maxPowerMultiplier = this.controller.getMaxRadiusPowerMultiplier() - 1.0f;
        float maxPowerMultiplierMax = this.controller.getMaxRadiusPowerMultiplierMax();
        float multiplier = 1.0f + maxPowerMultiplier * this.getPower();
        return Math.min(multiplier, maxPowerMultiplierMax);
    }

    @Override
    @Nonnull
    public CasterProperties getActiveProperties() {
        if (this.offhandCast && this.offhandWand != null) {
            return this.offhandWand;
        }
        if (this.activeWand != null) {
            return this.activeWand;
        }
        if (this.activeClass != null) {
            return this.activeClass;
        }
        return this.properties;
    }

    @Override
    public float getMana() {
        return this.getActiveProperties().getMana();
    }

    @Override
    public int getManaMax() {
        return this.getActiveProperties().getManaMax();
    }

    @Override
    public int getManaRegeneration() {
        return this.getActiveProperties().getManaRegeneration();
    }

    @Override
    public void setMana(float mana) {
        this.getActiveProperties().setMana(mana);
    }

    @Override
    public void updateMana() {
        this.getActiveProperties().updateMana();
    }

    @Override
    public int getEffectiveManaMax() {
        return this.getActiveProperties().getEffectiveManaMax();
    }

    @Override
    public int getEffectiveManaRegeneration() {
        return this.getActiveProperties().getEffectiveManaRegeneration();
    }

    @Override
    public void removeMana(float mana) {
        this.getActiveProperties().removeMana(mana);
    }

    @Override
    public void removeExperience(int xp) {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        float expProgress = player.getExp();
        int expLevel = player.getLevel();
        while ((expProgress > 0.0f || expLevel > 0) && xp > 0) {
            if (expProgress > 0.0f) {
                float expToLevel = Wand.getExpToLevel(expLevel);
                int expAtLevel = (int)(expProgress * expToLevel);
                if (expAtLevel > xp) {
                    xp = 0;
                    expProgress = (float)(expAtLevel -= xp) / expToLevel;
                    continue;
                }
                expProgress = 0.0f;
                xp -= expAtLevel;
                continue;
            }
            if ((xp -= Wand.getExpToLevel(--expLevel - 1)) >= 0) continue;
            expProgress = (float)(-xp) / (float)Wand.getExpToLevel(expLevel);
            xp = 0;
        }
        player.setExp(Math.max(0.0f, Math.min(1.0f, expProgress)));
        player.setLevel(Math.max(0, expLevel));
    }

    @Override
    public int getLevel() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getLevel();
        }
        return 0;
    }

    @Override
    public void setLevel(int level) {
        Player player = this.getPlayer();
        if (player != null) {
            player.setLevel(level);
        }
    }

    @Override
    public int getExperience() {
        Player player = this.getPlayer();
        if (player == null) {
            return 0;
        }
        float expProgress = player.getExp();
        int expLevel = player.getLevel();
        return Wand.getExperience(expLevel, expProgress);
    }

    @Override
    public void giveExperience(int xp) {
        Player player = this.getPlayer();
        if (player != null) {
            player.giveExp(xp);
        }
    }

    public void sendExperience(float exp, int level) {
        if (this.virtualExperience && exp == this.virtualExperienceProgress && level == this.virtualExperienceLevel) {
            return;
        }
        Player player = this.getPlayer();
        if (player != null) {
            CompatibilityUtils.sendExperienceUpdate(player, exp, level);
            this.virtualExperience = true;
            this.virtualExperienceProgress = exp;
            this.virtualExperienceLevel = level;
        }
    }

    public void resetSentExperience() {
        Player player = this.getPlayer();
        if (player != null) {
            CompatibilityUtils.sendExperienceUpdate(player, player.getExp(), player.getLevel());
        }
        this.virtualExperience = false;
    }

    public void experienceChanged() {
        this.virtualExperience = false;
    }

    @Override
    public boolean addBatch(Batch batch) {
        if (this.pendingBatches.size() >= this.controller.getPendingQueueDepth()) {
            this.controller.getLogger().info("Rejected spell cast for " + this.getName() + ", already has " + this.pendingBatches.size() + " pending, limit: " + this.controller.getPendingQueueDepth());
            return false;
        }
        this.pendingBatches.addLast(batch);
        this.controller.addPending(this);
        return true;
    }

    @Override
    public void registerEvent(SpellEventType type, Listener spell) {
        switch (type) {
            case PLAYER_QUIT: {
                if (this.quitListeners.contains(spell)) break;
                this.quitListeners.add(spell);
                break;
            }
            case PLAYER_DAMAGE: {
                if (this.damageListeners.contains(spell)) break;
                this.damageListeners.add(spell);
                break;
            }
            case PLAYER_DEATH: {
                if (this.deathListeners.contains(spell)) break;
                this.deathListeners.add(spell);
            }
        }
    }

    @Override
    public void unregisterEvent(SpellEventType type, Listener spell) {
        switch (type) {
            case PLAYER_DAMAGE: {
                this.damageListeners.remove(spell);
                break;
            }
            case PLAYER_QUIT: {
                this.quitListeners.remove(spell);
                break;
            }
            case PLAYER_DEATH: {
                this.deathListeners.remove(spell);
            }
        }
    }

    @Override
    @Nullable
    public Player getPlayer() {
        return this.isNPC ? null : (Player)this.playerRef.get();
    }

    @Override
    public Entity getEntity() {
        return (Entity)this.entityRef.get();
    }

    @Override
    public EntityData getEntityData() {
        return this.entityData;
    }

    @Override
    @Nullable
    public LivingEntity getLivingEntity() {
        Entity entity = (Entity)this.entityRef.get();
        return entity != null && entity instanceof LivingEntity ? (LivingEntity)entity : null;
    }

    @Override
    public CommandSender getCommandSender() {
        return (CommandSender)this.commandSenderRef.get();
    }

    @Override
    public List<LostWand> getLostWands() {
        Entity entity = this.getEntity();
        Collection<LostWand> allWands = this.controller.getLostWands();
        ArrayList<LostWand> mageWands = new ArrayList<LostWand>();
        if (entity == null) {
            return mageWands;
        }
        String playerId = entity.getUniqueId().toString();
        for (LostWand lostWand : allWands) {
            String owner = lostWand.getOwnerId();
            if (owner == null || !owner.equals(playerId)) continue;
            mageWands.add(lostWand);
        }
        return mageWands;
    }

    @Override
    public Location getLastDeathLocation() {
        return this.lastDeathLocation;
    }

    @Override
    public void showHoloText(Location location, String text, int duration) {
        if (!this.isPlayer()) {
            return;
        }
        final Player player = this.getPlayer();
        if (this.hologram == null) {
            this.hologram = HoloUtils.createHoloText(location, text);
        } else {
            if (this.hologramIsVisible) {
                this.hologram.hide(player);
            }
            this.hologram.teleport(location);
            this.hologram.setLabel(text);
        }
        this.hologram.show(player);
        BukkitScheduler scheduler = Bukkit.getScheduler();
        if (duration > 0) {
            scheduler.scheduleSyncDelayedTask((Plugin)this.controller.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    Mage.this.hologram.hide(player);
                    Mage.this.hologramIsVisible = false;
                }
            }, (long)duration);
        }
    }

    @Override
    public void enableFallProtection(int ms) {
        this.enableFallProtection(ms, null);
    }

    @Override
    public void enableFallProtection(int ms, @Nullable Spell protector) {
        this.enableFallProtection(ms, 1, protector);
    }

    @Override
    public void enableFallProtection(int ms, int count, @Nullable Spell protector) {
        long nextTime;
        if (ms <= 0 || count <= 0) {
            return;
        }
        if (protector != null && protector instanceof BaseSpell) {
            this.fallingSpell = (BaseSpell)protector;
        }
        if ((nextTime = System.currentTimeMillis() + (long)ms) > this.fallProtection) {
            this.fallProtection = nextTime;
        }
        if ((long)count > this.fallProtectionCount) {
            this.fallProtectionCount = count;
        }
    }

    @Override
    public void clearFallProtection() {
        this.fallingSpell = null;
        this.fallProtection = 0L;
        this.fallProtectionCount = 0L;
    }

    @Override
    public void enableSuperProtection(int ms) {
        if (ms <= 0) {
            return;
        }
        long nextTime = System.currentTimeMillis() + (long)ms;
        if (nextTime > this.superProtectionExpiration) {
            this.superProtectionExpiration = nextTime;
        }
    }

    @Override
    public void clearSuperProtection() {
        this.superProtectionExpiration = 0L;
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    @Override
    public void disable() {
        this.loading = true;
    }

    @Override
    public boolean isLoading() {
        return this.loading;
    }

    public void setUnloading(boolean unloading) {
        this.unloading = unloading;
    }

    public boolean isUnloading() {
        return this.unloading;
    }

    @Override
    public boolean hasPending() {
        if (this.undoQueue != null && this.undoQueue.hasScheduled()) {
            return true;
        }
        return this.hasPendingBatches();
    }

    @Override
    public boolean isValid() {
        if (this.forget) {
            return false;
        }
        if (!this.hasEntity) {
            return true;
        }
        Entity entity = this.getEntity();
        if (entity == null) {
            return false;
        }
        if (!this.isNPC && entity instanceof Player) {
            Player player = (Player)entity;
            return player.isOnline();
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return !living.isDead();
        }
        return entity.isValid();
    }

    @Override
    public boolean restoreWand() {
        Wand tempWand;
        String template;
        ItemStack[] inventory;
        if (this.boundWands.size() == 0) {
            return false;
        }
        Player player = this.getPlayer();
        if (player == null) {
            return false;
        }
        HashSet<String> foundTemplates = new HashSet<String>();
        for (ItemStack item : inventory = this.getInventory().getContents()) {
            if (!Wand.isWand(item) || (template = (tempWand = this.controller.getWand(item)).getTemplateKey()) == null) continue;
            foundTemplates.add(template);
        }
        for (ItemStack item : inventory = player.getEnderChest().getContents()) {
            if (!Wand.isWand(item) || (template = (tempWand = this.controller.getWand(item)).getTemplateKey()) == null) continue;
            foundTemplates.add(template);
        }
        int givenWands = 0;
        for (Map.Entry<String, Wand> wandEntry : this.boundWands.entrySet()) {
            String templateKey = wandEntry.getKey();
            if (foundTemplates.contains(templateKey)) continue;
            WandTemplate template2 = this.controller.getWandTemplate(templateKey);
            Wand wand = wandEntry.getValue();
            if (template2 == null || !wand.isBound()) continue;
            ++givenWands;
            ItemStack wandItem = wand.duplicate().getItem();
            wandItem.setAmount(1);
            this.giveItem(wandItem);
        }
        return givenWands > 0;
    }

    @Override
    public boolean isStealth() {
        if (this.isSneaking()) {
            return true;
        }
        return this.activeWand != null && this.activeWand.isStealth();
    }

    @Override
    public boolean isSneaking() {
        Player player = this.getPlayer();
        return player != null && player.isSneaking();
    }

    @Override
    public boolean isJumping() {
        Entity entity = this.getEntity();
        return entity != null && !entity.isOnGround();
    }

    @Override
    public ConfigurationSection getData() {
        if (this.loading) {
            return new MemoryConfiguration();
        }
        return this.data;
    }

    public void onGUIDeactivate() {
        GUIAction previousGUI = this.gui;
        this.gui = null;
        Player player = this.getPlayer();
        if (player != null) {
            DeprecatedUtils.updateInventory(player);
        }
        if (previousGUI != null) {
            previousGUI.deactivated();
        }
    }

    @Override
    public void activateGUI(GUIAction action, Inventory inventory) {
        Player player = this.getPlayer();
        if (player != null) {
            this.controller.disableItemSpawn();
            try {
                player.closeInventory();
                if (inventory != null) {
                    this.gui = action;
                    player.openInventory(inventory);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            this.controller.enableItemSpawn();
        }
        this.gui = action;
    }

    @Override
    public void continueGUI(GUIAction action, Inventory inventory) {
        Player player = this.getPlayer();
        if (player != null) {
            this.controller.disableItemSpawn();
            try {
                if (inventory != null) {
                    this.gui = action;
                    player.openInventory(inventory);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            this.controller.enableItemSpawn();
        }
        this.gui = action;
    }

    @Override
    public void deactivateGUI() {
        this.activateGUI(null, null);
    }

    @Override
    public GUIAction getActiveGUI() {
        return this.gui;
    }

    @Override
    public int getDebugLevel() {
        return this.debugLevel;
    }

    @Override
    public void setDebugger(CommandSender sender) {
        this.debugger = sender;
    }

    @Override
    public CommandSender getDebugger() {
        return this.debugger;
    }

    @Override
    public void setDebugLevel(int debugLevel) {
        this.debugLevel = debugLevel;
    }

    @Override
    public void debugPermissions(CommandSender sender, Spell spell) {
        Wand wand = this.getActiveWand();
        Location location = this.getLocation();
        if (spell == null && wand != null) {
            spell = wand.getActiveSpell();
        }
        sender.sendMessage(ChatColor.GOLD + "Permission check for " + ChatColor.AQUA + this.getDisplayName());
        sender.sendMessage(ChatColor.GOLD + "  id " + ChatColor.DARK_AQUA + this.getId());
        sender.sendMessage(ChatColor.GOLD + " at " + ChatColor.AQUA + ChatColor.BLUE + location.getBlockX() + " " + location.getBlockY() + " " + location.getBlockZ() + " " + ChatColor.DARK_BLUE + location.getWorld().getName());
        Player player = this.getPlayer();
        boolean hasBypass = false;
        boolean hasPVPBypass = false;
        boolean hasBuildBypass = false;
        boolean hasBreakBypass = false;
        if (player != null) {
            hasBypass = this.controller.hasBypassPermission((CommandSender)player);
            hasPVPBypass = player.hasPermission("Magic.bypass_pvp");
            hasBuildBypass = player.hasPermission("Magic.bypass_build");
            sender.sendMessage(ChatColor.AQUA + " Has bypass: " + Mage.formatBoolean(hasBypass, true, null));
            sender.sendMessage(ChatColor.AQUA + " Has PVP bypass: " + Mage.formatBoolean(hasPVPBypass, true, null));
            sender.sendMessage(ChatColor.AQUA + " Has Build bypass: " + Mage.formatBoolean(hasBuildBypass, true, null));
            sender.sendMessage(ChatColor.AQUA + " Has Break bypass: " + Mage.formatBoolean(hasBreakBypass, true, null));
        }
        boolean buildPermissionRequired = spell == null ? false : spell.requiresBuildPermission();
        boolean breakPermissionRequired = spell == null ? false : spell.requiresBreakPermission();
        boolean pvpRestricted = spell == null ? false : spell.isPvpRestricted();
        sender.sendMessage(ChatColor.AQUA + " Can build: " + Mage.formatBoolean(this.hasBuildPermission(location.getBlock()), hasBuildBypass || !buildPermissionRequired ? null : Boolean.valueOf(true)));
        sender.sendMessage(ChatColor.AQUA + " Can break: " + Mage.formatBoolean(this.hasBreakPermission(location.getBlock()), hasBreakBypass || !breakPermissionRequired ? null : Boolean.valueOf(true)));
        sender.sendMessage(ChatColor.AQUA + " Can pvp: " + Mage.formatBoolean(this.isPVPAllowed(location), hasPVPBypass || !pvpRestricted ? null : Boolean.valueOf(true)));
        boolean isPlayer = player != null;
        boolean spellDisguiseRestricted = spell == null ? false : spell.isDisguiseRestricted();
        sender.sendMessage(ChatColor.AQUA + " Is disguised: " + Mage.formatBoolean(this.controller.isDisguised(this.getEntity()), null, isPlayer && spellDisguiseRestricted ? Boolean.valueOf(true) : null));
        WorldBorder border = location.getWorld().getWorldBorder();
        double borderSize = border.getSize();
        if (borderSize < 5.0E7) {
            borderSize = borderSize / 2.0 - (double)border.getWarningDistance();
            Location offset = location.subtract(border.getCenter());
            boolean isOutsideBorder = offset.getX() < -borderSize || offset.getX() > borderSize || offset.getZ() < -borderSize || offset.getZ() > borderSize;
            sender.sendMessage(ChatColor.AQUA + " Is in world border (" + ChatColor.GRAY + borderSize + ChatColor.AQUA + "): " + Mage.formatBoolean(!isOutsideBorder, true, false));
        }
        if (spell != null) {
            sender.sendMessage(ChatColor.AQUA + " Has pnode " + ChatColor.GOLD + spell.getPermissionNode() + ChatColor.AQUA + ": " + Mage.formatBoolean(spell.hasCastPermission((CommandSender)player), hasBypass ? null : Boolean.valueOf(true)));
            sender.sendMessage(ChatColor.AQUA + " Region override: " + Mage.formatBoolean(this.controller.getRegionCastPermission(player, spell, location), hasBypass ? null : Boolean.valueOf(true)));
            sender.sendMessage(ChatColor.AQUA + " Field override: " + Mage.formatBoolean(this.controller.getPersonalCastPermission(player, spell, location), hasBypass ? null : Boolean.valueOf(true)));
            MaterialBrush brush = spell.getBrush();
            if (brush != null) {
                sender.sendMessage(ChatColor.GOLD + " " + spell.getName() + ChatColor.AQUA + " is erase: " + Mage.formatBoolean(brush.isErase(), null));
            }
            sender.sendMessage(ChatColor.GOLD + " " + spell.getName() + ChatColor.AQUA + " requires build: " + Mage.formatBoolean(spell.requiresBuildPermission(), null, true, true));
            sender.sendMessage(ChatColor.GOLD + " " + spell.getName() + ChatColor.AQUA + " requires break: " + Mage.formatBoolean(spell.requiresBreakPermission(), null, true, true));
            sender.sendMessage(ChatColor.GOLD + " " + spell.getName() + ChatColor.AQUA + " requires pvp: " + Mage.formatBoolean(spell.isPvpRestricted(), null, true, true));
            sender.sendMessage(ChatColor.GOLD + " " + spell.getName() + ChatColor.AQUA + " allowed while disguised: " + Mage.formatBoolean(!spell.isDisguiseRestricted(), null, false, true));
            if (spell instanceof BaseSpell) {
                boolean buildPermission = ((BaseSpell)spell).hasBuildPermission(location.getBlock());
                sender.sendMessage(ChatColor.GOLD + " " + spell.getName() + ChatColor.AQUA + " has build: " + Mage.formatBoolean(buildPermission, hasBuildBypass || !spell.requiresBuildPermission() ? null : Boolean.valueOf(true)));
                boolean breakPermission = ((BaseSpell)spell).hasBreakPermission(location.getBlock());
                sender.sendMessage(ChatColor.GOLD + " " + spell.getName() + ChatColor.AQUA + " has break: " + Mage.formatBoolean(breakPermission, hasBreakBypass || !spell.requiresBreakPermission() ? null : Boolean.valueOf(true)));
            }
            sender.sendMessage(ChatColor.AQUA + " Can cast " + ChatColor.GOLD + spell.getName() + ChatColor.AQUA + ": " + Mage.formatBoolean(spell.canCast(location)));
        }
    }

    public static String formatBoolean(Boolean flag, Boolean greenState) {
        return Mage.formatBoolean(flag, greenState, greenState == null ? null : Boolean.valueOf(greenState == false), false);
    }

    public static String formatBoolean(Boolean flag) {
        return Mage.formatBoolean(flag, true, false, false);
    }

    public static String formatBoolean(Boolean flag, Boolean greenState, Boolean redState) {
        return Mage.formatBoolean(flag, greenState, redState, false);
    }

    public static String formatBoolean(Boolean flag, Boolean greenState, Boolean redState, boolean dark) {
        String text;
        if (flag == null) {
            return ChatColor.GRAY + "none";
        }
        String string = text = flag != false ? "true" : "false";
        if (greenState != null && Objects.equal((Object)flag, (Object)greenState)) {
            return (dark ? ChatColor.DARK_GREEN : ChatColor.GREEN) + text;
        }
        if (redState != null && Objects.equal((Object)flag, (Object)redState)) {
            return (dark ? ChatColor.DARK_RED : ChatColor.RED) + text;
        }
        return ChatColor.GRAY + text;
    }

    @Override
    public void sendDebugMessage(String message) {
        this.sendDebugMessage(message, 1);
    }

    @Override
    public void sendDebugMessage(String message, int level) {
        if (this.debugLevel >= level && message != null && !message.isEmpty()) {
            CommandSender sender = this.debugger;
            if (sender == null) {
                sender = this.getCommandSender();
            }
            if (sender != null) {
                sender.sendMessage(this.controller.getMessagePrefix() + message);
            }
        }
    }

    public void clearRespawnInventories() {
        this.respawnArmor = null;
        this.respawnInventory = null;
    }

    public void restoreRespawnInventories() {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        PlayerInventory inventory = player.getInventory();
        if (this.respawnArmor != null) {
            ItemStack[] armor = inventory.getArmorContents();
            for (Map.Entry<Integer, ItemStack> entry : this.respawnArmor.entrySet()) {
                armor[entry.getKey().intValue()] = entry.getValue();
            }
            player.getInventory().setArmorContents(armor);
        }
        if (this.respawnInventory != null) {
            ArrayList<ItemStack> addToInventory = null;
            for (Map.Entry<Integer, ItemStack> entry : this.respawnInventory.entrySet()) {
                int slot = entry.getKey();
                ItemStack item = entry.getValue();
                if (slot >= 0) {
                    inventory.setItem(entry.getKey().intValue(), item);
                    continue;
                }
                if (addToInventory == null) {
                    addToInventory = new ArrayList<ItemStack>();
                }
                addToInventory.add(item);
            }
            if (addToInventory != null) {
                for (ItemStack item : addToInventory) {
                    HashMap returned = inventory.addItem(new ItemStack[]{item});
                    if (returned.isEmpty()) continue;
                    player.getWorld().dropItem(player.getLocation(), item);
                }
            }
        }
        this.clearRespawnInventories();
        this.controller.getPlugin().getServer().getScheduler().runTaskLater((Plugin)this.controller.getPlugin(), new Runnable(){

            @Override
            public void run() {
                Mage.this.armorUpdated();
            }
        }, 1L);
    }

    public void addToRespawnInventory(ItemStack item) {
        this.addToRespawnInventory(-1, item);
    }

    public void addToRespawnInventory(int slot, ItemStack item) {
        if (this.respawnInventory == null) {
            this.respawnInventory = new HashMap<Integer, ItemStack>();
        }
        this.respawnInventory.put(slot, item);
    }

    public void addToRespawnArmor(int slot, ItemStack item) {
        if (this.respawnArmor == null) {
            this.respawnArmor = new HashMap<Integer, ItemStack>();
        }
        this.respawnArmor.put(slot, item);
    }

    @Override
    public void setArmorItem(int armorSlot, ItemStack itemStack) {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        if (player.isDead()) {
            this.addToRespawnArmor(armorSlot, itemStack);
            return;
        }
        ItemStack[] armor = player.getInventory().getArmorContents();
        armor[armorSlot] = itemStack;
        player.getInventory().setArmorContents(armor);
    }

    @Override
    public void giveItem(ItemStack itemStack, boolean putInHand) {
        Entity entity;
        if (!this.tryGiveItem(itemStack, putInHand) && (entity = this.getEntity()) != null) {
            entity.getWorld().dropItem(entity.getLocation(), itemStack);
        }
    }

    @Override
    public void giveItem(ItemStack itemStack) {
        Entity entity;
        if (!this.tryGiveItem(itemStack) && (entity = this.getEntity()) != null) {
            entity.getWorld().dropItem(entity.getLocation(), itemStack);
        }
    }

    @Override
    public boolean tryGiveItem(ItemStack itemStack, boolean putInHand) {
        if (putInHand) {
            return this.tryGiveItem(itemStack);
        }
        Player player = this.getPlayer();
        if (player == null) {
            return true;
        }
        if (player.isDead()) {
            this.addToRespawnInventory(itemStack);
            return true;
        }
        PlayerInventory inventory = player.getInventory();
        ItemStack inHand = inventory.getItemInMainHand();
        Integer freeSlot = null;
        if (InventoryUtils.isEmpty(inHand)) {
            for (int i = 0; i < inventory.getSize() && freeSlot == null; ++i) {
                if (i == inventory.getHeldItemSlot() || !InventoryUtils.isEmpty(inventory.getItem(i))) continue;
                freeSlot = i;
            }
        }
        if (freeSlot == null) {
            return this.tryGiveItem(itemStack);
        }
        inventory.setItem(freeSlot.intValue(), itemStack);
        return true;
    }

    @Override
    public boolean tryGiveItem(ItemStack itemStack) {
        Wand wand;
        if (InventoryUtils.isEmpty(itemStack)) {
            return true;
        }
        Wand activeWand = this.getActiveWand();
        if (activeWand != null && activeWand.addItem(itemStack)) {
            return true;
        }
        Player player = this.getPlayer();
        if (player == null) {
            return true;
        }
        if (this.controller.isBindOnGive() && Wand.isWand(itemStack) && (wand = this.controller.getWand(itemStack)).isBound()) {
            wand.tryToOwn(player);
            itemStack = wand.getItem();
        }
        if (player.isDead()) {
            this.addToRespawnInventory(itemStack);
            return true;
        }
        if (this.hasStoredInventory()) {
            return this.addToStoredInventory(itemStack);
        }
        PlayerInventory inventory = player.getInventory();
        ItemStack inHand = inventory.getItemInMainHand();
        if (inHand == null || inHand.getType() == Material.AIR) {
            inventory.setItemInMainHand(itemStack);
            itemStack = inventory.getItemInMainHand();
            if (Wand.isWand(itemStack)) {
                this.checkWand();
            } else if (DefaultMaterials.isFilledMap(itemStack.getType())) {
                this.setLastHeldMapId(InventoryUtils.getMapId(itemStack));
            }
        } else {
            HashMap returned = player.getInventory().addItem(new ItemStack[]{itemStack});
            return returned.isEmpty();
        }
        return true;
    }

    public void armorUpdated() {
        this.activeArmor.clear();
        Player player = this.getPlayer();
        if (player != null) {
            boolean changed = false;
            ItemStack[] armor = player.getInventory().getArmorContents();
            for (int index = 0; index < armor.length; ++index) {
                ItemStack armorItem = armor[index];
                if (InventoryUtils.isEmpty(armorItem)) continue;
                if (!this.canUse(armorItem)) {
                    this.sendMessage(this.controller.getMessages().get("mage.no_class").replace("$name", this.controller.describeItem(armorItem)));
                    changed = true;
                    armor[index] = null;
                    this.giveItem(armorItem);
                    continue;
                }
                if (!Wand.isWand(armorItem)) continue;
                this.activeArmor.put(index, this.controller.getWand(armorItem));
            }
            if (changed) {
                player.getInventory().setArmorContents(armor);
            }
        }
        this.updatePassiveEffects();
    }

    protected void addPassiveEffectsGroup(Map<String, Double> properties, CasterProperties addProperties, String section, boolean stack, Double maxValue) {
        ConfigurationSection addSection = addProperties.getConfigurationSection(section);
        if (addSection != null) {
            Set sectionTypes = addSection.getKeys(false);
            for (String sectionType : sectionTypes) {
                Double existing = properties.get(sectionType);
                if (existing == null) {
                    existing = 0.0;
                }
                double addValue = addSection.getDouble(sectionType);
                existing = stack ? (maxValue != null ? Double.valueOf(Math.min(1.0, existing + addValue)) : Double.valueOf(existing + addValue)) : Double.valueOf(Math.max(existing, addValue));
                properties.put(sectionType, existing);
            }
        }
    }

    protected void addPassiveAttributes(CasterProperties properties) {
        boolean stack = properties.getBoolean("stack", false);
        this.addPassiveEffectsGroup(this.attributes, properties, "attributes", stack, null);
    }

    protected void addPassiveEffects(CasterProperties properties, boolean activeReduction) {
        this.earnMultiplier = (float)((double)this.earnMultiplier * properties.getDouble("earn_multiplier", properties.getDouble("sp_multiplier", 1.0)));
        this.manaRegenerationBoost += properties.getFloat("mana_regeneration_boost", 0.0f);
        this.manaMaxBoost += properties.getFloat("mana_max_boost", 0.0f);
        boolean stack = properties.getBoolean("stack", false);
        this.addPassiveEffectsGroup(this.protection, properties, "protection", stack, 1.0);
        this.addPassiveEffectsGroup(this.weakness, properties, "weakness", stack, 1.0);
        this.addPassiveEffectsGroup(this.strength, properties, "strength", stack, 1.0);
        if (activeReduction || properties.getBoolean("passive") || stack) {
            if (stack) {
                this.cooldownReduction = this.stackValue(this.cooldownReduction, properties.getFloat("cooldown_reduction", 0.0f));
                this.costReduction = this.stackValue(this.costReduction, properties.getFloat("cost_reduction", 0.0f));
                this.consumeReduction = this.stackValue(this.consumeReduction, properties.getFloat("consume_reduction", 0.0f));
            } else {
                this.cooldownReduction = Math.max(this.cooldownReduction, properties.getFloat("cooldown_reduction", 0.0f));
                this.costReduction = Math.max(this.costReduction, properties.getFloat("cost_reduction", 0.0f));
                this.consumeReduction = Math.max(this.consumeReduction, properties.getFloat("consume_reduction", 0.0f));
            }
        }
        for (String spellKey : properties.getSpells()) {
            MageSpell spell;
            if (this.triggeredSpells.contains(spellKey) || (spell = this.getSpell(spellKey)) == null) continue;
            this.triggeredSpells.add(spellKey);
            Collection<Trigger> spellTriggers = spell.getTriggers();
            for (Trigger trigger : spellTriggers) {
                String triggerType = trigger.getTrigger();
                List<TriggeredSpell> typeTriggers = this.triggers.get(triggerType);
                if (typeTriggers == null) {
                    typeTriggers = new ArrayList<TriggeredSpell>();
                    this.triggers.put(triggerType, typeTriggers);
                }
                typeTriggers.add(new TriggeredSpell(spellKey, trigger));
            }
        }
    }

    protected float stackValue(float currentValue, float stackValue) {
        return Math.min(1.0f, stackValue + currentValue);
    }

    @Override
    public void updatePassiveEffects() {
        this.attributes.clear();
        this.addPassiveAttributes(this.properties);
        if (this.activeClass != null) {
            this.addPassiveAttributes(this.activeClass);
        }
        for (MageClass mageClass : this.classes.values()) {
            if (mageClass == this.activeClass || mageClass.isLocked() || !mageClass.getBoolean("passive")) continue;
            this.addPassiveAttributes(mageClass);
        }
        for (MageModifier mageModifier : this.modifiers.values()) {
            this.addPassiveAttributes(mageModifier);
        }
        if (this.activeWand != null && !this.activeWand.isWorn()) {
            this.addPassiveAttributes(this.activeWand);
        }
        if (this.offhandWand != null && !this.offhandWand.isWorn()) {
            this.addPassiveAttributes(this.offhandWand);
        }
        for (Wand wand : this.activeArmor.values()) {
            if (wand == null) continue;
            this.addPassiveAttributes(wand);
        }
        this.reloadAttributes();
        this.protection.clear();
        this.strength.clear();
        this.weakness.clear();
        for (List list : this.triggers.values()) {
            list.clear();
        }
        this.triggeredSpells.clear();
        this.earnMultiplier = 1.0f;
        this.cooldownReduction = 0.0f;
        this.costReduction = 0.0f;
        this.consumeReduction = 0.0f;
        this.manaMaxBoost = 0.0f;
        this.manaRegenerationBoost = 0.0f;
        ArrayList<PotionEffectType> currentEffects = new ArrayList<PotionEffectType>(this.effectivePotionEffects.keySet());
        LivingEntity livingEntity = this.getLivingEntity();
        this.effectivePotionEffects.clear();
        this.addPassiveEffects(this.properties, true);
        if (this.activeClass != null) {
            this.addPassiveEffects(this.activeClass, true);
        }
        for (MageClass mageClass : this.classes.values()) {
            if (mageClass == this.activeClass || mageClass.isLocked() || !mageClass.getBoolean("passive")) continue;
            this.addPassiveEffects(mageClass, true);
        }
        for (MageModifier mageModifier : this.modifiers.values()) {
            this.addPassiveEffects(mageModifier, true);
        }
        if (this.activeWand != null && !this.activeWand.isWorn()) {
            this.addPassiveEffects(this.activeWand, false);
            this.effectivePotionEffects.putAll(this.activeWand.getPotionEffects());
        }
        if (this.offhandWand != null && !this.offhandWand.isWorn()) {
            this.addPassiveEffects(this.offhandWand, false);
            this.effectivePotionEffects.putAll(this.offhandWand.getPotionEffects());
        }
        for (Wand wand : this.activeArmor.values()) {
            if (wand == null) continue;
            this.addPassiveEffects(wand, false);
            this.effectivePotionEffects.putAll(wand.getPotionEffects());
        }
        if (livingEntity != null) {
            for (PotionEffectType potionEffectType : currentEffects) {
                if (this.effectivePotionEffects.containsKey(potionEffectType)) continue;
                livingEntity.removePotionEffect(potionEffectType);
            }
            for (Map.Entry entry : this.effectivePotionEffects.entrySet()) {
                PotionEffect effect = new PotionEffect((PotionEffectType)entry.getKey(), Integer.MAX_VALUE, ((Integer)entry.getValue()).intValue(), true, false);
                CompatibilityUtils.applyPotionEffect(livingEntity, effect);
            }
        }
        if (this.activeWand != null) {
            this.activeWand.passiveEffectsUpdated();
        } else if (this.activeClass != null) {
            this.activeClass.passiveEffectsUpdated();
        }
        if (this.offhandWand != null) {
            this.offhandWand.passiveEffectsUpdated();
        }
    }

    public Collection<Wand> getActiveArmor() {
        return this.activeArmor.values();
    }

    @Override
    public void deactivate() {
        this.deactivateWand();
        this.deactivateAllSpells(true, true);
        this.removeActiveEffects();
    }

    @Override
    public void undoScheduled() {
        int finished;
        int undid;
        if (this.undoQueue != null && (undid = this.undoQueue.undoScheduled()) != 0) {
            this.controller.info("Player " + this.getName() + " logging out, auto-undid " + undid + " spells");
        }
        if ((finished = this.finishPendingUndo()) != 0) {
            this.controller.info("Player " + this.getName() + " logging out, fast-forwarded undo for " + finished + " spells");
        }
        if (this.undoQueue != null && !this.undoQueue.isEmpty()) {
            if (this.controller.commitOnQuit()) {
                this.controller.info("Player logging out, committing constructions: " + this.getName());
                this.undoQueue.commit();
            } else {
                this.controller.info("Player " + this.getName() + " logging out with " + this.undoQueue.getSize() + " spells in their undo queue");
            }
        }
    }

    @Override
    public void removeItemsWithTag(String tag) {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        PlayerInventory inventory = player.getInventory();
        ItemStack[] contents = inventory.getContents();
        for (int index = 0; index < contents.length; ++index) {
            ItemStack item = contents[index];
            if (item == null || item.getType() == Material.AIR || !InventoryUtils.hasMeta(item, tag)) continue;
            inventory.setItem(index, null);
        }
        boolean modified = false;
        ItemStack[] armor = inventory.getArmorContents();
        for (int index = 0; index < armor.length; ++index) {
            ItemStack item = armor[index];
            if (item == null || item.getType() == Material.AIR || !InventoryUtils.hasMeta(item, tag)) continue;
            modified = true;
            armor[index] = null;
        }
        if (modified) {
            inventory.setArmorContents(armor);
        }
    }

    @Override
    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    @Override
    public boolean isQuiet() {
        return this.quiet;
    }

    public void setDestinationWarp(String warp) {
        this.destinationWarp = warp;
    }

    @Override
    public boolean isAtMaxSkillPoints() {
        return this.getSkillPoints() >= this.controller.getSPMaximum();
    }

    @Nullable
    private Currency initCurrency(String type) {
        Currency currency = this.controller.getCurrency(type);
        if (!this.data.contains(type)) {
            this.data.set(type, (Object)(currency == null ? 0.0 : currency.getDefaultValue()));
        }
        return currency;
    }

    @Override
    public double getCurrency(String type) {
        Currency currency = this.controller.getCurrency(type);
        return this.data.getDouble(type, currency == null ? 0.0 : currency.getDefaultValue());
    }

    @Override
    public void addCurrency(String type, double delta) {
        boolean firstEarn = !this.data.contains(type);
        Currency currency = this.initCurrency(type);
        double newValue = this.data.getDouble(type) + delta;
        if (currency != null && currency.hasMaxValue()) {
            newValue = Math.min(newValue, currency.getMaxValue());
        }
        Messages messages = this.controller.getMessages();
        String earnMessage = messages.get("currency." + type + ".earned", messages.get("currency.earned"));
        if (delta > 0.0 && earnMessage != null && !earnMessage.isEmpty()) {
            String amountString = messages.get("currency." + type + ".amount", type).replace("$amount", Integer.toString((int)Math.ceil(delta)));
            this.sendMessage(earnMessage.replace("$earned", amountString));
        }
        this.setCurrency(type, newValue);
        if (this.activeWand != null && Wand.currencyMode != WandManaMode.NONE && this.activeWand.usesCurrency(type)) {
            if (firstEarn && currency != null) {
                this.sendMessage(this.activeWand.getMessage("earn_instructions").replace("$currency", currency.getName(this.controller.getMessages())));
            }
            this.activeWand.updateMana();
        }
    }

    @Override
    public void removeCurrency(String type, double delta) {
        this.initCurrency(type);
        double current = this.data.getDouble(type);
        this.data.set(type, (Object)(current - delta));
    }

    @Override
    public void setCurrency(String type, double amount) {
        this.data.set(type, (Object)amount);
    }

    @Override
    public boolean isAtMaxCurrency(String type) {
        Currency currency = this.controller.getCurrency(type);
        if (currency == null || !currency.hasMaxValue()) {
            return false;
        }
        double value = this.getCurrency(type);
        return value >= currency.getMaxValue();
    }

    @Override
    public int getSkillPoints() {
        if (!this.data.contains(SKILL_POINT_KEY)) {
            this.data.set(SKILL_POINT_KEY, (Object)DEFAULT_SP);
        }
        if (this.data.isString(SKILL_POINT_KEY)) {
            try {
                this.data.set(SKILL_POINT_KEY, (Object)Integer.parseInt(this.data.getString(SKILL_POINT_KEY)));
            }
            catch (Exception ex) {
                this.data.set(SKILL_POINT_KEY, (Object)0);
            }
        }
        return this.data.getInt(SKILL_POINT_KEY);
    }

    @Override
    public void addSkillPoints(int delta) {
        int current = this.getSkillPoints();
        if (this.isPlayer()) {
            String earnMessage = this.controller.getMessages().get("mage.earned_sp");
            if (delta > 0 && earnMessage != null && !earnMessage.isEmpty()) {
                this.sendMessage(earnMessage.replace("$amount", Integer.toString(delta)));
            }
        }
        this.setSkillPoints(current + delta);
    }

    @Override
    public void setSkillPoints(int amount) {
        boolean firstEarn = !this.data.contains(SKILL_POINT_KEY);
        amount = Math.max(amount, 0);
        int limit = this.controller.getSPMaximum();
        if (limit > 0) {
            amount = Math.min(amount, limit);
        }
        this.data.set(SKILL_POINT_KEY, (Object)amount);
        if (this.activeWand != null && Wand.currencyMode != WandManaMode.NONE && this.activeWand.usesSP()) {
            if (firstEarn) {
                this.sendMessage(this.activeWand.getMessage("sp_instructions"));
            }
            this.activeWand.updateMana();
        }
    }

    @Override
    public Wand getBoundWand(String template) {
        return this.boundWands.get(template);
    }

    @Override
    @Nullable
    public WandUpgradePath getBoundWandPath(String templateKey) {
        com.elmakers.mine.bukkit.api.wand.Wand boundWand = this.boundWands.get(templateKey);
        if (boundWand != null) {
            return boundWand.getPath();
        }
        return null;
    }

    public void setEntityData(EntityData entityData) {
        this.entityData = entityData;
        this.controller.registerMagicMob(this);
        ConfigurationSection mageProperties = entityData.getMageProperties();
        if (mageProperties != null) {
            ConfigurationUtils.addConfigurations(this.properties.getConfiguration(), mageProperties);
            this.properties.loadProperties();
            this.updatePassiveEffects();
        }
        this.damagedBy = new HashMap<UUID, DamagedBy>();
    }

    public List<Wand> getBoundWands() {
        return ImmutableList.copyOf(this.boundWands.values());
    }

    public void updateHotbarStatus() {
        Player player = this.getPlayer();
        if (player != null) {
            Location location = this.getLocation();
            boolean isWandInventory = this.hasStoredInventory();
            for (int i = 0; i < 9; ++i) {
                boolean usingURLIcon;
                MageSpell spell;
                ItemStack spellItem = player.getInventory().getItem(i);
                String spellKey = Wand.getSpell(spellItem);
                String classKey = Wand.getSpellClass(spellItem);
                boolean isSkill = Wand.isSkill(spellItem);
                if (spellKey == null || !isSkill && !isWandInventory || (spell = this.getSpell(spellKey)) == null) continue;
                int targetAmount = 1;
                long remainingCooldown = 0L;
                CastingCost requiredCost = null;
                boolean canCastSpell = false;
                if (classKey != null && !classKey.isEmpty()) {
                    MageClass mageClass = this.getClass(classKey);
                    if (mageClass != null && spell instanceof BaseSpell) {
                        BaseSpell baseSpell = (BaseSpell)spell;
                        baseSpell.setMageClass(mageClass);
                        remainingCooldown = spell.getRemainingCooldown();
                        requiredCost = spell.getRequiredCost();
                        canCastSpell = spell.canCast(location);
                        baseSpell.setMageClass(null);
                    }
                } else {
                    remainingCooldown = spell.getRemainingCooldown();
                    requiredCost = spell.getRequiredCost();
                    canCastSpell = spell.canCast(location);
                }
                boolean canCast = canCastSpell;
                if (canCastSpell && remainingCooldown == 0L && requiredCost == null) {
                    targetAmount = 1;
                } else if (canCastSpell) {
                    int mana;
                    canCast = remainingCooldown == 0L;
                    int n = targetAmount = Wand.LiveHotbarCooldown ? (int)Math.min(Math.ceil((double)remainingCooldown / 1000.0), 99.0) : 99;
                    if (Wand.LiveHotbarCooldown && Wand.LiveHotbarMana && requiredCost != null && (mana = requiredCost.getMana()) > 0) {
                        if (mana <= this.getEffectiveManaMax() && this.getEffectiveManaRegeneration() > 0) {
                            float remainingMana = (float)mana - this.getMana();
                            canCast = canCast && remainingMana <= 0.0f;
                            int targetManaTime = (int)Math.min(Math.ceil(remainingMana / (float)this.getEffectiveManaRegeneration()), 99.0);
                            targetAmount = Math.max(targetManaTime, targetAmount);
                        } else {
                            canCastSpell = false;
                            canCast = false;
                        }
                    }
                }
                if (targetAmount == 0) {
                    targetAmount = 1;
                }
                boolean setAmount = false;
                MaterialAndData disabledIcon = spell.getDisabledIcon();
                MaterialAndData spellIcon = spell.getIcon();
                String urlIcon = spell.getIconURL();
                String disabledUrlIcon = spell.getDisabledIconURL();
                boolean bl = usingURLIcon = (this.controller.isUrlIconsEnabled() || spellIcon == null || spellIcon.getMaterial() == Material.AIR) && urlIcon != null && !urlIcon.isEmpty();
                if (disabledIcon != null && spellIcon != null && !usingURLIcon) {
                    if (!canCast || !spell.isEnabled()) {
                        if (disabledIcon.isValid() && (disabledIcon.getMaterial() != spellItem.getType() || disabledIcon.getData().shortValue() != spellItem.getDurability())) {
                            disabledIcon.applyToItem(spellItem);
                        }
                        if (!canCastSpell) {
                            if (spellItem.getAmount() != 1) {
                                spellItem.setAmount(1);
                            }
                            setAmount = true;
                        }
                    } else if (spellIcon.isValid() && (spellIcon.getMaterial() != spellItem.getType() || spellIcon.getData().shortValue() != spellItem.getDurability())) {
                        spellIcon.applyToItem(spellItem);
                    }
                } else if (usingURLIcon && disabledUrlIcon != null && !disabledUrlIcon.isEmpty() && DefaultMaterials.isSkull(spellItem.getType())) {
                    String currentURL = InventoryUtils.getSkullURL(spellItem);
                    if (!canCast) {
                        if (!disabledUrlIcon.equals(currentURL)) {
                            spellItem = InventoryUtils.setSkullURL(spellItem, disabledUrlIcon);
                            player.getInventory().setItem(i, spellItem);
                        }
                        if (!canCastSpell) {
                            if (spellItem.getAmount() != 1) {
                                spellItem.setAmount(1);
                            }
                            setAmount = true;
                        }
                    } else if (!urlIcon.equals(currentURL)) {
                        spellItem = InventoryUtils.setSkullURL(spellItem, urlIcon);
                        player.getInventory().setItem(i, spellItem);
                    }
                }
                if (setAmount || spellItem.getAmount() == targetAmount) continue;
                spellItem.setAmount(targetAmount);
            }
        }
    }

    public long getLastBlockTime() {
        return this.lastBlockTime;
    }

    public void setLastBlockTime(long ms) {
        this.lastBlockTime = ms;
    }

    @Override
    public boolean isReflected(double angle) {
        if (this.activeWand != null && this.activeWand.isReflected(angle)) {
            return true;
        }
        return this.offhandWand != null && this.offhandWand.isReflected(angle);
    }

    @Override
    public boolean isBlocked(double angle) {
        if (this.activeWand != null && this.activeWand.isBlocked(angle)) {
            return true;
        }
        return this.offhandWand != null && this.offhandWand.isBlocked(angle);
    }

    @Override
    @Deprecated
    public float getSPMultiplier() {
        return this.earnMultiplier;
    }

    @Override
    public float getEarnMultiplier() {
        return this.earnMultiplier;
    }

    @Override
    @Nonnull
    public MageProperties getProperties() {
        return this.properties;
    }

    @Override
    public double getVehicleMovementDirection() {
        LivingEntity li = this.getLivingEntity();
        if (li == null) {
            return 0.0;
        }
        return CompatibilityUtils.getForwardMovement(li);
    }

    @Override
    public double getVehicleStrafeDirection() {
        LivingEntity li = this.getLivingEntity();
        if (li == null) {
            return 0.0;
        }
        return CompatibilityUtils.getStrafeMovement(li);
    }

    @Override
    public boolean isVehicleJumping() {
        LivingEntity li = this.getLivingEntity();
        if (li == null) {
            return false;
        }
        return CompatibilityUtils.isJumping(li);
    }

    @Override
    public void setVanished(boolean vanished) {
        Player thisPlayer = this.getPlayer();
        if (thisPlayer != null && this.isVanished != vanished) {
            this.controller.setVanished(this, vanished);
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (vanished) {
                    DeprecatedUtils.hidePlayer((Plugin)this.controller.getPlugin(), player, thisPlayer);
                    continue;
                }
                DeprecatedUtils.showPlayer((Plugin)this.controller.getPlugin(), player, thisPlayer);
            }
        }
        this.isVanished = vanished;
    }

    @Override
    public boolean isVanished() {
        return this.isVanished;
    }

    @Override
    public void setGlidingAllowed(boolean allow) {
        this.glidingAllowed = allow;
        Player player = this.getPlayer();
        if (player != null) {
            this.controller.addFlightExemption(player, 5000);
        }
    }

    @Override
    public boolean isGlidingAllowed() {
        return this.glidingAllowed;
    }

    public boolean isForget() {
        return this.forget;
    }

    public void setForget(boolean forget) {
        this.forget = forget;
    }

    @Override
    public double getVaultBalance() {
        if (!VaultController.hasEconomy() || !this.isPlayer()) {
            return 0.0;
        }
        return VaultController.getInstance().getBalance(this.getPlayer());
    }

    @Override
    public boolean addVaultCurrency(double delta) {
        if (!VaultController.hasEconomy() || !this.isPlayer()) {
            return false;
        }
        VaultController.getInstance().depositPlayer(this.getPlayer(), delta);
        return true;
    }

    @Override
    public boolean removeVaultCurrency(double delta) {
        if (!VaultController.hasEconomy() || !this.isPlayer()) {
            return false;
        }
        VaultController.getInstance().withdrawPlayer(this.getPlayer(), delta);
        return true;
    }

    public void setIsAutomaton(boolean automaton) {
        this.isAutomaton = automaton;
    }

    @Override
    public boolean isAutomaton() {
        return this.isAutomaton;
    }

    @Override
    public void addTag(String tag) {
        this.tags.add(tag);
    }

    @Override
    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    public void setOpenCooldown(long openCooldown) {
        if (openCooldown > 0L) {
            this.disableWandOpenUntil = System.currentTimeMillis() + openCooldown;
        }
    }

    public long getWandDisableTime() {
        return this.disableWandOpenUntil;
    }

    public Integer getLastActivatedSlot() {
        return this.lastActivatedSlot;
    }

    public void setLastActivatedSlot(int slot) {
        this.lastActivatedSlot = slot;
    }

    @Override
    @Nullable
    public Double getAttribute(String attributeKey) {
        Player player;
        MagicAttribute defaultSetting;
        Double attribute = this.attributes.get(attributeKey);
        if (attribute == null && (defaultSetting = this.controller.getAttribute(attributeKey)) != null) {
            attribute = defaultSetting.getDefault();
        }
        if (attribute == null && (player = this.getPlayer()) != null) {
            List<AttributeProvider> providers = this.controller.getAttributeProviders();
            for (AttributeProvider provider : providers) {
                Double value = provider.getAttributeValue(attributeKey, player);
                if (value == null) continue;
                attribute = value;
                break;
            }
        }
        if (attribute == null) {
            attribute = this.getBuiltinAttribute(attributeKey);
        }
        return attribute;
    }

    @Nullable
    private Double getBuiltinAttribute(String attributeKey) {
        switch (attributeKey) {
            case "health": {
                LivingEntity living = this.getLivingEntity();
                return living == null ? null : Double.valueOf(living.getHealth());
            }
            case "health_max": {
                LivingEntity living = this.getLivingEntity();
                return living == null ? null : Double.valueOf(CompatibilityUtils.getMaxHealth((Damageable)living));
            }
            case "mana": {
                return this.getMana();
            }
            case "mana_max": {
                return this.getEffectiveManaMax();
            }
            case "xp": {
                return this.getExperience();
            }
            case "level": {
                return this.getLevel();
            }
            case "time": {
                Location location = this.getLocation();
                return location == null ? null : Double.valueOf(location.getWorld().getTime());
            }
            case "moon": {
                Location location = this.getLocation();
                return location == null ? null : Double.valueOf((int)(location.getWorld().getFullTime() / 24000L % 8L));
            }
            case "location_x": {
                Location location = this.getLocation();
                return location == null ? null : Double.valueOf(location.getX());
            }
            case "location_y": {
                Location location = this.getLocation();
                return location == null ? null : Double.valueOf(location.getY());
            }
            case "location_z": {
                Location location = this.getLocation();
                return location == null ? null : Double.valueOf(location.getZ());
            }
            case "damage": {
                return this.getLastDamage();
            }
            case "damage_dealt": {
                return this.getLastDamageDealt();
            }
            case "bowpull": {
                return this.getLastBowPull();
            }
            case "bowpower": {
                return this.getLastBowPower();
            }
        }
        return null;
    }

    @Override
    public void setLastDamageType(String damageType) {
        this.currentDamageType = damageType;
        this.lastDamageType = damageType;
    }

    @Override
    public String getLastDamageType() {
        return this.lastDamageType;
    }

    @Override
    public void setLastDamageDealtType(String damageType) {
        this.currentDamageDealtType = damageType;
        this.lastDamageDealtType = damageType;
    }

    @Override
    public String getLastDamageDealtType() {
        return this.lastDamageDealtType;
    }

    public boolean isManaRegenerationDisabled() {
        for (MageSpell spell : this.activeSpells) {
            if (!spell.disableManaRegenerationWhenActive()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Wand findWand(@Nonnull String template) {
        Player player = this.getPlayer();
        if (player == null) {
            return null;
        }
        PlayerInventory inventory = player.getInventory();
        for (ItemStack itemStack : inventory.getContents()) {
            String itemTemplate = Wand.getWandTemplate(itemStack);
            if (itemTemplate == null || !itemTemplate.equals(template)) continue;
            return this.controller.getWand(itemStack);
        }
        return null;
    }

    @Override
    @Nonnull
    public MageEffectContext getEffectContext() {
        if (this.effectContext == null) {
            this.effectContext = new MageEffectContext(this);
        }
        return (MageEffectContext)Verify.verifyNotNull((Object)this.effectContext);
    }

    @Override
    public long getCreatedTime() {
        return this.created;
    }

    @Override
    public boolean trigger(String trigger) {
        if (!trigger.equals("interval")) {
            this.sendDebugMessage("Processing trigger: " + trigger, 5);
        }
        this.lastTriggers.put(trigger, System.currentTimeMillis());
        if (this.entityData != null) {
            this.cancelLaunch = true;
            return this.entityData.trigger(this, trigger);
        }
        List<TriggeredSpell> spells = this.triggers.get(trigger.toLowerCase());
        if (spells == null || spells.isEmpty()) {
            return false;
        }
        this.processingTriggers.clear();
        this.processingTriggers.addAll(spells);
        boolean activated = false;
        this.cancelLaunch = false;
        for (TriggeredSpell triggered : this.processingTriggers) {
            MageSpell spell;
            if (!triggered.getTrigger().isValid(this) || (spell = this.getSpell(triggered.getSpellKey())) == null || !spell.isEnabled() || this.triggeringSpells.contains(spell.getKey())) continue;
            this.triggeringSpells.add(spell.getKey());
            this.cancelLaunch = this.cancelLaunch || triggered.getTrigger().isCancelLaunch();
            activated = spell.cast() || activated;
            triggered.getTrigger().triggered();
        }
        return activated;
    }

    @Override
    public void attributesUpdated() {
        this.updatePassiveEffects();
        for (MageSpell spell : this.spells.values()) {
            spell.updateTemplateParameters();
        }
        if (this.activeWand != null) {
            this.activeWand.deactivate();
            this.checkWand();
        }
    }

    @Override
    public void deactivateClasses() {
        for (MageClass mageClass : this.classes.values()) {
            if (mageClass.isLocked()) continue;
            mageClass.deactivateAttributes();
        }
    }

    @Override
    public void activateClasses() {
        for (MageClass mageClass : this.classes.values()) {
            if (mageClass.isLocked()) continue;
            mageClass.activateAttributes();
        }
    }

    @Override
    public void deactivateModifiers() {
        for (MageModifier modifier : this.modifiers.values()) {
            modifier.deactivateAttributes();
        }
    }

    @Override
    public void activateModifiers() {
        for (MageModifier modifier : this.modifiers.values()) {
            modifier.activateAttributes();
        }
    }

    @Override
    public void setLaunchingProjectile(boolean launching) {
        this.launchingProjectile = launching;
    }

    @Override
    public boolean isLaunchingProjectile() {
        return this.launchingProjectile;
    }

    @Override
    public double getLastDamage() {
        return this.lastDamage;
    }

    public void setLastDamage(double lastDamage) {
        this.lastDamage = lastDamage;
    }

    @Override
    public double getLastDamageDealt() {
        return this.lastDamageDealt;
    }

    @Override
    public double getLastBowPull() {
        return this.lastBowPull;
    }

    public void setLastBowPull(double lastBowPull) {
        this.lastBowPull = lastBowPull;
    }

    public int getLastBowPower() {
        if (this.lastBowUsed == null || !this.lastBowUsed.hasItemMeta()) {
            return 0;
        }
        ItemMeta meta = this.lastBowUsed.getItemMeta();
        return meta.getEnchantLevel(Enchantment.ARROW_DAMAGE);
    }

    public void setLastBowUsed(ItemStack itemStack) {
        this.lastBowUsed = itemStack;
    }

    public void setLastProjectileType(EntityType t) {
        this.lastProjectileType = t;
    }

    @Override
    public EntityType getLastProjectileType() {
        return this.lastProjectileType;
    }

    @Override
    public double getHealth() {
        LivingEntity li = this.getLivingEntity();
        return li == null ? 0.0 : li.getHealth();
    }

    @Override
    public double getMaxHealth() {
        LivingEntity li = this.getLivingEntity();
        return li == null ? 0.0 : CompatibilityUtils.getMaxHealth((Damageable)li);
    }

    public boolean isCancelLaunch() {
        if (this.entityData != null) {
            return this.entityData.isCancelLaunch();
        }
        return this.cancelLaunch;
    }

    @Override
    @Nullable
    public Long getLastTrigger(String trigger) {
        return this.lastTriggers.get(trigger);
    }

    @Override
    public boolean toggleSpellEnabled(String spellKey) {
        return this.toggleSpellEnabled(this.getSpell(spellKey));
    }

    public boolean toggleSpellEnabled(Spell spell) {
        if (spell != null && spell.isToggleable()) {
            spell.setEnabled(!spell.isEnabled());
            if (this.activeWand != null) {
                this.activeWand.updateSpellItem(spell);
            }
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public ConfigurationSection getVariables() {
        if (this.variables == null) {
            this.variables = new MemoryConfiguration();
        }
        return this.variables;
    }

    @Override
    public boolean addModifier(@Nonnull String key) {
        return this.addModifier(key, 0);
    }

    @Override
    public boolean addModifier(@Nonnull String key, @Nullable ConfigurationSection properties) {
        int duration = properties == null ? 0 : properties.getInt("duration");
        return this.addModifier(key, duration, properties);
    }

    @Override
    public boolean addModifier(@Nonnull String key, int duration) {
        return this.addModifier(key, duration, null);
    }

    @Override
    public boolean addModifier(@Nonnull String key, int duration, @Nullable ConfigurationSection properties) {
        MageModifier modifier = this.modifiers.get(key);
        if (modifier != null) {
            if (!modifier.hasDuration()) {
                return false;
            }
            if (duration > 0 && modifier.getTimeRemaining() > duration) {
                return false;
            }
            modifier.reset(duration);
            return true;
        }
        ModifierTemplate template = this.controller.getModifierTemplate(key);
        if (template == null) {
            this.controller.getLogger().warning("Invalid modifier key: " + key);
            return false;
        }
        template = template.getMageTemplate(this);
        modifier = new MageModifier(this, template);
        this.modifiers.put(key, modifier);
        modifier.onAdd(duration);
        this.updatePassiveEffects();
        return true;
    }

    @Override
    public MageModifier removeModifier(@Nonnull String key) {
        MageModifier modifier = this.modifiers.remove(key);
        if (modifier != null) {
            modifier.onRemoved();
            this.updatePassiveEffects();
        }
        return modifier;
    }

    @Override
    @Nonnull
    public Set<String> getModifierKeys() {
        return this.modifiers.keySet();
    }

    @Override
    @Nullable
    public MageModifier getModifier(String key) {
        return this.modifiers.get(key);
    }

    @Nullable
    public Integer getArrowToLaunch() {
        PlayerInventory inventory;
        Player player = this.getPlayer();
        PlayerInventory playerInventory = inventory = player == null ? null : player.getInventory();
        if (inventory == null) {
            return null;
        }
        ItemStack itemStack = inventory.getItemInMainHand();
        if (itemStack.getType() == Material.ARROW) {
            return -1;
        }
        itemStack = inventory.getItemInOffHand();
        if (itemStack.getType() == Material.ARROW) {
            return -2;
        }
        ItemStack[] contents = inventory.getContents();
        for (int i = 0; i < contents.length; ++i) {
            ItemStack item = contents[i];
            if (item == null || item.getType() != Material.ARROW) continue;
            return i;
        }
        return null;
    }

    @Nullable
    public ItemStack getItemInSlot(int slot) {
        PlayerInventory inventory;
        Player player = this.getPlayer();
        PlayerInventory playerInventory = inventory = player == null ? null : player.getInventory();
        if (inventory == null) {
            return null;
        }
        if (slot == -1) {
            return inventory.getItemInMainHand();
        }
        if (slot == -2) {
            return inventory.getItemInOffHand();
        }
        return inventory.getItem(slot);
    }

    public void clearSlot(int slot) {
        PlayerInventory inventory;
        Player player = this.getPlayer();
        PlayerInventory playerInventory = inventory = player == null ? null : player.getInventory();
        if (inventory == null) {
            return;
        }
        if (slot == -1) {
            inventory.setItemInMainHand(null);
        } else if (slot == -2) {
            inventory.setItemInOffHand(null);
        } else {
            inventory.setItem(slot, null);
        }
    }

    @Nonnull
    public Map<Player, MageConversation> getConversations() {
        return this.conversations;
    }

    @Override
    public boolean isBypassEnabled() {
        return this.bypassEnabled;
    }

    @Override
    public void setBypassEnabled(boolean enable) {
        this.bypassEnabled = enable;
    }

    public float getManaMaxMultiplier() {
        return 1.0f + this.manaMaxBoost;
    }

    public float getManaRegenerationMultiplier() {
        return 1.0f + this.manaRegenerationBoost;
    }

    public boolean isResourcePackEnabled() {
        return this.resourcePackEnabled;
    }

    public void setResourcePackEnabled(boolean enable) {
        this.resourcePackEnabled = enable;
    }

    private static class DamagedBy {
        private WeakReference<Player> player;
        public double damage;

        public DamagedBy(Player player, double damage) {
            this.player = new WeakReference<Player>(player);
            this.damage = damage;
        }

        public Entity getEntity() {
            return (Entity)this.player.get();
        }
    }
}

