/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.batch;

import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.batch.BrushBatch;
import com.elmakers.mine.bukkit.block.ConstructionType;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.util.Vector;

public class ShapeBatch
extends BrushBatch {
    private final Location center;
    private Vector orient = null;
    private final int radius;
    private final int thickness;
    private final ConstructionType type;
    private Integer maxOrientDimension = null;
    private Integer minOrientDimension = null;
    private int x = 0;
    private int y = 0;
    private int z = 0;
    private int r = 0;
    private boolean limitYAxis = false;

    public ShapeBatch(BrushSpell spell, Location center, ConstructionType type, int radius, int thickness, Location orientToLocation) {
        super(spell);
        this.center = center;
        this.radius = radius;
        this.thickness = thickness;
        this.type = type;
        if (orientToLocation != null) {
            Vector orientTo = orientToLocation.toVector().subtract(center.toVector());
            orientTo.setX(Math.abs(orientTo.getX()));
            orientTo.setY(Math.abs(orientTo.getY()));
            orientTo.setZ(Math.abs(orientTo.getZ()));
            this.orient = orientTo.getX() < orientTo.getZ() && orientTo.getX() < orientTo.getY() ? new Vector(1, 0, 0) : (orientTo.getZ() < orientTo.getX() && orientTo.getZ() < orientTo.getY() ? new Vector(0, 0, 1) : new Vector(0, 1, 0));
        } else {
            this.orient = new Vector(0, 1, 0);
        }
    }

    public void setOrientDimensionMax(int maxDim) {
        this.maxOrientDimension = maxDim;
    }

    public void setOrientDimensionMin(int minDim) {
        this.minOrientDimension = minDim;
    }

    @Override
    public int size() {
        return this.radius * this.radius * this.radius * 8;
    }

    @Override
    public int remaining() {
        if (this.r >= this.radius) {
            return 0;
        }
        return (this.radius - this.r) * (this.radius - this.r) * (this.radius - this.r) * 8;
    }

    @Override
    public int process(int maxBlocks) {
        int processedBlocks = 0;
        int yBounds = this.radius;
        if ((this.maxOrientDimension != null || this.minOrientDimension != null) && this.orient.getBlockY() > 0) {
            this.limitYAxis = true;
            yBounds = Math.max(this.minOrientDimension == null ? this.radius : this.minOrientDimension, this.maxOrientDimension == null ? this.radius : this.maxOrientDimension);
        }
        yBounds = Math.min(yBounds, 255);
        while (processedBlocks <= maxBlocks && !this.finished) {
            if (!this.createSymmetricalBlock(this.x, this.y, this.z)) {
                return processedBlocks;
            }
            int xBounds = this.r;
            int zBounds = this.r;
            if ((this.maxOrientDimension != null || this.minOrientDimension != null) && this.orient.getBlockX() > 0) {
                xBounds = Math.max(this.minOrientDimension == null ? this.r : this.minOrientDimension, this.maxOrientDimension == null ? this.r : this.maxOrientDimension);
            }
            if ((this.maxOrientDimension != null || this.minOrientDimension != null) && this.orient.getBlockZ() > 0) {
                zBounds = Math.max(this.minOrientDimension == null ? this.r : this.minOrientDimension, this.maxOrientDimension == null ? this.r : this.maxOrientDimension);
            }
            ++this.y;
            if (this.y > yBounds) {
                this.y = 0;
                if (this.x < xBounds) {
                    ++this.x;
                } else {
                    --this.z;
                    if (this.z < 0) {
                        ++this.r;
                        zBounds = this.r;
                        if ((this.maxOrientDimension != null || this.minOrientDimension != null) && this.orient.getBlockZ() > 0) {
                            zBounds = Math.max(this.minOrientDimension == null ? this.r : this.minOrientDimension, this.maxOrientDimension == null ? this.r : this.maxOrientDimension);
                        }
                        this.z = zBounds;
                        this.x = 0;
                    }
                }
            }
            if (this.r > this.radius) {
                this.finish();
                break;
            }
            ++processedBlocks;
        }
        return processedBlocks;
    }

    public boolean createSymmetricalBlock(int x, int y, int z) {
        boolean fillBlock = false;
        switch (this.type) {
            case SPHERE: {
                int maxDistanceSquared = this.radius * this.radius;
                float mx = (float)x - 0.5f;
                float my = (float)y - 0.5f;
                float mz = (float)z - 0.5f;
                int distanceSquared = (int)(mx * mx + my * my + mz * mz);
                if (this.thickness == 0) {
                    fillBlock = distanceSquared <= maxDistanceSquared;
                    break;
                }
                int outerDistanceSquared = (int)((mx += 1.0f) * mx + (my += 1.0f) * my + (mz += 1.0f) * mz);
                fillBlock = maxDistanceSquared >= distanceSquared - this.thickness && maxDistanceSquared <= outerDistanceSquared;
                break;
            }
            case PYRAMID: {
                int elevation = this.radius - y;
                if (this.thickness == 0) {
                    fillBlock = x <= elevation && z <= elevation;
                    break;
                }
                fillBlock = x <= elevation && x >= elevation - this.thickness && z <= elevation || z <= elevation && z >= elevation - this.thickness && x <= elevation;
                break;
            }
            default: {
                fillBlock = this.thickness == 0 ? true : x >= this.radius - this.thickness || y >= this.radius - this.thickness || z >= this.radius - this.thickness;
            }
        }
        boolean success = true;
        if (fillBlock) {
            if (y != 0) {
                boolean bl = success = success && this.createBlock(x, -y, z);
                if (x != 0) {
                    boolean bl2 = success = success && this.createBlock(-x, -y, z);
                }
                if (z != 0) {
                    boolean bl3 = success = success && this.createBlock(x, -y, -z);
                }
                if (x != 0 && z != 0) {
                    success = success && this.createBlock(-x, -y, -z);
                }
            }
            boolean bl = success = success && this.createBlock(x, y, z);
            if (x != 0) {
                boolean bl4 = success = success && this.createBlock(-x, y, z);
            }
            if (z != 0) {
                boolean bl5 = success = success && this.createBlock(x, y, -z);
            }
            if (z != 0 && x != 0) {
                success = success && this.createBlock(-x, y, -z);
            }
        }
        return success;
    }

    public boolean createBlock(int dx, int dy, int dz) {
        if (this.limitYAxis && this.minOrientDimension != null && dy < -this.minOrientDimension.intValue()) {
            return true;
        }
        if (this.limitYAxis && this.maxOrientDimension != null && dy > this.maxOrientDimension) {
            return true;
        }
        int x = this.center.getBlockX() + dx;
        int y = this.center.getBlockY() + dy;
        int z = this.center.getBlockZ() + dz;
        if (y < 0 || y > this.center.getWorld().getMaxHeight()) {
            return true;
        }
        Block block = this.center.getWorld().getBlockAt(x, y, z);
        if (!block.getChunk().isLoaded()) {
            block.getChunk().load();
            return false;
        }
        this.touch(block);
        MaterialBrush brush = this.spell.getBrush();
        brush.update(this.mage, block.getLocation());
        if (!brush.isReady()) {
            brush.prepare();
            return false;
        }
        if (!this.spell.hasBuildPermission(block)) {
            return true;
        }
        Location loc = this.center.clone();
        Vector direction = block.getLocation().toVector().subtract(this.center.toVector()).normalize();
        loc.setDirection(direction);
        Minecart minecart = CompatibilityUtils.spawnCustomMinecart(loc, brush.getMaterial(), brush.getData(), this.radius * 16);
        this.registerForUndo((Entity)minecart);
        return true;
    }

    @Override
    protected boolean contains(Location location) {
        return false;
    }
}

