/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.api.event.CraftWandEvent;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.MagicRecipe;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.plugin.Plugin;

public class CraftingController
implements Listener {
    private final MagicController controller;
    private boolean craftingEnabled = false;
    private boolean allowWandsAsIngredients = true;
    private Map<Material, List<MagicRecipe>> recipes = new HashMap<Material, List<MagicRecipe>>();
    private Set<String> recipeKeys = new HashSet<String>();

    public CraftingController(MagicController controller) {
        this.controller = controller;
    }

    public void load(ConfigurationSection configuration) {
        this.recipes.clear();
        this.recipeKeys.clear();
        if (!this.craftingEnabled) {
            return;
        }
        Set recipeKeys = configuration.getKeys(false);
        for (String key : recipeKeys) {
            MagicRecipe recipe;
            block6: {
                ConfigurationSection parameters = configuration.getConfigurationSection(key);
                if (!parameters.getBoolean("enabled", true)) continue;
                recipe = new MagicRecipe(key, this.controller);
                try {
                    if (!recipe.load(parameters)) {
                        this.controller.getLogger().warning("Failed to create crafting recipe: " + key);
                    }
                    break block6;
                }
                catch (Exception ex) {
                    this.controller.getLogger().log(Level.WARNING, "An error occurred creating crafting recipe: " + key, ex);
                }
                continue;
            }
            Material outputType = recipe.getOutputType();
            List<MagicRecipe> similar = this.recipes.get(outputType);
            if (similar == null) {
                similar = new ArrayList<MagicRecipe>();
                this.recipes.put(outputType, similar);
            }
            similar.add(recipe);
            this.recipeKeys.add(recipe.getKey());
        }
    }

    public void loadMainConfiguration(ConfigurationSection configuration) {
        this.craftingEnabled = configuration.getBoolean("enable_crafting", this.craftingEnabled);
        this.allowWandsAsIngredients = this.craftingEnabled && configuration.getBoolean("allow_wands_as_ingredients", this.allowWandsAsIngredients);
    }

    public boolean hasCraftPermission(Player player, MagicRecipe recipe) {
        if (player == null) {
            return false;
        }
        if (this.controller.hasBypassPermission((CommandSender)player)) {
            return true;
        }
        if (!this.controller.hasPermission(player, "Magic.wand.craft")) {
            return false;
        }
        return this.controller.hasPermission(player, "Magic.craft." + recipe.getKey(), true);
    }

    public void register(MagicController controller, Plugin plugin) {
        if (!this.craftingEnabled) {
            return;
        }
        for (List<MagicRecipe> list : this.recipes.values()) {
            for (MagicRecipe recipe : list) {
                recipe.register(controller, plugin);
            }
        }
    }

    @EventHandler
    public void onPrepareCraftItem(PrepareItemCraftEvent event) {
        CraftingInventory inventory = event.getInventory();
        ItemStack[] contents = inventory.getMatrix();
        if (!this.allowWandsAsIngredients) {
            for (int i = 0; i < 9 && i < contents.length; ++i) {
                ItemStack item = contents[i];
                if (!Wand.isSpecial(item)) continue;
                inventory.setResult(new ItemStack(Material.AIR));
                return;
            }
        }
        if (!this.craftingEnabled) {
            return;
        }
        Recipe recipe = event.getRecipe();
        if (recipe == null) {
            return;
        }
        ItemStack result = recipe.getResult();
        if (result == null) {
            return;
        }
        Material resultType = result.getType();
        List<MagicRecipe> candidates = this.recipes.get(resultType);
        if (candidates == null || candidates.size() == 0) {
            return;
        }
        for (MagicRecipe candidate : candidates) {
            MagicRecipe.MatchType matchType = candidate.getMatchType(contents);
            Material substitute = candidate.getSubstitute();
            if (matchType != MagicRecipe.MatchType.NONE) {
                for (HumanEntity human : event.getViewers()) {
                    if (!(human instanceof Player) || matchType != MagicRecipe.MatchType.PARTIAL && this.hasCraftPermission((Player)human, candidate)) continue;
                    inventory.setResult(new ItemStack(Material.AIR));
                    return;
                }
                if (matchType != MagicRecipe.MatchType.MATCH) break;
                ItemStack crafted = candidate.craft();
                inventory.setResult(crafted);
                break;
            }
            if (substitute == null) continue;
            inventory.setResult(new ItemStack(substitute, 1));
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        InventoryType inventoryType = event.getInventory().getType();
        InventoryType.SlotType slotType = event.getSlotType();
        if (slotType == InventoryType.SlotType.CRAFTING && (inventoryType == InventoryType.CRAFTING || inventoryType == InventoryType.WORKBENCH)) {
            ItemStack cursor = event.getCursor();
            if (Wand.isSpecial(cursor) && !this.allowWandsAsIngredients) {
                event.setCancelled(true);
            } else if (InventoryUtils.getMetaBoolean(cursor, "undroppable", false)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        HumanEntity human = event.getWhoClicked();
        if (!(human instanceof Player)) {
            return;
        }
        Player player = (Player)human;
        Mage mage = this.controller.getMage(player);
        if (mage.hasStoredInventory()) {
            event.setCancelled(true);
            return;
        }
        ItemStack currentItem = event.getCurrentItem();
        if (Wand.isWand(currentItem)) {
            CraftWandEvent castEvent = new CraftWandEvent(mage, this.controller.getWand(currentItem));
            Bukkit.getPluginManager().callEvent((Event)castEvent);
        }
    }

    public boolean isEnabled() {
        return this.craftingEnabled;
    }

    public int getCount() {
        return this.recipeKeys.size();
    }

    public List<String> getRecipeKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        for (List<MagicRecipe> recipeList : this.recipes.values()) {
            for (MagicRecipe recipe : recipeList) {
                keys.add(recipe.getKey());
            }
        }
        return keys;
    }
}

