/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Location;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class CastCommandExecutor
extends MagicTabExecutor {
    public CastCommandExecutor(MagicAPI api) {
        super(api, new String[]{"cast", "castp"});
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        String commandName = command.getName();
        if (commandName.equalsIgnoreCase("castp")) {
            if (!this.api.hasPermission(sender, "Magic.commands.castp")) {
                this.sendNoPermission(sender);
                return true;
            }
            if (args.length < 1) {
                if (sender != null) {
                    sender.sendMessage("Usage: /castp [player] [spell] <parameters>");
                }
                return true;
            }
            String playerName = args[0];
            List<Entity> targets = NMSUtils.selectEntities(sender, playerName);
            ArrayList<Mage> mages = new ArrayList<Mage>();
            if (targets != null) {
                MageController controller = this.api.getController();
                for (Entity entity : targets) {
                    Mage mage = controller.getMage(entity);
                    mages.add(mage);
                }
            } else {
                MageController controller;
                Mage mage = null;
                if (playerName.contains(",")) {
                    String[] idPieces = StringUtils.split((String)playerName, (char)',');
                    if (idPieces.length == 4 || idPieces.length == 2) {
                        try {
                            String entityId = idPieces[idPieces.length - 1];
                            Entity entity = CompatibilityUtils.getEntity(UUID.fromString(entityId));
                            if (entity == null) {
                                if (sender != null) {
                                    sender.sendMessage("Entity not found with id " + entityId);
                                }
                                return false;
                            }
                            controller = this.api.getController();
                            mage = controller.getMage(entity);
                            sender = null;
                        }
                        catch (Throwable ex) {
                            if (sender != null) {
                                sender.sendMessage("Failed to find entity by id, check server logs for errors");
                            }
                            ex.printStackTrace();
                            return false;
                        }
                    }
                } else if (playerName.contains(":")) {
                    String[] pieces = StringUtils.split((String)playerName, (char)':');
                    String mageId = pieces[0];
                    String mageName = pieces.length > 0 ? pieces[1] : mageId;
                    controller = this.api.getController();
                    mage = controller.getMage(mageId, mageName);
                }
                Player player = DeprecatedUtils.getPlayer(playerName);
                if (mage == null && player == null && playerName.contains("-")) {
                    try {
                        Entity entity;
                        entity = CompatibilityUtils.getEntity(UUID.fromString(playerName));
                        if (entity != null) {
                            mage = this.api.getController().getMage(entity);
                            sender = null;
                        }
                    }
                    catch (Throwable ex) {
                        if (sender != null) {
                            sender.sendMessage("Failed to find entity " + playerName + ", check server logs for errors");
                        }
                        ex.printStackTrace();
                        return false;
                    }
                }
                if (mage == null && player != null) {
                    if (!player.isOnline()) {
                        if (sender != null) {
                            sender.sendMessage("Player " + playerName + " is not online");
                        }
                        return true;
                    }
                    mage = this.controller.getMage(player);
                }
                if (mage != null) {
                    mages.add(mage);
                }
            }
            if (mages.isEmpty()) {
                if (sender != null) {
                    sender.sendMessage("No targets match selectors");
                }
                return true;
            }
            Location sourceLocation = null;
            if (sender != null && sender instanceof BlockCommandSender) {
                sourceLocation = ((BlockCommandSender)sender).getBlock().getLocation();
            }
            String[] castParameters = Arrays.copyOfRange(args, 1, args.length);
            for (Mage mage : mages) {
                if (mage == null || mage.isLoading()) continue;
                this.processCastCommand(sender, mage, castParameters, sourceLocation, " as " + mage.getName());
            }
            return true;
        }
        if (commandName.equalsIgnoreCase("cast")) {
            if (!this.api.hasPermission(sender, "Magic.commands.cast")) {
                this.sendNoPermission(sender);
                return true;
            }
            return this.processCastCommand(sender, this.controller.getMage(sender), args, null, null);
        }
        return false;
    }

    public boolean processCastCommand(CommandSender sender, Mage mage, String[] castParameters, Location targetLocation, String messageSuffix) {
        boolean result;
        if (((String[])castParameters).length < 1) {
            if (sender != null) {
                sender.sendMessage("Missing spell in cast command");
            }
            return false;
        }
        String spellName = castParameters[0];
        MageSpell spell = mage.getSpell(spellName);
        if (spell == null) {
            if (sender != null) {
                sender.sendMessage("Unknown spell " + spellName);
            }
            return false;
        }
        castParameters = sender.hasPermission("Magic.commands.cast.parameters") ? Arrays.copyOfRange(castParameters, 1, ((String[])castParameters).length) : null;
        ((MagicController)this.controller).toggleCastCommandOverrides(mage, sender, true);
        try {
            result = spell.cast((String[])castParameters, targetLocation);
        }
        catch (Throwable ex) {
            result = false;
            this.controller.getLogger().log(Level.SEVERE, "Error casting spell via command", ex);
        }
        if (result) {
            if (sender != null && messageSuffix != null) {
                sender.sendMessage("Cast " + spell.getName() + messageSuffix);
            }
        } else if (sender != null && messageSuffix != null) {
            sender.sendMessage("Failed to cast " + spell.getName() + messageSuffix);
        }
        ((MagicController)this.controller).toggleCastCommandOverrides(mage, sender, false);
        return result;
    }

    @Override
    public Collection<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        String spellName;
        SpellTemplate spell;
        HashSet<String> options = new HashSet<String>();
        String permissionKey = "cast";
        if (commandName.contains("castp")) {
            permissionKey = "castp";
            if (args.length == 1) {
                options.addAll(this.api.getPlayerNames());
                return options;
            }
            if (args.length > 1) {
                args = Arrays.copyOfRange(args, 1, args.length);
            }
        }
        if (args.length == 1) {
            Collection<SpellTemplate> spellList = this.api.getController().getSpellTemplates(true);
            for (SpellTemplate spell2 : spellList) {
                this.addIfPermissible(sender, options, "Magic." + permissionKey + ".", spell2.getKey());
            }
        }
        if (args.length > 1 && sender.hasPermission("Magic.commands.cast.parameters") && (spell = this.api.getSpellTemplate(spellName = args[0])) != null) {
            if (args.length % 2 == 0) {
                spell.getParameters(options);
            } else {
                spell.getParameterOptions(options, args[args.length - 2]);
            }
        }
        return options;
    }
}

