/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.entity;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.entity.EntityExtraData;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;

public class EntityEnderDragonData
extends EntityExtraData {
    public EnderDragon.Phase phase;

    public EntityEnderDragonData() {
    }

    public EntityEnderDragonData(ConfigurationSection parameters, MageController controller) {
        Logger log = controller.getLogger();
        String phaseName = parameters.getString("phase");
        if (phaseName != null && !phaseName.isEmpty()) {
            try {
                this.phase = EnderDragon.Phase.valueOf((String)phaseName.toUpperCase());
            }
            catch (Throwable ex) {
                log.warning("Invalid ender dragon phase: " + phaseName);
            }
        }
    }

    public EntityEnderDragonData(Entity entity) {
        if (entity instanceof EnderDragon) {
            this.phase = ((EnderDragon)entity).getPhase();
        }
    }

    @Override
    public void apply(Entity entity) {
        if (this.phase != null && entity instanceof EnderDragon) {
            ((EnderDragon)entity).setPhase(this.phase);
        }
    }

    @Override
    public EntityExtraData clone() {
        EntityEnderDragonData copy = new EntityEnderDragonData();
        copy.phase = this.phase;
        return copy;
    }
}

