/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.entity;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.api.item.Cost;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MageModifier;
import com.elmakers.mine.bukkit.entity.EntityAreaEffectCloudData;
import com.elmakers.mine.bukkit.entity.EntityArmorStandData;
import com.elmakers.mine.bukkit.entity.EntityEnderDragonData;
import com.elmakers.mine.bukkit.entity.EntityExtraData;
import com.elmakers.mine.bukkit.entity.EntityFallingBlockData;
import com.elmakers.mine.bukkit.entity.EntityFoxData;
import com.elmakers.mine.bukkit.entity.EntityHorseData;
import com.elmakers.mine.bukkit.entity.EntityMageData;
import com.elmakers.mine.bukkit.entity.EntityParrotData;
import com.elmakers.mine.bukkit.entity.EntitySlimeData;
import com.elmakers.mine.bukkit.entity.EntityVillagerData;
import com.elmakers.mine.bukkit.entity.EntityZombieData;
import com.elmakers.mine.bukkit.item.ItemData;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.SafetyUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Rotation;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Colorable;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class EntityData
implements com.elmakers.mine.bukkit.api.entity.EntityData,
Cloneable {
    protected static Map<UUID, WeakReference<Entity>> respawned = new HashMap<UUID, WeakReference<Entity>>();
    public static boolean isSpawning = false;
    private static int mobStackSize = 0;
    private static final int maxMobStackSize = 255;
    protected String key;
    protected WeakReference<Entity> entity = null;
    protected UUID uuid = null;
    protected EntityType type;
    protected EntityExtraData extraData;
    protected Location location;
    protected Vector relativeLocation;
    protected boolean hasMoved = false;
    protected boolean hasChangedHealth = false;
    protected boolean isTemporary = false;
    protected boolean isSplittable = false;
    private boolean respawn = false;
    protected String name = null;
    protected Art art;
    protected BlockFace facing;
    protected Rotation rotation;
    protected ItemStack item;
    protected Double maxHealth;
    protected Double health;
    protected Integer airLevel;
    protected boolean isAngry;
    protected boolean isBaby;
    protected boolean isSilent;
    protected boolean isTamed;
    protected boolean isSitting;
    protected boolean isInvulnerable;
    protected boolean hasAI = true;
    protected boolean hasGravity = true;
    protected boolean isDocile;
    protected boolean transformable;
    protected boolean preventProjectiles;
    protected boolean preventMelee;
    protected Boolean persist = null;
    protected int fireTicks;
    protected DyeColor dyeColor;
    protected Ocelot.Type ocelotType;
    protected Rabbit.Type rabbitType = null;
    protected Collection<PotionEffect> potionEffects = null;
    protected Collection<PotionEffectType> removeEffects = null;
    protected Map<String, ConfigurationSection> modifiers = null;
    protected Collection<String> removeModifiers = null;
    protected Map<Attribute, Double> attributes = null;
    protected Vector velocity = null;
    protected boolean hasPotionEffects = false;
    protected boolean hasVelocity = false;
    protected boolean isHanging = false;
    protected boolean isLiving = false;
    protected boolean isProjectile = false;
    protected boolean canPickupItems = false;
    protected com.elmakers.mine.bukkit.api.item.ItemData itemInHand;
    protected com.elmakers.mine.bukkit.api.item.ItemData itemInOffhand;
    protected com.elmakers.mine.bukkit.api.item.ItemData helmet;
    protected com.elmakers.mine.bukkit.api.item.ItemData chestplate;
    protected com.elmakers.mine.bukkit.api.item.ItemData leggings;
    protected com.elmakers.mine.bukkit.api.item.ItemData boots;
    protected Integer xp;
    protected Integer dropXp;
    protected boolean defaultDrops;
    protected boolean dropsRequirePlayerKiller;
    protected List<Deque<WeightedPair<String>>> drops;
    protected Set<String> tags;
    protected String interactSpell;
    protected String interactPermission;
    protected List<Cost> interactCosts;
    protected ConfigurationSection interactSpellParameters;
    protected EntityData.SourceType interactSpellSource;
    protected EntityData.TargetType interactSpellTarget;
    protected EntityData.SourceType interactCommandSource;
    protected List<String> interactCommands;
    protected ConfigurationSection disguise;
    protected EntityMageData mageData;
    protected EntityData mount;
    protected String mountType;
    protected ConfigurationSection configuration;

    public EntityData(Entity entity) {
        this.setEntity(entity);
        this.location = CompatibilityUtils.getHangingLocation(entity);
        this.isTemporary = entity.hasMetadata("temporary");
        this.isLiving = entity instanceof LivingEntity;
        this.isHanging = entity instanceof Hanging;
        this.isProjectile = entity instanceof Projectile;
        this.type = entity.getType();
        this.fireTicks = entity.getFireTicks();
        this.isSilent = CompatibilityUtils.isSilent(entity);
        this.persist = CompatibilityUtils.isPersist(entity);
        this.canPickupItems = entity instanceof Creature ? ((Creature)entity).getCanPickupItems() : false;
        this.name = entity.getCustomName();
        this.tags = CompatibilityUtils.getTags(entity);
        try {
            this.velocity = entity.getVelocity();
        }
        catch (Exception ex) {
            this.velocity = null;
        }
        if (entity instanceof Hanging) {
            Hanging hanging = (Hanging)entity;
            try {
                this.facing = hanging.getFacing();
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.WARNING, "Error reading HangingEntity " + entity + " of type " + entity.getType(), ex);
            }
        }
        if (entity instanceof LivingEntity) {
            LivingEntity li = (LivingEntity)entity;
            this.health = li.getHealth();
            this.potionEffects = li.getActivePotionEffects();
            this.airLevel = li.getRemainingAir();
            this.maxHealth = CompatibilityUtils.getMaxHealth((Damageable)li);
            this.hasAI = li.hasAI();
            this.itemInHand = this.getItem(li.getEquipment().getItemInMainHand());
            this.itemInOffhand = this.getItem(li.getEquipment().getItemInOffHand());
            this.helmet = this.getItem(li.getEquipment().getHelmet());
            this.chestplate = this.getItem(li.getEquipment().getChestplate());
            this.leggings = this.getItem(li.getEquipment().getLeggings());
            this.boots = this.getItem(li.getEquipment().getBoots());
        }
        if (entity instanceof Tameable) {
            this.isTamed = ((Tameable)entity).isTamed();
        }
        this.isSitting = CompatibilityUtils.isSitting(entity);
        this.isInvulnerable = CompatibilityUtils.isInvulnerable(entity);
        if (entity instanceof Ageable) {
            Ageable ageable = (Ageable)entity;
            boolean bl = this.isBaby = !ageable.isAdult();
        }
        if (entity instanceof Colorable) {
            Colorable colorable = (Colorable)entity;
            this.dyeColor = colorable.getColor();
        }
        if (entity instanceof Painting) {
            Painting painting = (Painting)entity;
            this.art = painting.getArt();
        } else if (entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            this.item = itemFrame.getItem();
            this.rotation = ((ItemFrame)entity).getRotation();
        } else if (entity instanceof Item) {
            Item droppedItem = (Item)entity;
            this.item = droppedItem.getItemStack();
        } else if (entity instanceof Horse) {
            this.extraData = new EntityHorseData((Horse)entity);
        } else if (entity instanceof Villager) {
            this.extraData = new EntityVillagerData((Villager)entity);
        } else if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            this.dyeColor = wolf.getCollarColor();
            this.isAngry = wolf.isAngry();
        } else if (entity instanceof Ocelot) {
            Ocelot ocelot = (Ocelot)entity;
            this.ocelotType = ocelot.getCatType();
        } else if (entity instanceof Rabbit) {
            Rabbit rabbit = (Rabbit)entity;
            this.rabbitType = rabbit.getRabbitType();
        } else if (entity instanceof ArmorStand) {
            this.extraData = new EntityArmorStandData((ArmorStand)entity);
        } else if (entity instanceof ExperienceOrb) {
            this.xp = ((ExperienceOrb)entity).getExperience();
        } else if (entity instanceof Zombie) {
            this.extraData = new EntityZombieData((Zombie)entity);
        } else if (entity instanceof AreaEffectCloud) {
            this.extraData = new EntityAreaEffectCloudData((AreaEffectCloud)entity);
        } else if (entity instanceof Slime) {
            this.extraData = new EntitySlimeData((Slime)entity);
        } else if (entity instanceof FallingBlock) {
            this.extraData = new EntityFallingBlockData((FallingBlock)entity);
        } else if (entity.getType().name().equals("PARROT")) {
            this.extraData = new EntityParrotData(entity);
        } else if (entity instanceof EnderDragon) {
            this.extraData = new EntityEnderDragonData(entity);
        } else if (CompatibilityUtils.isFox(entity)) {
            this.extraData = new EntityFoxData(entity);
        }
    }

    @Nullable
    private com.elmakers.mine.bukkit.api.item.ItemData getItem(ItemStack item) {
        return item == null ? null : new ItemData(item);
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }

    public EntityData(EntityType type) {
        this.type = type;
    }

    public EntityData(@Nonnull MageController controller, @Nonnull String key, ConfigurationSection parameters) {
        this.key = key;
        this.load(controller, parameters);
    }

    public EntityData(@Nonnull MageController controller, ConfigurationSection parameters) {
        this.load(controller, parameters);
    }

    @Override
    public void load(@Nonnull MageController controller, ConfigurationSection parameters) {
        com.elmakers.mine.bukkit.block.MaterialAndData itemData;
        List<String> tagList;
        ConfigurationSection mountConfig;
        String colorString;
        String entityName;
        this.configuration = parameters;
        this.hasChangedHealth = true;
        this.name = parameters.getString("name");
        if (this.name != null) {
            this.name = ChatColor.translateAlternateColorCodes((char)'&', (String)this.name);
        }
        if (parameters.contains("health")) {
            this.maxHealth = this.health = Double.valueOf(parameters.getDouble("health", 1.0));
        }
        if (parameters.contains("max_health")) {
            this.maxHealth = parameters.getDouble("max_health", 1.0);
        }
        this.isSilent = parameters.getBoolean("silent", false);
        if (parameters.contains("persist")) {
            this.persist = parameters.getBoolean("persist");
        }
        this.isDocile = parameters.getBoolean("docile");
        this.transformable = parameters.getBoolean("transformable", true);
        this.preventProjectiles = parameters.getBoolean("prevent_projectiles", false);
        this.preventMelee = parameters.getBoolean("prevent_melee", false);
        String string = entityName = parameters.contains("type") ? parameters.getString("type") : this.key;
        if (entityName != null && !entityName.isEmpty()) {
            this.type = EntityData.parseEntityType(entityName);
            if (this.type == null) {
                controller.getLogger().log(Level.WARNING, " Invalid entity type: " + entityName + " in mob config for " + this.key + ", did you forget the 'type' parameter?");
                return;
            }
        }
        if (this.type == null) {
            this.type = EntityType.ZOMBIE;
        }
        if ((colorString = parameters.getString("color")) != null) {
            try {
                this.dyeColor = DyeColor.valueOf((String)colorString.toUpperCase());
            }
            catch (Exception ex) {
                this.dyeColor = null;
            }
        }
        if ((mountConfig = ConfigurationUtils.getConfigurationSection(parameters, "mount")) != null) {
            this.mount = new EntityData(controller, mountConfig);
        } else {
            this.mountType = parameters.getString("mount");
        }
        this.disguise = ConfigurationUtils.getConfigurationSection(parameters, "disguise");
        this.isTamed = parameters.getBoolean("tamed", false);
        this.isSitting = parameters.getBoolean("sitting", false);
        this.isInvulnerable = parameters.getBoolean("invulnerable", false);
        this.isBaby = parameters.getBoolean("baby", false);
        this.isAngry = parameters.getBoolean("angry", false);
        this.hasAI = parameters.getBoolean("ai", true);
        this.hasGravity = parameters.getBoolean("gravity", true);
        this.isSplittable = parameters.getBoolean("split", true);
        this.potionEffects = ConfigurationUtils.getPotionEffectObjects(parameters, "potion_effects", controller.getLogger());
        this.hasPotionEffects = this.potionEffects != null && !this.potionEffects.isEmpty();
        ConfigurationSection modifierSection = parameters.getConfigurationSection("modifiers");
        if (modifierSection == null) {
            List<String> modifierList = ConfigurationUtils.getStringList(parameters, "modifiers");
            if (modifierList != null) {
                this.modifiers = new HashMap<String, ConfigurationSection>();
                for (String addKey : modifierList) {
                    this.modifiers.put(addKey, null);
                }
            }
        } else {
            this.modifiers = new HashMap<String, ConfigurationSection>();
            for (String addKey : modifierSection.getKeys(false)) {
                this.modifiers.put(addKey, modifierSection.getConfigurationSection(addKey));
            }
        }
        this.defaultDrops = parameters.getBoolean("default_drops", true);
        this.dropsRequirePlayerKiller = parameters.getBoolean("drops_require_player_killer", false);
        if (parameters.contains("xp")) {
            this.xp = parameters.getInt("xp");
        }
        if (parameters.contains("drop_xp")) {
            this.dropXp = parameters.getInt("drop_xp");
        }
        this.interactSpell = parameters.getString("interact_spell");
        this.interactSpellParameters = ConfigurationUtils.getConfigurationSection(parameters, "interact_spell_parameters");
        List<com.elmakers.mine.bukkit.item.Cost> interactCosts = com.elmakers.mine.bukkit.item.Cost.parseCosts(ConfigurationUtils.getConfigurationSection(parameters, "interact_costs"), controller);
        this.interactCosts = interactCosts == null ? null : new ArrayList<com.elmakers.mine.bukkit.item.Cost>(interactCosts);
        this.interactPermission = parameters.getString("interact_permission");
        String sourceType = parameters.getString("interact_spell_source", "PLAYER");
        if (sourceType.equalsIgnoreCase("NPC")) {
            sourceType = "MOB";
        } else if (sourceType.equalsIgnoreCase("OPPED_PLAYER")) {
            controller.getLogger().warning("Invalid spell source type: " + sourceType);
            sourceType = "PLAYER";
        }
        try {
            this.interactSpellSource = EntityData.SourceType.valueOf(sourceType.toUpperCase());
        }
        catch (Exception ex) {
            controller.getLogger().warning("Invalid mob source type: " + sourceType);
            this.interactSpellSource = EntityData.SourceType.PLAYER;
        }
        String targetType = parameters.getString("interact_spell_target", "MOB");
        if (targetType.equalsIgnoreCase("NPC")) {
            targetType = "MOB";
        }
        try {
            this.interactSpellTarget = EntityData.TargetType.valueOf(targetType.toUpperCase());
        }
        catch (Exception ex) {
            controller.getLogger().warning("Invalid mob target type: " + targetType);
            this.interactSpellTarget = EntityData.TargetType.MOB;
        }
        sourceType = parameters.getString("interact_command_source", "CONSOLE");
        if (sourceType.equalsIgnoreCase("MOB") || sourceType.equalsIgnoreCase("NPC")) {
            controller.getLogger().warning("Invalid command source type: " + sourceType);
            sourceType = "CONSOLE";
        }
        try {
            this.interactCommandSource = EntityData.SourceType.valueOf(sourceType.toUpperCase());
        }
        catch (Exception ex) {
            controller.getLogger().warning("Invalid command source type: " + sourceType);
            this.interactCommandSource = EntityData.SourceType.CONSOLE;
        }
        this.interactCommands = ConfigurationUtils.getStringList(parameters, "interact_commands", ";");
        if (parameters.isList("drops")) {
            List list = parameters.getList("drops");
            this.drops = new ArrayList<Deque<WeightedPair<String>>>();
            for (Object item : list) {
                ArrayDeque<WeightedPair<String>> dropProbability;
                if (item instanceof Map || item instanceof ConfigurationSection) {
                    ConfigurationSection table = null;
                    table = item instanceof Map ? ConfigurationUtils.toConfigurationSection((Map)item) : (ConfigurationSection)item;
                    dropProbability = new ArrayDeque();
                    RandomUtils.populateStringProbabilityMap(dropProbability, table, 0, 0, 0.0f);
                    this.drops.add(dropProbability);
                    continue;
                }
                List<String> dropList = ConfigurationUtils.getStringList(item);
                if (dropList == null) continue;
                dropProbability = new ArrayDeque<WeightedPair<String>>();
                RandomUtils.populateProbabilityList(String.class, dropProbability, dropList);
                this.drops.add(dropProbability);
            }
        }
        if ((tagList = ConfigurationUtils.getStringList(parameters, "tags")) != null) {
            this.tags = new HashSet<String>(tagList);
        }
        try {
            if (this.type == EntityType.HORSE) {
                this.extraData = new EntityHorseData(parameters, controller);
            } else if (this.type == EntityType.VILLAGER) {
                this.extraData = new EntityVillagerData(parameters, controller);
            } else if (this.type == EntityType.AREA_EFFECT_CLOUD) {
                this.extraData = new EntityAreaEffectCloudData(parameters, controller);
            } else if (this.type == EntityType.OCELOT && parameters.contains("ocelot_type")) {
                this.ocelotType = Ocelot.Type.valueOf((String)parameters.getString("ocelot_type").toUpperCase());
            } else if (this.type == EntityType.RABBIT && parameters.contains("rabbit_type")) {
                this.rabbitType = Rabbit.Type.valueOf((String)parameters.getString("rabbit_type").toUpperCase());
            } else if (this.type == EntityType.ZOMBIE || this.type.name().equals("PIG_ZOMBIE")) {
                EntityZombieData zombieData = new EntityZombieData();
                zombieData.isBaby = this.isBaby;
                this.extraData = zombieData;
            } else if (this.type == EntityType.ARMOR_STAND) {
                this.extraData = new EntityArmorStandData(parameters);
            } else if (this.type == EntityType.SLIME || this.type == EntityType.MAGMA_CUBE) {
                EntitySlimeData slimeData = new EntitySlimeData();
                slimeData.size = parameters.getInt("size", 16);
                this.extraData = slimeData;
            } else if (this.type == EntityType.FALLING_BLOCK) {
                this.extraData = new EntityFallingBlockData(parameters);
            } else if (this.type.name().equals("PARROT")) {
                this.extraData = new EntityParrotData(parameters, controller);
            } else if (this.type == EntityType.ENDER_DRAGON) {
                this.extraData = new EntityEnderDragonData(parameters, controller);
            } else if (this.type.name().equals("FOX")) {
                this.extraData = new EntityFoxData(parameters, controller);
            }
        }
        catch (Exception ex) {
            controller.getLogger().log(Level.WARNING, "Invalid entity type or sub-type", ex);
        }
        ConfigurationSection attributeConfiguration = ConfigurationUtils.getConfigurationSection(parameters, "entity_attributes");
        ConfigurationSection migrateAttributes = ConfigurationUtils.getConfigurationSection(parameters, "attributes");
        if (migrateAttributes != null) {
            boolean nagged = false;
            Set keys = migrateAttributes.getKeys(false);
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String attributeKey = (String)iterator.next();
                try {
                    Attribute.valueOf((String)attributeKey.toUpperCase());
                }
                catch (IllegalArgumentException ignored) {
                    continue;
                }
                if (attributeConfiguration == null) {
                    attributeConfiguration = parameters.createSection("entity_attributes");
                }
                attributeConfiguration.set(attributeKey, migrateAttributes.get(attributeKey));
                parameters.set("attributes", null);
                if (this.key == null || nagged) continue;
                controller.getLogger().warning("You have vanilla entity attributes in the 'attributes' property of mob template '" + this.key + "', please rename that to entity_attributes.");
                nagged = true;
            }
        }
        if (attributeConfiguration != null) {
            Set keys = attributeConfiguration.getKeys(false);
            if (keys.size() > 0) {
                this.attributes = new HashMap<Attribute, Double>();
            }
            for (String attributeKey : keys) {
                try {
                    Attribute attribute = Attribute.valueOf((String)attributeKey.toUpperCase());
                    this.attributes.put(attribute, attributeConfiguration.getDouble(attributeKey));
                }
                catch (Exception ex) {
                    controller.getLogger().log(Level.WARNING, "Invalid attribute type: " + attributeKey, ex);
                }
            }
        }
        this.item = (itemData = ConfigurationUtils.getMaterialAndData(parameters, "item")) == null || !itemData.isValid() ? null : itemData.getItemStack(parameters.getInt("amount", 1));
        this.itemInHand = controller.getOrCreateMagicItem(parameters.getString("item"));
        this.itemInOffhand = controller.getOrCreateMagicItem(parameters.getString("offhand"));
        this.helmet = controller.getOrCreateMagicItem(parameters.getString("helmet"));
        this.chestplate = controller.getOrCreateMagicItem(parameters.getString("chestplate"));
        this.leggings = controller.getOrCreateMagicItem(parameters.getString("leggings"));
        this.boots = controller.getOrCreateMagicItem(parameters.getString("boots"));
        this.canPickupItems = parameters.getBoolean("can_pickup_items", false);
        EntityMageData mageData = new EntityMageData(controller, parameters);
        if (!mageData.isEmpty()) {
            this.mageData = mageData;
        }
    }

    public static EntityData loadPainting(Vector location, Art art, BlockFace direction) {
        EntityData data = new EntityData(EntityType.PAINTING);
        data.facing = direction;
        data.relativeLocation = location.clone();
        data.art = art;
        return data;
    }

    public static EntityData loadItemFrame(Vector location, ItemStack item, BlockFace direction, Rotation rotation) {
        EntityData data = new EntityData(EntityType.ITEM_FRAME);
        data.facing = direction;
        data.relativeLocation = location.clone();
        data.rotation = rotation;
        data.item = item;
        return data;
    }

    public void setEntity(Entity entity) {
        this.entity = entity == null ? null : new WeakReference<Entity>(entity);
        this.uuid = entity == null ? null : entity.getUniqueId();
    }

    @Nullable
    public static EntityType parseEntityType(String typeString) {
        if (typeString == null) {
            return null;
        }
        EntityType returnType = null;
        try {
            returnType = EntityType.valueOf((String)typeString.toUpperCase());
        }
        catch (Exception ex) {
            returnType = null;
        }
        if (returnType == null) {
            returnType = EntityType.fromName((String)typeString);
        }
        return returnType;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public EntityType getType() {
        return this.type;
    }

    @Override
    public Art getArt() {
        return this.art;
    }

    @Override
    public BlockFace getFacing() {
        return this.facing;
    }

    @Override
    public double getHealth() {
        return this.health == null ? 0.0 : this.health;
    }

    @Nullable
    protected Entity trySpawn(MageController controller, CreatureSpawnEvent.SpawnReason reason) {
        Entity spawned = null;
        boolean addedToWorld = false;
        if (this.type != null && this.type != EntityType.PLAYER) {
            try {
                switch (this.type) {
                    case PAINTING: {
                        spawned = CompatibilityUtils.createPainting(this.location, this.facing, this.art);
                        break;
                    }
                    case ITEM_FRAME: {
                        spawned = CompatibilityUtils.createItemFrame(this.location, this.facing, this.rotation, this.item);
                        break;
                    }
                    case DROPPED_ITEM: {
                        spawned = this.location.getWorld().dropItem(this.location, this.item);
                        addedToWorld = true;
                        break;
                    }
                    case FALLING_BLOCK: {
                        Material material = null;
                        byte data = 0;
                        if (this.extraData != null && this.extraData instanceof EntityFallingBlockData) {
                            EntityFallingBlockData falling = (EntityFallingBlockData)this.extraData;
                            material = falling.getMaterial();
                            data = falling.getData();
                        }
                        if (material == null) {
                            material = Material.DIRT;
                        }
                        spawned = this.location.getWorld().spawnFallingBlock(this.location, material, data);
                        addedToWorld = true;
                        break;
                    }
                    default: {
                        spawned = CompatibilityUtils.createEntity(this.location, this.type);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.WARNING, "Error restoring entity type " + this.getType() + " at " + this.getLocation(), ex);
            }
        }
        if (spawned != null) {
            this.modifyPreSpawn(controller, spawned);
            if (!addedToWorld) {
                isSpawning = true;
                reason = reason == null ? CreatureSpawnEvent.SpawnReason.CUSTOM : reason;
                CompatibilityUtils.addToWorld(this.location.getWorld(), spawned, reason);
                isSpawning = false;
            }
            this.modifyPostSpawn(controller, spawned);
        }
        return spawned;
    }

    @Override
    @Nullable
    public EntityData getRelativeTo(Location center) {
        EntityData copy = this.clone();
        if (copy != null) {
            if (this.relativeLocation != null) {
                copy.location = center.clone().add(this.relativeLocation);
            } else if (this.location != null) {
                copy.location = this.location.clone();
            }
        }
        return copy;
    }

    @Override
    @Nullable
    public Entity spawn() {
        return this.spawn(null, null);
    }

    @Override
    @Nullable
    public Entity spawn(Location location) {
        return this.spawn(null, location, null);
    }

    @Override
    @Nullable
    public Entity spawn(MageController controller) {
        return this.spawn(controller, null);
    }

    @Override
    @Nullable
    public Entity spawn(MageController controller, Location location) {
        return this.spawn(controller, location, null);
    }

    @Override
    @Nullable
    public Entity spawn(MageController controller, Location location, CreatureSpawnEvent.SpawnReason reason) {
        if (location != null) {
            this.location = location;
        } else if (this.location == null) {
            return null;
        }
        return this.trySpawn(controller, reason);
    }

    @Override
    @Nullable
    public Entity undo() {
        Entity entity = this.getEntity();
        if (!(!this.respawn || this.isTemporary || this.uuid == null || entity != null && entity.isValid() && !entity.isDead() || entity instanceof Player)) {
            WeakReference<Entity> respawnedEntity = respawned.get(this.uuid);
            if (respawnedEntity != null) {
                entity = (Entity)respawnedEntity.get();
            } else {
                entity = this.trySpawn(null, null);
                if (entity != null) {
                    respawned.put(this.uuid, new WeakReference<Entity>(entity));
                    entity.setMetadata("nodrops", (MetadataValue)new FixedMetadataValue(MagicPlugin.getAPI().getPlugin(), (Object)true));
                }
            }
            this.setEntity(entity);
        } else if (entity != null) {
            this.modify(entity);
        }
        return entity;
    }

    @Override
    public boolean modify(Entity entity) {
        return this.modify(null, entity);
    }

    @Override
    public boolean modify(MageController controller, Entity entity) {
        if (entity.isDead()) {
            return false;
        }
        boolean modifiedPre = this.modifyPreSpawn(controller, entity);
        boolean modifiedPost = this.modifyPostSpawn(controller, entity);
        return modifiedPre || modifiedPost;
    }

    private boolean modifyPreSpawn(final MageController controller, final Entity entity) {
        Set<String> entityTags;
        if (entity == null || entity.getType() != this.type) {
            return false;
        }
        if (controller != null) {
            controller.registerMob(entity, this);
        }
        boolean isPlayer = entity instanceof Player;
        if (this.extraData != null) {
            this.extraData.apply(entity);
        }
        if (this.persist != null) {
            CompatibilityUtils.setPersist(entity, this.persist);
        }
        CompatibilityUtils.setSilent(entity, this.isSilent);
        entity.setFireTicks(this.fireTicks);
        if (entity instanceof Ageable) {
            Ageable ageable = (Ageable)entity;
            if (this.isBaby) {
                ageable.setBaby();
            } else {
                ageable.setAdult();
            }
        }
        if (entity instanceof Tameable) {
            ((Tameable)entity).setTamed(this.isTamed);
        }
        CompatibilityUtils.setSitting(entity, this.isSitting);
        CompatibilityUtils.setInvulnerable(entity, this.isInvulnerable);
        if (entity instanceof Colorable && this.dyeColor != null) {
            Colorable colorable = (Colorable)entity;
            colorable.setColor(this.dyeColor);
        }
        if (this.tags != null && !this.tags.isEmpty() && (entityTags = CompatibilityUtils.getTags(entity)) != null) {
            entityTags.addAll(this.tags);
        }
        if (entity instanceof Creature) {
            Creature creature = (Creature)entity;
            creature.setCanPickupItems(this.canPickupItems);
        }
        if (entity instanceof Item) {
            Item droppedItem = (Item)entity;
            droppedItem.setItemStack(this.item);
        } else if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            if (this.dyeColor != null) {
                wolf.setCollarColor(this.dyeColor);
            }
            wolf.setAngry(this.isAngry);
        } else if (entity instanceof Ocelot && this.ocelotType != null) {
            Ocelot ocelot = (Ocelot)entity;
            ocelot.setCatType(this.ocelotType);
        } else if (entity instanceof Rabbit && this.rabbitType != null) {
            Rabbit rabbit = (Rabbit)entity;
            rabbit.setRabbitType(this.rabbitType);
        } else if (entity instanceof ExperienceOrb && this.xp != null) {
            ((ExperienceOrb)entity).setExperience(this.xp.intValue());
        }
        if (!this.hasGravity && !(entity instanceof ArmorStand)) {
            CompatibilityUtils.setGravity(entity, this.hasGravity);
        }
        if (entity instanceof LivingEntity) {
            com.elmakers.mine.bukkit.api.magic.Mage mage;
            LivingEntity li = (LivingEntity)entity;
            if (this.hasPotionEffects && this.potionEffects != null) {
                for (PotionEffect effect : this.potionEffects) {
                    li.addPotionEffect(effect);
                }
            }
            if (this.removeEffects != null) {
                for (PotionEffectType effectType : this.removeEffects) {
                    li.removePotionEffect(effectType);
                }
            }
            if ((this.modifiers != null || this.removeModifiers != null) && (mage = controller.getRegisteredMage((Entity)li)) != null) {
                if (this.modifiers != null) {
                    for (Map.Entry entry : this.modifiers.entrySet()) {
                        mage.addModifier((String)entry.getKey(), (ConfigurationSection)entry.getValue());
                    }
                }
                if (this.removeModifiers != null) {
                    for (String string : this.removeModifiers) {
                        mage.removeModifier(string);
                    }
                }
            }
            try {
                if (!isPlayer) {
                    this.applyAttributes(li);
                    this.copyEquipmentTo(li);
                    if (this.maxHealth != null) {
                        CompatibilityUtils.setMaxHealth((Damageable)li, this.maxHealth);
                    }
                }
                if (this.health != null && this.hasChangedHealth) {
                    li.setHealth(Math.min(this.health, CompatibilityUtils.getMaxHealth((Damageable)li)));
                }
                if (this.airLevel != null) {
                    li.setRemainingAir(Math.min(this.airLevel, li.getRemainingAir()));
                }
                if (!this.hasAI) {
                    li.setAI(this.hasAI);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        if (!isPlayer && this.name != null && this.name.length() > 0) {
            entity.setCustomName(this.name);
        }
        if (controller != null) {
            this.attach(controller, entity);
        }
        if (controller != null && this.disguise != null) {
            this.tryDisguise(controller, entity, this.disguise);
            int redisguise = this.disguise.getString("type", "").equalsIgnoreCase("player") ? 2 : 0;
            redisguise = this.disguise.getInt("redisguise", redisguise);
            if (redisguise > 0) {
                Bukkit.getScheduler().runTaskLater(controller.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        EntityData.this.tryDisguise(controller, entity, EntityData.this.disguise);
                    }
                }, (long)redisguise);
            }
        }
        return true;
    }

    private void tryDisguise(MageController controller, Entity entity, ConfigurationSection disguise) {
        if (!controller.disguise(entity, disguise)) {
            controller.getLogger().warning("Invalid disguise type: " + disguise.getString("type"));
        }
    }

    @Override
    public void attach(@Nonnull MageController controller, @Nonnull Entity entity) {
        if (this.mageData != null) {
            com.elmakers.mine.bukkit.api.magic.Mage apiMage = controller.getMage(entity);
            if (apiMage instanceof Mage) {
                ((Mage)apiMage).setEntityData(this);
            }
            this.mageData.resetTriggers();
            this.mageData.trigger(apiMage, "spawn");
        }
    }

    @Nullable
    public ConfigurationSection getMageProperties() {
        return this.mageData != null ? this.mageData.mageProperties : null;
    }

    private boolean modifyPostSpawn(MageController controller, Entity entity) {
        if (entity == null || entity.getType() != this.type) {
            return false;
        }
        if (this.hasMoved && this.location != null && !this.location.equals((Object)entity.getLocation())) {
            entity.teleport(this.location);
        }
        if (this.hasVelocity && this.velocity != null) {
            SafetyUtils.setVelocity(entity, this.velocity);
        }
        if (this.mount != null || this.mountType != null) {
            boolean allowMount = true;
            if (++mobStackSize > 255) {
                if (controller != null) {
                    controller.getLogger().warning("Mob " + this.key + " has more than " + 255 + " mounts");
                }
                allowMount = false;
            }
            if (this.mount == null) {
                this.mount = (EntityData)controller.getMob(this.mountType);
                if (this.mount == null) {
                    if (controller != null) {
                        controller.getLogger().warning("Mob " + this.key + " has invalid mount: " + this.mountType);
                    }
                    allowMount = false;
                }
            }
            if (allowMount) {
                Entity mountEntity = this.mount.spawn(controller, entity.getLocation());
                DeprecatedUtils.setPassenger(mountEntity, entity);
            }
            --mobStackSize;
        }
        if (entity instanceof Painting) {
            Painting painting = (Painting)entity;
            if (this.art != null) {
                painting.setArt(this.art, true);
            }
            if (this.facing != null) {
                painting.setFacingDirection(this.facing, true);
            }
        } else if (entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            itemFrame.setItem(this.item);
            if (this.facing != null) {
                itemFrame.setFacingDirection(this.facing, true);
            }
        }
        return true;
    }

    public void applyAttributes(LivingEntity entity) {
        if (this.attributes != null) {
            for (Map.Entry<Attribute, Double> entry : this.attributes.entrySet()) {
                AttributeInstance attribute = entity.getAttribute(entry.getKey());
                if (attribute == null) continue;
                attribute.setBaseValue(entry.getValue().doubleValue());
            }
        }
    }

    public void copyEquipmentTo(LivingEntity entity) {
        if (this.itemInHand != null) {
            entity.getEquipment().setItemInMainHand(this.itemInHand.getItemStack(1));
        }
        if (this.itemInOffhand != null) {
            entity.getEquipment().setItemInOffHand(this.itemInOffhand.getItemStack(1));
        }
        if (this.helmet != null) {
            entity.getEquipment().setHelmet(this.helmet.getItemStack(1));
        }
        if (this.chestplate != null) {
            entity.getEquipment().setChestplate(this.chestplate.getItemStack(1));
        }
        if (this.leggings != null) {
            entity.getEquipment().setLeggings(this.leggings.getItemStack(1));
        }
        if (this.boots != null) {
            entity.getEquipment().setBoots(this.boots.getItemStack(1));
        }
    }

    @Override
    public void setHasMoved(boolean moved) {
        this.hasMoved = moved;
    }

    @Override
    public void setDamaged(boolean damaged) {
        this.hasChangedHealth = damaged;
    }

    public void setHasPotionEffects(boolean changed) {
        this.hasPotionEffects = changed;
    }

    public void addPotionEffectForRemoval(PotionEffectType potionEffectType) {
        if (this.removeEffects == null) {
            this.removeEffects = new ArrayList<PotionEffectType>();
        }
        this.removeEffects.add(potionEffectType);
    }

    public void addModifier(MageModifier modifier) {
        if (this.modifiers == null) {
            this.modifiers = new HashMap<String, ConfigurationSection>();
        }
        this.modifiers.put(modifier.getKey(), modifier.getConfiguration());
    }

    public void addModifierForRemoval(String modifierKey) {
        if (this.removeModifiers == null) {
            this.removeModifiers = new ArrayList<String>();
        }
        this.removeModifiers.add(modifierKey);
    }

    public void setHasVelocity(boolean hasVelocity) {
        this.hasVelocity = hasVelocity;
    }

    public boolean isHanging() {
        return this.isHanging;
    }

    public boolean isLiving() {
        return this.isLiving;
    }

    public boolean isProjectile() {
        return this.isProjectile;
    }

    @Nullable
    public Entity getEntity() {
        return this.entity == null ? null : (Entity)this.entity.get();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public EntityData clone() {
        try {
            return (EntityData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isRespawn() {
        return this.respawn;
    }

    public void setRespawn(boolean respawn) {
        this.respawn = respawn;
    }

    public void modifyDrops(MageController controller, EntityDeathEvent event) {
        if (this.dropXp != null) {
            event.setDroppedExp(this.dropXp.intValue());
        }
        List dropList = event.getDrops();
        if (!this.defaultDrops) {
            dropList.clear();
        }
        if (this.dropsRequirePlayerKiller) {
            EntityDamageEvent lastDamage = event.getEntity().getLastDamageCause();
            if (!(lastDamage instanceof EntityDamageByEntityEvent)) {
                return;
            }
            Entity entity2 = ((EntityDamageByEntityEvent)lastDamage).getDamager();
            entity2 = CompatibilityUtils.getSource(entity2);
            if (!(entity2 instanceof Player) || entity2 == event.getEntity()) {
                return;
            }
        }
        if (this.drops != null) {
            for (Deque deque : this.drops) {
                ItemStack item;
                String key = (String)RandomUtils.weightedRandom(deque);
                if (key == null || (item = controller.createItem(key)) == null) continue;
                dropList.add(item);
            }
        }
    }

    @Override
    public String describe() {
        if (this.name != null && !this.name.isEmpty()) {
            return this.name;
        }
        if (this.type == null) {
            return "Unknown";
        }
        String name = this.type.name();
        if (this.ocelotType != null) {
            name = name + ":" + this.ocelotType;
        } else if (this.rabbitType != null) {
            name = name + ":" + this.rabbitType;
        }
        return name;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public long getTickInterval() {
        return this.mageData == null ? 0L : this.mageData.tickInterval;
    }

    public void tick(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        if (this.mageData != null) {
            this.mageData.tick(mage);
        }
    }

    public boolean trigger(com.elmakers.mine.bukkit.api.magic.Mage mage, String trigger) {
        if (this.mageData == null) {
            return false;
        }
        boolean result = this.mageData.trigger(mage, trigger);
        this.mageData.resetTriggers();
        return result;
    }

    @Override
    @Nullable
    public String getInteractSpell() {
        return this.interactSpell;
    }

    @Override
    @Nullable
    public ConfigurationSection getInteractSpellParameters() {
        return this.interactSpellParameters;
    }

    @Override
    public EntityData.SourceType getInteractSpellSource() {
        return this.interactSpellSource;
    }

    @Override
    public EntityData.TargetType getInteractSpellTarget() {
        return this.interactSpellTarget;
    }

    @Override
    @Nullable
    public List<String> getInteractCommands() {
        return this.interactCommands;
    }

    @Override
    public EntityData.SourceType getInteractCommandSource() {
        return this.interactCommandSource;
    }

    @Override
    @Nullable
    public Collection<Cost> getInteractCosts() {
        return this.interactCosts;
    }

    public boolean shouldFocusOnDamager() {
        return this.mageData == null ? false : this.mageData.aggro;
    }

    public double getTrackRadiusSquared() {
        return this.mageData == null ? 0.0 : this.mageData.getTrackRadiusSquared();
    }

    @Override
    public void setMaterial(@Nonnull MaterialAndData material) {
        if (this.extraData != null && this.extraData instanceof EntityFallingBlockData) {
            ((EntityFallingBlockData)this.extraData).setMaterialAndData(material);
        }
    }

    @Override
    @Nullable
    public MaterialAndData getMaterial() {
        if (this.extraData != null && this.extraData instanceof EntityFallingBlockData) {
            return ((EntityFallingBlockData)this.extraData).getMaterialAndData();
        }
        if (this.item != null) {
            return new com.elmakers.mine.bukkit.block.MaterialAndData(this.item);
        }
        return null;
    }

    public boolean isCancelLaunch() {
        return this.mageData != null ? this.mageData.isCancelLaunch : true;
    }

    public boolean hasAI() {
        return this.hasAI;
    }

    public void setAI(boolean hasAI) {
        this.hasAI = hasAI;
    }

    public boolean isInvulnerable() {
        return this.isInvulnerable;
    }

    public void setInvulnerable(boolean invulnerable) {
        this.isInvulnerable = invulnerable;
    }

    public boolean hasGravity() {
        return this.hasGravity;
    }

    public void setGravity(boolean hasGravity) {
        this.hasGravity = hasGravity;
    }

    public boolean isPersist() {
        return this.persist != null && this.persist != false;
    }

    public void setPersist(boolean persist) {
        this.persist = persist;
    }

    @Override
    public boolean isDocile() {
        return this.isDocile;
    }

    @Override
    public boolean isTransformable() {
        return this.transformable;
    }

    @Override
    @Nullable
    public ConfigurationSection getConfiguration() {
        return this.configuration;
    }

    @Override
    @Nullable
    public String getInteractPermission() {
        return this.interactPermission;
    }

    public boolean isSplittable() {
        return this.isSplittable;
    }

    @Override
    public boolean isPreventProjectiles() {
        return this.preventProjectiles;
    }

    @Override
    public boolean isPreventMelee() {
        return this.preventMelee;
    }
}

