/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.action.GUIAction;
import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageClass;
import com.elmakers.mine.bukkit.api.magic.MageClassTemplate;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAttribute;
import com.elmakers.mine.bukkit.api.magic.MagicConfigurable;
import com.elmakers.mine.bukkit.api.magic.MagicPropertyType;
import com.elmakers.mine.bukkit.api.magic.ProgressionPath;
import com.elmakers.mine.bukkit.api.requirements.Requirement;
import com.elmakers.mine.bukkit.api.spell.CostReducer;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.item.Cost;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationStore;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationTransform;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SelectorAction
extends CompoundAction
implements GUIAction,
CostReducer {
    private static final int MAX_INVENTORY_SLOTS = 54;
    protected double costScale = 1.0;
    protected double earnScale = 1.0;
    protected boolean autoClose = true;
    protected SelectorConfiguration defaultConfiguration;
    protected ItemData confirmFillMaterial;
    protected CastContext context;
    private Map<Integer, SelectorOption> showingItems;
    private int itemCount;
    private int numSlots;
    private int has = 0;
    private String title;
    private String confirmTitle;
    private String confirmUnlockTitle;
    private boolean isActive = false;
    private SpellResult finalResult = null;
    private Inventory displayInventory = null;

    @Override
    public void deactivated() {
        if (this.context != null) {
            this.context.getMage().removeItemsWithTag("slot");
        }
        this.isActive = false;
    }

    @Override
    public void dragged(InventoryDragEvent event) {
        event.setCancelled(true);
    }

    protected String getMessage(String key) {
        return this.context.getMessage(key, this.getDefaultMessage(this.context, key));
    }

    protected String getDefaultMessage(CastContext context, String key) {
        return context.getController().getMessages().get("shops." + key);
    }

    @Override
    public void clicked(InventoryClickEvent event) {
        event.setCancelled(true);
        ItemStack item = event.getCurrentItem();
        Mage mage = this.context.getMage();
        if (item == null || !InventoryUtils.hasMeta(item, "slot")) {
            if (!this.autoClose) {
                mage.deactivateGUI();
            }
            return;
        }
        int slotIndex = Integer.parseInt(InventoryUtils.getMetaString(item, "slot"));
        MageController controller = this.context.getController();
        SelectorOption option = this.showingItems.get(slotIndex);
        if (option == null || option.isPlaceholder()) {
            return;
        }
        String unpurchasableMessage = InventoryUtils.getMetaString(item, "unpurchasable");
        if (unpurchasableMessage != null && !unpurchasableMessage.isEmpty()) {
            this.context.showMessage(unpurchasableMessage);
            if (this.autoClose) {
                mage.deactivateGUI();
            }
            return;
        }
        Cost required = option.getRequiredCost(this, this.context);
        if (required != null) {
            String baseMessage = this.getMessage("insufficient");
            String costDescription = required.getFullDescription(controller.getMessages(), this);
            costDescription = baseMessage.replace("$cost", costDescription);
            this.context.showMessage(costDescription);
        } else {
            String itemName = option.getName();
            if (InventoryUtils.hasMeta(item, "confirm")) {
                String inventoryTitle = this.getConfirmTitle(option).replace("$item", itemName);
                Inventory confirmInventory = CompatibilityUtils.createInventory(null, 9, inventoryTitle);
                InventoryUtils.removeMeta(item, "confirm");
                for (int i = 0; i < 9; ++i) {
                    if (i != 4) {
                        ItemMeta meta;
                        ItemStack filler;
                        ItemStack itemStack = filler = this.confirmFillMaterial == null ? null : this.confirmFillMaterial.getItemStack(1);
                        if (filler == null) {
                            filler = new ItemStack(Material.AIR);
                        }
                        if ((meta = filler.getItemMeta()) != null) {
                            meta.setDisplayName(ChatColor.DARK_GRAY + (i < 4 ? "-->" : "<--"));
                            filler.setItemMeta(meta);
                        }
                        confirmInventory.setItem(i, filler);
                        continue;
                    }
                    confirmInventory.setItem(i, item);
                }
                mage.deactivateGUI();
                this.isActive = true;
                mage.activateGUI(this, confirmInventory);
                return;
            }
            this.finalResult = option.give(this, this.context);
            if (this.finalResult.isSuccess() && this.finalResult != SpellResult.NO_TARGET) {
                this.context.showMessage(option.getSelectedMessage(this));
            }
        }
        if (this.autoClose || this.finalResult != SpellResult.CAST) {
            if (this.isActive) {
                mage.deactivateGUI();
            }
        } else {
            mage.continueGUI(this, this.getInventory(this.context));
        }
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        this.context = context;
        this.defaultConfiguration = new SelectorConfiguration(parameters);
        String fillerKey = parameters.getString("confirm_filler");
        if (fillerKey != null && !fillerKey.isEmpty()) {
            this.confirmFillMaterial = context.getController().getItem(fillerKey);
        }
        this.autoClose = parameters.getBoolean("auto_close", true);
        this.costScale = parameters.getDouble("scale", 1.0);
        this.earnScale = parameters.getDouble("earn_scale", this.costScale);
        this.title = parameters.getString("title");
        this.confirmTitle = parameters.getString("confirm_title");
        this.confirmUnlockTitle = parameters.getString("unlock_confirm_title");
        this.finalResult = null;
        this.isActive = false;
        this.numSlots = 0;
        this.showingItems = new HashMap<Integer, SelectorOption>();
        this.has = 0;
        Collection<ConfigurationSection> optionConfigs = ConfigurationUtils.getNodeList(parameters, "options");
        if (optionConfigs != null) {
            this.loadOptions(optionConfigs);
        }
        super.prepare(context, parameters);
    }

    protected void loadOptions(Collection<ConfigurationSection> optionConfigs) {
        ArrayList<SelectorOption> options = new ArrayList<SelectorOption>();
        for (ConfigurationSection configurationSection : optionConfigs) {
            SelectorOption newOption = new SelectorOption(this.defaultConfiguration, configurationSection, this.context, this);
            if (newOption.hasLimit() && newOption.has(this.context)) {
                ++this.has;
            }
            options.add(newOption);
        }
        for (SelectorOption selectorOption : options) {
            Integer targetSlot;
            int slot;
            if (selectorOption.isUnavailable() && !selectorOption.showIfUnavailable() || (slot = (targetSlot = selectorOption.getSlot()) == null ? this.numSlots : targetSlot) >= 54) continue;
            if (!selectorOption.isPlaceholder()) {
                ++this.itemCount;
            }
            this.showingItems.put(slot, selectorOption);
            this.numSlots = Math.max(slot + 1, this.numSlots);
        }
    }

    public SpellResult showItems(CastContext context) {
        Mage mage = context.getMage();
        Player player = mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        this.isActive = true;
        this.finalResult = SpellResult.NO_ACTION;
        Inventory displayInventory = this.getInventory(context);
        mage.activateGUI(this, displayInventory);
        return SpellResult.CAST;
    }

    protected String getInventoryTitle() {
        if (this.title != null && !this.title.isEmpty()) {
            return this.title;
        }
        return this.getMessage("title");
    }

    protected String getConfirmTitle(SelectorOption option) {
        if (option.isUnlock()) {
            if (this.confirmUnlockTitle != null && !this.confirmUnlockTitle.isEmpty()) {
                return this.confirmUnlockTitle;
            }
            return this.getMessage("unlock_confirm_title");
        }
        if (this.confirmTitle != null && !this.confirmTitle.isEmpty()) {
            return this.confirmTitle;
        }
        return this.getMessage("confirm_title");
    }

    protected String getBalanceDescription(CastContext context) {
        Mage mage = context.getMage();
        if (this.defaultConfiguration.free) {
            return "";
        }
        String costType = this.defaultConfiguration.getCostType();
        Cost cost = new Cost(context.getController(), costType, 1.0);
        cost.checkSupported(context.getController(), this.defaultConfiguration.getCostTypeFallback());
        cost.setAmount(cost.getBalance(mage, context.getWand()));
        return cost.getFullDescription(context.getController().getMessages());
    }

    protected Inventory getInventory(CastContext context) {
        String pathName;
        String inventoryTitle = this.getInventoryTitle();
        String balanceDescription = this.getBalanceDescription(context);
        inventoryTitle = inventoryTitle.replace("$balance", balanceDescription);
        ProgressionPath path = context.getMage().getActiveProperties().getPath();
        String string = pathName = path == null ? null : path.getName();
        if (pathName == null) {
            pathName = "";
        }
        inventoryTitle = inventoryTitle.replace("$path", pathName);
        int invSize = (int)Math.ceil((float)this.numSlots / 9.0f) * 9;
        this.displayInventory = CompatibilityUtils.createInventory(null, invSize, inventoryTitle);
        for (Map.Entry<Integer, SelectorOption> entry : this.showingItems.entrySet()) {
            ItemStack icon = entry.getValue().getIcon();
            InventoryUtils.setMeta(icon, "slot", Integer.toString(entry.getKey()));
            this.displayInventory.setItem(entry.getKey().intValue(), icon);
        }
        return this.displayInventory;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("confirm");
        parameters.add("path");
        parameters.add("path_end");
        parameters.add("path_exact");
        parameters.add("auto_upgrade");
        parameters.add("require_wand");
        parameters.add("permission");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        MageController controller = spell.getController();
        if (parameterKey.equals("path") || parameterKey.equals("path_exact") || parameterKey.equals("path_end")) {
            examples.addAll(controller.getWandPathKeys());
        } else if (parameterKey.equals("require_wand") || parameterKey.equals("confirm") || parameterKey.equals("auto_upgrade")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public void finish(CastContext context) {
        this.isActive = false;
        this.finalResult = null;
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.isActive = false;
        this.finalResult = null;
    }

    public RequirementsResult checkDefaultRequirements(CastContext context) {
        return this.defaultConfiguration.checkRequirements(context);
    }

    @Override
    public SpellResult start(CastContext context) {
        RequirementsResult check = this.checkDefaultRequirements(context);
        if (!check.result.isSuccess()) {
            context.sendMessageKey(check.result.name(), check.message);
            return check.result;
        }
        if (this.itemCount == 0) {
            context.showMessage("no_items", this.getDefaultMessage(context, "no_items"));
            return SpellResult.NO_ACTION;
        }
        return this.showItems(context);
    }

    @Override
    public SpellResult step(CastContext context) {
        if (this.isActive) {
            return SpellResult.PENDING;
        }
        return this.finalResult == null ? SpellResult.NO_ACTION : this.finalResult;
    }

    @Nullable
    protected ItemStack parseItem(String itemKey) {
        if (itemKey == null || itemKey.isEmpty() || itemKey.equalsIgnoreCase("none")) {
            return null;
        }
        ItemStack item = this.context.getController().createItem(itemKey);
        if (item == null) {
            this.context.getLogger().warning("Failed to create item in selector: " + itemKey);
        }
        return item;
    }

    @Override
    public float getCostReduction() {
        return 0.0f;
    }

    @Override
    public float getConsumeReduction() {
        return 0.0f;
    }

    @Override
    public float getCostScale() {
        return (float)this.costScale;
    }

    protected int getNumSlots() {
        return this.numSlots;
    }

    @Override
    protected void addHandlers(Spell spell, ConfigurationSection parameters) {
    }

    protected class SelectorOption
    extends SelectorConfiguration {
        protected Integer slot;
        protected String name;
        protected String description;
        protected List<String> lore;
        protected String unavailableMessage;
        protected boolean placeholder;
        protected boolean unavailable;
        protected SelectorConfiguration defaults;
        protected Double startingAttributeValue;

        public SelectorOption(SelectorConfiguration defaults, ConfigurationSection configuration, CastContext context, CostReducer reducer) {
            String template;
            MagicAttribute attribute;
            this.slot = null;
            this.name = null;
            this.description = null;
            this.lore = null;
            this.defaults = defaults;
            this.selectedMessage = defaults.selectedMessage;
            this.selectedFreeMessage = defaults.selectedFreeMessage;
            this.items = defaults.items;
            this.costs = defaults.costs;
            this.castSpell = defaults.castSpell;
            this.applyToWand = defaults.applyToWand;
            this.applyToCaster = defaults.applyToCaster;
            this.applyTo = defaults.applyTo;
            this.applyToClass = defaults.applyToClass;
            this.attributeKey = defaults.attributeKey;
            this.attributeAmount = defaults.attributeAmount;
            this.allowAttributeReduction = defaults.allowAttributeReduction;
            this.unlockClass = defaults.unlockClass;
            this.lockClass = defaults.lockClass;
            this.switchClass = defaults.switchClass;
            this.putInHand = defaults.putInHand;
            this.limit = defaults.limit;
            this.unlockKey = defaults.unlockKey;
            this.unlockSection = defaults.unlockSection;
            this.showConfirmation = defaults.showConfirmation;
            this.costType = defaults.costType;
            this.costTypeFallback = defaults.costTypeFallback;
            this.earnType = defaults.earnType;
            this.showUnavailable = defaults.showUnavailable;
            this.commands = defaults.commands;
            this.actions = defaults.actions;
            this.free = defaults.free;
            this.costOverride = defaults.costOverride;
            this.effects = defaults.effects;
            this.applyLoreToItem = defaults.applyLoreToItem;
            this.applyNameToItem = defaults.applyNameToItem;
            this.allowDroppedItems = defaults.allowDroppedItems;
            this.iconKey = defaults.iconKey;
            this.iconPlaceholderKey = defaults.iconPlaceholderKey;
            this.iconDisabledKey = defaults.iconDisabledKey;
            this.lore = configuration.contains("lore") ? configuration.getStringList("lore") : new ArrayList();
            boolean bl = this.placeholder = configuration.getBoolean("placeholder") || configuration.getString("item", "").equals("none");
            if (this.placeholder) {
                this.icon = SelectorAction.this.parseItem(this.iconPlaceholderKey);
                if (this.icon == null) {
                    this.icon = new ItemStack(Material.AIR);
                } else {
                    this.icon = InventoryUtils.makeReal(this.icon);
                    InventoryUtils.makeUnbreakable(this.icon);
                    InventoryUtils.hideFlags(this.icon, 63);
                    ItemMeta meta = this.icon.getItemMeta();
                    meta.setDisplayName(" ");
                    this.icon.setItemMeta(meta);
                }
                return;
            }
            this.parse(configuration);
            if (defaults.requirements != null) {
                if (this.requirements == null) {
                    this.requirements = defaults.requirements;
                } else {
                    this.requirements.addAll(defaults.requirements);
                }
            }
            if (configuration.contains("slot")) {
                this.slot = configuration.getInt("slot");
            }
            this.name = configuration.getString("name", "");
            MageController controller = context.getController();
            if (this.name.isEmpty() && this.unlockClass != null && !this.unlockClass.isEmpty()) {
                MageClassTemplate mageClass = controller.getMageClassTemplate(this.unlockClass);
                this.name = SelectorAction.this.getMessage("unlock_class");
                if (mageClass != null) {
                    this.name = this.name.replace("$class", mageClass.getName());
                } else {
                    controller.getLogger().warning("Unknown class in selector config: " + this.unlockClass);
                }
            }
            String castSpell = this.getCastSpell(context.getWand());
            if (this.name.isEmpty() && castSpell != null && !castSpell.isEmpty()) {
                SpellTemplate spell = controller.getSpellTemplate(castSpell);
                this.name = SelectorAction.this.getMessage("cast_spell");
                if (spell != null) {
                    this.name = this.name.replace("$spell", spell.getName());
                } else {
                    controller.getLogger().warning("Unknown spell in selector config: " + castSpell);
                }
            }
            MagicAttribute magicAttribute = attribute = this.attributeKey == null ? null : controller.getAttribute(this.attributeKey);
            if (this.name.isEmpty() && attribute != null) {
                this.name = attribute.getName(controller.getMessages());
                if (this.attributeAmount != 0) {
                    String template2 = this.attributeAmount < 0 ? SelectorAction.this.getMessage("decrease_attribute") : SelectorAction.this.getMessage("increase_attribute");
                    this.name = template2.replace("$attribute", this.name).replace("$amount", Integer.toString(Math.abs(this.attributeAmount)));
                }
            }
            if (this.attributeKey != null) {
                this.startingAttributeValue = context.getMage().getAttribute(this.attributeKey);
            }
            if (this.name.isEmpty() && this.items != null) {
                ItemStack item = (ItemStack)this.items.get(0);
                this.name = controller.describeItem(item);
                if (item.getAmount() > 1) {
                    template = SelectorAction.this.getMessage("item_amount");
                    this.name = template.replace("$name", this.name).replace("$amount", Integer.toString(item.getAmount()));
                }
            }
            if (this.name.isEmpty() && this.iconKey != null) {
                ItemStack icon = SelectorAction.this.parseItem(this.iconKey);
                this.name = controller.describeItem(icon);
                if (icon.getAmount() > 1) {
                    template = SelectorAction.this.getMessage("item_amount");
                    this.name = template.replace("$name", this.name).replace("$amount", Integer.toString(icon.getAmount()));
                }
            }
            this.name = ChatColor.translateAlternateColorCodes((char)'&', (String)this.name);
            this.description = configuration.getString("description");
            if (this.description == null) {
                if (this.unlockClass != null && !this.unlockClass.isEmpty()) {
                    MageClassTemplate mageClass = controller.getMageClassTemplate(this.unlockClass);
                    if (mageClass != null) {
                        this.description = mageClass.getDescription();
                    } else {
                        controller.getLogger().warning("Unknown class in selector config: " + this.unlockClass);
                    }
                } else if (castSpell != null && !castSpell.isEmpty()) {
                    SpellTemplate spell = controller.getSpellTemplate(castSpell);
                    if (spell == null) {
                        controller.getLogger().warning("Unknown spell in selector config: " + castSpell);
                    } else {
                        this.description = spell.getDescription();
                    }
                } else if (attribute != null && this.attributeAmount == 0) {
                    this.description = attribute.getDescription(controller.getMessages());
                }
            }
            this.updateIcon(context, reducer);
        }

        public void updateIcon(CastContext context, CostReducer reducer) {
            Double value;
            ItemMeta meta;
            ItemData iconDisabled;
            MageClassTemplate mageClass;
            MagicAttribute attribute;
            SpellTemplate spellTemplate;
            String costHeading;
            Mage mage;
            ConfigurationSection unlocks;
            MageController controller = context.getController();
            this.unavailable = false;
            this.icon = SelectorAction.this.parseItem(this.iconKey);
            if (this.icon != null && this.icon.hasItemMeta()) {
                ItemMeta meta2 = this.icon.getItemMeta();
                meta2.setLore(null);
                this.icon.setItemMeta(meta2);
            }
            ArrayList<String> lore = new ArrayList<String>();
            if (this.lore != null) {
                lore.addAll(this.lore);
            }
            if (this.description != null && !this.description.isEmpty()) {
                InventoryUtils.wrapText(this.description, lore);
            }
            boolean unlocked = false;
            if (this.unlockKey != null && !this.unlockKey.isEmpty() && (unlocks = (mage = context.getMage()).getData().getConfigurationSection(this.unlockSection)) != null && unlocks.getBoolean(this.unlockKey, false)) {
                unlocked = true;
                this.costs = null;
                this.showConfirmation = false;
                String unlockedMessage = SelectorAction.this.getMessage("unlocked_lore");
                InventoryUtils.wrapText(unlockedMessage, lore);
            }
            if (!unlocked) {
                RequirementsResult check = this.checkRequirements(context);
                if (!check.result.isSuccess() && !this.hasAltTags(context.getWand())) {
                    this.unavailable = true;
                    this.unavailableMessage = check.message;
                    if (this.unavailableMessage != null && !this.unavailableMessage.isEmpty()) {
                        InventoryUtils.wrapText(check.message, lore);
                    }
                }
            }
            if (this.costs != null && !this.unavailable) {
                costHeading = SelectorAction.this.getMessage("cost_heading");
                if (!costHeading.isEmpty()) {
                    InventoryUtils.wrapText(costHeading, lore);
                }
                String costKey = this.unlockKey != null && !this.unlockKey.isEmpty() ? "unlock_cost_lore" : "cost_lore";
                String requiredKey = this.unlockKey != null && !this.unlockKey.isEmpty() ? "required_unlock_cost_lore" : "required_cost_lore";
                String costString = SelectorAction.this.getMessage(costKey);
                String requiredCostString = SelectorAction.this.getMessage(requiredKey);
                for (Cost cost : this.costs) {
                    if (this.costModifiers != null) {
                        for (CostModifier modifier : this.costModifiers) {
                            modifier.modify(cost);
                        }
                    }
                    String costDescription = cost.has(context.getMage(), context.getWand(), reducer) ? costString : requiredCostString;
                    costDescription = costDescription.replace("$cost", cost.getFullDescription(context.getController().getMessages(), reducer));
                    InventoryUtils.wrapText(costDescription, lore);
                }
            } else if (this.unlockKey != null && !this.unlockKey.isEmpty() && !unlocked) {
                this.unavailable = true;
                String lockedMessage = SelectorAction.this.getMessage("locked");
                if (!lockedMessage.isEmpty()) {
                    InventoryUtils.wrapText(lockedMessage, lore);
                    if (this.unavailableMessage == null) {
                        this.unavailableMessage = lockedMessage;
                    }
                }
            }
            if (this.earns != null) {
                costHeading = SelectorAction.this.getMessage("earn_heading");
                if (!costHeading.isEmpty()) {
                    InventoryUtils.wrapText(costHeading, lore);
                }
                String earnString = SelectorAction.this.getMessage("earn_lore");
                for (Cost earn : this.earns) {
                    earnString = earnString.replace("$earn", earn.getFullDescription(context.getController().getMessages(), reducer));
                    InventoryUtils.wrapText(earnString, lore);
                }
            }
            if (this.icon == null && this.items != null) {
                this.icon = InventoryUtils.getCopy((ItemStack)this.items.get(0));
                if (this.applyLoreToItem && this.lore != null && !this.lore.isEmpty()) {
                    ItemMeta meta3 = this.icon.getItemMeta();
                    meta3.setLore(null);
                    this.icon.setItemMeta(meta3);
                }
            }
            if (this.icon == null && this.castSpell != null && !this.castSpell.isEmpty() && (spellTemplate = context.getController().getSpellTemplate(this.castSpell)) != null) {
                if (this.unavailable && spellTemplate.getDisabledIcon() != null) {
                    this.icon = spellTemplate.getDisabledIcon().getItemStack(1);
                }
                if (this.icon == null && spellTemplate.getIcon() != null) {
                    this.icon = spellTemplate.getIcon().getItemStack(1);
                }
                if (this.icon == null && this.unavailable && spellTemplate.getDisabledIconURL() != null) {
                    this.icon = controller.getURLSkull(spellTemplate.getDisabledIconURL());
                }
                if (this.icon == null && spellTemplate.getIconURL() != null) {
                    this.icon = controller.getURLSkull(spellTemplate.getIconURL());
                }
            }
            MagicAttribute magicAttribute = attribute = this.attributeKey == null ? null : controller.getAttribute(this.attributeKey);
            if (this.icon == null && attribute != null) {
                ItemData iconData;
                String iconKey;
                if (this.iconDisabledKey == null) {
                    this.iconDisabledKey = attribute.getIconDisabledKey();
                }
                if ((iconKey = attribute.getIconKey()) != null && !iconKey.isEmpty() && (iconData = controller.getOrCreateItem(iconKey)) != null) {
                    this.icon = iconData.getItemStack();
                }
            }
            if (this.icon != null && attribute != null) {
                int amount = 1;
                CasterProperties caster = this.getCaster(context);
                Double currentAmount = caster.getAttribute(this.attributeKey);
                if (currentAmount != null) {
                    if (this.attributeAmount == 0) {
                        amount = (int)Math.floor(currentAmount);
                    } else {
                        boolean allowed;
                        double newValue = (double)this.attributeAmount + currentAmount;
                        boolean bl = allowed = attribute == null || attribute.inRange(newValue);
                        if (!this.allowAttributeReduction && this.startingAttributeValue != null && newValue < this.startingAttributeValue) {
                            allowed = false;
                        }
                        if (!allowed) {
                            this.unavailable = true;
                            String template = this.attributeAmount < 0 ? SelectorAction.this.getMessage("attribute_min") : SelectorAction.this.getMessage("attribute_max");
                            this.unavailableMessage = template.replace("$attribute", attribute.getName(context.getController().getMessages()));
                        }
                    }
                }
                this.icon.setAmount(Math.max(1, amount));
            }
            if (this.icon == null && this.unlockClass != null && !this.unlockClass.isEmpty() && (mageClass = controller.getMageClassTemplate(this.unlockClass)) != null) {
                ItemData iconData;
                String iconKey;
                if (this.iconDisabledKey == null) {
                    this.iconDisabledKey = mageClass.getIconDisabledKey();
                }
                if ((iconKey = mageClass.getIconKey()) != null && !iconKey.isEmpty() && (iconData = controller.getOrCreateItem(iconKey)) != null) {
                    this.icon = iconData.getItemStack();
                }
            }
            if (this.unavailable && this.iconDisabledKey != null && (iconDisabled = controller.getItem(this.iconDisabledKey)) != null) {
                this.icon = iconDisabled.getItemStack();
            }
            if (this.icon == null && this.defaults.icon != null) {
                this.icon = InventoryUtils.getCopy(this.defaults.icon);
            }
            ItemMeta itemMeta = meta = this.icon == null ? null : this.icon.getItemMeta();
            if (this.icon == null || meta == null) {
                this.icon = controller.getURLSkull("http://textures.minecraft.net/texture/1adaf6e6e387bc18567671bb82e948488bbacff97763ee5985442814989f5d");
                meta = this.icon.getItemMeta();
                if (meta == null) {
                    this.icon = new ItemStack(Wand.DefaultUpgradeMaterial);
                    meta = this.icon.getItemMeta();
                }
            }
            String name = this.name;
            if (this.attributeKey != null && this.attributeAmount == 0 && (value = context.getMage().getAttribute(this.attributeKey)) != null) {
                String template = SelectorAction.this.getMessage("attribute");
                name = template.replace("$attribute", name).replace("$amount", Integer.toString((int)value.doubleValue()));
            }
            meta.setDisplayName(name);
            if (!lore.isEmpty()) {
                ArrayList<String> itemLore = meta.getLore();
                if (itemLore == null) {
                    itemLore = new ArrayList<String>();
                }
                for (String line : lore) {
                    itemLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
                }
                meta.setLore(itemLore);
            }
            this.icon.setItemMeta(meta);
            this.icon = InventoryUtils.makeReal(this.icon);
            InventoryUtils.makeUnbreakable(this.icon);
            InventoryUtils.hideFlags(this.icon, 63);
            if (this.unavailable) {
                if (this.unavailableMessage != null && !this.unavailableMessage.isEmpty()) {
                    InventoryUtils.setMeta(this.icon, "unpurchasable", this.unavailableMessage);
                } else {
                    this.showUnavailable = false;
                }
            }
            if (this.showConfirmation) {
                InventoryUtils.setMeta(this.icon, "confirm", "true");
            }
        }

        @Nullable
        protected String getCastSpell(com.elmakers.mine.bukkit.api.wand.Wand wand) {
            if (this.alternateSpellTags != null && wand != null) {
                for (String key : this.alternateSpellTags.keySet()) {
                    if (!wand.hasTag(key)) continue;
                    return (String)this.alternateSpellTags.get(key);
                }
            }
            return this.castSpell;
        }

        protected boolean hasAltTags(com.elmakers.mine.bukkit.api.wand.Wand wand) {
            if (this.alternateSpellTags == null || wand == null) {
                return false;
            }
            for (String key : this.alternateSpellTags.keySet()) {
                if (!wand.hasTag(key)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        protected Cost takeCosts(CostReducer reducer, CastContext context) {
            Cost required = this.getRequiredCost(reducer, context);
            if (required != null) {
                return required;
            }
            if (this.costs != null) {
                for (Cost cost : this.costs) {
                    cost.deduct(context.getMage(), context.getWand(), reducer);
                }
            }
            return null;
        }

        @Nullable
        public Cost getRequiredCost(CostReducer reducer, CastContext context) {
            if (this.costs != null) {
                for (Cost cost : this.costs) {
                    if (cost.has(context.getMage(), context.getWand(), reducer)) continue;
                    return cost;
                }
            }
            return null;
        }

        public SpellResult give(CostReducer reducer, CastContext context) {
            Cost required;
            Mage mage = context.getMage();
            com.elmakers.mine.bukkit.api.wand.Wand wand = context.getWand();
            if (this.placeholder) {
                return SpellResult.NO_ACTION;
            }
            if (this.unlockClass != null && !this.unlockClass.isEmpty()) {
                if (mage.hasClassUnlocked(this.unlockClass)) {
                    String hasClassMessage = SelectorAction.this.getMessage("has_class").replace("$class", this.name);
                    context.showMessage(hasClassMessage);
                    return SpellResult.NO_TARGET;
                }
                MageClass activeClass = mage.getActiveClass();
                if (this.switchClass && activeClass != null) {
                    mage.lockClass(activeClass.getKey());
                }
                mage.unlockClass(this.unlockClass);
                if (this.lockClass != null && !this.lockClass.isEmpty()) {
                    mage.lockClass(this.lockClass);
                }
                if (this.switchClass) {
                    mage.setActiveClass(this.unlockClass);
                    wand = SelectorAction.this.actionContext.checkWand();
                }
            }
            CasterProperties caster = this.getCaster(context);
            if (this.applyToWand && caster == null) {
                context.showMessage("no_wand", SelectorAction.this.getDefaultMessage(context, "no_wand"));
                return SpellResult.NO_TARGET;
            }
            if (caster != null && this.items != null) {
                boolean anyApplied = false;
                for (ItemStack item : this.items) {
                    anyApplied = caster.addItem(item) || anyApplied;
                }
                if (!anyApplied) {
                    String inapplicable = SelectorAction.this.getMessage("not_applicable").replace("$item", this.name);
                    context.showMessage(inapplicable);
                    return SpellResult.NO_TARGET;
                }
            }
            if (caster != null && this.attributeKey != null && !this.attributeKey.isEmpty()) {
                MagicAttribute attributeDefinition = context.getController().getAttribute(this.attributeKey);
                Double amount = caster.getAttribute(this.attributeKey);
                if (amount != null && attributeDefinition != null) {
                    double newValue = amount + (double)this.attributeAmount;
                    if (!attributeDefinition.inRange(newValue)) {
                        return SpellResult.NO_TARGET;
                    }
                    caster.setAttribute(this.attributeKey, newValue);
                    if (!SelectorAction.this.autoClose && SelectorAction.this.displayInventory != null) {
                        for (Map.Entry entry : SelectorAction.this.showingItems.entrySet()) {
                            SelectorOption option = (SelectorOption)entry.getValue();
                            if (option.isPlaceholder()) continue;
                            option.updateIcon(context, reducer);
                            ItemStack icon = option.getIcon();
                            InventoryUtils.setMeta(icon, "slot", Integer.toString((Integer)entry.getKey()));
                            SelectorAction.this.displayInventory.setItem(((Integer)entry.getKey()).intValue(), icon);
                        }
                    }
                } else {
                    context.getLogger().warning("Invalid attribute: " + this.attributeKey);
                }
            }
            MageController controller = context.getController();
            String castSpell = this.getCastSpell(context.getWand());
            if (castSpell != null && !castSpell.isEmpty()) {
                MageSpell spell = null;
                spell = mage.getSpell(castSpell);
                if (SelectorAction.this.autoClose) {
                    mage.deactivateGUI();
                }
                if (spell == null || !spell.cast()) {
                    context.showMessage("cast_fail", SelectorAction.this.getDefaultMessage(context, "cast_fail"));
                    return SpellResult.NO_TARGET;
                }
            }
            if (this.unlockKey != null && !this.unlockKey.isEmpty()) {
                ConfigurationSection unlocks = mage.getData().getConfigurationSection(this.unlockSection);
                if (unlocks != null && !unlocks.getBoolean(this.unlockKey)) {
                    String unlockMessage = SelectorAction.this.getMessage("unlocked");
                    context.showMessage(this.getCostsMessage(reducer, unlockMessage));
                }
                if (unlocks == null) {
                    unlocks = mage.getData().createSection(this.unlockSection);
                }
                unlocks.set(this.unlockKey, (Object)true);
            }
            if (this.items != null && caster == null) {
                boolean gave = false;
                for (ItemStack item : this.items) {
                    ItemStack copy = InventoryUtils.getCopy(item);
                    if (this.allowDroppedItems) {
                        mage.giveItem(copy, this.putInHand);
                        gave = true;
                        continue;
                    }
                    gave = mage.tryGiveItem(copy, this.putInHand) || gave;
                }
                if (!gave) {
                    context.showMessage(SelectorAction.this.getMessage("full"));
                    return SpellResult.NO_TARGET;
                }
            }
            if (this.commands != null && !this.commands.isEmpty()) {
                for (Object command : this.commands) {
                    String execute = context.parameterize((String)command);
                    controller.getPlugin().getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), execute);
                }
            }
            if (this.earns != null) {
                boolean givenAny = false;
                for (Cost cost : this.earns) {
                    givenAny = cost.give(mage, wand) || givenAny;
                }
                if (!givenAny) {
                    return SpellResult.NO_TARGET;
                }
            }
            if (this.actions != null) {
                SelectorAction.this.startActions(this.actions);
            }
            if ((required = this.takeCosts(reducer, context)) != null) {
                String baseMessage = SelectorAction.this.getMessage("insufficient");
                String costDescription = required.getFullDescription(controller.getMessages(), reducer);
                costDescription = baseMessage.replace("$cost", costDescription);
                context.showMessage(costDescription);
                return SpellResult.INSUFFICIENT_RESOURCES;
            }
            if (!this.effects.isEmpty()) {
                context.playEffects(this.effects);
            }
            return SpellResult.CAST;
        }

        @Nullable
        public CasterProperties getCaster(CastContext context) {
            Mage mage = context.getMage();
            com.elmakers.mine.bukkit.api.wand.Wand wand = context.getWand();
            CasterProperties caster = null;
            if (this.applyTo != null) {
                MagicConfigurable properties = mage.getProperties().getStorage(this.applyTo);
                if (properties instanceof CasterProperties) {
                    caster = (CasterProperties)properties;
                }
            } else if (this.applyToClass != null && !this.applyToClass.isEmpty()) {
                caster = mage.getClass(this.applyToClass);
            } else if (this.applyToWand) {
                caster = wand;
            } else if (this.applyToCaster) {
                caster = mage.getActiveProperties();
            }
            return caster;
        }

        public Integer getSlot() {
            return this.slot;
        }

        public boolean isPlaceholder() {
            return this.placeholder;
        }

        public boolean isUnavailable() {
            return this.unavailable;
        }

        @Nullable
        public ItemStack getIcon() {
            return this.icon;
        }

        public String getName() {
            return this.name;
        }

        public String getSelectedMessage(CostReducer reducer) {
            String message = this.selectedMessage;
            if (this.costs == null) {
                if (this.selectedFreeMessage != null) {
                    message = this.selectedFreeMessage;
                } else if (message == null) {
                    message = SelectorAction.this.getMessage("selected_free");
                }
            } else if (message == null) {
                message = SelectorAction.this.getMessage("selected");
            }
            return this.getCostsMessage(reducer, message);
        }

        public String getCostsMessage(CostReducer reducer, String baseMessage) {
            String costString = "";
            if (this.costs != null) {
                for (Cost cost : this.costs) {
                    if (!costString.isEmpty()) {
                        costString = costString + ", ";
                    }
                    costString = costString + cost.getFullDescription(SelectorAction.this.context.getController().getMessages(), reducer);
                }
            }
            if (costString.isEmpty()) {
                costString = SelectorAction.this.getMessage("nothing");
            }
            String earnString = "";
            if (this.earns != null) {
                for (Cost earn : this.earns) {
                    if (!earnString.isEmpty()) {
                        earnString = earnString + ", ";
                    }
                    earnString = earnString + earn.getFullDescription(SelectorAction.this.context.getController().getMessages());
                }
            }
            if (earnString.isEmpty()) {
                earnString = SelectorAction.this.getMessage("nothing");
            }
            return baseMessage.replace("$item", this.name).replace("$name", this.name).replace("$cost", costString).replace("$earn", earnString);
        }
    }

    protected class SelectorConfiguration {
        @Nullable
        protected ItemStack icon;
        @Nullable
        protected String iconKey;
        @Nullable
        protected String iconDisabledKey;
        @Nullable
        protected String iconPlaceholderKey;
        @Nullable
        protected List<ItemStack> items;
        @Nullable
        protected List<Cost> costs = null;
        @Nonnull
        protected String costType = "currency";
        @Nonnull
        protected String earnType = "currency";
        @Nullable
        protected String costOverride = null;
        @Nonnull
        protected String costTypeFallback = "item";
        @Nullable
        protected String castSpell = null;
        @Nullable
        protected String unlockClass = null;
        @Nullable
        protected String lockClass = null;
        @Nullable
        protected String selectedMessage = null;
        @Nullable
        protected String selectedFreeMessage = null;
        @Nullable
        protected String unlockKey = null;
        @Nullable
        protected String actions = null;
        @Nonnull
        protected String unlockSection = "unlocked";
        @Nullable
        protected Collection<Requirement> requirements;
        @Nullable
        protected List<String> commands;
        @Nullable
        protected List<CostModifier> costModifiers;
        @Nullable
        protected List<Cost> earns = null;
        @Nullable
        protected Map<String, String> alternateSpellTags;
        @Nonnull
        protected String effects = "selected";
        @Nullable
        protected String attributeKey = null;
        protected boolean allowAttributeReduction = false;
        protected int attributeAmount = 0;
        protected boolean applyToWand = false;
        protected boolean applyToCaster = false;
        protected MagicPropertyType applyTo = null;
        @Nullable
        protected String applyToClass = null;
        protected boolean showConfirmation = false;
        protected boolean showUnavailable = false;
        protected boolean switchClass = false;
        protected boolean putInHand = false;
        protected boolean free = false;
        protected boolean applyLoreToItem = false;
        protected boolean applyNameToItem = false;
        protected boolean allowDroppedItems = true;
        protected int limit = 0;

        public SelectorConfiguration(ConfigurationSection configuration) {
            this.parse(configuration);
        }

        protected SelectorConfiguration() {
        }

        protected void parse(ConfigurationSection configuration) {
            ConfigurationSection altTags;
            List itemList;
            String applyToString;
            this.applyToWand = configuration.getBoolean("apply_to_wand", this.applyToWand);
            this.applyToCaster = configuration.getBoolean("apply_to_caster", this.applyToCaster);
            this.applyToClass = configuration.getString("apply_to_class", this.applyToClass);
            this.putInHand = configuration.getBoolean("put_in_hand", this.putInHand);
            this.castSpell = configuration.getString("cast_spell", this.castSpell);
            this.unlockClass = configuration.getString("unlock_class", this.unlockClass);
            this.lockClass = configuration.getString("lock_class", this.lockClass);
            this.allowAttributeReduction = configuration.getBoolean("allow_attribute_reduction", this.allowAttributeReduction);
            if (configuration.contains("switch_class")) {
                this.switchClass = true;
                this.unlockClass = configuration.getString("switch_class");
            }
            if ((applyToString = configuration.getString("apply_to", this.applyTo == null ? null : this.applyTo.name())) != null && !applyToString.isEmpty()) {
                try {
                    this.applyTo = MagicPropertyType.valueOf(applyToString.toUpperCase());
                }
                catch (Exception ex) {
                    SelectorAction.this.context.getLogger().warning("Invalid apply_to: " + applyToString);
                }
            } else {
                this.applyTo = null;
            }
            this.attributeAmount = configuration.getInt("attribute_amount", this.attributeAmount);
            this.attributeKey = configuration.getString("attribute", this.attributeKey);
            this.limit = configuration.getInt("limit", this.limit);
            this.unlockKey = configuration.getString("unlock", this.unlockKey);
            this.unlockSection = configuration.getString("unlock_section", this.unlockSection);
            this.showConfirmation = configuration.getBoolean("confirm", this.showConfirmation);
            this.costType = configuration.getString("cost_type", this.costType);
            this.costOverride = configuration.getString("cost_override", this.costOverride);
            this.earnType = configuration.getString("earn_type", this.earnType);
            this.costTypeFallback = configuration.getString("cost_type_fallback", this.costTypeFallback);
            this.actions = configuration.getString("actions", this.actions);
            this.showUnavailable = configuration.getBoolean("show_unavailable", this.showUnavailable);
            this.commands = ConfigurationUtils.getStringList(configuration, "commands");
            String command = configuration.getString("command");
            if (command != null && !command.isEmpty()) {
                if (this.commands == null) {
                    this.commands = new ArrayList<String>();
                }
                this.commands.add(command);
            }
            this.free = configuration.getBoolean("free", this.free);
            this.effects = configuration.getString("effects", this.effects);
            this.applyLoreToItem = configuration.getBoolean("apply_lore_to_item", this.applyLoreToItem);
            this.applyNameToItem = configuration.getBoolean("apply_name_to_item", this.applyNameToItem);
            this.allowDroppedItems = configuration.getBoolean("allow_dropped_items", this.allowDroppedItems);
            if (this.costType.isEmpty() || this.costType.equalsIgnoreCase("none")) {
                this.free = true;
            }
            this.selectedMessage = configuration.getString("selected", this.selectedMessage);
            this.selectedFreeMessage = configuration.getString("selected_free", this.selectedFreeMessage);
            Collection<ConfigurationSection> requirementConfigurations = ConfigurationUtils.getNodeList(configuration, "requirements");
            if (requirementConfigurations != null) {
                this.requirements = new ArrayList<Requirement>();
                for (ConfigurationSection configurationSection : requirementConfigurations) {
                    this.requirements.add(new Requirement(configurationSection));
                }
            }
            if (configuration.contains("item")) {
                this.items = new ArrayList<ItemStack>();
                ItemStack item = SelectorAction.this.parseItem(configuration.getString("item"));
                if (item != null) {
                    this.items.add(item);
                }
            }
            if (configuration.contains("items") && (itemList = configuration.getStringList("items")).size() > 0) {
                this.items = new ArrayList<ItemStack>();
                for (String itemKey : itemList) {
                    this.items.add(SelectorAction.this.parseItem(itemKey));
                }
            }
            if ((altTags = ConfigurationUtils.getConfigurationSection(configuration, "cast_for_tags")) != null) {
                this.alternateSpellTags = new HashMap<String, String>();
                for (String key : altTags.getKeys(false)) {
                    this.alternateSpellTags.put(key, altTags.getString(key));
                }
            }
            if (this.actions != null && !this.actions.isEmpty()) {
                SelectorAction.this.addHandler(SelectorAction.this.context.getSpell(), this.actions);
            }
            if (this.items != null && this.items.isEmpty()) {
                this.items = null;
            }
            MageController mageController = SelectorAction.this.context.getController();
            this.iconPlaceholderKey = configuration.getString("placeholder_icon");
            this.iconKey = configuration.getString("icon");
            this.iconDisabledKey = configuration.getString("icon_disabled");
            this.costModifiers = this.parseCostModifiers(configuration, "cost_modifiers");
            if (!this.free) {
                this.costs = this.parseCosts(ConfigurationUtils.getConfigurationSection(configuration, "costs"));
                double cost = configuration.getDouble("cost");
                if (cost > 0.0) {
                    if (this.costs == null) {
                        this.costs = new ArrayList<Cost>();
                    }
                    Cost optionCost = new Cost(SelectorAction.this.context.getController(), this.costType, cost);
                    if (this.costOverride != null) {
                        optionCost.convert(mageController, this.costOverride);
                    }
                    optionCost.checkSupported(mageController, this.costTypeFallback);
                    optionCost.scale(mageController.getWorthBase());
                    this.costs.add(optionCost);
                } else if (configuration.isString("cost")) {
                    if (this.costs == null) {
                        this.costs = new ArrayList<Cost>();
                    }
                    this.costs.add(new Cost(SelectorAction.this.context.getController(), configuration.getString("cost"), 1.0));
                }
                if (this.costs == null && this.items != null) {
                    this.costs = new ArrayList<Cost>();
                    for (ItemStack item : this.items) {
                        Cost itemCost = null;
                        String spellKey = mageController.getSpell(item);
                        if (spellKey == null) {
                            Double worth = mageController.getWorth(item);
                            if (worth != null && worth > 0.0) {
                                itemCost = new Cost(SelectorAction.this.context.getController(), this.costType, worth);
                            }
                        } else {
                            SpellTemplate spell = mageController.getSpellTemplate(spellKey);
                            itemCost = (Cost)spell.getCost();
                        }
                        if (itemCost == null) continue;
                        if (this.costOverride != null) {
                            itemCost.convert(mageController, this.costOverride);
                            itemCost.checkSupported(mageController, this.costTypeFallback);
                        } else {
                            itemCost.checkSupported(mageController, this.costType, this.costTypeFallback);
                        }
                        itemCost.scale(mageController.getWorthBase());
                        this.costs.add(itemCost);
                    }
                }
            }
            if ((this.applyNameToItem || this.applyLoreToItem) && this.items != null) {
                for (ItemStack item : this.items) {
                    List lore;
                    ItemMeta meta = item.getItemMeta();
                    String customName = configuration.getString("name");
                    if (this.applyNameToItem && customName != null && !customName.isEmpty()) {
                        meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)customName));
                    }
                    List list = lore = configuration.contains("lore") ? configuration.getStringList("lore") : null;
                    if (this.applyLoreToItem && lore != null) {
                        ArrayList<String> translated = new ArrayList<String>();
                        for (String line : lore) {
                            translated.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
                        }
                        meta.setLore(translated);
                    }
                    item.setItemMeta(meta);
                }
            }
            this.earns = this.parseCosts(ConfigurationUtils.getConfigurationSection(configuration, "earns"));
            double earn = configuration.getDouble("earn");
            if (earn > 0.0) {
                if (this.earns == null) {
                    this.earns = new ArrayList<Cost>();
                }
                Cost earnCost = new Cost(SelectorAction.this.context.getController(), this.earnType, earn);
                earnCost.checkSupported(mageController, this.costType, this.costTypeFallback);
                earnCost.scale(mageController.getWorthBase());
                earnCost.scale(SelectorAction.this.earnScale);
                this.earns.add(earnCost);
            }
        }

        @Nullable
        protected List<Cost> parseCosts(ConfigurationSection node) {
            return Cost.parseCosts(node, SelectorAction.this.context.getController());
        }

        @Nullable
        protected List<CostModifier> parseCostModifiers(ConfigurationSection configuration, String section) {
            Collection<ConfigurationSection> modifierConfigs = ConfigurationUtils.getNodeList(configuration, section);
            if (modifierConfigs == null) {
                return null;
            }
            ArrayList<CostModifier> modifiers = new ArrayList<CostModifier>();
            for (ConfigurationSection modifierConfig : modifierConfigs) {
                modifiers.add(new CostModifier(modifierConfig));
            }
            return modifiers;
        }

        public boolean hasLimit() {
            return this.limit > 0;
        }

        public String getCostType() {
            return this.costType;
        }

        public String getCostTypeFallback() {
            return this.costTypeFallback;
        }

        public boolean has(CastContext context) {
            Mage mage = context.getMage();
            return this.unlockClass != null && !this.unlockClass.isEmpty() && mage.hasClassUnlocked(this.unlockClass);
        }

        public RequirementsResult checkRequirements(CastContext context) {
            String message;
            MageController controller = context.getController();
            Mage mage = context.getMage();
            Player player = mage.getPlayer();
            if (player == null) {
                return new RequirementsResult(SpellResult.PLAYER_REQUIRED);
            }
            if (this.limit > 0 && SelectorAction.this.has >= this.limit) {
                return new RequirementsResult(SpellResult.NO_TARGET, SelectorAction.this.getMessage("at_limit").replace("$limit", Integer.toString(this.limit)));
            }
            if (this.unlockClass != null && !this.unlockClass.isEmpty() && mage.hasClassUnlocked(this.unlockClass)) {
                return new RequirementsResult(SpellResult.NO_TARGET, SelectorAction.this.getMessage("has_class").replace("$class", this.unlockClass));
            }
            if (this.requirements != null && (message = controller.checkRequirements(context, this.requirements)) != null) {
                return new RequirementsResult(SpellResult.NO_TARGET, message);
            }
            return new RequirementsResult(SpellResult.CAST);
        }

        public boolean isUnlock() {
            return this.unlockKey != null && !this.unlockKey.isEmpty();
        }

        public boolean showIfUnavailable() {
            return this.showUnavailable;
        }
    }

    protected class CostModifier {
        private ModifierType type;
        private String equation;
        private String property;
        private double defaultValue;

        public CostModifier(ConfigurationSection configuration) {
            String typeString = configuration.getString("type");
            try {
                this.type = ModifierType.valueOf(typeString.toUpperCase());
            }
            catch (Exception ex) {
                SelectorAction.this.context.getLogger().warning("Invalid modifier type in selector config: " + typeString);
                this.type = null;
                return;
            }
            this.defaultValue = configuration.getDouble("default");
            this.equation = configuration.getString("scale");
            this.property = this.type == ModifierType.ATTRIBUTE ? configuration.getString("attribute") : configuration.getString("property");
        }

        public void modify(Cost cost) {
            if (this.type == null) {
                return;
            }
            Mage mage = SelectorAction.this.context.getMage();
            double value = this.defaultValue;
            switch (this.type) {
                case MAGE: {
                    value = mage.getProperties().getProperty(this.property, value);
                    break;
                }
                case ATTRIBUTE: {
                    Double attribute = mage.getAttribute(this.property);
                    if (attribute == null) break;
                    value = attribute;
                    break;
                }
                case CLASS: {
                    MageClass activeClass = mage.getActiveClass();
                    if (activeClass == null) break;
                    value = activeClass.getProperty(this.property, value);
                    break;
                }
                case WAND: {
                    com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
                    if (wand == null) break;
                    value = wand.getProperty(this.property, value);
                }
            }
            EquationTransform transform = EquationStore.getInstance().getTransform(this.equation);
            transform.setVariable("x", value);
            double scale = transform.get();
            cost.scale(scale);
        }
    }

    protected static enum ModifierType {
        WAND,
        MAGE,
        CLASS,
        ATTRIBUTE;

    }

    protected class RequirementsResult {
        public final SpellResult result;
        public final String message;

        public RequirementsResult(SpellResult result, String message) {
            this.result = result;
            this.message = message;
        }

        public RequirementsResult(SpellResult result) {
            this(result, this$0.context.getMessage(result.name().toLowerCase()));
        }

        public String toString() {
            return this.result.toString() + " " + this.message;
        }
    }
}

