/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;

public class FlowerAction
extends BaseSpellAction {
    private final ArrayList<MaterialAndData> flowers = new ArrayList();
    private final ArrayList<MaterialAndData> tallFlowers = new ArrayList();
    private MaterialAndData requireBlock;

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        this.flowers.clear();
        this.tallFlowers.clear();
        List flowerKeys = parameters.getStringList("flowers");
        for (String flowerKey : flowerKeys) {
            MaterialAndData flower = new MaterialAndData(flowerKey = CompatibilityUtils.migrateMaterial(flowerKey));
            if (!flower.isValid()) continue;
            this.flowers.add(flower);
        }
        List tallFlowerKeys = parameters.getStringList("tall_flowers");
        for (String flowerKey : tallFlowerKeys) {
            MaterialAndData flower = new MaterialAndData(flowerKey = CompatibilityUtils.migrateMaterial(flowerKey));
            if (!flower.isValid()) continue;
            this.tallFlowers.add(flower);
        }
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.requireBlock = new MaterialAndData(parameters.getString("grow_on", "grass_block"));
        if (!this.requireBlock.isValid()) {
            this.requireBlock = new MaterialAndData(Material.GRASS);
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        boolean tall;
        Block block = context.getTargetBlock();
        if (block == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.requireBlock.is(block)) {
            return SpellResult.NO_TARGET;
        }
        if (!DefaultMaterials.isAir((block = block.getRelative(BlockFace.UP)).getType())) {
            return SpellResult.NO_TARGET;
        }
        MaterialAndData material = null;
        Random random = context.getRandom();
        boolean bl = tall = this.flowers.size() == 0 || this.tallFlowers.size() > 0 && random.nextBoolean();
        if (tall) {
            material = this.tallFlowers.get(random.nextInt(this.tallFlowers.size()));
        } else if (this.flowers.size() > 0) {
            material = this.flowers.get(random.nextInt(this.flowers.size()));
        }
        if (material == null) {
            return SpellResult.FAIL;
        }
        context.registerForUndo(block);
        material.modify(block);
        if (tall) {
            block = block.getRelative(BlockFace.UP);
            context.registerForUndo(block);
            material.modify(block);
            CompatibilityUtils.setTopHalf(block);
        }
        return SpellResult.CAST;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    @Override
    public boolean requiresBuildPermission() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }
}

