/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.magic.Mage;
import java.lang.ref.WeakReference;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class MageConversation {
    private final Mage speaker;
    private final WeakReference<Player> targetPlayer;
    private final String formatString;
    private int nextLine;

    public MageConversation(Mage speaker, Player targetPlayer) {
        this.speaker = speaker;
        this.targetPlayer = new WeakReference<Player>(targetPlayer);
        this.formatString = speaker.getController().getMessages().get("npc.dialog");
    }

    public boolean sayNextLine(List<String> dialog) {
        Player target = (Player)this.targetPlayer.get();
        if (target == null || this.nextLine >= dialog.size()) {
            return true;
        }
        String line = dialog.get(this.nextLine);
        if (!line.isEmpty()) {
            String message = this.formatString.replace("$line", line);
            message = message.replace("$speaker", this.speaker.getDisplayName()).replace("$target", target.getDisplayName());
            target.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        }
        ++this.nextLine;
        return this.nextLine >= dialog.size();
    }
}

