/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.block.AbstractSchematic;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public class Schematic
extends AbstractSchematic {
    public void load(short width, short height, short length, int[] blockTypes, Map<Integer, MaterialAndData> palette, Collection<Object> tileEntityData, Collection<Object> entityData, Vector origin) {
        this.initialize((short)width, (short)height, (short)length);
        this.loadEntities(entityData, origin);
        this.loadTileEntities(tileEntityData);
        if (blockTypes != null && palette != null) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    for (int x = 0; x < width; ++x) {
                        int index = x + (y * length + z) * width;
                        int palleteIndex = blockTypes[index];
                        MaterialAndData material = palette.get(palleteIndex);
                        if (material == null) continue;
                        BlockVector blockLocation = new BlockVector(x, y, z);
                        this.blocks[x][y][z] = material = this.addTileEntity(blockLocation, material, true);
                    }
                }
            }
        }
        this.loaded = true;
    }

    @Override
    protected void loadTileEntities(Collection<Object> tileEntityData) {
        if (tileEntityData == null || tileEntityData.isEmpty()) {
            return;
        }
        this.tileEntities = new HashMap();
        for (Object tileEntity : tileEntityData) {
            try {
                BlockVector position = NMSUtils.getBlockVector(tileEntity, "Pos");
                if (position == null) continue;
                this.tileEntities.put(position, tileEntity);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

