/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.ActionContext;
import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.action.CastContext;
import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import java.util.ArrayList;
import java.util.List;

public class ParallelAction
extends CompoundAction {
    private List<SubAction> remaining = null;
    private List<SubAction> processing = null;

    @Override
    public void reset(com.elmakers.mine.bukkit.api.action.CastContext context) {
        super.reset(context);
        ActionHandler actions = this.getHandler("actions");
        if (actions != null) {
            if (this.remaining == null) {
                this.remaining = new ArrayList<SubAction>();
            }
            for (ActionContext action : actions.getActions()) {
                action.getAction().reset(context);
                this.remaining.add(new SubAction(action, context));
            }
        }
    }

    @Override
    public void finish(com.elmakers.mine.bukkit.api.action.CastContext context) {
        super.finish(context);
        ActionHandler actions = this.getHandler("actions");
        if (actions != null) {
            actions.finish(context);
        }
    }

    @Override
    public SpellResult perform(com.elmakers.mine.bukkit.api.action.CastContext context) {
        SpellResult result = SpellResult.NO_ACTION;
        if (this.remaining.isEmpty()) {
            return result;
        }
        if (this.processing == null) {
            this.processing = new ArrayList<SubAction>(this.remaining);
        } else {
            this.processing.clear();
            this.processing.addAll(this.remaining);
        }
        this.remaining.clear();
        int startingWork = context.getWorkAllowed();
        context.setWorkAllowed(0);
        int splitWork = Math.max(1, startingWork / this.processing.size());
        for (SubAction action : this.processing) {
            context.setWorkAllowed(context.getWorkAllowed() + splitWork);
            SpellResult actionResult = action.perform();
            context.addResult(actionResult);
            if (actionResult.isStop()) {
                this.remaining.add(action);
            }
            result = result.min(actionResult);
        }
        return result;
    }

    @Override
    public Object clone() {
        ParallelAction action = (ParallelAction)super.clone();
        action.remaining = null;
        action.processing = null;
        return action;
    }

    private static class SubAction {
        private ActionContext action;
        private com.elmakers.mine.bukkit.api.action.CastContext context;

        public SubAction(ActionContext action, com.elmakers.mine.bukkit.api.action.CastContext context) {
            this.action = action;
            this.context = new CastContext(context);
        }

        public SpellResult perform() {
            return this.action.perform(this.context);
        }
    }
}

