/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.utility.Base64Coder;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.utility.SkinUtils;
import com.google.common.collect.Multimap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Skull;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InventoryUtils
extends NMSUtils {
    public static int MAX_LORE_LENGTH = 24;
    public static int MAX_PROPERTY_DISPLAY_LENGTH = 50;

    public static boolean saveTagsToItem(ConfigurationSection tags, ItemStack item) {
        Object handle = InventoryUtils.getHandle(item);
        if (handle == null) {
            return false;
        }
        Object tag = InventoryUtils.getTag(handle);
        if (tag == null) {
            return false;
        }
        return InventoryUtils.addTagsToNBT(InventoryUtils.getMap(tags), tag);
    }

    public static boolean saveTagsToItem(Map<String, Object> tags, ItemStack item) {
        Object handle = InventoryUtils.getHandle(item);
        if (handle == null) {
            return false;
        }
        Object tag = InventoryUtils.getTag(handle);
        if (tag == null) {
            return false;
        }
        return InventoryUtils.addTagsToNBT(tags, tag);
    }

    public static boolean configureSkillItem(ItemStack skillItem, String skillClass, ConfigurationSection skillConfig) {
        boolean quickCast;
        if (skillItem == null) {
            return false;
        }
        Object handle = InventoryUtils.getHandle(skillItem);
        if (handle == null) {
            return false;
        }
        Object tag = InventoryUtils.getTag(handle);
        if (tag == null) {
            return false;
        }
        InventoryUtils.setMetaBoolean(tag, "skill", true);
        Object spellNode = InventoryUtils.getNode(skillItem, "spell");
        if (skillClass != null && spellNode != null) {
            InventoryUtils.setMeta(spellNode, "class", skillClass);
        }
        if (skillConfig == null) {
            return true;
        }
        if (skillConfig.getBoolean("undroppable", false)) {
            InventoryUtils.setMetaBoolean(tag, "undroppable", true);
        }
        if (skillConfig.getBoolean("keep", false)) {
            InventoryUtils.setMetaBoolean(tag, "keep", true);
        }
        if (!(quickCast = skillConfig.getBoolean("quick_cast", true)) && spellNode != null) {
            InventoryUtils.setMetaBoolean(spellNode, "quick_cast", false);
        }
        return true;
    }

    public static boolean saveTagsToNBT(ConfigurationSection tags, Object node) {
        return InventoryUtils.saveTagsToNBT(tags, node, null);
    }

    public static boolean saveTagsToNBT(ConfigurationSection tags, Object node, Set<String> tagNames) {
        return InventoryUtils.saveTagsToNBT(InventoryUtils.getMap(tags), node, tagNames);
    }

    public static boolean addTagsToNBT(Map<String, Object> tags, Object node) {
        if (node == null) {
            Bukkit.getLogger().warning("Trying to save tags to a null node");
            return false;
        }
        if (!class_NBTTagCompound.isAssignableFrom(node.getClass())) {
            Bukkit.getLogger().warning("Trying to save tags to a non-CompoundTag");
            return false;
        }
        for (Map.Entry<String, Object> tag : tags.entrySet()) {
            Object value = tag.getValue();
            try {
                Object wrappedTag = InventoryUtils.wrapInTag(value);
                if (wrappedTag == null) continue;
                class_NBTTagCompound_setMethod.invoke(node, tag.getKey(), wrappedTag);
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.WARNING, "Error saving item data tag " + tag.getKey(), ex);
            }
        }
        return true;
    }

    public static boolean saveTagsToNBT(Map<String, Object> tags, Object node, Set<String> tagNames) {
        Set<String> currentTags;
        if (node == null) {
            Bukkit.getLogger().warning("Trying to save tags to a null node");
            return false;
        }
        if (!class_NBTTagCompound.isAssignableFrom(node.getClass())) {
            Bukkit.getLogger().warning("Trying to save tags to a non-CompoundTag");
            return false;
        }
        if (tagNames == null) {
            tagNames = tags.keySet();
        }
        currentTags = (currentTags = InventoryUtils.getTagKeys(node)) != null && !tagNames.containsAll(currentTags) ? new HashSet<String>(currentTags) : null;
        for (String tagName : tagNames) {
            if (currentTags != null) {
                currentTags.remove(tagName);
            }
            Object value = tags.get(tagName);
            try {
                Object wrappedTag = InventoryUtils.wrapInTag(value);
                if (wrappedTag == null) continue;
                class_NBTTagCompound_setMethod.invoke(node, tagName, wrappedTag);
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.WARNING, "Error saving item data tag " + tagName, ex);
            }
        }
        if (currentTags != null) {
            for (String currentTag : currentTags) {
                InventoryUtils.removeMeta(node, currentTag);
            }
        }
        return true;
    }

    public static Object wrapInTag(Object value) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        if (value == null) {
            return null;
        }
        Object wrappedValue = null;
        if (value instanceof Boolean) {
            wrappedValue = class_NBTTagByte_constructor.newInstance((byte)((Boolean)value != false ? 1 : 0));
        } else if (value instanceof Double) {
            wrappedValue = class_NBTTagDouble_constructor.newInstance((Double)value);
        } else if (value instanceof Float) {
            wrappedValue = class_NBTTagFloat_constructor.newInstance((Float)value);
        } else if (value instanceof Integer) {
            wrappedValue = class_NBTTagInt_constructor.newInstance((Integer)value);
        } else if (value instanceof Long) {
            wrappedValue = class_NBTTagLong_constructor.newInstance((Long)value);
        } else if (value instanceof ConfigurationSection) {
            wrappedValue = class_NBTTagCompound_constructor.newInstance(new Object[0]);
            InventoryUtils.saveTagsToNBT((ConfigurationSection)value, wrappedValue, null);
        } else if (value instanceof Map) {
            wrappedValue = class_NBTTagCompound_constructor.newInstance(new Object[0]);
            Map valueMap = (Map)value;
            InventoryUtils.addTagsToNBT(valueMap, wrappedValue);
        } else if (value instanceof Collection) {
            ArrayList<Number> list = (ArrayList<Number>)value;
            Object listMeta = class_NBTTagList_constructor.newInstance(new Object[0]);
            if (list.size() > 1 && list instanceof List) {
                List checkList = (List)value;
                Object e = checkList.get(0);
                Object second = checkList.get(1);
                if (e instanceof String && !(second instanceof String)) {
                    list = new ArrayList<Number>();
                    for (int i = 1; i < checkList.size(); ++i) {
                        if (e.equals("I")) {
                            list.add(InventoryUtils.convertToInteger(checkList.get(i)));
                            continue;
                        }
                        if (e.equals("L")) {
                            list.add(InventoryUtils.convertToLong(checkList.get(i)));
                            continue;
                        }
                        if (e.equals("B")) {
                            list.add(InventoryUtils.convertToByte(checkList.get(i)));
                            continue;
                        }
                        list.add((Number)checkList.get(i));
                    }
                    if (e.equals("I")) {
                        wrappedValue = class_NBTTagIntArray_constructor.newInstance(list);
                    } else if (e.equals("L")) {
                        wrappedValue = class_NBTTagLongArray_constructor.newInstance(list);
                    } else if (e.equals("B")) {
                        wrappedValue = class_NBTTagByteArray_constructor.newInstance(list);
                    }
                }
            }
            if (wrappedValue == null) {
                for (Object e : list) {
                    if (e == null) continue;
                    InventoryUtils.addToList(listMeta, InventoryUtils.wrapInTag(e));
                }
                wrappedValue = listMeta;
            }
        } else {
            wrappedValue = class_NBTTagString_consructor.newInstance(value.toString());
        }
        return wrappedValue;
    }

    protected static Long convertToLong(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Integer) {
            return (long)((Integer)o);
        }
        if (o instanceof Byte) {
            return (long)((Byte)o);
        }
        if (o instanceof Double) {
            return (long)((Double)o).doubleValue();
        }
        if (o instanceof String) {
            return Long.parseLong((String)o);
        }
        return null;
    }

    protected static Integer convertToInteger(Object o) {
        Long intVal = InventoryUtils.convertToLong(o);
        return intVal == null ? null : Integer.valueOf((int)intVal.longValue());
    }

    protected static Byte convertToByte(Object o) {
        Long intVal = InventoryUtils.convertToLong(o);
        return intVal == null ? null : Byte.valueOf((byte)intVal.longValue());
    }

    protected static Short convertToShort(Object o) {
        Long intVal = InventoryUtils.convertToLong(o);
        return intVal == null ? null : Short.valueOf((short)intVal.longValue());
    }

    protected static Double convertToDouble(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Integer) {
            return (double)((Integer)o);
        }
        if (o instanceof Long) {
            return (double)((Long)o);
        }
        if (o instanceof Byte) {
            return (double)((Byte)o);
        }
        if (o instanceof String) {
            return Double.parseDouble((String)o);
        }
        return null;
    }

    public static Set<String> getTagKeys(Object tag) {
        if (tag == null || class_NBTTagCompound_getKeysMethod == null) {
            return null;
        }
        try {
            return (Set)class_NBTTagCompound_getKeysMethod.invoke(tag, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getMetaObject(Object tag, String key) {
        try {
            Object metaBase = class_NBTTagCompound_getMethod.invoke(tag, key);
            return InventoryUtils.getTagValue(metaBase);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getTagValue(Object tag) throws IllegalAccessException, InvocationTargetException {
        if (tag == null) {
            return null;
        }
        Object value = null;
        if (class_NBTTagDouble.isAssignableFrom(tag.getClass())) {
            value = class_NBTTagDouble_dataField.get(tag);
        } else if (class_NBTTagInt.isAssignableFrom(tag.getClass())) {
            value = class_NBTTagInt_dataField.get(tag);
        } else if (class_NBTTagLong.isAssignableFrom(tag.getClass())) {
            value = class_NBTTagLong_dataField.get(tag);
        } else if (class_NBTTagFloat.isAssignableFrom(tag.getClass())) {
            value = class_NBTTagFloat_dataField.get(tag);
        } else if (class_NBTTagShort.isAssignableFrom(tag.getClass())) {
            value = class_NBTTagShort_dataField.get(tag);
        } else if (class_NBTTagByte.isAssignableFrom(tag.getClass())) {
            value = class_NBTTagByte_dataField.get(tag);
            if (value != null && value.equals((byte)0)) {
                value = false;
            } else if (value != null && value.equals((byte)1)) {
                value = true;
            }
        } else if (class_NBTTagList.isAssignableFrom(tag.getClass())) {
            List items = (List)class_NBTTagList_list.get(tag);
            ArrayList<Object> converted = new ArrayList<Object>();
            for (Object baseTag : items) {
                Object convertedBase = InventoryUtils.getTagValue(baseTag);
                if (convertedBase == null) continue;
                converted.add(convertedBase);
            }
            value = converted;
        } else if (class_NBTTagString.isAssignableFrom(tag.getClass())) {
            value = class_NBTTagString_dataField.get(tag);
        } else if (class_NBTTagCompound.isAssignableFrom(tag.getClass())) {
            HashMap<String, Object> compoundMap = new HashMap<String, Object>();
            Set<String> keys = InventoryUtils.getTagKeys(tag);
            for (String key : keys) {
                Object baseTag = class_NBTTagCompound_getMethod.invoke(tag, key);
                Object convertedBase = InventoryUtils.getTagValue(baseTag);
                if (convertedBase == null) continue;
                compoundMap.put(key, convertedBase);
            }
            value = compoundMap;
        }
        return value;
    }

    public static boolean inventorySetItem(Inventory inventory, int index, ItemStack item) {
        try {
            Method setItemMethod = class_CraftInventoryCustom.getMethod("setItem", Integer.TYPE, ItemStack.class);
            setItemMethod.invoke((Object)inventory, index, item);
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean setInventoryResults(Inventory inventory, ItemStack item) {
        try {
            Method getResultsMethod = inventory.getClass().getMethod("getResultInventory", new Class[0]);
            Object inv = getResultsMethod.invoke((Object)inventory, new Object[0]);
            Method setItemMethod = inv.getClass().getMethod("setItem", Integer.TYPE, class_ItemStack);
            setItemMethod.invoke(inv, 0, InventoryUtils.getHandle(item));
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static ItemStack setSkullURL(ItemStack itemStack, String url) {
        try {
            return InventoryUtils.setSkullURL(itemStack, new URL(url), UUID.randomUUID());
        }
        catch (MalformedURLException e) {
            Bukkit.getLogger().log(Level.WARNING, "Malformed URL: " + url, e);
            return itemStack;
        }
    }

    public static ItemStack setSkullURLAndName(ItemStack itemStack, URL url, String ownerName, UUID id) {
        try {
            itemStack = InventoryUtils.makeReal(itemStack);
            Object skullOwner = InventoryUtils.createNode(itemStack, "SkullOwner");
            InventoryUtils.setMeta(skullOwner, "Name", ownerName);
            return InventoryUtils.setSkullURL(itemStack, url, id);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return itemStack;
        }
    }

    public static ItemStack setSkullURL(ItemStack itemStack, URL url, UUID id) {
        return InventoryUtils.setSkullURL(itemStack, url, id, "MHF_Question");
    }

    public static ItemStack setSkullURL(ItemStack itemStack, URL url, UUID id, String name) {
        try {
            Object gameProfile = class_GameProfile_constructor.newInstance(id, name);
            Multimap properties = (Multimap)class_GameProfile_properties.get(gameProfile);
            if (properties == null) {
                return itemStack;
            }
            itemStack = InventoryUtils.makeReal(itemStack);
            String textureJSON = "{textures:{SKIN:{url:\"" + url + "\"}}}";
            String encoded = Base64Coder.encodeString(textureJSON);
            properties.put((Object)"textures", class_GameProfileProperty_noSignatureConstructor.newInstance("textures", encoded));
            ItemMeta skullMeta = itemStack.getItemMeta();
            InventoryUtils.setSkullProfile(skullMeta, gameProfile);
            itemStack.setItemMeta(skullMeta);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return itemStack;
    }

    public static String getSkullURL(ItemStack skull) {
        return SkinUtils.getProfileURL(InventoryUtils.getSkullProfile(skull.getItemMeta()));
    }

    @Deprecated
    public static String getPlayerSkullURL(String playerName) {
        return SkinUtils.getOnlineSkinURL(playerName);
    }

    public static Object getSkullProfile(ItemMeta itemMeta) {
        Object profile = null;
        try {
            if (itemMeta == null || !class_CraftMetaSkull.isInstance(itemMeta)) {
                return null;
            }
            profile = class_CraftMetaSkull_profile.get(itemMeta);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return profile;
    }

    public static boolean setSkullProfile(ItemMeta itemMeta, Object data) {
        try {
            if (itemMeta == null || !class_CraftMetaSkull.isInstance(itemMeta)) {
                return false;
            }
            class_CraftMetaSkull_profile.set(itemMeta, data);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Object getSkullProfile(Skull state) {
        Object profile = null;
        try {
            if (state == null || !class_CraftSkull.isInstance(state)) {
                return false;
            }
            profile = class_CraftSkull_profile.get(state);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return profile;
    }

    public static boolean setSkullProfile(Skull state, Object data) {
        try {
            if (state == null || !class_CraftSkull.isInstance(state)) {
                return false;
            }
            class_CraftSkull_profile.set(state, data);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void wrapText(String text, Collection<String> list) {
        InventoryUtils.wrapText(text, MAX_LORE_LENGTH, list);
    }

    public static void wrapText(String text, String prefix, Collection<String> list) {
        InventoryUtils.wrapText(text, prefix, MAX_LORE_LENGTH, list);
    }

    public static void wrapText(String text, int maxLength, Collection<String> list) {
        InventoryUtils.wrapText(text, "", maxLength, list);
    }

    public static void wrapText(String text, String prefix, int maxLength, Collection<String> list) {
        String[] lines;
        String colorPrefix = "";
        for (String line : lines = StringUtils.split((String)text, (String)"\n\r")) {
            line = prefix + line;
            while (line.length() > maxLength) {
                int spaceIndex = line.lastIndexOf(32, maxLength);
                if (spaceIndex <= 0) {
                    list.add(colorPrefix + line);
                    return;
                }
                String colorText = colorPrefix + line.substring(0, spaceIndex);
                colorPrefix = ChatColor.getLastColors((String)colorText);
                list.add(colorText);
                line = line.substring(spaceIndex);
            }
            list.add(colorPrefix + line);
        }
    }

    public static boolean hasItem(Inventory inventory, String itemName) {
        ItemStack[] items;
        if (inventory == null) {
            return false;
        }
        for (ItemStack item : items = inventory.getContents()) {
            String displayName;
            if (item == null || !item.hasItemMeta() || (displayName = item.getItemMeta().getDisplayName()) == null || !displayName.equals(itemName)) continue;
            return true;
        }
        return false;
    }

    public static void openSign(Player player, Location signBlock) {
        try {
            Object tileEntity = InventoryUtils.getTileEntity(signBlock);
            Object playerHandle = InventoryUtils.getHandle(player);
            if (tileEntity != null && playerHandle != null) {
                class_EntityPlayer_openSignMethod.invoke(playerHandle, tileEntity);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void makeKeep(ItemStack itemStack) {
        InventoryUtils.setMetaBoolean(itemStack, "keep", true);
    }

    public static boolean isKeep(ItemStack itemStack) {
        return InventoryUtils.hasMeta(itemStack, "keep");
    }

    public static void applyAttributes(ItemStack item, ConfigurationSection attributeConfig, String slot) {
        if (item == null || attributeConfig == null) {
            return;
        }
        Set attributeKeys = attributeConfig.getKeys(false);
        for (String attributeKey : attributeKeys) {
            try {
                double value;
                Attribute attribute = Attribute.valueOf((String)attributeKey.toUpperCase());
                if (CompatibilityUtils.setItemAttribute(item, attribute, value = attributeConfig.getDouble(attributeKey), slot)) continue;
                Bukkit.getLogger().warning("Failed to set attribute: " + attributeKey);
            }
            catch (Exception ex) {
                Bukkit.getLogger().warning("Invalid attribute: " + attributeKey);
            }
        }
    }

    public static void applyEnchantments(ItemStack item, ConfigurationSection enchantConfig) {
        if (item == null || enchantConfig == null) {
            return;
        }
        Set enchantKeys = enchantConfig.getKeys(false);
        for (String enchantKey : enchantKeys) {
            try {
                Enchantment enchantment = Enchantment.getByName((String)enchantKey.toUpperCase());
                item.addUnsafeEnchantment(enchantment, enchantConfig.getInt(enchantKey));
            }
            catch (Exception ex) {
                Bukkit.getLogger().warning("Invalid enchantment: " + enchantKey);
            }
        }
    }

    public static String describeProperty(Object property) {
        return InventoryUtils.describeProperty(property, 0);
    }

    public static String describeProperty(Object property, int maxLength) {
        String propertyString;
        if (property == null) {
            return "(Empty)";
        }
        if (property instanceof ConfigurationSection) {
            ConfigurationSection section = (ConfigurationSection)property;
            Set keys = section.getKeys(false);
            StringBuilder full = new StringBuilder("{");
            boolean first = true;
            for (String key : keys) {
                if (!first) {
                    full.append(',');
                }
                first = false;
                full.append(key).append(':').append(InventoryUtils.describeProperty(section.get(key)));
            }
            propertyString = full.append('}').toString();
        } else {
            propertyString = property.toString();
        }
        if (maxLength > 0 && propertyString.length() > maxLength - 3) {
            propertyString = propertyString.substring(0, maxLength - 3) + "...";
        }
        return propertyString;
    }

    public static boolean isSameInstance(ItemStack one, ItemStack two) {
        return one == two;
    }

    public static int getMapId(ItemStack mapItem) {
        if (InventoryUtils.isCurrentVersion()) {
            return InventoryUtils.getMetaInt(mapItem, "map", 0);
        }
        return mapItem.getDurability();
    }

    public static void setMapId(ItemStack mapItem, int id) {
        if (InventoryUtils.isCurrentVersion()) {
            InventoryUtils.setMetaInt(mapItem, "map", id);
        } else {
            mapItem.setDurability((short)id);
        }
    }

    public static void convertIntegers(Map<String, Object> m) {
        for (Map.Entry<String, Object> entry : m.entrySet()) {
            Object value = entry.getValue();
            if (value != null && value instanceof Double) {
                double d = (Double)value;
                if (d != (double)((int)d)) continue;
                entry.setValue((int)d);
                continue;
            }
            if (value != null && value instanceof Float) {
                float f = ((Float)value).floatValue();
                if (f != (float)((int)f)) continue;
                entry.setValue((int)f);
                continue;
            }
            if (value == null || !(value instanceof Map)) continue;
            Map map = (Map)value;
            InventoryUtils.convertIntegers(map);
        }
    }
}

