/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.magic.command.Paginator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class SpellsPaginator
extends Paginator<SpellTemplate> {
    private final MageController controller;

    public SpellsPaginator(MageController controller) {
        this.controller = controller;
    }

    @Override
    @Nonnull
    protected List<SpellTemplate> getList(CommandSender sender) {
        Collection<SpellTemplate> spells = this.controller.getSpellTemplates(sender.hasPermission("Magic.bypass_hidden"));
        ArrayList<SpellTemplate> list = new ArrayList<SpellTemplate>(spells);
        Collections.sort(list, new Comparator<SpellTemplate>(){

            @Override
            public int compare(SpellTemplate spell1, SpellTemplate spell2) {
                return spell1.getName().compareTo(spell2.getName());
            }
        });
        return list;
    }

    @Override
    @Nonnull
    protected String describe(SpellTemplate spell) {
        String name = spell.getName();
        String description = spell.getDescription();
        String[] pieces = StringUtils.split((String)description, (String)"\n");
        if ((description = pieces[0]).length() > 30) {
            description = description.substring(0, 27) + "...";
        }
        if (!name.equals(spell.getKey())) {
            description = name + " : " + description;
        }
        return ChatColor.AQUA + spell.getKey() + ChatColor.BLUE + description;
    }

    @Override
    @Nonnull
    protected String getTypeNamePlural() {
        return "spells";
    }
}

