/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.effect.NPCTargetingContext;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.command.SelectionManager;
import com.elmakers.mine.bukkit.npc.MagicNPC;
import com.elmakers.mine.bukkit.utility.Target;
import com.elmakers.mine.bukkit.utility.Targeting;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class NPCSelectionManager
extends SelectionManager<com.elmakers.mine.bukkit.api.npc.MagicNPC> {
    private final Targeting targeting = new Targeting();
    private static final int selectRange = 32;

    public NPCSelectionManager(MagicController controller) {
        super(controller);
        MemoryConfiguration targetingParameters = new MemoryConfiguration();
        targetingParameters.set("range", (Object)32);
        targetingParameters.set("target", (Object)"other_entity");
        targetingParameters.set("ignore_blocks", (Object)true);
        this.targeting.processParameters((ConfigurationSection)targetingParameters);
    }

    @Override
    @Nonnull
    public Collection<com.elmakers.mine.bukkit.api.npc.MagicNPC> getAll() {
        return this.controller.getNPCs();
    }

    @Override
    @Nonnull
    protected String getTypeNamePlural() {
        return "NPCs";
    }

    @Override
    protected void showListItem(CommandSender sender, com.elmakers.mine.bukkit.api.npc.MagicNPC npc, SelectionManager.ListType listType) {
        int duration;
        switch (listType) {
            case INACTIVE: {
                return;
            }
            case TARGET: {
                duration = 5;
                break;
            }
            case SELECTED: {
                duration = 4;
                break;
            }
            default: {
                duration = 3;
            }
        }
        this.highlight(npc, duration);
    }

    public void highlight(com.elmakers.mine.bukkit.api.npc.MagicNPC npc) {
        this.highlight(npc, 5);
    }

    public void highlight(com.elmakers.mine.bukkit.api.npc.MagicNPC npc, int duration) {
        Entity entity = npc.getEntity();
        if (entity != null && entity instanceof LivingEntity) {
            LivingEntity li = (LivingEntity)entity;
            li.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, duration * 20, 1, true, false));
        }
    }

    @Override
    @Nullable
    protected com.elmakers.mine.bukkit.api.npc.MagicNPC getTarget(CommandSender sender, List<com.elmakers.mine.bukkit.api.npc.MagicNPC> sorted) {
        Mage mage = this.controller.getRegisteredMage(sender);
        if (mage == null) {
            return null;
        }
        MagicNPC npc = null;
        NPCTargetingContext context = new NPCTargetingContext(mage);
        this.targeting.reset();
        Target target = this.targeting.target(context, 32.0);
        if (target != null && target.hasEntity()) {
            npc = this.controller.getNPC(target.getEntity());
        }
        return npc;
    }
}

