/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.data.MageData;
import com.elmakers.mine.bukkit.api.data.MageDataCallback;
import com.elmakers.mine.bukkit.api.data.MageDataStore;
import com.elmakers.mine.bukkit.magic.MagicController;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class MigrateDataTask
implements Runnable {
    private final MagicController controller;
    private final MageDataStore currentStore;
    private final MageDataStore migrateStore;
    private final CommandSender sender;
    private final Collection<String> ids;

    public MigrateDataTask(MagicController controller, MageDataStore currentStore, MageDataStore migrateStore, CommandSender sender) {
        this.controller = controller;
        this.currentStore = currentStore;
        this.migrateStore = migrateStore;
        this.sender = sender;
        this.ids = migrateStore.getAllIds();
        controller.getLogger().info("Player data migration started by " + sender.getName());
        sender.sendMessage(ChatColor.GREEN + "Beginning migration of " + this.ids.size() + " player data records");
    }

    public void messageSender(final String message) {
        Bukkit.getScheduler().runTask((Plugin)this.controller.getPlugin(), new Runnable(){

            @Override
            public void run() {
                MigrateDataTask.this.sender.sendMessage(message);
            }
        });
    }

    @Override
    public void run() {
        int count = this.ids.size();
        int index = 0;
        int interval = (int)Math.ceil((double)count / 20.0);
        MageDataCallback loadCallback = new MageDataCallback(){

            @Override
            public void run(MageData data) {
                if (data != null) {
                    MigrateDataTask.this.currentStore.save(data, null, false);
                    MigrateDataTask.this.migrateStore.migrate(data.getId());
                }
            }
        };
        for (String id : this.ids) {
            ++index;
            if (this.controller.getRegisteredMage(id) != null) continue;
            this.migrateStore.load(id, loadCallback);
            if (index % interval != 0) continue;
            this.messageSender(ChatColor.AQUA + "Migrated " + index + "/" + count);
        }
        this.messageSender(ChatColor.GREEN + "Migration complete. Please remove `migrate_data_store` from config.yml");
        this.controller.finishMigratingPlayerData();
    }
}

