/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.entity;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.entity.EntityExtraData;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class EntityFoxData
extends EntityExtraData {
    private Object type;
    private UUID firstTrusted;

    public EntityFoxData() {
    }

    public EntityFoxData(ConfigurationSection parameters, MageController controller) {
        String trusted;
        Logger log = controller.getLogger();
        String typeString = parameters.getString("fox_type");
        if (typeString != null && !typeString.isEmpty()) {
            try {
                this.type = CompatibilityUtils.getFoxType(typeString.toUpperCase());
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Invalid fox_type: " + parameters.getString("fox_type"), ex);
            }
        }
        if ((trusted = parameters.getString("trusted")) != null && !trusted.isEmpty()) {
            try {
                this.firstTrusted = UUID.fromString(trusted);
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Invalid trusted UUID: " + parameters.getString("trusted"), ex);
            }
        }
    }

    public EntityFoxData(Entity fox) {
        if (CompatibilityUtils.isFox(fox)) {
            this.type = CompatibilityUtils.getFoxType(fox);
            Object trusted = CompatibilityUtils.getFirstTrustedPlayer(fox);
            if (trusted != null && trusted instanceof Player) {
                this.firstTrusted = ((Player)trusted).getUniqueId();
            }
        }
    }

    @Override
    public void apply(Entity entity) {
        if (CompatibilityUtils.isFox(entity)) {
            OfflinePlayer trusted;
            if (this.type != null) {
                CompatibilityUtils.setFoxType(entity, this.type);
            }
            if (this.firstTrusted != null && (trusted = Bukkit.getOfflinePlayer((UUID)this.firstTrusted)) != null) {
                CompatibilityUtils.setFirstTrustedPlayer(entity, (AnimalTamer)trusted);
            }
        }
    }

    @Override
    public EntityExtraData clone() {
        EntityFoxData copy = new EntityFoxData();
        copy.type = this.type;
        return copy;
    }
}

