/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.block.ModifyType;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.DeprecatedUtils;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.util.BlockVector;

public class BlockData
extends MaterialAndData
implements com.elmakers.mine.bukkit.api.block.BlockData {
    public static final BlockFace[] FACES = new BlockFace[]{BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.UP, BlockFace.DOWN};
    public static final BlockFace[] SIDES = new BlockFace[]{BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST};
    public static boolean undoing = false;
    protected com.elmakers.mine.bukkit.api.block.BlockData nextState;
    protected com.elmakers.mine.bukkit.api.block.BlockData priorState;
    protected Collection<WeakReference<Player>> fakeSentToPlayers;
    protected BlockVector location;
    protected String worldName;
    protected WeakReference<UndoList> undoList = null;
    protected double damage;

    public static long getBlockId(Block block) {
        return BlockData.getBlockId(block.getWorld().getName(), block.getX(), block.getY(), block.getZ());
    }

    public static long getBlockId(Location location) {
        return BlockData.getBlockId(location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public static long getBlockId(String world, int x, int y, int z) {
        long worldHashCode = world == null ? 0L : (long)world.hashCode();
        return (worldHashCode & 0xFL) << 56 | ((long)x & 0xFFFFFFL) << 32 | ((long)z & 0xFFFFFFL) << 8 | (long)y & 0xFFL;
    }

    @Override
    public int hashCode() {
        return (int)this.getId();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof BlockData) {
            return this.getId() == ((BlockData)other).getId();
        }
        return super.equals(other);
    }

    @Override
    public long getId() {
        if (this.location == null) {
            return 0L;
        }
        return BlockData.getBlockId(this.worldName, this.location.getBlockX(), this.location.getBlockY(), this.location.getBlockZ());
    }

    public static BlockFace getReverseFace(BlockFace blockFace) {
        switch (blockFace) {
            case NORTH: {
                return BlockFace.SOUTH;
            }
            case WEST: {
                return BlockFace.EAST;
            }
            case SOUTH: {
                return BlockFace.NORTH;
            }
            case EAST: {
                return BlockFace.WEST;
            }
            case UP: {
                return BlockFace.DOWN;
            }
            case DOWN: {
                return BlockFace.UP;
            }
        }
        return BlockFace.SELF;
    }

    public BlockData() {
    }

    public BlockData(Block block) {
        super(block);
        this.location = new BlockVector(block.getX(), block.getY(), block.getZ());
        this.worldName = block.getWorld().getName();
    }

    public BlockData(com.elmakers.mine.bukkit.api.block.BlockData copy) {
        super(copy);
        this.location = copy.getPosition();
        this.worldName = copy.getWorldName();
    }

    public BlockData(int x, int y, int z, String world, String key) {
        super(key);
        this.location = new BlockVector(x, y, z);
        this.worldName = world;
    }

    public void save(ConfigurationSection node) {
        if (this.worldName == null) {
            return;
        }
        node.set("material", (Object)ConfigurationUtils.fromMaterial(this.material));
        node.set("data", (Object)this.data);
        Location location = new Location(Bukkit.getWorld((String)this.worldName), this.location.getX(), this.location.getY(), this.location.getZ());
        node.set("location", (Object)ConfigurationUtils.fromLocation(location));
    }

    public void setPosition(BlockVector location) {
        this.location = location;
    }

    @Override
    public void unlink() {
        if (this.priorState != null) {
            this.priorState.setNextState(this.nextState);
        }
        if (this.nextState != null) {
            this.nextState.updateFrom(this);
            this.nextState.setPriorState(this.priorState);
        }
        this.priorState = null;
        this.nextState = null;
    }

    @Override
    public boolean undo() {
        return this.undo(false);
    }

    @Override
    public boolean undo(boolean applyPhysics) {
        return this.undo(applyPhysics ? ModifyType.NORMAL : ModifyType.NO_PHYSICS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean undo(ModifyType modifyType) {
        Block block = this.getBlock();
        if (block == null) {
            return true;
        }
        if (this.fakeSentToPlayers != null) {
            if (this.nextState == null) {
                for (WeakReference<Player> playerRef : this.fakeSentToPlayers) {
                    Player player = (Player)playerRef.get();
                    if (player == null) continue;
                    DeprecatedUtils.sendBlockChange(player, block);
                }
            }
            this.fakeSentToPlayers = null;
            this.unlink();
            return true;
        }
        Chunk chunk = block.getChunk();
        if (!chunk.isLoaded()) {
            chunk.load();
            return false;
        }
        if (this.nextState == null && this.isDifferent(block)) {
            undoing = true;
            try {
                this.modify(block, modifyType);
            }
            finally {
                undoing = false;
            }
        }
        this.unlink();
        return true;
    }

    @Override
    public void commit() {
        UndoList list;
        this.updateFrom(this.getBlock());
        if (this.nextState != null) {
            this.nextState.setPriorState(null);
            this.nextState.updateFrom(this.getBlock());
            this.nextState = null;
        }
        if (this.priorState != null) {
            this.priorState.setNextState(null);
            this.priorState.updateFrom(this.getBlock());
            this.priorState.commit();
            this.priorState = null;
        }
        if ((list = (UndoList)this.undoList.get()) != null) {
            list.remove(this);
        }
    }

    @Override
    public String toString() {
        return this.location.getBlockX() + "," + this.location.getBlockY() + "," + this.location.getBlockZ() + "," + this.worldName + "|" + this.getKey();
    }

    @Nullable
    public static BlockData fromString(String s) {
        BlockData result = null;
        if (s == null) {
            return null;
        }
        try {
            String[] pieces = StringUtils.split((String)s, (char)'|');
            String[] locationPieces = StringUtils.split((String)pieces[0], (char)',');
            int x = Integer.parseInt(locationPieces[0]);
            int y = Integer.parseInt(locationPieces[1]);
            int z = Integer.parseInt(locationPieces[2]);
            String world = locationPieces[3];
            result = new BlockData(x, y, z, world, pieces[1]);
            if (!result.isValid()) {
                result = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public com.elmakers.mine.bukkit.api.block.BlockData getNextState() {
        return this.nextState;
    }

    @Override
    public void setNextState(com.elmakers.mine.bukkit.api.block.BlockData next) {
        this.nextState = next;
    }

    @Override
    public com.elmakers.mine.bukkit.api.block.BlockData getPriorState() {
        return this.priorState;
    }

    @Override
    public void setPriorState(com.elmakers.mine.bukkit.api.block.BlockData prior) {
        this.priorState = prior;
    }

    @Override
    public void restore() {
        this.restore(false);
    }

    @Override
    public void restore(boolean applyPhysics) {
        this.modify(this.getBlock(), applyPhysics);
    }

    @Override
    public String getWorldName() {
        return this.worldName;
    }

    @Override
    public BlockVector getPosition() {
        return this.location;
    }

    @Override
    @Nullable
    public World getWorld() {
        if (this.worldName == null || this.worldName.length() == 0) {
            return null;
        }
        return Bukkit.getWorld((String)this.worldName);
    }

    @Override
    @Nullable
    public Block getBlock() {
        World world;
        Block block = null;
        if (this.location != null && (world = this.getWorld()) != null) {
            block = world.getBlockAt(this.location.getBlockX(), this.location.getBlockY(), this.location.getBlockZ());
        }
        return block;
    }

    @Override
    @Nullable
    public Chunk getChunk() {
        World world;
        Chunk chunk = null;
        if (this.location != null && (world = this.getWorld()) != null) {
            chunk = world.getChunkAt(this.location.getBlockX() >> 4, this.location.getBlockZ() >> 4);
        }
        return chunk;
    }

    @Override
    public boolean isDifferent() {
        return this.isDifferent(this.getBlock());
    }

    @Override
    @Nullable
    public UndoList getUndoList() {
        return this.undoList != null ? (UndoList)this.undoList.get() : null;
    }

    @Override
    public void setUndoList(UndoList list) {
        if (list == null) {
            this.undoList = null;
            return;
        }
        this.undoList = new WeakReference<UndoList>(list);
    }

    @Override
    public BlockVector getLocation() {
        return this.location;
    }

    @Override
    @Deprecated
    public boolean containsAny(Set<Material> materials) {
        if (materials.contains(this.material)) {
            return true;
        }
        if (this.priorState != null) {
            return this.priorState.containsAny(materials);
        }
        return false;
    }

    @Override
    public boolean containsAny(MaterialSet materials) {
        if (materials.testMaterialAndData(this)) {
            return true;
        }
        if (this.priorState != null) {
            return this.priorState.containsAny(materials);
        }
        return false;
    }

    @Override
    public double getDamage() {
        return this.damage;
    }

    @Override
    public void addDamage(double damage) {
        this.damage += damage;
    }

    @Override
    public void setFake(Collection<WeakReference<Player>> players) {
        this.fakeSentToPlayers = players;
    }

    @Override
    public boolean isFake() {
        return this.fakeSentToPlayers != null;
    }
}

