/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ChatAction
extends BaseSpellAction {
    @Nonnull
    private List<String> messages = ImmutableList.of();

    private String translate(CastContext context, String key) {
        String message = context.getMessage(key, key);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        List keys = parameters.getStringList("randomized_messages");
        if (!keys.isEmpty()) {
            this.messages = new ArrayList<String>();
            for (String key : keys) {
                this.messages.add(this.translate(context, key));
            }
        } else {
            String key = parameters.getString("message", "");
            if (!key.isEmpty()) {
                this.messages = ImmutableList.of((Object)this.translate(context, key));
            }
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        String message;
        Entity target = context.getTargetEntity();
        if (!(target instanceof Player)) {
            return SpellResult.PLAYER_REQUIRED;
        }
        switch (this.messages.size()) {
            case 0: {
                return SpellResult.FAIL;
            }
            case 1: {
                message = this.messages.get(0);
                break;
            }
            default: {
                Random r = context.getRandom();
                message = this.messages.get(r.nextInt(this.messages.size()));
            }
        }
        Player p = (Player)target;
        p.chat(message);
        return SpellResult.CAST;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }
}

