/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.magic.Locatable;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.command.Selection;
import com.elmakers.mine.bukkit.utility.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class SelectionManager<T extends Locatable> {
    protected final MagicController controller;
    private final Selection<T> consoleSelection = new Selection();
    private final Map<UUID, Selection<T>> selections = new HashMap<UUID, Selection<T>>();
    private int rowsPerPage = 8;

    public SelectionManager(MagicController controller) {
        this.controller = controller;
    }

    @Nullable
    public T getSelected(CommandSender sender) {
        Selection<T> selection = this.getSelection(sender);
        return (T)(selection == null ? null : (Locatable)selection.getSelected());
    }

    @Nullable
    private Selection<T> getSelection(CommandSender sender) {
        Player player;
        Selection<T> selection = this.consoleSelection;
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (player != null) {
            selection = this.selections.get(player.getUniqueId());
        }
        return selection;
    }

    @Nonnull
    private Selection<T> createSelection(CommandSender sender) {
        if (sender instanceof Player) {
            Selection<T> selection = this.getSelection(sender);
            if (selection == null) {
                selection = new Selection();
                this.selections.put(((Player)sender).getUniqueId(), selection);
            }
            return selection;
        }
        return this.consoleSelection;
    }

    public void clearSelection(CommandSender sender) {
        Selection<Object> selection = this.getSelection(sender);
        if (selection != null) {
            selection.setSelected(null);
        }
    }

    public void setSelection(CommandSender sender, T select) {
        Selection<T> selection = this.createSelection(sender);
        selection.setSelected(select);
    }

    @Nonnull
    protected abstract Collection<T> getAll();

    @Nonnull
    protected abstract String getTypeNamePlural();

    protected abstract void showListItem(CommandSender var1, T var2, ListType var3);

    @Nullable
    protected abstract T getTarget(CommandSender var1, List<T> var2);

    @Nullable
    public List<T> getList(CommandSender sender) {
        Selection<T> selection = this.getSelection(sender);
        return selection == null ? null : selection.getList();
    }

    @Nonnull
    public Selection<T> updateList(CommandSender sender) {
        Location location = null;
        if (sender instanceof Player) {
            location = ((Player)sender).getEyeLocation();
        }
        Collection<T> all = this.getAll();
        List<T> sorted = location != null ? this.getSorted(all, location) : new ArrayList<T>(all);
        Selection<T> selection = this.createSelection(sender);
        selection.setList(sorted);
        return selection;
    }

    public void list(CommandSender sender, String[] args) {
        Selection<T> selection;
        List<T> sorted;
        int page = 0;
        String pageNumber = "?";
        if (args.length > 0) {
            try {
                pageNumber = args[0];
                page = Integer.parseInt(args[0]) - 1;
            }
            catch (Exception ex) {
                sender.sendMessage(ChatColor.RED + "Invalid page number: " + ChatColor.WHITE + args[0]);
                return;
            }
        }
        if ((sorted = (selection = this.updateList(sender)).getList()).isEmpty()) {
            sender.sendMessage(ChatColor.RED + "No automata to list");
            return;
        }
        int start = page * this.rowsPerPage;
        int end = start + this.rowsPerPage;
        int pages = (int)Math.ceil((double)sorted.size() / (double)this.rowsPerPage) + 1;
        if (start < 0 || start > sorted.size()) {
            sender.sendMessage(ChatColor.RED + "Invalid page number: " + ChatColor.WHITE + pageNumber + ChatColor.GRAY + "/" + ChatColor.GOLD + pages);
            return;
        }
        sender.sendMessage(ChatColor.AQUA + "Total " + this.getTypeNamePlural() + ": " + ChatColor.DARK_AQUA + sorted.size());
        T target = this.getTarget(sender, sorted);
        Locatable selected = (Locatable)selection.getSelected();
        end = Math.min(end, sorted.size());
        for (int i = start; i < end; ++i) {
            ChatColor color;
            ListType listType;
            Locatable item = (Locatable)sorted.get(i);
            if (item == selected) {
                listType = ListType.SELECTED;
                color = ChatColor.GOLD;
            } else if (item == target) {
                listType = ListType.TARGET;
                color = ChatColor.AQUA;
            } else if (item.isActive()) {
                listType = ListType.ACTIVE;
                color = ChatColor.LIGHT_PURPLE;
            } else {
                listType = ListType.INACTIVE;
                color = ChatColor.GRAY;
            }
            this.showListItem(sender, item, listType);
            String message = ChatColor.WHITE + Integer.toString(i + 1) + ChatColor.GRAY + ": " + color + item.getName() + ChatColor.DARK_PURPLE + this.getDistanceMessage(sender, item);
            sender.sendMessage(message);
        }
        if (sorted.size() > this.rowsPerPage) {
            sender.sendMessage("  " + ChatColor.GRAY + "Page " + ChatColor.YELLOW + (page + 1) + ChatColor.GRAY + "/" + ChatColor.GOLD + pages);
        }
    }

    @Nonnull
    public String getDistanceMessage(CommandSender sender, Locatable item) {
        String message = "";
        if (sender instanceof Player) {
            Location location = ((Player)sender).getEyeLocation();
            Location itemLocation = item.getLocation();
            if (location.getWorld().equals(itemLocation.getWorld())) {
                double distance = location.distance(itemLocation);
                message = ChatColor.GRAY + " (" + ChatColor.WHITE + TextUtils.printNumber(distance, 1) + ChatColor.BLUE + " blocks away" + ChatColor.GRAY + ")";
            }
        }
        return message;
    }

    private List<T> getSorted(Collection<T> list, final Location location) {
        ArrayList<T> sorted = new ArrayList<T>(list);
        Collections.sort(sorted, new Comparator<T>(){

            @Override
            public int compare(Locatable a, Locatable b) {
                double bDistance;
                boolean aInWorld = location.getWorld().equals(a.getLocation().getWorld());
                boolean bInWorld = location.getWorld().equals(b.getLocation().getWorld());
                if (aInWorld && !bInWorld) {
                    return -1;
                }
                if (!aInWorld && bInWorld) {
                    return 1;
                }
                if (!aInWorld) {
                    return 0;
                }
                double aDistance = location.distanceSquared(a.getLocation());
                if (aDistance < (bDistance = location.distanceSquared(b.getLocation()))) {
                    return -1;
                }
                if (aDistance > bDistance) {
                    return 1;
                }
                return 0;
            }
        });
        return sorted;
    }

    protected static enum ListType {
        ACTIVE,
        TARGET,
        SELECTED,
        INACTIVE;

    }
}

