/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.economy;

import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.economy.BaseMagicCurrency;

public class LevelCurrency
extends BaseMagicCurrency {
    public LevelCurrency(MageController controller) {
        super(controller, "levels", 1.0);
    }

    @Override
    public double getBalance(Mage mage, CasterProperties caster) {
        return mage.getLevel();
    }

    @Override
    public boolean has(Mage mage, CasterProperties caster, double amount) {
        return (double)mage.getLevel() >= amount;
    }

    @Override
    public void deduct(Mage mage, CasterProperties caster, double amount) {
        int newLevel = Math.max(0, mage.getLevel() - this.getRoundedAmount(amount));
        mage.setLevel(newLevel);
    }

    @Override
    public boolean give(Mage mage, CasterProperties caster, double amount) {
        int newLevel = mage.getLevel() + this.getRoundedAmount(amount);
        mage.setLevel(newLevel);
        return mage.isPlayer();
    }
}

