/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public class ChangeBiomeAction
extends BaseSpellAction {
    private Biome biome;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        String biomeKey = parameters.getString("biome", "");
        try {
            this.biome = Biome.valueOf((String)biomeKey.toUpperCase());
        }
        catch (Exception biomeEx) {
            context.getLogger().warning("Invalid biome: " + biomeKey);
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        if (this.biome == null) {
            return SpellResult.FAIL;
        }
        Block block = context.getTargetBlock();
        block.setBiome(this.biome);
        return SpellResult.CAST;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }
}

