/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public abstract class BaseTeleportAction
extends BaseSpellAction {
    protected int verticalSearchDistance;
    protected boolean safe = true;
    private boolean requiresBuildPermission = false;
    private boolean requiresExitPermission = true;
    private boolean keepVelocity = false;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.verticalSearchDistance = parameters.getInt("vertical_range", context.getVerticalSearchDistance());
        this.safe = parameters.getBoolean("safe", true);
        this.requiresBuildPermission = parameters.getBoolean("require_build", false);
        this.requiresExitPermission = parameters.getBoolean("require_exit", true);
        this.keepVelocity = parameters.getBoolean("keep_velocity", this.keepVelocity);
    }

    protected SpellResult teleport(CastContext context, Entity entity, Location targetLocation) {
        if (this.requiresBuildPermission && !context.hasBuildPermission(targetLocation.getBlock())) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (this.requiresExitPermission && entity instanceof Player && !context.getController().isExitAllowed((Player)entity, entity.getLocation()) && context.getController().isExitAllowed((Player)entity, targetLocation)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (!context.canCast(targetLocation)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        Location sourceLocation = this.keepVelocity ? entity.getLocation() : null;
        Vector sourceVelocity = this.keepVelocity ? entity.getVelocity() : null;
        boolean result = context.teleport(entity, targetLocation, this.verticalSearchDistance, this.safe);
        if (result && this.keepVelocity) {
            double deltaYaw = targetLocation.getYaw() - sourceLocation.getYaw();
            double angle = Math.toRadians(deltaYaw);
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            double initialX = sourceVelocity.getX();
            double initialZ = sourceVelocity.getZ();
            sourceVelocity.setX(initialX * cos - initialZ * sin);
            sourceVelocity.setZ(initialZ * cos + initialX * sin);
            entity.setVelocity(sourceVelocity);
        }
        return result ? SpellResult.CAST : SpellResult.NO_TARGET;
    }
}

